/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.utils;

import com.iflytek.skintool.domin.BasePictureData;
import com.iflytek.skintool.domin.FileData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.parser.utils.ThemeFileManager;
import com.iflytek.skintool.util.PathClass;
import com.iflytek.skintool.util.ThemeUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ThemeFileParser {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String COMMENT_TAG = "#";
    private static final String PROPERTY_START_TAG = "[";
    private static final String PROPERTY_END_TAG = "]";
    private static final String SEPARATE_TAG = "=";
    private static final String IMAGE_KEY_TAG = "SRC";
    private String mFilePath = null;
    private String mFileName = null;
    private String mChangeFilePath = null;
    private String mChangeFileDir = null;
    private String mNeedChangePic = null;
    private Map<String, Properties> mPropertiesMap = null;

    public Map<String, Properties> getAllProperties(String themeDir, String subfolder, String fileName, Object context, int resType) {
        this.mFileName = fileName;
        this.mFilePath = themeDir;
        this.loadFile();
        return this.mPropertiesMap;
    }

    private void loadFile() {
        this.mPropertiesMap = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(String.valueOf(this.mFilePath) + this.mFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                is = new FileInputStream(String.valueOf(PathClass.getpath()) + "\\layout\\layout_default\\480\\layout\\" + this.mFileName);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        this.readFile(is);
    }

    private void readFile(InputStream is) {
        if (is != null) {
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    isr = new InputStreamReader(is, Charset.forName("UTF-8"));
                    br = new BufferedReader(isr, 8192);
                    this.mPropertiesMap = new HashMap<String, Properties>();
                    String str = null;
                    Properties properties = null;
                    while ((str = br.readLine()) != null) {
                        str = str.trim();
                        String key = null;
                        String value = null;
                        if (str.startsWith(COMMENT_TAG)) continue;
                        if (str.startsWith(PROPERTY_START_TAG) && str.endsWith(PROPERTY_END_TAG)) {
                            key = str.substring(1, str.length() - 1);
                            if (key.length() <= 0) continue;
                            properties = new Properties();
                            this.mPropertiesMap.put(key, properties);
                            continue;
                        }
                        if (!str.contains(SEPARATE_TAG)) continue;
                        int index = str.indexOf(SEPARATE_TAG);
                        key = str.substring(0, index).trim();
                        value = str.substring(index + 1).trim();
                        if (key.length() <= 0 || properties == null) continue;
                        properties.put(key, value);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException e) {
                    block40: {
                        e.printStackTrace();
                        this.mPropertiesMap = null;
                        if (br == null) break block40;
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Map<String, Properties> getStreamProperties(InputStream is) {
        this.mPropertiesMap = null;
        try {
            this.readFile(is);
        }
        catch (Exception e) {
            return null;
        }
        return this.mPropertiesMap;
    }

    public boolean isEmpty() {
        return this.mPropertiesMap == null || this.mPropertiesMap.isEmpty();
    }

    public void changeIniData(BasePictureData mChangeBack, StyleData mStyleData, String iniFilePath, String iniFileName, String tag) {
        FileOutputStream out = null;
        FileInputStream is = null;
        this.mChangeFilePath = String.valueOf(iniFilePath) + ThemeFileManager.getInstance().getDefaultResDir() + iniFileName;
        this.mChangeFileDir = String.valueOf(iniFilePath) + ThemeFileManager.getInstance().getDefaultResDir();
        try {
            is = new FileInputStream(String.valueOf(iniFilePath) + ThemeFileManager.getInstance().getDefaultResDir() + iniFileName);
            out = new FileOutputStream(String.valueOf(iniFilePath) + ThemeFileManager.getInstance().getDefaultResDir() + "tmp.ini");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.changeFile(is, out, mChangeBack, mStyleData, tag);
    }

    private void changeFile(InputStream is, OutputStream out, BasePictureData mChangeBack, StyleData mStyleData, String tag) {
        int fileLine = 0;
        int start = 0;
        int end = 0;
        String str = null;
        String key = null;
        int mark = 0;
        if (mChangeBack.getPictureColor() == 0 && mChangeBack.getPictureFileName() != null) {
            mark = 0;
        }
        if (mChangeBack.getPictureFileName() == null && mChangeBack.getPictureColor() != 0) {
            mark = 1;
            mChangeBack.getPictureColor();
        }
        if (mChangeBack.getPictureFileName() == null && mChangeBack.getPictureColor() == 0) {
            mark = 2;
        }
        if (is != null) {
            block67: {
                InputStreamReader isr;
                BufferedWriter bw;
                OutputStreamWriter osr;
                block68: {
                    osr = null;
                    bw = null;
                    isr = null;
                    BufferedReader br = null;
                    try {
                        osr = new OutputStreamWriter(out, "utf-8");
                        bw = new BufferedWriter(osr, 8192);
                        isr = new InputStreamReader(is, "utf-8");
                        br = new BufferedReader(isr, 8192);
                        while ((str = br.readLine()) != null) {
                            if (str.startsWith(COMMENT_TAG)) {
                                ++fileLine;
                                ++start;
                                ++end;
                                continue;
                            }
                            if (str.startsWith(PROPERTY_START_TAG) && str.endsWith(PROPERTY_END_TAG)) {
                                key = str.substring(1, str.length() - 1);
                                ++start;
                                ++end;
                                if (!key.equals(tag)) continue;
                                while ((str = br.readLine()) != null && !str.startsWith(PROPERTY_START_TAG) && !str.endsWith(PROPERTY_END_TAG)) {
                                    ++end;
                                }
                                this.changeAttribute(fileLine, start, end, mChangeBack, bw, mark);
                                break;
                            }
                            ++start;
                            ++end;
                            ++fileLine;
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (isr != null) {
                            try {
                                isr.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (bw != null) {
                            try {
                                bw.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (osr != null) {
                            try {
                                osr.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        try {
                            is.close();
                            out.close();
                        }
                        catch (IOException e3) {}
                        break block67;
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                            break block67;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException e3) {}
                            }
                            if (isr != null) {
                                try {
                                    isr.close();
                                }
                                catch (IOException e3) {}
                            }
                            if (bw != null) {
                                try {
                                    bw.close();
                                }
                                catch (IOException e4) {
                                    e4.printStackTrace();
                                }
                            }
                            if (osr != null) {
                                try {
                                    osr.close();
                                }
                                catch (IOException e5) {
                                    e5.printStackTrace();
                                }
                            }
                            try {
                                is.close();
                                out.close();
                            }
                            catch (IOException e5) {}
                        }
                    }
                    if (br == null) break block68;
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (osr != null) {
                    try {
                        osr.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    is.close();
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            File oldFile = new File(this.mChangeFilePath);
            File newFile = new File(String.valueOf(this.mChangeFileDir) + File.separator + "tmp.ini");
            this.fileReplace(oldFile, newFile);
        }
    }

    private void changeAttribute(int fileLine, int start, int end, BasePictureData mChangeBack, BufferedWriter bw, int mark) {
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dt = new Date();
        BufferedReader br1 = null;
        FileInputStream is = null;
        InputStreamReader isr = null;
        try {
            is = new FileInputStream(this.mChangeFilePath);
            isr = new InputStreamReader((InputStream)is, "utf-8");
            br1 = new BufferedReader(isr, 8192);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        String str = null;
        int i = 0;
        try {
            str = br1.readLine();
            block10: while (str != null) {
                if (i == start) {
                    switch (mark) {
                        case 2: {
                            i = start;
                            while (i < end) {
                                if (str.contains("TEXT_SIZE") && !str.contains(COMMENT_TAG)) {
                                    sb.append("");
                                    sb.append("TEXT_SIZE=" + mChangeBack.getFont().getSize());
                                    sb.append("\n");
                                } else if (str.contains("TEXT_COLOR") && !str.contains(COMMENT_TAG)) {
                                    sb.append("");
                                    sb.append("TEXT_COLOR=0x" + Integer.toHexString(mChangeBack.getTextColor()));
                                    sb.append("\n");
                                } else {
                                    sb.append(str);
                                    sb.append("\n");
                                }
                                str = br1.readLine();
                                ++i;
                            }
                            continue block10;
                        }
                        case 1: {
                            i = start;
                            while (i < end) {
                                if (str.contains("BG_COLOR") && !str.contains(COMMENT_TAG)) {
                                    sb.append("");
                                    sb.append("BG_COLOR=0x" + Integer.toHexString(mChangeBack.getPictureColor()));
                                    sb.append("\n");
                                } else if (str.contains("IMAGE") && !str.contains(COMMENT_TAG)) {
                                    sb.append("");
                                    sb.append("BG_COLOR=0x" + Integer.toHexString(mChangeBack.getPictureColor()));
                                    sb.append("\n");
                                } else {
                                    sb.append(str);
                                    sb.append("\n");
                                }
                                str = br1.readLine();
                                ++i;
                            }
                            continue block10;
                        }
                        case 0: {
                            long sysTime = dt.getTime();
                            String tmp = Long.toString(sysTime);
                            String key = "Image_" + tmp + "_" + "Bg";
                            i = start;
                            while (i < end) {
                                if (str.contains("BG_COLOR") && !str.contains(COMMENT_TAG)) {
                                    sb.append("");
                                    sb.append("IMAGE=Image_" + tmp + "_" + "Bg");
                                    sb.append("\n");
                                } else if (str.contains("IMAGE") && !str.contains(COMMENT_TAG)) {
                                    sb.append("");
                                    sb.append("IMAGE=Image_" + tmp + "_" + "Bg");
                                    sb.append("\n");
                                } else {
                                    sb.append(str);
                                    sb.append("\n");
                                }
                                this.changeImageIni(mChangeBack, key);
                                str = br1.readLine();
                                ++i;
                            }
                            break block2;
                        }
                    }
                    continue;
                }
                ++i;
                sb.append(str);
                sb.append("\n");
                str = br1.readLine();
            }
            bw.write("" + sb);
            bw.flush();
            bw.close();
            br1.close();
            isr.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fileReplace(File oldFile, File newFile) {
        String path = oldFile.getPath();
        newFile.renameTo(new File(path));
    }

    private void changeImageIni(BasePictureData changedata, String tag) {
        String imageIniFilePath = String.valueOf(FileData.getThemeFilePath()) + ThemeFileManager.getInstance().getDefaultResDir();
        String imageIniFileName = "image.ini";
        String first = PROPERTY_START_TAG + tag + PROPERTY_END_TAG;
        String second = "SRC=" + this.mNeedChangePic;
        try {
            FileWriter fos = new FileWriter(String.valueOf(imageIniFilePath) + imageIniFileName, true);
            fos.write("\n" + first);
            fos.write("\n" + second);
            if (changedata.getXDivs() != null) {
                fos.write("\nX_DIVS=" + changedata.getXDivs()[0] + "," + changedata.getXDivs()[1]);
            }
            if (changedata.getYDivs() != null) {
                fos.write("\nY_DIVS=" + changedata.getYDivs()[0] + "," + changedata.getYDivs()[1]);
            }
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyImageFile(String srcFilePath, String srcFileName, String desFilePath) {
        this.mNeedChangePic = ThemeUtils.copyFile(srcFilePath, srcFileName, desFilePath);
    }
}

