/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.domin.KeyGravity;
import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.PromptContent;
import com.iflytek.skintool.model.layout.SelectorData;
import com.iflytek.skintool.model.layout.SubKeyData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.DimensParser;
import com.iflytek.skintool.parser.common.ImageParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.layout.BalloonParser;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class KeyParser
extends BaseParser {
    private String mImageStr;
    private String mForeStateStr;
    private String mBackStateStr;
    private Map<Integer, StyleData> mStateSet;
    private String[] mModeKeyStrArray;
    private boolean mFurtherParser;
    protected KeyData mKeyData;
    private SelectorData mSelectorData;
    private SubKeyData mSubKeyData;
    private StyleParser mStyleParser;
    private DimensParser mDimensParser;
    private ImageParser mImageParser;
    private BalloonParser mBalloonParser;
    private boolean isSubKeyParser = false;
    private boolean isSelectorParser = false;

    public KeyParser(Object context) {
        super(context);
        this.mFileName = "key.ini";
    }

    private void resetParams() {
        this.mImageStr = null;
        this.mForeStateStr = null;
        this.mBackStateStr = null;
        this.mStateSet = new HashMap<Integer, StyleData>();
        this.mFurtherParser = false;
    }

    @Override
    public BaseData getParserResult(String tag) {
        String keyTag = String.valueOf(this.mFileName) + this.mLandscape;
        HashMap<String, KeyData> keyDataPool = (HashMap<String, KeyData>)mAllDataPool.get(keyTag);
        keyDataPool = new HashMap<String, KeyData>();
        BaseData keyData = null;
        if (keyData == null) {
            this.resetParams();
            this.mModeKeyStrArray = null;
            this.mKeyData = new KeyData();
            this.mKeyData.setTag(tag);
            this.parserProperties(tag);
            if (this.mModeKeyStrArray != null && this.mModeKeyStrArray.length > 0) {
                this.furtherParserProperty();
                SelectorData selectorData = new SelectorData();
                selectorData.setTag(tag);
                selectorData.setDimens(this.mKeyData.getDimensData());
                KeyData tmpKeyData = this.mKeyData.clone();
                String[] stringArray = this.mModeKeyStrArray;
                int n = this.mModeKeyStrArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String tmpTag = stringArray[n2];
                    this.mKeyData = new KeyData(tmpKeyData);
                    this.mKeyData.setDimensData(new DimensData());
                    this.mKeyData.setTag(tmpTag);
                    this.parserProperties(tmpTag);
                    this.furtherParserProperty();
                    selectorData.addData(this.mKeyData.clone());
                    ++n2;
                }
                keyData = selectorData;
            } else {
                this.furtherParserProperty();
                keyData = this.mKeyData.clone();
            }
            keyDataPool.put(tag, this.mKeyData);
            mAllDataPool.put(keyTag, keyDataPool);
        }
        return keyData;
    }

    private void furtherParserProperty() {
        this.mFurtherParser = true;
        if (this.mForeStateStr != null) {
            this.mStateSet = new HashMap<Integer, StyleData>();
            this.parserProperties(this.mForeStateStr);
            if (this.isSubKeyParser) {
                this.mSubKeyData.setForegroundStyle(this.mStateSet);
            } else {
                this.mKeyData.setForeStateSet(this.mStateSet);
            }
        }
        if (this.mImageStr != null) {
            StyleData styleData = this.mKeyData.getForeStyle();
            styleData.setImageTag(this.mImageStr);
            this.mImageParser = new ImageParser(null);
            this.mImageParser.setParserObject(this.layoutType);
            String mCurrentThemeDir1 = String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultLayoutResFilePath();
            this.mImageParser.setThemeDir(mCurrentThemeDir1);
            ImageData imageData = this.mImageParser.getParserResult(this.mImageStr);
            ManageUtils.imageDataPoolMap.put(this.mImageStr, imageData);
        }
        if (this.mBackStateStr != null) {
            this.mStateSet = new HashMap<Integer, StyleData>();
            this.parserProperties(this.mBackStateStr);
            this.mKeyData.setBackStateSet(this.mStateSet);
        }
        this.resetParams();
    }

    private void subKeyParser(String key) {
        String[] mSubKeySet;
        this.isSubKeyParser = true;
        String[] stringArray = mSubKeySet = ThemeUtils.splitString(key, ",");
        int n = mSubKeySet.length;
        int n2 = 0;
        while (n2 < n) {
            String subkey = stringArray[n2];
            this.mSubKeyData = new SubKeyData();
            this.mSubKeyData.setTag(subkey);
            Properties prop = (Properties)this.mPropertiesMap.get(subkey);
            if (prop != null) {
                for (String string : prop.keySet()) {
                    String value = prop.getProperty(string);
                    this.parserProperty(string, value, false);
                }
            }
            this.furtherParserProperty();
            this.mKeyData.addSubKeyDataForGravity(this.mSubKeyData);
            ++n2;
        }
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("IMAGE")) {
            if (this.isSubKeyParser) {
                this.mSubKeyData.setImageTag(value);
            } else {
                this.mKeyData.setImageTag(value);
                this.mImageStr = value;
            }
        } else if (key.equalsIgnoreCase("MODE")) {
            this.mKeyData.setShowModeStr(value);
        } else if (key.equalsIgnoreCase("AREA_TYPE")) {
            this.mKeyData.setmKeyType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("STYLE_TYPE")) {
            this.mKeyData.setThemeType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("RESPONCE_TYPE")) {
            this.mKeyData.setResponseType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("FUN_TYPE")) {
            this.mKeyData.setFunctionType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("TEXT")) {
            if (this.isSubKeyParser & !this.mFurtherParser) {
                this.mSubKeyData.setText(value);
            } else if (!this.mFurtherParser) {
                this.mKeyData.setText(value);
            }
        } else if (key.equalsIgnoreCase("FORE_STATE")) {
            this.mForeStateStr = value;
        } else if (key.equalsIgnoreCase("NORMAL")) {
            this.mStyleParser.setParserObject(this.layoutType);
            this.mStateSet.put(1, this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("PRESSED")) {
            this.mStyleParser.setParserObject(this.layoutType);
            this.mStateSet.put(2, this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("SELECTED")) {
            this.mStyleParser.setParserObject(this.layoutType);
            this.mStateSet.put(8, this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("FOCUSED")) {
            this.mStyleParser.setParserObject(this.layoutType);
            this.mStateSet.put(4, this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("BACK_STATE")) {
            this.mBackStateStr = value;
        } else if (key.equalsIgnoreCase("DIMENS")) {
            this.mDimensParser.setParserObject(this.layoutType);
            if (this.isSubKeyParser) {
                this.mSubKeyData.setDimens(this.mDimensParser.getParserResult(value));
            } else if (this.isSelectorParser && this.mSelectorData != null) {
                this.mSelectorData.setDimens(this.mDimensParser.getParserResult(value));
            } else {
                this.mKeyData.setDimensData(this.mDimensParser.getParserResult(value));
            }
        } else if (!this.mFurtherParser && key.equalsIgnoreCase("SELECTOR")) {
            this.mModeKeyStrArray = ThemeUtils.splitString(value, ",");
        } else if (key.equalsIgnoreCase("TEMPLATE")) {
            this.parserProperties(value);
        } else if (key.equalsIgnoreCase("SUB_KEY")) {
            this.subKeyParser(value);
            this.isSubKeyParser = false;
        } else if (key.equalsIgnoreCase("GRAVITY")) {
            if (this.isSubKeyParser) {
                this.mSubKeyData.setGravity(KeyGravity.parseGravity(value));
            } else {
                this.mKeyData.getCellKeyData().setGravity(KeyGravity.parseGravity(value));
            }
        } else if (key.equalsIgnoreCase("VISIBILITY")) {
            if (this.isSubKeyParser) {
                this.mSubKeyData.setVisibility(ThemeUtils.getBool(value));
            } else {
                this.mKeyData.getCellKeyData().setVisibility(ThemeUtils.getBool(value));
            }
        } else if (key.equalsIgnoreCase("TARGET")) {
            if (this.isSubKeyParser) {
                this.mSubKeyData.setTarget(ThemeUtils.getInt(value));
            } else {
                this.mKeyData.getCellKeyData().setTarget(ThemeUtils.getInt(value));
            }
        } else if (key.equalsIgnoreCase("SUPPORT_OPERATION")) {
            String[] operationStrSet = ThemeUtils.splitString(value, ",");
            int[] operationSet = new int[operationStrSet.length];
            int i = 0;
            while (i < operationSet.length) {
                int operaType;
                operationSet[i] = operaType = 1 << ThemeUtils.getInt(operationStrSet[i]);
                ++i;
            }
            if (this.isSubKeyParser) {
                this.mSubKeyData.setSupportOperation(operationSet);
            } else {
                this.mKeyData.getCellKeyData().setSupportOperation(operationSet);
            }
        } else if (key.equalsIgnoreCase("SEQUENCE")) {
            if (this.isSubKeyParser) {
                this.mSubKeyData.setSequence(value);
            } else {
                this.mKeyData.getCellKeyData().setSequence(value);
            }
        } else if (!key.equalsIgnoreCase("INPUT")) {
            if (key.equalsIgnoreCase("BALLOON")) {
                this.getPromptContent().setPopTag(value);
                if (this.isSubKeyParser) {
                    this.mBalloonParser = new BalloonParser(null);
                    this.mBalloonParser.setParserObject(this.layoutType);
                    this.mSubKeyData.setBalloonData(this.mBalloonParser.getParserResult(value));
                }
            } else if (key.equalsIgnoreCase("POP_TEXT")) {
                this.getPromptContent().setPopTexts(ThemeUtils.splitString(value, ","));
            } else if (key.equalsIgnoreCase("POP_SHOW")) {
                this.getPromptContent().setPopHlIndex(ThemeUtils.getInt(value));
            } else if (key.equalsIgnoreCase("POP_IMAGE")) {
                this.getPromptContent().setPopDrawableStr(ThemeUtils.splitString(value, ","));
            } else if (key.equalsIgnoreCase("SUPPORT_POP")) {
                this.getPromptContent().setSupportPop(ThemeUtils.getBool(value));
            } else if (key.equalsIgnoreCase("SUPPORT_SOUND")) {
                this.getPromptContent().setSupportSound(ThemeUtils.getBool(value));
            } else if (key.equalsIgnoreCase("SUPPORT_VIBRATE")) {
                this.getPromptContent().setSupportVibrate(ThemeUtils.getBool(value));
            } else if (key.equalsIgnoreCase("CODE")) {
                if (this.isSubKeyParser) {
                    this.mSubKeyData.setCode(ThemeUtils.parseCode(value));
                    this.mSubKeyData.setCodeString(value);
                } else {
                    this.mKeyData.getCellKeyData().setCode(ThemeUtils.parseCode(value));
                    this.mKeyData.getCellKeyData().setCodeString(value);
                }
            } else if (key.equalsIgnoreCase("TARGET")) {
                if (this.isSubKeyParser) {
                    this.mSubKeyData.setTarget(ThemeUtils.getInt(value));
                } else {
                    this.mKeyData.getCellKeyData().setTarget(ThemeUtils.getInt(value));
                }
            } else if (key.equalsIgnoreCase("TARGET_MODE")) {
                if (this.isSubKeyParser) {
                    this.mSubKeyData.setTargetModeStr(value);
                } else {
                    this.mKeyData.getCellKeyData().setTargetModeStr(value);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void setStyleParser(StyleParser styleParser) {
        this.mStyleParser = styleParser;
    }

    public void setDimensParser(DimensParser dimensParser) {
        this.mDimensParser = dimensParser;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }

    private PromptContent getPromptContent() {
        PromptContent promptContent = this.isSubKeyParser ? this.mSubKeyData.getPromptContent() : this.mKeyData.getCellKeyData().getPromptContent();
        if (promptContent == null) {
            promptContent = new PromptContent();
            if (this.isSubKeyParser) {
                this.mSubKeyData.setPromptContent(promptContent);
            } else {
                this.mKeyData.getCellKeyData().setPromptContent(promptContent);
            }
        }
        return promptContent;
    }
}

