/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.domin.DisplayConst;
import com.iflytek.skintool.model.layout.BalloonData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.DimensParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.util.ThemeUtils;

public class BalloonParser
extends BaseParser {
    protected BalloonData balloonData;
    protected DimensParser dimensParser;
    protected StyleParser styleParser;

    public BalloonParser(Object context) {
        super(context);
        this.mFileName = "balloon.ini";
        this.dimensParser = new DimensParser(context);
        this.styleParser = new StyleParser(context);
    }

    @Override
    public BalloonData getParserResult(String tag) {
        this.balloonData = new BalloonData();
        this.parserProperties(tag);
        this.balloonData.setTag(tag);
        return this.balloonData;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("POP_TYPE")) {
            this.balloonData.setBalloonType(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("STYLE")) {
            this.styleParser.setParserObject(this.layoutType);
            this.balloonData.setStyleData(this.styleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("DIMENS")) {
            this.dimensParser.setParserObject(this.layoutType);
            this.balloonData.setDimensData(this.dimensParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("STYLE_TYPE")) {
            this.balloonData.setThemeType(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("SUPPORT_GESTURE")) {
            this.balloonData.setSupportGesture(Boolean.valueOf(value));
        } else if (key.equalsIgnoreCase("BALLOON_Y_OFFSET")) {
            this.balloonData.setYOffset(ThemeUtils.getDimension(value, DisplayConst.IME_HEIGHT));
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

