/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.SelectorData;
import com.iflytek.skintool.parser.common.DimensParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.layout.AreaParser;
import com.iflytek.skintool.parser.utils.ThemeFileManager;
import java.util.Map;
import java.util.Properties;

public class AreaParserImpl {
    private Object mContext;
    private AreaParser mAreaParser;
    private boolean mLandscape;
    private StyleParser mStyleParser;
    private DimensParser mDimensParser;
    private int layoutType;

    public AreaParserImpl(Object context) {
        this.mContext = context;
        this.mAreaParser = new AreaParser(context);
    }

    public void setParserObject(int i) {
        this.layoutType = i;
        this.mAreaParser.setParserObject(this.layoutType);
        this.mStyleParser.setParserObject(i);
        this.mDimensParser.setParserObject(i);
    }

    public BaseData getParserResult(String tag) {
        Properties properties = this.mAreaParser.getPropertiesMap().get(tag);
        if (properties == null) {
            Map<String, Properties> propertiesMap = ThemeFileManager.getInstance().getSkinFile(!this.mLandscape, this.mAreaParser.getFileName(), this.layoutType);
            if (propertiesMap == null || propertiesMap.isEmpty()) {
                return null;
            }
            properties = propertiesMap.get(tag);
        }
        if (properties != null) {
            if (properties.containsKey("SELECTOR")) {
                SelectorData selectorData = new SelectorData();
                selectorData.setTag(tag);
                String dimensTag = properties.getProperty("DIMENS");
                if (dimensTag != null) {
                    selectorData.setDimens(this.mDimensParser.getParserResult(dimensTag));
                }
                String[] stringArray = this.mAreaParser.getModeAreaStrArray(tag);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String modeAreaStr = stringArray[n2];
                    selectorData.addData(this.reallyParserResult(modeAreaStr));
                    ++n2;
                }
                return selectorData;
            }
            return this.reallyParserResult(tag);
        }
        return null;
    }

    public void setStyleParser(StyleParser styleParser) {
        this.mStyleParser = styleParser;
        this.mAreaParser.setStyleParser(styleParser);
    }

    private AreaData reallyParserResult(String tag) {
        switch (this.mAreaParser.getAreaType(tag)) {
            case 12: {
                break;
            }
            default: {
                this.mAreaParser = new AreaParser(this.mContext);
            }
        }
        this.mAreaParser.setStyleParser(this.mStyleParser);
        this.mAreaParser.setDimensParser(this.mDimensParser);
        this.mAreaParser.setParserObject(this.layoutType);
        return this.mAreaParser.getParserResult(tag);
    }

    public void setDimensParser(DimensParser dimensParser) {
        this.mDimensParser = dimensParser;
        this.mAreaParser.setDimensParser(dimensParser);
    }
}

