/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.common;

import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.util.ThemeUtils;

public class DimensParser
extends BaseParser {
    public static final int LENGTH_TWO = 2;
    protected DimensData mDimensData;

    public DimensParser(Object context) {
        super(context);
        this.mFileName = "dimens.ini";
    }

    @Override
    public DimensData getParserResult(String tag) {
        this.mDimensData = null;
        if (this.mDimensData == null) {
            this.mDimensData = new DimensData();
            this.parserProperties(tag);
            this.mDimensData.setTag(tag);
        }
        return this.mDimensData;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("PADDING")) {
            this.mDimensData.setPaddingString(ThemeUtils.splitString(value, ","));
        } else if (key.equalsIgnoreCase("MARGIN")) {
            this.mDimensData.setMarginString(ThemeUtils.splitString(value, ","));
        } else if (key.equalsIgnoreCase("SIZE")) {
            String[] sizeStrings = ThemeUtils.splitString(value, ",");
            if (sizeStrings != null && sizeStrings.length == 2) {
                this.mDimensData.setWidthString(sizeStrings[0]);
                this.mDimensData.setHeightString(sizeStrings[1]);
            }
        } else if (key.equalsIgnoreCase("POS")) {
            String[] posStrings = ThemeUtils.splitString(value, ",");
            if (posStrings != null && posStrings.length == 2) {
                this.mDimensData.setX(Integer.valueOf(posStrings[0]).intValue());
                this.mDimensData.setY(Integer.valueOf(posStrings[1]).intValue());
            }
        } else if (key.equalsIgnoreCase("MIN_WIDTH")) {
            this.mDimensData.setMinWidthString(value);
        } else if (key.equalsIgnoreCase("MIN_HEIGHT")) {
            this.mDimensData.setMinHeightString(value);
        } else if (key.equalsIgnoreCase("PAGE_SIZE")) {
            String[] stringArray = ThemeUtils.splitString(value, "x");
            this.mDimensData.setRowCount(Integer.valueOf(stringArray[0]));
            this.mDimensData.setmColumnCount(Integer.valueOf(stringArray[1]));
        }
        return true;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

