/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.layout;

import com.iflytek.skintool.domin.LayoutType;
import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.SelectorData;
import java.util.ArrayList;
import java.util.List;

public class RowData
extends BaseData {
    private LayoutType mLayoutType = LayoutType.VERTICAL;
    private StyleData mStyleData = new StyleData();
    private List<BaseData> mKeySet;
    private String mRowTag;

    public RowData() {
        this.mDimensData = new DimensData();
    }

    public void setLayoutType(int layoutType) {
        switch (layoutType) {
            case 0: {
                this.mLayoutType = LayoutType.VERTICAL;
                break;
            }
            case 1: {
                this.mLayoutType = LayoutType.HORIZONTAL;
                break;
            }
            case 2: {
                this.mLayoutType = LayoutType.ABSOLUTE;
                break;
            }
            default: {
                this.mLayoutType = LayoutType.VERTICAL;
            }
        }
    }

    public void setLayoutType(LayoutType type) {
        this.mLayoutType = type;
    }

    @Override
    public LayoutType getLayoutType() {
        return this.mLayoutType;
    }

    public void setRowTag(String tag) {
        this.mRowTag = tag;
    }

    public String getRowTag() {
        return this.mRowTag;
    }

    public void setStyleDataTag(String styleDataTag) {
    }

    public void setStyleData(StyleData styleData) {
        this.mStyleData = styleData;
    }

    @Override
    public StyleData getStyle() {
        return this.mStyleData;
    }

    public void setKeySet(List<BaseData> keySet) {
        this.mKeySet = keySet;
    }

    public void addKeyData(BaseData keyData) {
        if (this.mKeySet == null) {
            this.mKeySet = new ArrayList<BaseData>();
        }
        this.mKeySet.add(keyData);
    }

    public List<BaseData> getKeySet() {
        return this.mKeySet;
    }

    @Override
    public RowData clone() {
        RowData rowData = (RowData)super.clone();
        if (rowData == null) {
            return null;
        }
        if (this.mStyleData != null) {
            rowData.mStyleData = this.mStyleData.clone();
        }
        if (this.mKeySet != null && !this.mKeySet.isEmpty()) {
            ArrayList<BaseData> tmpList = new ArrayList<BaseData>();
            for (BaseData keyData : this.mKeySet) {
                if (keyData == null) continue;
                tmpList.add(keyData.clone());
            }
            rowData.mKeySet = tmpList;
        }
        return rowData;
    }

    @Override
    public void setDimensData(DimensData dimensData) {
        this.mDimensData = dimensData;
    }

    public void removeAllKeyData() {
        if (this.mKeySet != null) {
            this.mKeySet.clear();
        }
    }

    @Override
    protected float getAbsX() {
        return this.mDimensData.getAbsX();
    }

    @Override
    protected float getAbsY() {
        return this.mDimensData.getAbsY();
    }

    @Override
    public ArrayList<BaseData> getChilds() {
        ArrayList<BaseData> keyDataSet = new ArrayList<BaseData>();
        for (BaseData baseData : this.mKeySet) {
            if (baseData instanceof SelectorData) {
                if (baseData.getDimensData() != null) {
                    ((SelectorData)baseData).getDataSet().get(0).setDimensData(baseData.getDimensData());
                }
                keyDataSet.add(((SelectorData)baseData).getDataSet().get(0));
                continue;
            }
            keyDataSet.add(baseData);
        }
        return keyDataSet;
    }
}

