/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.layout;

import com.iflytek.skintool.domin.LayoutType;
import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.SelectorData;
import java.util.ArrayList;
import java.util.List;

public class KeyboardData
extends BaseData {
    private int mKeyBoardType;
    private String ShowModeString;
    private String mStyleTag;
    private StyleData mStyle;
    private LayoutType mLayoutType = LayoutType.VERTICAL;
    private List<BaseData> mAreaDataSet;
    private ContainerType mKeyboardType = ContainerType.VIEWGROUP;
    private KeyboardDataType mKeyboardDataType = KeyboardDataType.KEYBOARD;

    public void setKeyBoardType(int type) {
        this.mKeyBoardType = type;
    }

    public int getKeyBoardType() {
        return this.mKeyBoardType;
    }

    public KeyboardData() {
        this.mStyle = new StyleData();
    }

    @Override
    public KeyboardData clone() {
        KeyboardData keyboardData = (KeyboardData)super.clone();
        if (keyboardData == null) {
            return null;
        }
        if (this.mStyle != null) {
            keyboardData.mStyle = this.mStyle.clone();
        }
        if (this.mDimensData != null) {
            keyboardData.mDimensData = this.mDimensData.clone();
        }
        if (this.mAreaDataSet != null) {
            ArrayList<BaseData> areaDataSet = new ArrayList<BaseData>();
            for (BaseData baseData : this.mAreaDataSet) {
                areaDataSet.add(baseData.clone());
            }
            keyboardData.mAreaDataSet = areaDataSet;
        }
        return keyboardData;
    }

    public void setKeyboardType(ContainerType type) {
        this.mKeyboardType = type;
    }

    public ContainerType getKeyboardType() {
        return this.mKeyboardType;
    }

    public void resume(KeyboardData keyboardData) {
        if (keyboardData != null) {
            this.mTag = keyboardData.mTag;
            this.mStyle = keyboardData.mStyle;
            this.mLayoutType = keyboardData.mLayoutType;
            this.mAreaDataSet = keyboardData.mAreaDataSet;
        }
    }

    @Override
    public StyleData getStyle() {
        return this.mStyle;
    }

    public void setStyle(StyleData style) {
        this.mStyle = new StyleData();
        this.mStyle = style;
    }

    public void setStyleTag(String styletag) {
        if (this.mStyleTag != null) {
            this.mStyleTag = styletag;
        }
    }

    public void setShowModeStr(String value) {
        this.ShowModeString = value;
    }

    public String getShowModeStr() {
        return this.ShowModeString;
    }

    @Override
    public LayoutType getLayoutType() {
        return this.mLayoutType;
    }

    public void setLayoutType(int layoutWay) {
        switch (layoutWay) {
            case 0: {
                this.mLayoutType = LayoutType.VERTICAL;
                break;
            }
            case 1: {
                this.mLayoutType = LayoutType.HORIZONTAL;
                break;
            }
            case 2: {
                this.mLayoutType = LayoutType.ABSOLUTE;
                break;
            }
            default: {
                this.mLayoutType = LayoutType.VERTICAL;
            }
        }
    }

    public List<BaseData> getAreaDataSet() {
        return this.mAreaDataSet;
    }

    public void setAreaSet(List<BaseData> areaDataSet) {
        this.mAreaDataSet = areaDataSet;
    }

    public ArrayList<KeyData> getAllKeys() {
        if (this.mAreaDataSet == null || this.mAreaDataSet.isEmpty()) {
            return null;
        }
        ArrayList<KeyData> keys = new ArrayList<KeyData>();
        for (BaseData baseData : this.mAreaDataSet) {
            if (baseData instanceof SelectorData) {
                for (BaseData areaData : ((SelectorData)baseData).getDataSet()) {
                    ArrayList<KeyData> keylist = ((AreaData)areaData).getAllKeys();
                    if (keylist == null) continue;
                    keys.addAll(keylist);
                }
                continue;
            }
            ArrayList<KeyData> keylist = ((AreaData)baseData).getAllKeys();
            if (keylist == null) continue;
            keys.addAll(keylist);
        }
        return keys;
    }

    public KeyboardDataType getKeyboardDataType() {
        return this.mKeyboardDataType;
    }

    public void setKeyboardDataType(int keyboardDataType) {
        switch (keyboardDataType) {
            case 0: {
                this.mKeyboardDataType = KeyboardDataType.KEYBOARD;
                break;
            }
            case 1: {
                this.mKeyboardDataType = KeyboardDataType.CAND;
                break;
            }
            case 2: {
                this.mKeyboardDataType = KeyboardDataType.SPEECH;
                break;
            }
            case 3: {
                this.mKeyboardDataType = KeyboardDataType.MENU;
                break;
            }
            default: {
                this.mKeyboardDataType = KeyboardDataType.KEYBOARD;
            }
        }
    }

    @Override
    public ArrayList<BaseData> getChilds() {
        ArrayList<BaseData> areaSet = new ArrayList<BaseData>();
        for (BaseData baseData : this.mAreaDataSet) {
            if (baseData instanceof SelectorData) {
                ((SelectorData)baseData).getDataSet().get(0).setDimensData(baseData.getDimensData());
                areaSet.add(((SelectorData)baseData).getDataSet().get(0));
                continue;
            }
            areaSet.add(baseData);
        }
        return areaSet;
    }

    public static enum ContainerType {
        VIEWGROUP,
        VIEWFLIPPER;

    }

    public static enum KeyboardDataType {
        KEYBOARD,
        CAND,
        SPEECH,
        MENU;

    }
}

