/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.layout;

import com.iflytek.skintool.domin.LayoutType;
import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.AnimationData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.RowData;
import com.iflytek.skintool.model.layout.SelectorData;
import java.util.ArrayList;
import java.util.List;

public class AreaData
extends BaseData {
    private KeyData mKeyAttribute;
    private StyleData mStyle;
    private AnimationData mAnimationData;
    private StyleData mSeparatorStyleData;
    private DimensData mSeparatorDimensData;
    private LayoutType mSeparatorLayoutType = LayoutType.VERTICAL;
    private LayoutType mLayoutType = LayoutType.VERTICAL;
    private List<RowData> mRowSet;
    private StyleData mUp_Fade_Style = null;
    private DimensData mUp_Fade_Dimens = null;
    private List<String> mContents;
    private List<KeyData> mKeyDataSet;
    private int mAreaType;
    private String mAttrModeString;

    public AreaData() {
        this.mThemeType = 0x5000000;
        this.mStyle = new StyleData();
        this.mDimensData = new DimensData();
    }

    @Override
    public AreaData clone() {
        AreaData areaData = (AreaData)super.clone();
        if (areaData == null) {
            return null;
        }
        if (this.mLayoutType != null) {
            areaData.mLayoutType = this.mLayoutType;
        }
        if (this.mKeyAttribute != null) {
            areaData.mKeyAttribute = this.mKeyAttribute.clone();
        }
        if (this.mStyle != null) {
            areaData.mStyle = this.mStyle.clone();
        }
        if (this.mDimensData != null) {
            areaData.mDimensData = this.mDimensData.clone();
        }
        if (this.mSeparatorStyleData != null) {
            areaData.mSeparatorStyleData = this.mSeparatorStyleData.clone();
        }
        if (this.mSeparatorDimensData != null) {
            areaData.mSeparatorDimensData = this.mSeparatorDimensData.clone();
        }
        if (this.mSeparatorLayoutType != null) {
            areaData.mSeparatorLayoutType = this.mSeparatorLayoutType;
        }
        if (this.mRowSet != null) {
            ArrayList<RowData> rows = new ArrayList<RowData>();
            for (RowData row : this.mRowSet) {
                rows.add(row.clone());
            }
            areaData.mRowSet = rows;
        }
        return areaData;
    }

    public void resume(AreaData areaData) {
        if (areaData != null) {
            this.mKeyAttribute = areaData.getKeyAttribute();
            this.mStyle = areaData.getStyle().clone();
            this.mSeparatorStyleData = areaData.getSeparatorStyleData();
            this.mSeparatorDimensData = areaData.getSeparatorDimensData();
            this.mSeparatorLayoutType = areaData.getSeparatorLayoutType();
            this.mLayoutType = areaData.getLayoutType();
            this.mAreaType = areaData.getAreaType();
            this.mContents = areaData.getContents();
        }
    }

    public KeyData getKeyAttribute() {
        return this.mKeyAttribute;
    }

    public void setKeyAttribute(KeyData keyAttribute) {
        this.mKeyAttribute = keyAttribute;
    }

    @Override
    public StyleData getStyle() {
        return this.mStyle;
    }

    public void setStyle(StyleData style) {
        this.mStyle = new StyleData();
        this.mStyle = style;
    }

    public String getAttrModeStr() {
        return this.mAttrModeString;
    }

    public void setAttrModeStr(String value) {
        this.mAttrModeString = value;
    }

    public StyleData getSeparatorStyleData() {
        return this.mSeparatorStyleData;
    }

    public void setSeparatorStyleData(StyleData separatorStyleData) {
        this.mSeparatorStyleData = separatorStyleData;
    }

    @Override
    public LayoutType getLayoutType() {
        return this.mLayoutType;
    }

    public void setLayoutType(int layoutType) {
        switch (layoutType) {
            case 0: {
                this.mLayoutType = LayoutType.VERTICAL;
                break;
            }
            case 1: {
                this.mLayoutType = LayoutType.HORIZONTAL;
                break;
            }
            case 2: {
                this.mLayoutType = LayoutType.ABSOLUTE;
                break;
            }
            default: {
                this.mLayoutType = LayoutType.VERTICAL;
            }
        }
    }

    public List<RowData> getRowSet() {
        return this.mRowSet;
    }

    public void setRowSet(List<RowData> rowSet) {
        this.mRowSet = rowSet;
    }

    public void setAreaType(int type) {
        this.mAreaType = type;
    }

    public int getAreaType() {
        return this.mAreaType;
    }

    public List<String> getContents() {
        return this.mContents;
    }

    public void setContents(List<String> contents) {
        this.mContents = contents;
    }

    public LayoutType getSeparatorLayoutType() {
        return this.mSeparatorLayoutType;
    }

    public void setSeparatorLayoutType(int separatorLayoutType) {
        switch (separatorLayoutType) {
            case 0: {
                this.mSeparatorLayoutType = LayoutType.VERTICAL;
                break;
            }
            case 1: {
                this.mSeparatorLayoutType = LayoutType.HORIZONTAL;
                break;
            }
            default: {
                this.mSeparatorLayoutType = LayoutType.VERTICAL;
            }
        }
    }

    public void setSeparatorDimensData(DimensData mSeparatorDimensData) {
        this.mSeparatorDimensData = mSeparatorDimensData;
    }

    public DimensData getSeparatorDimensData() {
        if (this.mSeparatorDimensData == null) {
            this.mSeparatorDimensData = new DimensData();
        }
        return this.mSeparatorDimensData;
    }

    public ArrayList<KeyData> getAllKeys() {
        if (this.mRowSet == null || this.mRowSet.isEmpty()) {
            return null;
        }
        ArrayList<KeyData> keys = new ArrayList<KeyData>();
        for (BaseData baseData : this.mRowSet) {
            this.addKeysFromRow(keys, (RowData)baseData);
        }
        return keys;
    }

    private void addKeysFromRow(ArrayList<KeyData> keys, RowData rowData) {
        List<BaseData> rowKeys = rowData.getKeySet();
        if (rowKeys == null || rowKeys.isEmpty()) {
            return;
        }
        for (BaseData baseData : rowKeys) {
            if (baseData instanceof SelectorData) {
                for (BaseData areaData : ((SelectorData)baseData).getDataSet()) {
                    keys.add((KeyData)areaData);
                }
                continue;
            }
            keys.add((KeyData)baseData);
        }
    }

    public void styleSeparatorMeasure(float width, float height, DimensData style) {
        if (style != null) {
            style.measureMargin(width, height);
            if (!style.measureWidth(width)) {
                switch (this.mSeparatorLayoutType) {
                    case HORIZONTAL: {
                        break;
                    }
                    default: {
                        style.setWidth(width);
                    }
                }
            }
            if (!style.measureHeight(height)) {
                switch (this.mSeparatorLayoutType) {
                    case HORIZONTAL: {
                        style.setHeight(height);
                        break;
                    }
                }
                style.measurePadding(width, height);
            }
        }
    }

    public void setAnimation(Object parserResult) {
        this.mAnimationData = (AnimationData)parserResult;
    }

    public AnimationData getAnimation() {
        return this.mAnimationData;
    }

    public void setUp_Fade_Style(StyleData Up_Fade_Style) {
        this.mUp_Fade_Style = Up_Fade_Style;
    }

    public StyleData getUp_Fade_Style() {
        return this.mUp_Fade_Style;
    }

    public DimensData getUp_Fade_Dimens() {
        return this.mUp_Fade_Dimens;
    }

    public void setUp_Fade_Dimens(DimensData Up_Fade_Dimens) {
        this.mUp_Fade_Dimens = Up_Fade_Dimens;
    }

    @Override
    public ArrayList<BaseData> getChilds() {
        ArrayList<BaseData> rowDataSet = new ArrayList<BaseData>();
        if (this.mRowSet != null) {
            for (BaseData baseData : this.mRowSet) {
                rowDataSet.add(baseData);
            }
            return rowDataSet;
        }
        if (this.getContents() != null && this.getContents().size() > 0) {
            ArrayList<BaseData> arrayList = new ArrayList<BaseData>();
            if (this.mKeyDataSet == null) {
                this.fillKeySet();
            }
            for (BaseData baseData : this.mKeyDataSet) {
                arrayList.add(baseData);
            }
            return arrayList;
        }
        return null;
    }

    private void fillKeySet() {
        this.mKeyDataSet = new ArrayList<KeyData>();
        int i = 0;
        while (i < this.getContents().size()) {
            KeyData keyData = this.mKeyAttribute.clone();
            keyData.setText(this.getContents().get(i));
            this.mKeyDataSet.add(keyData);
            ++i;
        }
    }

    public KeyData getKeyData(int index) {
        if (this.mKeyDataSet == null) {
            return null;
        }
        return this.mKeyDataSet.get(index);
    }

    public static enum SlipType {
        NONE,
        LEFT_RIGHT,
        UP_DOWN;

    }
}

