/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.graphical.low;

import com.iflytek.skintool.graphical.low.ColorButton;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonGroup
extends JPanel {
    private int row;
    private int column;
    private JButton[] buttons;
    private int filledSize = 0;
    public static int TYPE_COLOR = 0;
    public static int TYPE_IMAGE = 1;

    public void init(int x, int y, int type) {
        int i;
        this.row = x;
        this.column = y;
        if (type == TYPE_COLOR) {
            this.buttons = new ColorButton[this.row * this.column];
            i = 0;
            while (i < this.row * this.column) {
                this.buttons[i] = new ColorButton();
                this.buttons[i].setFocusable(false);
                ++i;
            }
        } else if (type == TYPE_IMAGE) {
            this.buttons = new JButton[this.row * this.column];
            i = 0;
            while (i < this.row * this.column) {
                this.buttons[i] = new JButton();
                ++i;
            }
        }
        i = 0;
        while (i < this.row * this.column) {
            this.buttons[i].setSize((int)this.getPreferredSize().getWidth() / this.column, (int)this.getPreferredSize().getHeight() / this.row);
            this.buttons[i].setLocation(i % this.column * (int)this.getPreferredSize().getWidth() / this.column, i / this.column * (int)this.getPreferredSize().getHeight() / this.row);
            this.buttons[i].setBackground(null);
            this.add(this.buttons[i]);
            ++i;
        }
        this.setLayout(null);
        this.initListener();
    }

    public void setColor(int num) {
        if (num < this.row * this.column) {
            int i = 0;
            while (i < num) {
                Random random = new Random();
                int r = random.nextInt(255);
                int g = random.nextInt(255);
                int b = random.nextInt(255);
                this.buttons[i].setBackground(new Color(r, g, b));
                ++i;
            }
        }
        this.filledSize = num;
    }

    public void setImage(int num) {
        if (num < this.row * this.column) {
            int i = 0;
            while (i < num) {
                ImageIcon icon = new ImageIcon("E:\\bg.jpg");
                this.buttons[i].setIcon(icon);
                ++i;
            }
        }
        this.filledSize = num;
    }

    public void addColor(Color color) {
        int i = this.filledSize;
        while (i > 0) {
            if (i < this.column * this.row) {
                this.buttons[i].setBackground(this.buttons[i - 1].getBackground());
            }
            --i;
        }
        this.buttons[0].setBackground(color);
        this.filledSize = this.filledSize < this.row * this.column ? this.filledSize + 1 : this.filledSize;
    }

    public void addImage(ImageIcon icon) {
        int i = this.filledSize;
        while (i > 0) {
            if (i < this.column * this.row) {
                this.buttons[i].setIcon(this.buttons[i - 1].getIcon());
            }
            --i;
        }
        this.buttons[0].setIcon(icon);
        this.filledSize = this.filledSize < this.row * this.column ? this.filledSize + 1 : this.filledSize;
    }

    private void initListener() {
        int i = 0;
        while (i < this.row * this.column) {
            this.buttons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                }
            });
            ++i;
        }
    }

    public int getFilledSize() {
        return this.filledSize;
    }

    public Color getCellColor(int index) {
        return this.buttons[index].getBackground();
    }

    public JButton[] getButtons() {
        return this.buttons;
    }

    public int getMaxNum() {
        return this.column * this.row;
    }

    public void setGroupEnable(boolean flag) {
        int i = 0;
        while (i < this.row * this.column) {
            this.buttons[i].setEnabled(flag);
            ++i;
        }
    }

    public void clearGroup() {
        int i = 0;
        while (i < this.filledSize) {
            this.buttons[i].setBackground(Color.WHITE);
            this.buttons[i].setIcon(null);
            ++i;
        }
        this.filledSize = 0;
    }

    public void setBorder(boolean b) {
        if (!b) {
            int i = 0;
            while (i < this.row * this.column) {
                this.buttons[i].setOpaque(false);
                this.buttons[i].setContentAreaFilled(false);
                this.buttons[i].setBorderPainted(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.row * this.column) {
                this.buttons[i].setBorderPainted(true);
                ++i;
            }
        }
    }

    public int getButtonWidth() {
        return (int)(this.getPreferredSize().getWidth() / (double)this.column);
    }

    public int getButtonHeight() {
        return (int)(this.getPreferredSize().getHeight() / (double)this.row);
    }
}

