/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.graphical.high;

import com.iflytek.skintool.domin.KeyImageData;
import com.iflytek.skintool.graphical.low.IMEPanel;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.KeyboardData;
import com.iflytek.skintool.model.layout.RowData;
import com.iflytek.skintool.model.layout.SubKeyData;
import com.iflytek.skintool.model.pool.ExpressionImagePool;
import com.iflytek.skintool.model.pool.ThemeDataPool;
import com.iflytek.skintool.util.DrawUtil;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.PictureUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class KeyboardExpressionPanel
extends IMEPanel {
    private static final long serialVersionUID = -760684307111984991L;
    private IMEPanel contentPanel;
    private IMEPanel controlPanel;

    public KeyboardExpressionPanel(KeyboardData downKeyBoardData, IMEPanel parent, IMEPanel cand, String mTag) {
        this.initView();
        this.initKeyBoardData(downKeyBoardData, parent, cand);
    }

    private void initKeyBoardData(KeyboardData keyboard, IMEPanel parent, IMEPanel cand) {
        this.setSize(cand.getWidth(), parent.getHeight() - cand.getHeight());
        this.setLocation(0, cand.getHeight());
        this.setOpaque(false);
        KeyboardExpressionPanel.drawExpressionKeyboard(this, parent, keyboard);
    }

    private void initView() {
        this.setLayout(null);
        this.add(this.contentPanel);
        this.add(this.controlPanel);
        this.setSonPanel(this.contentPanel);
        this.setSonPanel(this.controlPanel);
    }

    public static void drawExpressionKeyboard(IMEPanel panel, IMEPanel parent, KeyboardData data) {
        DimensData dimensData = data.getDimensData();
        dimensData.measurePadding(panel.getWidth(), panel.getHeight());
        panel.setPadding(dimensData.getPadding());
        StyleData themeStyleData = null;
        StyleData keyboardStyleData = null;
        try {
            themeStyleData = ThemeDataPool.msubjectset.getKeyBoard(data.getThemeType()).getStyleData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (themeStyleData != null) {
            keyboardStyleData = themeStyleData;
        }
        if (keyboardStyleData != null) {
            DrawUtil.setStyle(panel, keyboardStyleData, parent, 1);
        }
        int i = 0;
        while (i < data.getAreaDataSet().size()) {
            AreaData areaData = (AreaData)data.getAreaDataSet().get(i);
            DimensData areaDimensData = areaData.getDimensData();
            DrawUtil.setDimens(panel.getSonPanel()[i], areaDimensData, panel);
            areaDimensData.measureMargin(panel.getWidth(), panel.getHeight());
            panel.getSonPanel()[i].setMargin(areaDimensData.getMargin());
            areaDimensData.measurePadding(panel.getSonPanel()[i].getWidth(), panel.getSonPanel()[i].getHeight());
            panel.getSonPanel()[i].setPadding(areaDimensData.getPadding());
            panel.getSonPanel()[i].setSize(panel.getSonPanel()[i].getWidth() - panel.getSonPanel()[i].getMargin().mX1 - panel.getSonPanel()[i].getMargin().mX2, panel.getSonPanel()[i].getHeight() - panel.getSonPanel()[i].getMargin().mY1 - panel.getSonPanel()[i].getMargin().mY2);
            int tempWidth = 0;
            int k = 0;
            while (k < i) {
                tempWidth = panel.getSonPanel()[k].getWidth() + panel.getSonPanel()[k].getMargin().getmX1() + panel.getSonPanel()[k].getMargin().getmX2() + tempWidth;
                ++k;
            }
            panel.getSonPanel()[i].setLocation(panel.getPadding().mX1 + panel.getSonPanel()[i].getMargin().mX1 + tempWidth, panel.getPadding().mY1 + panel.getSonPanel()[i].getMargin().mY1);
            panel.getSonPanel()[i].setOpaque(false);
            StyleData areaStyleData = areaData.getStyle();
            StyleData themeAreaData = null;
            try {
                themeAreaData = ThemeDataPool.msubjectset.getAreaLayoutData(areaData.getThemeType()).getBackgroundStyle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (themeAreaData != null) {
                ManageUtils.flag = true;
                areaStyleData = themeAreaData;
            }
            if (areaStyleData != null) {
                DrawUtil.setStyle(panel.getSonPanel()[i], areaStyleData, panel, 2);
            }
            ManageUtils.flag = false;
            if (i == 0) {
                KeyboardExpressionPanel.drawExpressionContent(panel.getSonPanel()[0], panel, areaData);
            } else if (i == 1) {
                KeyboardExpressionPanel.drawExpressionControl(panel.getSonPanel()[1], panel, areaData);
            }
            ++i;
        }
    }

    private static void drawExpressionContent(IMEPanel panel, IMEPanel parent, AreaData data) {
        DimensData dimensData = data.getDimensData();
        int cellWidth = (panel.getWidth() - panel.getPadding().mX1 - panel.getPadding().mX2) / dimensData.getRowCount();
        int cellHeight = (panel.getHeight() - panel.getPadding().mY1 - panel.getPadding().mY2) / dimensData.getColumnCount();
        KeyData keyData = data.getKeyAttribute();
        DimensData keyDimens = keyData.getDimensData();
        keyDimens.measurePadding(panel.getWidth(), panel.getHeight());
        StyleData styleBackData = keyData.getBackStateSet().get(1);
        if (styleBackData != null && styleBackData.getImageTag() != null) {
            styleBackData.loadImage(false, cellWidth, cellHeight);
        }
        StyleData themeForeStyleData = null;
        if (keyData.getThemeType() > 0) {
            try {
                themeForeStyleData = ThemeDataPool.msubjectset.getThemeKeyData(keyData.getThemeType()).getForegroundStyle(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ExpressionImagePool imagePool = ExpressionImagePool.getInstance();
        int i = 0;
        while (i < dimensData.getColumnCount()) {
            int j = 0;
            while (j < dimensData.getRowCount()) {
                panel.getSonButton()[j + i * dimensData.getRowCount()].setSize(cellWidth, cellHeight);
                panel.getSonButton()[j + i * dimensData.getRowCount()].setKeyData(keyData);
                panel.getSonButton()[j + i * dimensData.getRowCount()].setLocation(j * cellWidth + panel.getPadding().getmX1(), i * cellHeight + panel.getPadding().getmY1());
                ImageIcon tempIcon = imagePool.getImageIcon(j + i * dimensData.getRowCount());
                Image tempImage = tempIcon.getImage();
                tempImage = tempImage.getScaledInstance(50, 50, 1);
                tempIcon = new ImageIcon(tempImage);
                if (styleBackData != null && styleBackData.getImage() != null) {
                    panel.getSonButton()[j + i * dimensData.getRowCount()].setIcon(styleBackData.getImage());
                }
                JLabel tempLabel = new JLabel();
                tempLabel.setIcon(tempIcon);
                panel.getSonButton()[j + i * dimensData.getRowCount()].setLayout(null);
                tempLabel.setSize(tempIcon.getIconWidth(), tempIcon.getIconHeight());
                tempLabel.setLocation((cellWidth - tempIcon.getIconWidth()) / 2, (cellHeight - tempIcon.getIconHeight()) / 2);
                panel.getSonButton()[j + i * dimensData.getRowCount()].add(tempLabel);
                ++j;
            }
            ++i;
        }
    }

    private static void drawExpressionControl(IMEPanel panel, IMEPanel parent, AreaData data) {
        RowData rowData = data.getRowSet().get(0);
        int keySpace = 7;
        int keyWidth = panel.getWidth() - 2 * keySpace;
        int keyHeight = (panel.getHeight() - (rowData.getKeySet().size() - 1) * keySpace) / rowData.getKeySet().size();
        int i = 0;
        while (i < rowData.getKeySet().size()) {
            block30: {
                block29: {
                    KeyData keyData = (KeyData)rowData.getKeySet().get(i);
                    panel.getSonButton()[i].setSize(keyWidth, keyHeight);
                    panel.getSonButton()[i].setLocation(panel.getPadding().mX1 + keySpace, panel.getPadding().mY1 + (keyHeight + keySpace) * i);
                    StyleData styleData = keyData.getBackStateSet().get(1);
                    StyleData themeStyleData = null;
                    try {
                        themeStyleData = ThemeDataPool.msubjectset.getThemeKeyData(keyData.getThemeType()).getBackgroundStyle(1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (themeStyleData != null) {
                        styleData = themeStyleData;
                        ManageUtils.flag = true;
                    }
                    ImageIcon keyIcon = null;
                    if (styleData == null) break block29;
                    KeyImageData keyimage = styleData.loadImage(false, panel.getSonButton()[i].getWidth(), panel.getSonButton()[i].getHeight());
                    ManageUtils.flag = false;
                    panel.getSonButton()[i].setKeyimage(keyimage);
                    if (keyData.getImageTag() != null) {
                        keyData.loadImage(false, panel.getSonButton()[i].getWidth(), panel.getSonButton()[i].getHeight());
                        keyIcon = PictureUtil.getCombinPicture(new ImageIcon(styleData.getImage().getImage().getScaledInstance(panel.getSonButton()[i].getWidth(), panel.getSonButton()[i].getHeight(), 1)), keyData.getImage());
                        panel.getSonButton()[i].setIcon(keyIcon);
                        panel.getSonButton()[i].setForeImageIcon(keyData.getImage());
                    } else if (keyData.getSubKeys() != null) {
                        for (SubKeyData subKeyData : keyData.getSubKeys()) {
                            if (subKeyData.getForegroundStyle(1) == null || subKeyData.getForegroundStyle(1).getImageTag() == null) continue;
                            subKeyData.loadImage(false, panel.getSonButton()[i].getWidth(), panel.getSonButton()[i].getHeight());
                            keyIcon = PictureUtil.getCombinPicture(new ImageIcon(styleData.getImage().getImage().getScaledInstance(panel.getSonButton()[i].getWidth(), panel.getSonButton()[i].getHeight(), 1)), subKeyData.getForegroundStyle(1).getImage());
                            panel.getSonButton()[i].setIcon(keyIcon);
                            panel.getSonButton()[i].setForeImageIcon(subKeyData.getForegroundStyle(1).getImage());
                        }
                    } else if (keyData.getForeStateSet().get(1) != null && keyData.getForeStateSet().get(1).getImageTag() != null) {
                        StyleData foreStyleData = keyData.getForeStateSet().get(1);
                        foreStyleData.loadImage(false, panel.getSonButton()[i].getWidth(), panel.getSonButton()[i].getHeight());
                        keyIcon = PictureUtil.getCombinPicture(new ImageIcon(styleData.getImage().getImage().getScaledInstance(panel.getSonButton()[i].getWidth(), panel.getSonButton()[i].getHeight(), 1)), foreStyleData.getImage());
                        panel.getSonButton()[i].setIcon(keyIcon);
                        panel.getSonButton()[i].setForeImageIcon(foreStyleData.getImage());
                    } else {
                        panel.getSonButton()[i].setIcon(styleData.getImage());
                    }
                    panel.getSonButton()[i].setBackgroundIcon(styleData.getImage());
                    panel.getSonButton()[i].setFocusable(false);
                    if (styleData.getImage() == null) {
                        panel.getSonButton()[i].setOpaque(true);
                        panel.getSonButton()[i].setBackground(new Color(styleData.getBgColor()));
                    }
                    panel.getSonButton()[i].setKeyTag(keyData.getTag());
                    if (keyData.getText() == null && keyData.getSubKeys() == null) break block29;
                    StyleData forePressedStyle = new StyleData();
                    StyleData forestyledata = new StyleData();
                    StyleData themeForeStyle = null;
                    StyleData themeForePressedStyle = null;
                    String mText = null;
                    StringBuffer mTextBuffer = new StringBuffer();
                    if (keyData.getText() != null) {
                        mText = keyData.getText();
                        forestyledata = keyData.getForeStyle(1);
                        if (forestyledata == (forePressedStyle = keyData.getForeStyle(2))) {
                            forePressedStyle = new StyleData();
                            keyData.getForeStateSet().put(2, forePressedStyle);
                        }
                    } else {
                        for (SubKeyData subKeyData : keyData.getSubKeys()) {
                            if (subKeyData.getText() == null) continue;
                            mTextBuffer.append(subKeyData.getText());
                            mTextBuffer.append(',');
                        }
                        forestyledata = keyData.getSubKeys().get(0).getForegroundStyle(1);
                        forePressedStyle = keyData.getSubKeys().get(0).getForegroundStyle(2);
                        mText = mTextBuffer.toString();
                    }
                    try {
                        themeForeStyle = ThemeDataPool.msubjectset.getThemeKeyData(keyData.getThemeType()).getForegroundStyle(1);
                    }
                    catch (Exception subKeyData) {
                        // empty catch block
                    }
                    try {
                        themeForePressedStyle = ThemeDataPool.msubjectset.getThemeKeyData(keyData.getThemeType()).getForegroundStyle(2);
                    }
                    catch (Exception subKeyData) {
                        // empty catch block
                    }
                    if (themeForeStyle != null) {
                        if (themeForeStyle.getTextSize() > 0) {
                            forestyledata.setTextSize(themeForeStyle.getTextSize(), true);
                        }
                        forestyledata.setTextColor(themeForeStyle.getTextColor());
                    }
                    if (themeForePressedStyle != null) {
                        if (themeForePressedStyle.getTextSize() > 0) {
                            forePressedStyle.setTextSize(themeForePressedStyle.getTextSize(), true);
                        }
                        forePressedStyle.setTextColor(themeForePressedStyle.getTextColor());
                    }
                    if (mText == null) break block30;
                    panel.getSonButton()[i].setText(mText);
                    int textSize = forestyledata.getTextSize();
                    panel.getSonButton()[i].setType(keyData.getType());
                    int textColor = forestyledata.getTextColor();
                    if (DrawUtil.getDefaultfont() == null) {
                        DrawUtil.setDefaultfont(ManageUtils.getIMEFont());
                    }
                    Font iniFont = DrawUtil.getDefaultfont() != null ? DrawUtil.getDefaultfont().deriveFont((float)textSize) : new Font("Dialog", 0, textSize);
                    panel.getSonButton()[i].setFont(iniFont);
                    panel.getSonButton()[i].setForeground(new Color(textColor));
                }
                ManageUtils.flag = false;
            }
            ++i;
        }
    }
}

