/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.front.view;

import com.iflytek.skintool.domin.MyFont;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.ThemeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontDialog
extends JDialog {
    private static final long serialVersionUID = -8361241959208171619L;
    private JList list_font_size;
    private JList list_font_style;
    private JList list_font_name;
    private JTextField text_font_size;
    private JTextField text_font_style;
    private JTextField text_font_name;
    private String fontName;
    private String fontSize;
    private String fontStyle;
    private MyFont font_new;
    private JLabel prve_label;
    private JComponent component;
    private Font defaultFont;
    private Map<String, File> font_file_map;

    public MyFont getDlgFont() {
        return this.font_new;
    }

    private void actionForward(ListSelectionEvent arg0) {
        this.text_font_name.setText(String.valueOf(this.list_font_name.getSelectedValue()));
        this.text_font_size.setText(String.valueOf(this.list_font_size.getSelectedValue()));
        this.text_font_style.setText(String.valueOf(this.list_font_style.getSelectedValue()));
        String name = this.text_font_name.getText();
        String size = this.text_font_size.getText();
        String style = this.text_font_style.getText();
        if (!size.equals("null")) {
            Font temp;
            int intSize = Integer.parseInt(size);
            if (style.equals("\u5e38\u89c4")) {
                temp = new Font(name, 0, intSize);
                this.font_new = new MyFont(temp, this.font_file_map.get(name));
            }
            if (style.equals("\u52a0\u7c97")) {
                temp = new Font(name, 1, intSize);
                this.font_new = new MyFont(temp, this.font_file_map.get(name));
            }
            if (style.equals("\u503e\u659c")) {
                temp = new Font(name, 2, intSize);
                this.font_new = new MyFont(temp, this.font_file_map.get(name));
            }
            if (style.equals("\u52a0\u7c97_\u503e\u659c")) {
                temp = new Font(name, 3, intSize);
                this.font_new = new MyFont(temp, this.font_file_map.get(name));
            }
            this.prve_label.setFont(this.font_new.getFont());
        }
    }

    public void setInitFont(Font f, JComponent c) {
        if (f == null) {
            this.component = c;
        }
        this.defaultFont = f;
        this.fontName = f.getFontName();
        this.fontSize = String.valueOf(f.getSize());
        boolean isBold = f.isBold();
        boolean isIt = f.isItalic();
        boolean isPlain = f.isPlain();
        if (isBold && !isIt) {
            this.fontStyle = "\u52a0\u7c97";
        }
        if (!isBold && isIt) {
            this.fontStyle = "\u503e\u659c";
        }
        if (isPlain) {
            this.fontStyle = "\u5e38\u89c4";
        }
        if (isBold && isIt) {
            this.fontStyle = "\u52a0\u7c97_\u503e\u659c";
        }
        this.list_font_name.setSelectedValue(this.fontName, true);
        this.list_font_style.setSelectedValue(this.fontStyle, true);
        this.list_font_size.setSelectedValue(this.fontSize, true);
        this.text_font_name.setText(this.fontName);
        this.text_font_style.setText(this.fontStyle);
        this.text_font_size.setText(this.fontSize);
        this.font_new.setFont(f);
    }

    public FontDialog() {
        this.setResizable(false);
        this.setBounds(100, 100, 386, 375);
        URL url = ClassLoader.getSystemResource("icon.png");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.createImage(url);
        this.setIconImage(img);
        this.font_file_map = new HashMap<String, File>();
        this.font_new = new MyFont();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        this.getContentPane().add((Component)panel, "Center");
        JLabel label = new JLabel();
        label.setText("\u5b57\u4f53:");
        label.setBounds(10, 11, 35, 20);
        panel.add(label);
        this.text_font_name = new JTextField();
        this.text_font_name.setBackground(new Color(255, 255, 255));
        this.text_font_name.setEditable(false);
        this.text_font_name.setBounds(10, 32, 120, 21);
        panel.add(this.text_font_name);
        JLabel label_1 = new JLabel();
        label_1.setText("\u5b57\u5f62:");
        label_1.setBounds(151, 11, 35, 20);
        panel.add(label_1);
        this.text_font_style = new JTextField();
        this.text_font_style.setBackground(new Color(255, 255, 255));
        this.text_font_style.setEditable(false);
        this.text_font_style.setBounds(151, 32, 120, 21);
        panel.add(this.text_font_style);
        JLabel label_2 = new JLabel();
        label_2.setText("\u5927\u5c0f:");
        label_2.setBounds(285, 12, 35, 20);
        panel.add(label_2);
        this.text_font_size = new JTextField();
        this.text_font_size.setBackground(new Color(255, 255, 255));
        this.text_font_size.setEditable(false);
        this.text_font_size.setBounds(285, 32, 73, 21);
        panel.add(this.text_font_size);
        JLabel label_3 = new JLabel();
        label_3.setText("\u9884\u89c8:");
        label_3.setBounds(151, 192, 35, 20);
        panel.add(label_3);
        JButton button = new JButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String name = FontDialog.this.text_font_name.getText();
                String size = FontDialog.this.text_font_size.getText();
                String style = FontDialog.this.text_font_style.getText();
                int fontstyle = 0;
                if (style.equals("\u5e38\u89c4")) {
                    fontstyle = 0;
                }
                if (style.equals("\u52a0\u7c97")) {
                    fontstyle = 1;
                }
                if (style.equals("\u503e\u659c")) {
                    fontstyle = 2;
                }
                if (style.equals("\u52a0\u7c97_\u503e\u659c")) {
                    fontstyle = 3;
                }
                if (name == null) {
                    name = FontDialog.this.defaultFont.getName();
                }
                int fontsize = size == null ? FontDialog.this.defaultFont.getSize() : Integer.valueOf(size).intValue();
                if (style == null) {
                    fontstyle = FontDialog.this.defaultFont.getStyle();
                }
                Font temp = new Font(name, fontstyle, fontsize);
                FontDialog.this.font_new = new MyFont(temp, (File)FontDialog.this.font_file_map.get(name));
                FontDialog.this.setVisible(false);
                FontDialog.this.dispose();
            }
        });
        button.setText("\u786e\u5b9a");
        button.setBounds(154, 296, 100, 25);
        panel.add(button);
        JButton button_1 = new JButton();
        button_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FontDialog.this.font_new.setFont(FontDialog.this.defaultFont);
                FontDialog.this.setVisible(false);
                FontDialog.this.dispose();
            }
        });
        button_1.setText("\u53d6\u6d88");
        button_1.setBounds(258, 296, 100, 25);
        panel.add(button_1);
        this.prve_label = new JLabel();
        this.prve_label.setHorizontalAlignment(0);
        this.prve_label.setOpaque(true);
        this.prve_label.setBackground(new Color(255, 255, 255));
        this.prve_label.setBorder(new EtchedBorder(1));
        this.prve_label.setText("\u5b57\u4f53\u6837\u5f0f AaBbCc");
        this.prve_label.setBounds(151, 218, 207, 63);
        panel.add(this.prve_label);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(10, 59, 120, 262);
        panel.add(scrollPane);
        this.list_font_name = new JList();
        this.list_font_name.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                FontDialog.this.actionForward(arg0);
            }
        });
        this.list_font_name.setSelectionMode(0);
        this.list_font_name.setModel(new DefaultComboBoxModel<String>(this.getFontList()));
        scrollPane.setViewportView(this.list_font_name);
        this.list_font_style = new JList();
        this.list_font_style.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                FontDialog.this.actionForward(arg0);
            }
        });
        this.list_font_style.setBounds(151, 59, 120, 124);
        this.list_font_style.setSelectionMode(0);
        this.list_font_style.setModel(new DefaultComboBoxModel<String>(this.getFontStyleList()));
        panel.add(this.list_font_style);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(285, 59, 73, 124);
        panel.add(scrollPane_1);
        this.list_font_size = new JList();
        this.list_font_size.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                FontDialog.this.actionForward(arg0);
            }
        });
        this.list_font_size.setSelectionMode(0);
        this.list_font_size.setModel(new DefaultComboBoxModel<String>(this.getFontSizeList()));
        scrollPane_1.setViewportView(this.list_font_size);
    }

    private String[] getFontStyleList() {
        return new String[]{"\u5e38\u89c4", "\u503e\u659c", "\u52a0\u7c97", "\u52a0\u7c97_\u503e\u659c"};
    }

    private String[] getFontSizeList() {
        return new String[]{"6", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    }

    private Vector<String> getFontList() {
        GraphicsEnvironment eq = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Vector<String> vector = new Vector<String>();
        if (ManageUtils.getIMEFont() != null) {
            vector.add(ManageUtils.getIMEFont().getName());
        }
        String[] fontNames = eq.getAvailableFontFamilyNames();
        List<File> ttffile = ThemeUtils.getTTFFileFromDir();
        int i = 0;
        while (i < ttffile.size()) {
            Font f = null;
            Font df = null;
            try {
                f = Font.createFont(0, ttffile.get(i));
                df = f.deriveFont(40.0f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (FontFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            vector.add(df.getFontName());
            this.font_file_map.put(df.getFontName(), ttffile.get(i));
            ++i;
        }
        return vector;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FontDialog fontDlg = new FontDialog();
                JTextArea textArea = new JTextArea();
                Font f = textArea.getFont();
                fontDlg.setInitFont(f, textArea);
                fontDlg.setTitle("\u8bbe\u7f6e\u5b57\u4f53");
                fontDlg.setLocationRelativeTo(null);
                fontDlg.setModal(true);
                fontDlg.setVisible(true);
            }
        });
    }
}

