/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.front.controler;

import com.iflytek.skintool.front.controler.CandiBarEditLogic;
import com.iflytek.skintool.front.controler.ChooseTemplateLogic;
import com.iflytek.skintool.front.controler.KeyEditLogic;
import com.iflytek.skintool.front.controler.LeftPanelLogic;
import com.iflytek.skintool.front.controler.MainViewLogic;
import com.iflytek.skintool.front.controler.SkinBackEditLogic;
import com.iflytek.skintool.front.controler.SkinInfoEditLogic;
import com.iflytek.skintool.front.view.RightPanelView;
import com.iflytek.skintool.model.pool.LayoutDataPool;
import com.iflytek.skintool.util.ComponentImageCapturer;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.ThemeUtils;
import com.iflytek.skintool.util.ZIPFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class RightPanelLogic {
    private RightPanelView rightPanelView;
    private SkinInfoEditLogic skinInfoEditLogic;
    private SkinBackEditLogic skinBackEditLogic;
    private CandiBarEditLogic candiBarEditLogic;
    private KeyEditLogic keyEditLogic;
    private LeftPanelLogic leftLogic;
    private MainViewLogic mainLogic;
    private static String defaultPreviewImageName = "preview.jpg";

    public RightPanelLogic(LeftPanelLogic logic, MainViewLogic mLogic) {
        this.skinInfoEditLogic = new SkinInfoEditLogic(logic.getKeyboardViewLogic());
        this.skinBackEditLogic = new SkinBackEditLogic(logic.getKeyboardViewLogic());
        this.candiBarEditLogic = new CandiBarEditLogic(logic.getKeyboardViewLogic());
        this.keyEditLogic = new KeyEditLogic(logic.getKeyboardViewLogic());
        this.rightPanelView = new RightPanelView(this.skinInfoEditLogic.getSkinInfoEditView(), this.skinBackEditLogic.getSkinBackEditView(), this.candiBarEditLogic.getCandiBarEditView(), this.keyEditLogic.getKeyEditView());
        this.leftLogic = logic;
        this.mainLogic = mLogic;
        this.initListener();
    }

    public RightPanelView getRightPanelView() {
        return this.rightPanelView;
    }

    private ActionListener skininfoBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RightPanelLogic.this.skinInfoEditLogic.getSkinInfoEditView().setVisible(true);
                RightPanelLogic.this.skinBackEditLogic.getSkinBackEditView().setVisible(false);
                RightPanelLogic.this.candiBarEditLogic.getCandiBarEditView().setVisible(false);
                RightPanelLogic.this.keyEditLogic.getKeyEditView().setVisible(false);
                RightPanelLogic.this.leftLogic.getKeyboardViewLogic().hidePinyinAndCharacter();
            }
        };
    }

    private ActionListener skinbackBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RightPanelLogic.this.skinInfoEditLogic.getSkinInfoEditView().setVisible(false);
                RightPanelLogic.this.skinBackEditLogic.getSkinBackEditView().setVisible(true);
                RightPanelLogic.this.candiBarEditLogic.getCandiBarEditView().setVisible(false);
                RightPanelLogic.this.keyEditLogic.getKeyEditView().setVisible(false);
                RightPanelLogic.this.leftLogic.getKeyboardViewLogic().hidePinyinAndCharacter();
            }
        };
    }

    private ActionListener candibarBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RightPanelLogic.this.skinInfoEditLogic.getSkinInfoEditView().setVisible(false);
                RightPanelLogic.this.skinBackEditLogic.getSkinBackEditView().setVisible(false);
                RightPanelLogic.this.candiBarEditLogic.getCandiBarEditView().setVisible(true);
                RightPanelLogic.this.candiBarEditLogic.getKeyboardViewLogic().showPinyinAndCharacter();
                RightPanelLogic.this.leftLogic.getLeftPanelView().getLayoutComboBox().setSelectedIndex(0);
                RightPanelLogic.this.leftLogic.getLeftPanelView().getKeyboardComboBox().setSelectedIndex(0);
                RightPanelLogic.this.keyEditLogic.getKeyEditView().setVisible(false);
            }
        };
    }

    private ActionListener keyeditBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RightPanelLogic.this.skinInfoEditLogic.getSkinInfoEditView().setVisible(false);
                RightPanelLogic.this.skinBackEditLogic.getSkinBackEditView().setVisible(false);
                RightPanelLogic.this.candiBarEditLogic.getCandiBarEditView().setVisible(false);
                RightPanelLogic.this.keyEditLogic.getKeyEditView().setVisible(true);
                RightPanelLogic.this.leftLogic.getKeyboardViewLogic().hidePinyinAndCharacter();
            }
        };
    }

    private ActionListener exportThemeListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String defaultDisk = "e:/";
                String defaultFileName_it = String.valueOf(LayoutDataPool.getThemeInfo().getName()) + ".it";
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File(defaultDisk));
                chooser.setDialogTitle("\u5bfc\u51fa\u76ae\u80a4\u4e3b\u9898\u6587\u4ef6");
                chooser.setSelectedFile(new File(defaultFileName_it));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.addChoosableFileFilter(new ZIPFilter());
                int ch = chooser.showDialog(null, "\u5bfc\u51fa");
                if (ch == 0) {
                    int ifadd;
                    File file = chooser.getSelectedFile();
                    Pattern pattern = Pattern.compile(".*\\.[a-z]+", 2);
                    Matcher matcher = pattern.matcher(file.getAbsolutePath());
                    if (!matcher.find()) {
                        file = new File(file.getAbsolutePath().concat(".it"));
                    }
                    if (file.exists() && (ifadd = JOptionPane.showConfirmDialog(null, file + "\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728,\u662f\u5426\u8986\u76d6!", "\u6587\u4ef6\u5b58\u5728", 0, 2)) == 0) {
                        ThemeUtils.deleteDir(file.getAbsolutePath());
                    }
                    ManageUtils.flag = true;
                    String path = String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultThemeResFilePath() + defaultPreviewImageName;
                    ManageUtils.flag = false;
                    try {
                        ImageIO.write((RenderedImage)ComponentImageCapturer.getScrrenShot(RightPanelLogic.this.leftLogic.getKeyboardViewLogic().getKeyboardView().getLayoutPanels().get(0), 240, 200), "jpg", new File(path));
                        ManageUtils.exportSkinFile(file, LayoutDataPool.getThemeInfo().getID());
                    }
                    catch (Exception e2) {
                        System.out.println(e2.getMessage());
                    }
                } else {
                    return;
                }
            }
        };
    }

    private ActionListener reChooseListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RightPanelLogic.this.mainLogic.getChooseTemplateLogic() == null) {
                    ChooseTemplateLogic logic = new ChooseTemplateLogic(RightPanelLogic.this.mainLogic);
                    logic.showView();
                } else {
                    RightPanelLogic.this.mainLogic.getChooseTemplateLogic().showView();
                }
            }
        };
    }

    private void initListener() {
        this.rightPanelView.getSkininfoButton().addActionListener(this.skininfoBtnListener());
        this.rightPanelView.getBackgroundButton().addActionListener(this.skinbackBtnListener());
        this.rightPanelView.getCandiButton().addActionListener(this.candibarBtnListener());
        this.rightPanelView.getKeyButton().addActionListener(this.keyeditBtnListener());
        this.rightPanelView.getExportButton().addActionListener(this.exportThemeListener());
        this.rightPanelView.getReChooseButton().addActionListener(this.reChooseListener());
    }

    public SkinInfoEditLogic getSkinInfoEditLogic() {
        return this.skinInfoEditLogic;
    }

    public SkinBackEditLogic getSkinBackEditLogic() {
        return this.skinBackEditLogic;
    }

    public CandiBarEditLogic getCandiBarEditLogic() {
        return this.candiBarEditLogic;
    }

    public KeyEditLogic getKeyEditLogic() {
        return this.keyEditLogic;
    }
}

