/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.front.controler;

import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.domin.SaveImageData;
import com.iflytek.skintool.front.controler.KeyboardViewLogic;
import com.iflytek.skintool.front.view.KeyEditView;
import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.model.pool.ImagePool;
import com.iflytek.skintool.model.pool.LayoutDataPool;
import com.iflytek.skintool.model.pool.ThemeDataPool;
import com.iflytek.skintool.model.theme.ThemeAreaData;
import com.iflytek.skintool.model.theme.ThemeKeyData;
import com.iflytek.skintool.parser.utils.ThemeFileManager;
import com.iflytek.skintool.util.CustomizedColorChooser;
import com.iflytek.skintool.util.CustomizedFileChooser;
import com.iflytek.skintool.util.FileUtils;
import com.iflytek.skintool.util.ImageFilter;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.ThemeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.swing.ImageIcon;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KeyEditLogic {
    private KeyboardViewLogic keyboardViewLogic;
    private KeyEditView keyEditView;
    private String keyImagePath;
    private String keyPressedImagePath;
    boolean initComboxFlag;
    private final String defaultImageTag = "Image_Keyboard_Key";
    private final String defaultImageSrc = "btn_keyboard_key_normal.png";
    private final String defaultPressedImageTag = "Image_Keyboard_Key_Press";
    private final String defaultPressedImageSrc = "btn_keyboard_key_pressed.png";
    private SaveImageData saveKeyImageData;
    private SaveImageData saveKeyPressedData;
    private static String savedKeyImagePath = String.valueOf(System.getProperty("user.dir")) + "\\bin\\keyimage";
    private static String savedKeyPressedImagePath = String.valueOf(System.getProperty("user.dir")) + "\\bin\\keypressedimage";

    public KeyEditView getKeyEditView() {
        return this.keyEditView;
    }

    public KeyEditLogic(KeyboardViewLogic logic) {
        this.keyboardViewLogic = logic;
        this.keyEditView = new KeyEditView();
        this.initListeners();
        this.initTextfieldListeners();
    }

    private void initListeners() {
        this.keyEditView.getNormalStateButton().addActionListener(this.chooseKeyImageListener());
        this.keyEditView.getNormalKeyModeBox().addActionListener(this.stretchModeChangedListener());
        this.keyEditView.getPressedStateButton().addActionListener(this.chooseKeyPressedImageListener());
        this.keyEditView.getPressedKeyModeBox().addActionListener(this.pressedStretchModeChangedListener());
        this.keyEditView.getUndoNormalButton().addActionListener(this.undoKeyImageListener());
        this.keyEditView.getUndoPressedButton().addActionListener(this.undoPressedKeyImageListener());
        this.keyEditView.getNormalForegroundButton().addActionListener(this.normalKeyForegroundLisenter());
        this.keyEditView.getPressedForegroundButton().addActionListener(this.pressedKeyForegroundLisenter());
        this.keyEditView.getAlphaSlider().addChangeListener(this.alphaChangedLisenter());
    }

    private void initTextfieldListeners() {
        this.keyEditView.getxStartField().addKeyListener(this.keyTextFieldEnterListener());
        this.keyEditView.getxEndField().addKeyListener(this.keyTextFieldEnterListener());
        this.keyEditView.getyStartField().addKeyListener(this.keyTextFieldEnterListener());
        this.keyEditView.getyEndField().addKeyListener(this.keyTextFieldEnterListener());
        this.keyEditView.getPressedXStartField().addKeyListener(this.pressedTextFieldEnterListener());
        this.keyEditView.getPressedYStartField().addKeyListener(this.pressedTextFieldEnterListener());
        this.keyEditView.getPressedXEndField().addKeyListener(this.pressedTextFieldEnterListener());
        this.keyEditView.getPressedYEndField().addKeyListener(this.pressedTextFieldEnterListener());
    }

    private ActionListener normalForeBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    KeyEditLogic.this.keyEditView.getNormalForegroundButton().setBackground(colorChooser.getColor());
                    KeyEditLogic.this.keyboardViewLogic.getKeyboardView().changeKeyForeColor(colorChooser.getColor());
                    ThemeDataPool.getComboKeyData().getForegroundStyle(1).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getNormalKeyData().getForegroundStyle(1).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getSpeechTitleKeyData().getForegroundStyle(1).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getSpeechLanguageKeyData().getForegroundStyle(1).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getSpeechBtnKeyData().getForegroundStyle(1).setTextColor(colorChooser.getColor().getRGB());
                }
            }
        };
    }

    private ActionListener pressedForeBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    KeyEditLogic.this.keyEditView.getPressedForegroundButton().setBackground(colorChooser.getColor());
                    ThemeDataPool.getComboKeyData().getForegroundStyle(2).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getNormalKeyData().getForegroundStyle(2).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getSpeechTitleKeyData().getForegroundStyle(2).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getSpeechLanguageKeyData().getForegroundStyle(2).setTextColor(colorChooser.getColor().getRGB());
                    ThemeDataPool.getSpeechBtnKeyData().getForegroundStyle(2).setTextColor(colorChooser.getColor().getRGB());
                }
            }
        };
    }

    private ActionListener chooseKeyImageListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedFileChooser fileChooser = new CustomizedFileChooser(new ImageFilter());
                File imageFile = fileChooser.getFile();
                if (imageFile != null) {
                    if (KeyEditLogic.this.saveKeyImageData.getStoragePath() == null) {
                        KeyEditLogic.this.saveKeyImageData.setStoragePath(savedKeyImagePath);
                        FileUtils.copyFile(KeyEditLogic.this.saveKeyImageData.getCurPath(), savedKeyImagePath, true);
                    }
                    KeyEditLogic.this.keyImagePath = imageFile.getAbsolutePath();
                    KeyEditLogic.this.keyEditView.getxStartField().setText("0");
                    KeyEditLogic.this.keyEditView.getxEndField().setText("0");
                    KeyEditLogic.this.keyEditView.getyStartField().setText("0");
                    KeyEditLogic.this.keyEditView.getyEndField().setText("0");
                    String tag = ThemeDataPool.getNormalKeyData().getBackgroundStyle(1).getImageTag();
                    if (tag == null) {
                        tag = "Image_Keyboard_Key";
                        ThemeDataPool.getNormalKeyData().getBackgroundStyleSet().get(1).setImageTag("Image_Keyboard_Key");
                        ThemeDataPool.getNormalKeyData().getBackgroundStyleSet().get(1).getImageData().setSrcName("btn_keyboard_key_normal.png");
                    }
                    ManageUtils.flag = true;
                    String srcImagePath = ThemeFileManager.getInstance().getImageNameByTag(tag);
                    ManageUtils.flag = false;
                    try {
                        FileChannel src = new FileInputStream(KeyEditLogic.this.keyImagePath).getChannel();
                        FileChannel des = new FileOutputStream(srcImagePath).getChannel();
                        des.transferFrom(src, 0L, src.size());
                        des.close();
                        src.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    ImagePool.getInstance().removeImage(tag);
                    ThemeKeyData themeFuncKeyData = ThemeDataPool.getFuncKeyData();
                    String funcKeyTag = themeFuncKeyData.getBackgroundStyle(1).getImageTag();
                    ImagePool.getInstance().removeImage(funcKeyTag);
                    themeFuncKeyData.getBackgroundStyle(1).setImageTag(tag);
                    ThemeAreaData themeAreaData = ThemeDataPool.getComboAreaData();
                    String combAreaTag = themeAreaData.getBackgroundStyle().getImageTag();
                    ImagePool.getInstance().removeImage(combAreaTag);
                    themeAreaData.getBackgroundStyle().setImageTag(tag);
                    ImageData imageData = ThemeFileManager.getInstance().getImageByTag(tag);
                    imageData.getXDivs()[0] = 0;
                    imageData.getXDivs()[1] = 0;
                    imageData.getYDivs()[0] = 0;
                    imageData.getYDivs()[1] = 0;
                    imageData.setType(-1);
                    String[] XDivsStr = new String[]{"0", "0"};
                    String[] yDivsStr = new String[]{"0", "0"};
                    ThemeDataPool.getNormalKeyData().getBackgroundStyle(1).getImageData().setXDivs(XDivsStr);
                    ThemeDataPool.getNormalKeyData().getBackgroundStyle(1).getImageData().setYDivs(yDivsStr);
                    ThemeDataPool.getNormalKeyData().getBackgroundStyle(1).getImageData().setType(-1);
                    themeFuncKeyData.getBackgroundStyle(1).getImageData().setXDivs(XDivsStr);
                    themeFuncKeyData.getBackgroundStyle(1).getImageData().setYDivs(yDivsStr);
                    themeFuncKeyData.getBackgroundStyle(1).getImageData().setType(-1);
                    themeAreaData.getBackgroundStyle().getImageData().setXDivs(XDivsStr);
                    themeAreaData.getBackgroundStyle().getImageData().setYDivs(yDivsStr);
                    themeAreaData.getBackgroundStyle().getImageData().setType(-1);
                    KeyEditLogic.this.keyboardViewLogic.getKeyboardView().reload();
                }
            }
        };
    }

    private ActionListener chooseKeyPressedImageListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedFileChooser fileChooser = new CustomizedFileChooser(new ImageFilter());
                File imageFile = fileChooser.getFile();
                if (imageFile != null) {
                    if (KeyEditLogic.this.saveKeyPressedData.getStoragePath() == null) {
                        KeyEditLogic.this.saveKeyPressedData.setStoragePath(savedKeyPressedImagePath);
                        FileUtils.copyFile(KeyEditLogic.this.saveKeyPressedData.getCurPath(), savedKeyPressedImagePath, true);
                    }
                    KeyEditLogic.this.keyPressedImagePath = imageFile.getAbsolutePath();
                    KeyEditLogic.this.keyEditView.getPressedXStartField().setText("0");
                    KeyEditLogic.this.keyEditView.getPressedXEndField().setText("0");
                    KeyEditLogic.this.keyEditView.getPressedYStartField().setText("0");
                    KeyEditLogic.this.keyEditView.getPressedYEndField().setText("0");
                    String tag = ThemeDataPool.getNormalKeyData().getBackgroundStyle(2).getImageTag();
                    if (tag == null) {
                        tag = "Image_Keyboard_Key_Press";
                        ThemeDataPool.getNormalKeyData().getBackgroundStyleSet().get(1).setImageTag("Image_Keyboard_Key_Press");
                        ThemeDataPool.getNormalKeyData().getBackgroundStyleSet().get(1).getImageData().setSrcName("btn_keyboard_key_pressed.png");
                    }
                    ManageUtils.flag = true;
                    String srcImagePath = ThemeFileManager.getInstance().getImageNameByTag(tag);
                    ManageUtils.flag = false;
                    try {
                        FileChannel src = new FileInputStream(KeyEditLogic.this.keyPressedImagePath).getChannel();
                        FileChannel des = new FileOutputStream(srcImagePath).getChannel();
                        des.transferFrom(src, 0L, src.size());
                        des.close();
                        src.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    ImagePool.getInstance().removeImage(tag);
                    ThemeKeyData themeFuncKeyData = ThemeDataPool.getFuncKeyData();
                    String funcKeyTag = themeFuncKeyData.getBackgroundStyle(2).getImageTag();
                    ImagePool.getInstance().removeImage(funcKeyTag);
                    themeFuncKeyData.getBackgroundStyle(2).setImageTag(tag);
                    ImageData imageData = ThemeFileManager.getInstance().getImageByTag(tag);
                    imageData.getXDivs()[0] = 0;
                    imageData.getXDivs()[1] = 0;
                    imageData.getYDivs()[0] = 0;
                    imageData.getYDivs()[1] = 0;
                    imageData.setType(-1);
                    String[] XDivsStr = new String[]{"0", "0"};
                    String[] yDivsStr = new String[]{"0", "0"};
                    ThemeDataPool.getNormalKeyData().getBackgroundStyle(2).getImageData().setXDivs(XDivsStr);
                    ThemeDataPool.getNormalKeyData().getBackgroundStyle(2).getImageData().setYDivs(yDivsStr);
                    ThemeDataPool.getNormalKeyData().getBackgroundStyle(2).getImageData().setType(-1);
                    themeFuncKeyData.getBackgroundStyle(2).getImageData().setXDivs(XDivsStr);
                    themeFuncKeyData.getBackgroundStyle(2).getImageData().setYDivs(yDivsStr);
                    themeFuncKeyData.getBackgroundStyle(2).getImageData().setType(-1);
                }
            }
        };
    }

    private KeyListener keyTextFieldEnterListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isDigit(e.getKeyChar())) {
                    return;
                }
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    KeyEditLogic.this.processKeyImageParams();
                }
            }
        };
    }

    private KeyListener pressedTextFieldEnterListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isDigit(e.getKeyChar())) {
                    return;
                }
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    KeyEditLogic.this.processPressedImageParam();
                }
            }
        };
    }

    private void processKeyImageParams() {
        ThemeKeyData themeKeyData = ThemeDataPool.getNormalKeyData();
        ManageUtils.flag = true;
        String srcKeyImage = String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultThemeResFilePath() + themeKeyData.getBackgroundStyle(1).getImageData().getImageSrcName();
        ManageUtils.flag = false;
        ImageIcon themeKeyIcon = new ImageIcon(srcKeyImage);
        themeKeyIcon.getImage().flush();
        if (!(this.keyEditView.getxStartField().getText().trim().equals("") || this.keyEditView.getxEndField().getText().trim().equals("") || this.keyEditView.getyStartField().getText().trim().equals("") || this.keyEditView.getyEndField().getText().equals(""))) {
            boolean flag = true;
            if (Integer.valueOf(this.keyEditView.getxStartField().getText()) < Integer.valueOf(this.keyEditView.getxEndField().getText())) {
                if (Integer.valueOf(this.keyEditView.getxStartField().getText()) <= themeKeyIcon.getIconWidth()) {
                    if (Integer.valueOf(this.keyEditView.getxEndField().getText()) <= themeKeyIcon.getIconWidth()) {
                        flag = true;
                    } else {
                        flag = false;
                        this.keyEditView.getBtnErrorLabel().setText("\"X\u7ed3\u675f\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u5bbd\u5ea6");
                    }
                } else {
                    flag = false;
                    this.keyEditView.getBtnErrorLabel().setText("\"X\u5f00\u59cb\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u5bbd\u5ea6");
                }
            } else {
                flag = false;
                this.keyEditView.getBtnErrorLabel().setText("\"X\u5f00\u59cb\"\u9700\u5927\u4e8e\"X\u7ed3\u675f\"");
            }
            if (flag && Integer.valueOf(this.keyEditView.getyStartField().getText()) < Integer.valueOf(this.keyEditView.getyEndField().getText())) {
                if (Integer.valueOf(this.keyEditView.getyStartField().getText()) <= themeKeyIcon.getIconHeight()) {
                    if (Integer.valueOf(this.keyEditView.getyEndField().getText()) <= themeKeyIcon.getIconHeight()) {
                        flag = true;
                    } else {
                        flag = false;
                        this.keyEditView.getBtnErrorLabel().setText("\"Y\u7ed3\u675f\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6");
                    }
                } else {
                    flag = false;
                    this.keyEditView.getBtnErrorLabel().setText("\"Y\u5f00\u59cb\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6");
                }
            } else if (flag) {
                flag = false;
                this.keyEditView.getBtnErrorLabel().setText("\"Y\u5f00\u59cb\"\u9700\u5927\u4e8e\"Y\u7ed3\u675f\"");
            }
            if (flag) {
                this.keyEditView.getBtnErrorLabel().setText(" ");
                ImageIcon keyIcon = themeKeyData.getBackgroundStyle(1).getImage();
                if (keyIcon != null) {
                    Rectangle rect = new Rectangle(Integer.valueOf(this.keyEditView.getxStartField().getText()), Integer.valueOf(this.keyEditView.getyStartField().getText()), Integer.valueOf(this.keyEditView.getxEndField().getText()), Integer.valueOf(this.keyEditView.getyEndField().getText()));
                    rect.setmType();
                    int mode = this.keyEditView.getNormalKeyModeBox().getSelectedIndex();
                    ImagePool.getInstance().removeImage(themeKeyData.getBackgroundStyle(1).getImageTag());
                    String[] XDivsStr = new String[]{this.keyEditView.getxStartField().getText(), this.keyEditView.getxEndField().getText()};
                    String[] yDivsStr = new String[]{this.keyEditView.getyStartField().getText(), this.keyEditView.getyEndField().getText()};
                    themeKeyData.getBackgroundStyle(1).getImageData().setXDivs(XDivsStr);
                    themeKeyData.getBackgroundStyle(1).getImageData().setYDivs(yDivsStr);
                    ImageData imageData = ThemeFileManager.getInstance().getImageByTag(themeKeyData.getBackgroundStyle(1).getImageTag());
                    imageData.getXDivs()[0] = Integer.valueOf(this.keyEditView.getxStartField().getText());
                    imageData.getXDivs()[1] = Integer.valueOf(this.keyEditView.getxEndField().getText());
                    imageData.getYDivs()[0] = Integer.valueOf(this.keyEditView.getyStartField().getText());
                    imageData.getYDivs()[1] = Integer.valueOf(this.keyEditView.getyEndField().getText());
                    if (mode == 0) {
                        themeKeyData.getBackgroundStyle(1).getImageData().setType(-1);
                        imageData.setType(-1);
                        this.keyboardViewLogic.getKeyboardView().reload();
                    }
                    if (mode == 1) {
                        themeKeyData.getBackgroundStyle(1).getImageData().setType(3);
                        imageData.setType(3);
                        this.keyboardViewLogic.getKeyboardView().reload();
                    }
                }
            }
        } else {
            this.keyEditView.getBtnErrorLabel().setText("\u56fe\u7247\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void processPressedImageParam() {
        ThemeKeyData themeKeyData = ThemeDataPool.getNormalKeyData();
        ManageUtils.flag = true;
        String srcKeyImage = String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultThemeResFilePath() + themeKeyData.getBackgroundStyle(2).getImageData().getImageSrcName();
        ManageUtils.flag = false;
        ImageIcon themeKeyIcon = new ImageIcon(srcKeyImage);
        themeKeyIcon.getImage().flush();
        if (!(this.keyEditView.getPressedXStartField().getText().trim().equals("") || this.keyEditView.getPressedXEndField().getText().trim().equals("") || this.keyEditView.getPressedYStartField().getText().trim().equals("") || this.keyEditView.getPressedYEndField().getText().equals(""))) {
            boolean flag = true;
            if (Integer.valueOf(this.keyEditView.getPressedXStartField().getText()) < Integer.valueOf(this.keyEditView.getPressedXEndField().getText())) {
                if (Integer.valueOf(this.keyEditView.getPressedXStartField().getText()) <= themeKeyIcon.getIconWidth()) {
                    if (Integer.valueOf(this.keyEditView.getPressedXEndField().getText()) <= themeKeyIcon.getIconWidth()) {
                        flag = true;
                    } else {
                        flag = false;
                        this.keyEditView.getPressedBtnErrorLabel().setText("\"X\u7ed3\u675f\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u5bbd\u5ea6");
                    }
                } else {
                    flag = false;
                    this.keyEditView.getPressedBtnErrorLabel().setText("\"X\u5f00\u59cb\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u5bbd\u5ea6");
                }
            } else {
                flag = false;
                this.keyEditView.getPressedBtnErrorLabel().setText("\"X\u5f00\u59cb\"\u9700\u5927\u4e8e\"X\u7ed3\u675f\"");
            }
            if (flag && Integer.valueOf(this.keyEditView.getPressedYStartField().getText()) < Integer.valueOf(this.keyEditView.getPressedYEndField().getText())) {
                if (Integer.valueOf(this.keyEditView.getPressedYStartField().getText()) <= themeKeyIcon.getIconHeight()) {
                    if (Integer.valueOf(this.keyEditView.getPressedYEndField().getText()) <= themeKeyIcon.getIconHeight()) {
                        flag = true;
                    } else {
                        flag = false;
                        this.keyEditView.getPressedBtnErrorLabel().setText("\"Y\u7ed3\u675f\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6");
                    }
                } else {
                    flag = false;
                    this.keyEditView.getPressedBtnErrorLabel().setText("\"Y\u5f00\u59cb\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6");
                }
            } else if (flag) {
                flag = false;
                this.keyEditView.getPressedBtnErrorLabel().setText("\"Y\u5f00\u59cb\"\u9700\u5927\u4e8e\"Y\u7ed3\u675f\"");
            }
            if (flag) {
                this.keyEditView.getPressedBtnErrorLabel().setText(" ");
                ImageIcon keyIcon = themeKeyData.getBackgroundStyle(2).getImage();
                if (keyIcon != null) {
                    int mode = this.keyEditView.getPressedKeyModeBox().getSelectedIndex();
                    ImagePool.getInstance().removeImage(themeKeyData.getBackgroundStyle(2).getImageTag());
                    String[] XDivsStr = new String[]{this.keyEditView.getPressedXStartField().getText(), this.keyEditView.getPressedXEndField().getText()};
                    String[] yDivsStr = new String[]{this.keyEditView.getPressedYStartField().getText(), this.keyEditView.getPressedYEndField().getText()};
                    themeKeyData.getBackgroundStyle(2).getImageData().setXDivs(XDivsStr);
                    themeKeyData.getBackgroundStyle(2).getImageData().setYDivs(yDivsStr);
                    ImageData imageData = ThemeFileManager.getInstance().getImageByTag(themeKeyData.getBackgroundStyle(2).getImageTag());
                    imageData.getXDivs()[0] = Integer.valueOf(this.keyEditView.getPressedXStartField().getText());
                    imageData.getXDivs()[1] = Integer.valueOf(this.keyEditView.getPressedXEndField().getText());
                    imageData.getYDivs()[0] = Integer.valueOf(this.keyEditView.getPressedYStartField().getText());
                    imageData.getYDivs()[1] = Integer.valueOf(this.keyEditView.getPressedYEndField().getText());
                    if (mode == 1) {
                        themeKeyData.getBackgroundStyle(2).getImageData().setType(3);
                        imageData.setType(3);
                    } else {
                        themeKeyData.getBackgroundStyle(2).getImageData().setType(-1);
                        imageData.setType(-1);
                    }
                    this.keyboardViewLogic.getKeyboardView().reload();
                }
            }
        } else {
            this.keyEditView.getPressedBtnErrorLabel().setText("\u56fe\u7247\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private ActionListener stretchModeChangedListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!KeyEditLogic.this.initComboxFlag) {
                    KeyEditLogic.this.processKeyImageParams();
                }
            }
        };
    }

    private ActionListener pressedStretchModeChangedListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!KeyEditLogic.this.initComboxFlag) {
                    KeyEditLogic.this.processPressedImageParam();
                }
            }
        };
    }

    private ActionListener undoKeyImageListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KeyEditLogic.this.saveKeyImageData.getStoragePath() != null) {
                    FileUtils.copyFile(KeyEditLogic.this.saveKeyImageData.getStoragePath(), KeyEditLogic.this.saveKeyImageData.getCurPath(), true);
                }
                KeyEditLogic.this.keyEditView.getNormalKeyModeBox().setSelectedIndex(KeyEditLogic.this.saveKeyImageData.getStretchMode());
                KeyEditLogic.this.keyEditView.getxStartField().setText(Integer.toString(KeyEditLogic.this.saveKeyImageData.getRect().getmX1()));
                KeyEditLogic.this.keyEditView.getyStartField().setText(Integer.toString(KeyEditLogic.this.saveKeyImageData.getRect().getmY1()));
                KeyEditLogic.this.keyEditView.getxEndField().setText(Integer.toString(KeyEditLogic.this.saveKeyImageData.getRect().getmX2()));
                KeyEditLogic.this.keyEditView.getyEndField().setText(Integer.toString(KeyEditLogic.this.saveKeyImageData.getRect().getmY2()));
                KeyEditLogic.this.processKeyImageParams();
            }
        };
    }

    private ActionListener undoPressedKeyImageListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KeyEditLogic.this.saveKeyPressedData.getStoragePath() != null) {
                    FileUtils.copyFile(KeyEditLogic.this.saveKeyPressedData.getStoragePath(), KeyEditLogic.this.saveKeyPressedData.getCurPath(), true);
                }
                KeyEditLogic.this.keyEditView.getPressedKeyModeBox().setSelectedIndex(KeyEditLogic.this.saveKeyPressedData.getStretchMode());
                KeyEditLogic.this.keyEditView.getPressedXStartField().setText(Integer.toString(KeyEditLogic.this.saveKeyPressedData.getRect().getmX1()));
                KeyEditLogic.this.keyEditView.getPressedYStartField().setText(Integer.toString(KeyEditLogic.this.saveKeyPressedData.getRect().getmY1()));
                KeyEditLogic.this.keyEditView.getPressedXEndField().setText(Integer.toString(KeyEditLogic.this.saveKeyPressedData.getRect().getmX2()));
                KeyEditLogic.this.keyEditView.getPressedYEndField().setText(Integer.toString(KeyEditLogic.this.saveKeyPressedData.getRect().getmY2()));
                KeyEditLogic.this.processPressedImageParam();
            }
        };
    }

    private ActionListener normalKeyForegroundLisenter() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    KeyEditLogic.this.setNormalKeyForeground(colorChooser.getColor());
                }
            }
        };
    }

    private void setNormalKeyForeground(Color color) {
        this.getKeyEditView().getNormalForegroundButton().setBackground(color);
        ThemeDataPool.msubjectset.setThemeColor(color.getRGB());
        ThemeDataPool.msubjectset.getThemeKeyData(3).getForegroundStyle(1).setTextColor(color.getRGB());
        this.keyboardViewLogic.getKeyboardView().setVisible(false);
        this.keyboardViewLogic.getKeyboardView().reload();
        this.keyboardViewLogic.getKeyboardView().setVisible(true);
    }

    private ActionListener pressedKeyForegroundLisenter() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    KeyEditLogic.this.setPressedKeyForeground(colorChooser.getColor());
                }
            }
        };
    }

    private void setPressedKeyForeground(Color color) {
        this.getKeyEditView().getPressedForegroundButton().setBackground(color);
        ThemeDataPool.msubjectset.getThemeKeyData(3).getForegroundStyle(2).setTextColor(color.getRGB());
        ThemeDataPool.msubjectset.setThemePressColor(color.getRGB());
    }

    public void unableKeyEditor() {
        this.keyEditView.setEditorEnable(false);
    }

    public void enableKeyEditor() {
        this.keyEditView.setEditorEnable(true);
    }

    public boolean isInitComboxFlag() {
        return this.initComboxFlag;
    }

    public void setInitComboxFlag(boolean initComboxFlag) {
        this.initComboxFlag = initComboxFlag;
    }

    public SaveImageData getSaveKeyImageData() {
        return this.saveKeyImageData;
    }

    public void setSaveKeyImageData(SaveImageData saveKeyImageData) {
        this.saveKeyImageData = saveKeyImageData;
    }

    public SaveImageData getSaveKeyPressedData() {
        return this.saveKeyPressedData;
    }

    public void setSaveKeyPressedData(SaveImageData saveKeyPressedData) {
        this.saveKeyPressedData = saveKeyPressedData;
    }

    public void setAlpha(int value) {
        this.keyEditView.getAlphaValueLabel().setText(String.valueOf(ThemeUtils.getPercentFromAlpha(value)) + "%");
        this.keyEditView.getAlphaSlider().setValue(ThemeUtils.getPercentFromAlpha(value));
    }

    private ChangeListener alphaChangedLisenter() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                KeyEditLogic.this.keyEditView.getAlphaValueLabel().setText(String.valueOf(source.getValue()) + "%");
                KeyEditLogic.this.keyboardViewLogic.getKeyboardView().setAlpha(ThemeUtils.getAlphaFromPercent(source.getValue()));
                LayoutDataPool.getThemeInfo().setAlpha(ThemeUtils.getAlphaFromPercent(source.getValue()));
            }
        };
    }
}

