/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.front.controler;

import com.iflytek.skintool.domin.KeyImageData;
import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.domin.SaveImageData;
import com.iflytek.skintool.front.controler.KeyboardViewLogic;
import com.iflytek.skintool.front.view.CandiBarEditView;
import com.iflytek.skintool.graphical.high.IMEKeyboardPanel;
import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.ComposingData;
import com.iflytek.skintool.model.pool.ImagePool;
import com.iflytek.skintool.model.pool.ThemeDataPool;
import com.iflytek.skintool.model.theme.ThemeKeyboardData;
import com.iflytek.skintool.util.CustomizedColorChooser;
import com.iflytek.skintool.util.CustomizedFileChooser;
import com.iflytek.skintool.util.FileUtils;
import com.iflytek.skintool.util.ImageFilter;
import com.iflytek.skintool.util.JavaNinePatchImage;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.PictureUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;

public class CandiBarEditLogic {
    private CandiBarEditView candiBarEditView;
    private KeyboardViewLogic keyboardViewLogic;
    private ImageData imageData;
    private boolean initFlag = false;
    private Color oldFocusedCandColor;
    private Color oldUnfocusedCandColor;
    private Color oldPressedCandColor;
    private Color oldComposingColor;
    private Color oldComposingBgColor;
    private Color oldCandBgColor;
    private SaveImageData saveImageData;
    private static String savedCandImagePath = String.valueOf(System.getProperty("user.dir")) + "\\bin\\candimage";

    public CandiBarEditLogic(KeyboardViewLogic logic) {
        this.keyboardViewLogic = logic;
        this.candiBarEditView = new CandiBarEditView();
        this.initListeners();
        this.initTextFieldListeners();
    }

    public CandiBarEditView getCandiBarEditView() {
        return this.candiBarEditView;
    }

    public KeyboardViewLogic getKeyboardViewLogic() {
        return this.keyboardViewLogic;
    }

    private void initListeners() {
        this.candiBarEditView.getPyCompositeColorButton().addActionListener(this.pyComposingColorListener());
        this.candiBarEditView.getPyBackgroundColorButton().addActionListener(this.pyComposingBgListener());
        this.candiBarEditView.getFirstCandiColorButton().addActionListener(this.firstCandColorListener());
        this.candiBarEditView.getCandiColorButton().addActionListener(this.candColorListener());
        this.candiBarEditView.getCandiPressBgcolorButton().addActionListener(this.candPressedBackListener());
        this.candiBarEditView.getCandiPressColorButton().addActionListener(this.candPressedListener());
        this.candiBarEditView.getChooseBgButton().addActionListener(this.chooseCandBgListener());
        this.candiBarEditView.getStretchModeList().addActionListener(this.stretchModeChangedLisenter());
        this.candiBarEditView.getUndoCompisingForeButton().addActionListener(this.undoComposingColorListener());
        this.candiBarEditView.getUndoComposingBgButton().addActionListener(this.undoComposingBgListener());
        this.candiBarEditView.getUndoFocusedCandButton().addActionListener(this.undoFocusedCandColorListener());
        this.candiBarEditView.getUndoPressedCandBgButton().addActionListener(this.undoCandPressedBgListener());
        this.candiBarEditView.getUndoPressedCandButton().addActionListener(this.undoCandPressedColorListener());
        this.candiBarEditView.getUndoUnfocusedCandButton().addActionListener(this.undoUnfocusedCandColorListener());
        this.candiBarEditView.getUndoCandImageButton().addActionListener(this.undoImageCandListener());
    }

    private void initTextFieldListeners() {
        this.candiBarEditView.getStartXField().addKeyListener(this.textFieldEnterListener());
        this.candiBarEditView.getStartYField().addKeyListener(this.textFieldEnterListener());
        this.candiBarEditView.getEndXField().addKeyListener(this.textFieldEnterListener());
        this.candiBarEditView.getEndYField().addKeyListener(this.textFieldEnterListener());
    }

    private ActionListener pyComposingColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    CandiBarEditLogic.this.setComposingColor(colorChooser.getColor());
                }
            }
        };
    }

    private ActionListener pyComposingBgListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    CandiBarEditLogic.this.setComposingBgColor(colorChooser.getColor());
                }
            }
        };
    }

    private ActionListener firstCandColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    CandiBarEditLogic.this.setFocusedCandColor(colorChooser.getColor());
                }
            }
        };
    }

    private ActionListener candColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    CandiBarEditLogic.this.setUnfocusedCandColor(colorChooser.getColor());
                }
            }
        };
    }

    private ActionListener candPressedBackListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    CandiBarEditLogic.this.setCandPressedBgColor(colorChooser.getColor());
                }
            }
        };
    }

    private ActionListener candPressedListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedColorChooser colorChooser = new CustomizedColorChooser(null, "");
                if (colorChooser.getColor() != null) {
                    CandiBarEditLogic.this.setCandPressedColor(colorChooser.getColor());
                }
            }
        };
    }

    private ActionListener chooseCandBgListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizedFileChooser fileChooser = new CustomizedFileChooser(new ImageFilter());
                File imageFile = fileChooser.getFile();
                if (imageFile != null) {
                    ImageIcon imageIcon = new ImageIcon(imageFile.getAbsolutePath());
                    Image image = imageIcon.getImage();
                    int candWidth = CandiBarEditLogic.this.keyboardViewLogic.getKeyboardView().getCharacterCandPanel().getWidth();
                    int candHeight = CandiBarEditLogic.this.keyboardViewLogic.getKeyboardView().getCharacterCandPanel().getHeight();
                    image = image.getScaledInstance(candWidth, candHeight, 1);
                    imageIcon = new ImageIcon(image);
                    CandiBarEditLogic.this.keyboardViewLogic.getKeyboardView().setCandBackgroundIcon(imageIcon);
                    IMEKeyboardPanel imeKeyboardPanel = (IMEKeyboardPanel)CandiBarEditLogic.this.keyboardViewLogic.getKeyboardView().getLayoutPanels().get(0).getSonPanel()[0];
                    ThemeKeyboardData themeKeyboardData = ThemeDataPool.msubjectset.getKeyBoard(imeKeyboardPanel.getKeyboardData().getThemeType());
                    ManageUtils.flag = true;
                    KeyImageData keyImageData = ImagePool.getInstance().getImageByTag(themeKeyboardData.getStyleData().getImageTag(), false, candWidth, candHeight);
                    if (keyImageData != null) {
                        keyImageData.setIcon(imageIcon);
                    }
                    ManageUtils.flag = false;
                    CandiBarEditLogic.this.saveImageData.setStoragePath(savedCandImagePath);
                    FileUtils.copyFile(CandiBarEditLogic.this.saveImageData.getCurPath(), savedCandImagePath, true);
                    FileUtils.copyFile(imageFile.getAbsolutePath(), CandiBarEditLogic.this.saveImageData.getCurPath(), true);
                    CandiBarEditLogic.this.candiBarEditView.getStartXField().setText("0");
                    CandiBarEditLogic.this.candiBarEditView.getStartYField().setText("0");
                    CandiBarEditLogic.this.candiBarEditView.getEndXField().setText("0");
                    CandiBarEditLogic.this.candiBarEditView.getEndYField().setText("0");
                    String[] XDivsStr = new String[]{"0", "0"};
                    String[] yDivsStr = new String[]{"0", "0"};
                    themeKeyboardData.getStyleData().getImageData().setXDivs(XDivsStr);
                    themeKeyboardData.getStyleData().getImageData().setYDivs(yDivsStr);
                }
            }
        };
    }

    private KeyListener textFieldEnterListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isDigit(e.getKeyChar())) {
                    return;
                }
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CandiBarEditLogic.this.processCandPicParams();
                }
            }
        };
    }

    private void processCandPicParams() {
        ThemeKeyboardData themeKeyboardData = ThemeDataPool.getThemeCandData();
        ManageUtils.flag = true;
        String srcCandImage = String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultThemeResFilePath() + themeKeyboardData.getStyleData().getImageData().getImageSrcName();
        ManageUtils.flag = false;
        ImageIcon themeBalloonIcon = new ImageIcon(srcCandImage);
        themeBalloonIcon.getImage().flush();
        if (!(this.candiBarEditView.getStartXField().getText().trim().equals("") || this.candiBarEditView.getEndXField().getText().trim().equals("") || this.candiBarEditView.getStartYField().getText().trim().equals("") || this.candiBarEditView.getEndYField().getText().equals(""))) {
            boolean flag = true;
            if (Integer.valueOf(this.candiBarEditView.getStartXField().getText()) < Integer.valueOf(this.candiBarEditView.getEndXField().getText())) {
                if (Integer.valueOf(this.candiBarEditView.getStartXField().getText()) <= themeBalloonIcon.getIconWidth()) {
                    if (Integer.valueOf(this.candiBarEditView.getEndXField().getText()) <= themeBalloonIcon.getIconWidth()) {
                        flag = true;
                    } else {
                        flag = false;
                        this.candiBarEditView.getErrorLabel().setText("\"X\u7ed3\u675f\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u5bbd\u5ea6");
                    }
                } else {
                    flag = false;
                    this.candiBarEditView.getErrorLabel().setText("\"X\u5f00\u59cb\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u5bbd\u5ea6");
                }
            } else {
                flag = false;
                this.candiBarEditView.getErrorLabel().setText("\"X\u5f00\u59cb\"\u9700\u5927\u4e8e\"X\u7ed3\u675f\"");
            }
            if (flag && Integer.valueOf(this.candiBarEditView.getStartYField().getText()) < Integer.valueOf(this.candiBarEditView.getEndYField().getText())) {
                if (Integer.valueOf(this.candiBarEditView.getStartYField().getText()) <= themeBalloonIcon.getIconHeight()) {
                    if (Integer.valueOf(this.candiBarEditView.getEndYField().getText()) <= themeBalloonIcon.getIconHeight()) {
                        flag = true;
                    } else {
                        flag = false;
                        this.candiBarEditView.getErrorLabel().setText("\"Y\u7ed3\u675f\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6");
                    }
                } else {
                    flag = false;
                    this.candiBarEditView.getErrorLabel().setText("\"Y\u5f00\u59cb\"\u4e0d\u80fd\u5927\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6");
                }
            } else if (flag) {
                flag = false;
                this.candiBarEditView.getErrorLabel().setText("\"Y\u5f00\u59cb\"\u9700\u5927\u4e8e\"Y\u7ed3\u675f\"");
            }
            if (flag) {
                this.candiBarEditView.getErrorLabel().setText(" ");
                ImageIcon candIcon = themeKeyboardData.getStyleData().getImage();
                if (candIcon != null) {
                    Rectangle rect = new Rectangle(Integer.valueOf(this.candiBarEditView.getStartXField().getText()), Integer.valueOf(this.candiBarEditView.getStartYField().getText()), Integer.valueOf(this.candiBarEditView.getEndXField().getText()), Integer.valueOf(this.candiBarEditView.getEndYField().getText()));
                    rect.setmType();
                    int mode = this.candiBarEditView.getStretchModeList().getSelectedIndex();
                    ImageIcon imageIcon = new ImageIcon(srcCandImage);
                    if (mode == 0) {
                        JavaNinePatchImage jnpImage = new JavaNinePatchImage(null, rect, candIcon.getIconWidth(), candIcon.getIconHeight(), themeBalloonIcon.getImage());
                        ManageUtils.flag = true;
                        if (rect.getmType() == 3) {
                            imageIcon = new ImageIcon(jnpImage.getDestImage().getScaledInstance(candIcon.getIconWidth(), candIcon.getIconHeight(), 1));
                            ImagePool.getInstance().getImageByTag(themeKeyboardData.getStyleData().getImageTag(), false, candIcon.getIconWidth(), candIcon.getIconHeight()).setIcon(imageIcon);
                        } else {
                            imageIcon = new ImageIcon(jnpImage.getDestImage());
                            ImagePool.getInstance().getImageByTag(themeKeyboardData.getStyleData().getImageTag(), false, candIcon.getIconWidth(), candIcon.getIconHeight()).setIcon(imageIcon);
                        }
                        ManageUtils.flag = false;
                        this.keyboardViewLogic.getKeyboardView().setCandBackgroundIcon(imageIcon);
                    }
                    if (mode == 1) {
                        themeKeyboardData.getStyleData().getImageData().setType(3);
                        BufferedImage iBufferedImage = new BufferedImage(candIcon.getIconWidth(), candIcon.getIconHeight(), 6);
                        PictureUtil.getTiledImage(iBufferedImage.getGraphics(), imageIcon.getImage(), Integer.valueOf(this.candiBarEditView.getStartXField().getText()), Integer.valueOf(this.candiBarEditView.getEndXField().getText()), Integer.valueOf(this.candiBarEditView.getStartYField().getText()), Integer.valueOf(this.candiBarEditView.getEndYField().getText()), candIcon.getIconWidth(), candIcon.getIconHeight());
                        iBufferedImage.flush();
                        imageIcon = new ImageIcon(iBufferedImage);
                        this.keyboardViewLogic.getKeyboardView().setCandBackgroundIcon(imageIcon);
                        ManageUtils.flag = true;
                        ImagePool.getInstance().getImageByTag(themeKeyboardData.getStyleData().getImageTag(), false, candIcon.getIconWidth(), candIcon.getIconHeight()).setIcon(imageIcon);
                        ManageUtils.flag = false;
                    }
                }
                String[] XDivsStr = new String[]{this.candiBarEditView.getStartXField().getText(), this.candiBarEditView.getEndXField().getText()};
                String[] yDivsStr = new String[]{this.candiBarEditView.getStartYField().getText(), this.candiBarEditView.getEndYField().getText()};
                themeKeyboardData.getStyleData().getImageData().setXDivs(XDivsStr);
                themeKeyboardData.getStyleData().getImageData().setYDivs(yDivsStr);
            }
        } else {
            this.candiBarEditView.getErrorLabel().setText("\u56fe\u7247\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private ActionListener stretchModeChangedLisenter() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CandiBarEditLogic.this.initFlag) {
                    CandiBarEditLogic.this.processCandPicParams();
                }
            }
        };
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }

    public void setInitFlag(boolean initFlag) {
        this.initFlag = initFlag;
    }

    public void unableCandiBarEditor() {
        this.candiBarEditView.setEditorEnable(false);
    }

    public void enableCandiBarEditor() {
        this.candiBarEditView.setEditorEnable(true);
    }

    public Color getOldFocusedCandColor() {
        return this.oldFocusedCandColor;
    }

    public void setOldFocusedCandColor(Color oldFocusedCandColor) {
        this.oldFocusedCandColor = oldFocusedCandColor;
    }

    public Color getOldUnfocusedCandColor() {
        return this.oldUnfocusedCandColor;
    }

    public void setOldUnfocusedCandColor(Color oldUnfocusedCandColor) {
        this.oldUnfocusedCandColor = oldUnfocusedCandColor;
    }

    public Color getOldPressedCandColor() {
        return this.oldPressedCandColor;
    }

    public void setOldPressedCandColor(Color oldPressedCandColor) {
        this.oldPressedCandColor = oldPressedCandColor;
    }

    public Color getOldComposingColor() {
        return this.oldComposingColor;
    }

    public void setOldComposingColor(Color oldComposingColor) {
        this.oldComposingColor = oldComposingColor;
    }

    public Color getOldComposingBgColor() {
        return this.oldComposingBgColor;
    }

    public void setOldComposingBgColor(Color oldComposingBgColor) {
        this.oldComposingBgColor = oldComposingBgColor;
    }

    public Color getOldCandBgColor() {
        return this.oldCandBgColor;
    }

    public void setOldCandBgColor(Color oldCandBgColor) {
        this.oldCandBgColor = oldCandBgColor;
    }

    private ActionListener undoFocusedCandColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CandiBarEditLogic.this.setFocusedCandColor(CandiBarEditLogic.this.oldFocusedCandColor);
            }
        };
    }

    private ActionListener undoUnfocusedCandColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CandiBarEditLogic.this.setUnfocusedCandColor(CandiBarEditLogic.this.oldUnfocusedCandColor);
            }
        };
    }

    private ActionListener undoCandPressedColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CandiBarEditLogic.this.setCandPressedColor(CandiBarEditLogic.this.oldPressedCandColor);
            }
        };
    }

    private ActionListener undoCandPressedBgListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CandiBarEditLogic.this.setCandPressedBgColor(CandiBarEditLogic.this.oldCandBgColor);
            }
        };
    }

    private ActionListener undoComposingColorListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CandiBarEditLogic.this.setComposingColor(CandiBarEditLogic.this.oldComposingColor);
            }
        };
    }

    private ActionListener undoComposingBgListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CandiBarEditLogic.this.setComposingBgColor(CandiBarEditLogic.this.oldComposingBgColor);
            }
        };
    }

    private void setFocusedCandColor(Color color) {
        this.candiBarEditView.getFirstCandiColorButton().setBackground(color);
        this.keyboardViewLogic.getKeyboardView().setFocusdCharColor(color);
        if (ThemeDataPool.getThemeCandCharKeyData() != null) {
            ThemeDataPool.getThemeCandCharKeyData().getForegroundStyle(4).setTextColor(color.getRGB());
        }
    }

    private void setUnfocusedCandColor(Color color) {
        this.candiBarEditView.getCandiColorButton().setBackground(color);
        this.keyboardViewLogic.getKeyboardView().setNormalCharColor(color);
        if (ThemeDataPool.getThemeCandCharKeyData() != null) {
            ThemeDataPool.getThemeCandCharKeyData().getForegroundStyle(1).setTextColor(color.getRGB());
        }
    }

    private void setCandPressedBgColor(Color color) {
        this.candiBarEditView.getCandiPressBgcolorButton().setBackground(color);
        if (ThemeDataPool.getThemeCandCharKeyData() != null) {
            ThemeDataPool.getThemeCandCharKeyData().getBackgroundStyle(2).setBgColor(color.getRGB());
        }
    }

    private void setCandPressedColor(Color color) {
        this.candiBarEditView.getCandiPressColorButton().setBackground(color);
        if (ThemeDataPool.getThemeCandCharKeyData() != null) {
            ThemeDataPool.getThemeCandCharKeyData().getForegroundStyle(2).setTextColor(color.getRGB());
        }
    }

    private void setComposingColor(Color color) {
        this.candiBarEditView.getPyCompositeColorButton().setBackground(color);
        this.keyboardViewLogic.getKeyboardView().getComposingPanel().setPyForegroundColor(color);
        if (ThemeDataPool.msubjectset.getComposingData() == null) {
            ThemeDataPool.msubjectset.setComposingData(new ComposingData());
        }
        if (ThemeDataPool.msubjectset.getComposingData().getForegroundStyle(1) == null) {
            ThemeDataPool.msubjectset.getComposingData().setForegroundStyle(1, new StyleData());
            ThemeDataPool.msubjectset.getComposingData().getForegroundStyle(1).setTag("Style_Composing_Key_Fixed");
        }
        ThemeDataPool.msubjectset.getComposingData().getForegroundStyle(1).setTextColor(color.getRGB());
    }

    private void setComposingBgColor(Color color) {
        this.candiBarEditView.getPyBackgroundColorButton().setBackground(color);
        this.keyboardViewLogic.getKeyboardView().getComposingPanel().setBackground(color);
        if (ThemeDataPool.msubjectset.getComposingData() == null) {
            ThemeDataPool.msubjectset.setComposingData(new ComposingData());
        }
        if (ThemeDataPool.msubjectset.getComposingData().getBackgroundStyle() == null) {
            ThemeDataPool.msubjectset.getComposingData().setBackgroundStyle(new StyleData());
            ThemeDataPool.msubjectset.getComposingData().getBackgroundStyle().setTag("Style_Back_Composing_Key");
        }
        ThemeDataPool.msubjectset.getComposingData().getBackgroundStyle().setImageTag(null);
        ThemeDataPool.msubjectset.getComposingData().getBackgroundStyle().setBgColor(color.getRGB());
    }

    public SaveImageData getSaveImageData() {
        return this.saveImageData;
    }

    public void setSaveImageData(SaveImageData saveImageData) {
        this.saveImageData = saveImageData;
    }

    private ActionListener undoImageCandListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CandiBarEditLogic.this.saveImageData.getStoragePath() != null) {
                    FileUtils.copyFile(CandiBarEditLogic.this.saveImageData.getStoragePath(), CandiBarEditLogic.this.saveImageData.getCurPath(), true);
                }
                CandiBarEditLogic.this.candiBarEditView.getStartXField().setText(Integer.toString(((CandiBarEditLogic)CandiBarEditLogic.this).saveImageData.getRect().mX1));
                CandiBarEditLogic.this.candiBarEditView.getStartYField().setText(Integer.toString(((CandiBarEditLogic)CandiBarEditLogic.this).saveImageData.getRect().mY1));
                CandiBarEditLogic.this.candiBarEditView.getEndXField().setText(Integer.toString(((CandiBarEditLogic)CandiBarEditLogic.this).saveImageData.getRect().mX2));
                CandiBarEditLogic.this.candiBarEditView.getEndYField().setText(Integer.toString(((CandiBarEditLogic)CandiBarEditLogic.this).saveImageData.getRect().mY2));
                CandiBarEditLogic.this.candiBarEditView.getStretchModeList().setSelectedIndex(CandiBarEditLogic.this.saveImageData.getStretchMode());
                CandiBarEditLogic.this.processCandPicParams();
            }
        };
    }
}

