/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.domin;

import com.iflytek.skintool.util.ThemeUtils;

public class KeyGravity {
    private static final String ATTR_CENTER = "center";
    private static final String ATTR_LEFT = "left";
    private static final String ATTR_RIGHT = "right";
    private static final String ATTR_TOP = "top";
    private static final String ATTR_BOTTOM = "bottom";
    public static final int UNDEFINE = 0;
    public static final int LEFT = 1;
    public static final int TOP = 16;
    public static final int RIGHT = 256;
    public static final int BOTTOM = 4096;
    public static final int CENTER_HORIZONTAL = 65536;
    public static final int CENTER_VERTICAL = 0x100000;
    public static final int CENTER = 0x110000;

    public static int parseGravity(String value) {
        String[] strArray = ThemeUtils.splitString(value, "|");
        if (strArray != null) {
            if (strArray.length == 1 && strArray[0].equalsIgnoreCase(ATTR_CENTER)) {
                return 0x110000;
            }
            int gravity = 0;
            String[] stringArray = strArray;
            int n = strArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (str.equalsIgnoreCase(ATTR_LEFT)) {
                    gravity |= 1;
                } else if (str.equalsIgnoreCase(ATTR_RIGHT)) {
                    gravity |= 0x100;
                } else if (str.equalsIgnoreCase(ATTR_BOTTOM)) {
                    gravity |= 0x1000;
                } else if (str.equalsIgnoreCase(ATTR_TOP)) {
                    gravity |= 0x10;
                } else if (str.equalsIgnoreCase(ATTR_CENTER)) {
                    gravity |= 0x110000;
                }
                ++n2;
            }
            if ((gravity & 0x110000) == 0x110000) {
                if (KeyGravity.isLeft(gravity)) {
                    gravity = 0x100001;
                } else if (KeyGravity.isRight(gravity)) {
                    gravity = 0x100100;
                } else if (KeyGravity.isTop(gravity)) {
                    gravity = 65552;
                } else if (KeyGravity.isBottom(gravity)) {
                    gravity = 69632;
                }
            }
            return gravity;
        }
        return 0;
    }

    public static boolean isLeft(int gravity) {
        return KeyGravity.isContainSpecifiedGravity(gravity, 1);
    }

    public static boolean isTop(int gravity) {
        return KeyGravity.isContainSpecifiedGravity(gravity, 16);
    }

    public static boolean isRight(int gravity) {
        return KeyGravity.isContainSpecifiedGravity(gravity, 256);
    }

    public static boolean isBottom(int gravity) {
        return KeyGravity.isContainSpecifiedGravity(gravity, 4096);
    }

    public static boolean isCenterHorizontal(int gravity) {
        return KeyGravity.isContainSpecifiedGravity(gravity, 65536);
    }

    public static boolean isCenterVertical(int gravity) {
        return KeyGravity.isContainSpecifiedGravity(gravity, 0x100000);
    }

    private static boolean isContainSpecifiedGravity(int gravity, int specified) {
        return (gravity & specified) != 0;
    }
}

