/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.utils;

import com.iflytek.serializer.common.ImageDataSerializer;
import com.iflytek.serializer.common.StyleDataSerializer;
import com.iflytek.serializer.interfaces.ISerializerListener;
import com.iflytek.serializer.interfaces.Iniable;
import com.iflytek.serializer.layout.AnimationDataSerializer;
import com.iflytek.serializer.theme.SubjectDataSerializer;
import com.iflytek.serializer.theme.ThemeInfoSerializer;
import com.iflytek.skintool.model.theme.SubjectData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ThemePackageWriter {
    private static final String IT_SUFFIX = ".it";
    private ThemeInfoSerializer mThemeInfoSerializer;
    private SubjectDataSerializer mSubjectDataSerializer;
    private StyleDataSerializer mStyleDataSerializer;
    private ImageDataSerializer mImageDataSerializer;
    private AnimationDataSerializer mAnimationDataSerializer;

    public ThemePackageWriter() {
        this.init();
        this.setListener(new ThemePackageListener());
    }

    private void init() {
        this.mThemeInfoSerializer = new ThemeInfoSerializer();
        this.mSubjectDataSerializer = new SubjectDataSerializer();
        this.mStyleDataSerializer = new StyleDataSerializer();
        this.mImageDataSerializer = new ImageDataSerializer();
        this.mAnimationDataSerializer = new AnimationDataSerializer();
    }

    private void setListener(ISerializerListener listener) {
        this.mThemeInfoSerializer.setListener(listener);
        this.mSubjectDataSerializer.setListener(listener);
        this.mStyleDataSerializer.setListener(listener);
        this.mImageDataSerializer.setListener(listener);
        this.mAnimationDataSerializer.setListener(listener);
    }

    public void startParse(SubjectData data) {
        this.mSubjectDataSerializer.serializeData(data);
    }

    private void writetoFile(File file, String fileName, Iniable object) {
        block14: {
            FileOutputStream fos = null;
            try {
                try {
                    file = new File(String.valueOf(file.getAbsolutePath()) + File.separator + fileName);
                    if (file.exists()) {
                        file.delete();
                    } else {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    }
                    fos = new FileOutputStream(file.getAbsoluteFile(), true);
                    fos.write(object.toIniString().getBytes("UTF-8"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fos == null) break block14;
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        fos = null;
                    }
                    fos = null;
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        fos = null;
                    }
                    fos = null;
                }
            }
        }
    }

    public void genPackage(File dir, String fileName) {
        String tmpPath = String.valueOf(dir.getAbsolutePath()) + File.separator + fileName;
        File tmpDir = new File(tmpPath);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        this.mThemeInfoSerializer.genThemeInfo();
        this.writetoFile(new File(tmpPath), "theme_info.ini", this.mThemeInfoSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "720" + File.separator + "layout" + File.separator), "subject.ini", this.mSubjectDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "720" + File.separator + "layout" + File.separator), "style.ini", this.mStyleDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "720" + File.separator + "layout" + File.separator), "image.ini", this.mImageDataSerializer);
    }

    class ThemePackageListener
    implements ISerializerListener {
        ThemePackageListener() {
        }

        @Override
        public String redirect(int type, String tag, Object object) {
            switch (type) {
                case 9: {
                    tag = ThemePackageWriter.this.mStyleDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 7: {
                    tag = ThemePackageWriter.this.mAnimationDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 12: {
                    tag = ThemePackageWriter.this.mImageDataSerializer.serializeData(type, tag, object);
                    break;
                }
            }
            return tag;
        }
    }
}

