/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.theme;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.theme.ThemeSubKey;
import com.iflytek.skintool.util.SkinUtils;
import java.util.Map;
import java.util.TreeMap;

public class ThemeSubKeyDataSerializer
extends AbstractBaseSerializer<ThemeSubKey> {
    int[] KEY_STATES = new int[]{16, 4, 1, 2, 8};
    String[] KEY_STATES_STRS = new String[]{"DISABLED", "FOCUSED", "NORMAL", "PRESSED", "SELECTED"};
    private TreeMap<String, TreeMap<String, String>> mStateProps = new TreeMap();

    @Override
    public String toIniString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toIniString());
        for (Map.Entry<String, TreeMap<String, String>> entrySets : this.mStateProps.entrySet()) {
            SkinUtils.stringMerge(sb, entrySets.getKey());
            for (Map.Entry<String, String> entry : entrySets.getValue().entrySet()) {
                SkinUtils.stringMerge(sb, entry.getKey(), entry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public TreeMap<String, String> writeto(ThemeSubKey object) {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        attr.put("FORE_STATE", "FORE_STATE_" + object.getkeyTag());
        TreeMap<String, String> states = new TreeMap<String, String>();
        int i = 0;
        while (i < this.KEY_STATES.length) {
            StyleData styleData = object.getSubKeyForegroundStyleSet().get(this.KEY_STATES[i]);
            if (styleData != null) {
                states.put(this.KEY_STATES_STRS[i], this.mListener.redirect(9, "Style_" + object.getkeyTag() + "_" + this.KEY_STATES_STRS[i], styleData));
            }
            ++i;
        }
        this.mStateProps.put("FORE_STATE_" + object.getkeyTag(), states);
        attr.put("GRAVITY", SerializerUtil.getGravityStr(object.getKeyGravity()));
        return attr;
    }

    @Override
    public String getTag(ThemeSubKey data) {
        return "SubKey_" + this.mProps.size();
    }
}

