/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.theme;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.interfaces.ISerializerListener;
import com.iflytek.serializer.theme.ThemeSubKeyDataSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.theme.ThemeKeyData;
import com.iflytek.skintool.model.theme.ThemeSubKey;
import com.iflytek.skintool.util.SkinUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ThemeKeyDataSerializer
extends AbstractBaseSerializer<ThemeKeyData> {
    int[] KEY_STATES = new int[]{1, 2, 4, 8, 16};
    String[] KEY_STATES_STRS = new String[]{"NORMAL", "PRESSED", "FOCUSED", "SELECTED", "DISABLED"};
    private TreeMap<String, TreeMap<String, String>> mStateProps = new TreeMap();
    ThemeSubKeyDataSerializer mThemeSubKeyDataSerializer = new ThemeSubKeyDataSerializer();

    @Override
    public void setListener(ISerializerListener listener) {
        super.setListener(listener);
        this.mThemeSubKeyDataSerializer.setListener(listener);
    }

    @Override
    public TreeMap<String, String> writeto(ThemeKeyData keyData) {
        HashMap<Integer, HashMap<Integer, StyleData>> subKeys;
        int cur = this.mProps.size();
        TreeMap<String, String> attr = new TreeMap<String, String>();
        if (keyData.getTypeAttr() != null) {
            attr.put("TYPE", SerializerUtil.array2str(keyData.getTypeAttr(), ","));
        }
        TreeMap<String, String> backState = new TreeMap<String, String>();
        int i = 0;
        while (i < this.KEY_STATES.length) {
            StyleData styleData = keyData.getBackgroundStyle(this.KEY_STATES[i]);
            if (styleData != null) {
                backState.put(this.KEY_STATES_STRS[i], this.mListener.redirect(9, styleData.getTag(), styleData));
            }
            ++i;
        }
        if (backState.size() > 0) {
            this.mStateProps.put("Back_State_Key_" + cur, backState);
            attr.put("BACK_STATE", "Back_State_Key_" + cur);
        }
        TreeMap<String, String> foreState = new TreeMap<String, String>();
        int i2 = 0;
        while (i2 < this.KEY_STATES.length) {
            StyleData styleData = keyData.getForegroundStyle(this.KEY_STATES[i2]);
            if (styleData != null) {
                foreState.put(this.KEY_STATES_STRS[i2], this.mListener.redirect(9, styleData.getTag(), styleData));
            }
            ++i2;
        }
        if (foreState.size() > 0) {
            this.mStateProps.put("Fore_State_Key_" + cur, foreState);
            attr.put("FORE_STATE", "Fore_State_Key_" + cur);
        }
        if ((subKeys = keyData.getAllSubKeyForground()) != null) {
            String subStr = "";
            for (int key : subKeys.keySet()) {
                HashMap<Integer, StyleData> subKeyStyleDatas = subKeys.get(key);
                ThemeSubKey themeSubKey = new ThemeSubKey();
                themeSubKey.setKeyGravity(key);
                themeSubKey.setSubKeyForegroundStyleSet(subKeyStyleDatas);
                subStr = String.valueOf(subStr) + this.mThemeSubKeyDataSerializer.serializeData(19, "Key_" + cur + "_Sub_Key_" + key, themeSubKey);
            }
            attr.put("SUB_KEY", subStr);
        }
        return attr;
    }

    @Override
    public String toIniString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toIniString());
        for (Map.Entry<String, TreeMap<String, String>> entrySets : this.mStateProps.entrySet()) {
            SkinUtils.stringMerge(sb, entrySets.getKey());
            for (Map.Entry<String, String> entry : entrySets.getValue().entrySet()) {
                SkinUtils.stringMerge(sb, entry.getKey(), entry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isExist(ThemeKeyData data) {
        if (this.mProps.size() != 0) {
            String typeStr = SerializerUtil.array2str(data.getTypeAttr(), ",");
            if (typeStr == null) {
                return false;
            }
            Collection values = this.mProps.values();
            for (TreeMap treeMap : values) {
                if (!treeMap.containsKey("TYPE") || !((String)treeMap.get("TYPE")).equals(typeStr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTag(ThemeKeyData data) {
        if (data.getkeyTag() != null) {
            return data.getkeyTag();
        }
        return "Key_" + this.mProps.size();
    }
}

