/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.theme;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.interfaces.ISerializerListener;
import com.iflytek.serializer.theme.ThemeAreaDataSerializer;
import com.iflytek.serializer.theme.ThemeBallonDataSerializer;
import com.iflytek.serializer.theme.ThemeComposingDataSerializer;
import com.iflytek.serializer.theme.ThemeKeyBoardDataSerializer;
import com.iflytek.serializer.theme.ThemeKeyDataSerializer;
import com.iflytek.serializer.theme.ThemeLayoutDataSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.layout.ComposingData;
import com.iflytek.skintool.model.pool.ThemeDataPool;
import com.iflytek.skintool.model.theme.SubjectData;
import com.iflytek.skintool.model.theme.ThemeBalloonData;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.TreeMap;

public class SubjectDataSerializer
extends AbstractBaseSerializer<SubjectData> {
    ThemeLayoutDataSerializer mThemeLayoutDataSerializer;
    ThemeAreaDataSerializer mThemeAreaDataSerializer;
    ThemeComposingDataSerializer mThemeComposingDataSerializer;
    ThemeKeyDataSerializer mThemeKeyDataSerializer;
    ThemeKeyBoardDataSerializer mThemeKeyBoardDataSerializer;
    ThemeBallonDataSerializer mThemeBallonDataSerializer;

    public SubjectDataSerializer() {
        this.init();
        this.setListener(this.mListener);
    }

    private void init() {
        this.mThemeLayoutDataSerializer = new ThemeLayoutDataSerializer();
        this.mThemeAreaDataSerializer = new ThemeAreaDataSerializer();
        this.mThemeComposingDataSerializer = new ThemeComposingDataSerializer();
        this.mThemeKeyDataSerializer = new ThemeKeyDataSerializer();
        this.mThemeKeyBoardDataSerializer = new ThemeKeyBoardDataSerializer();
        this.mThemeBallonDataSerializer = new ThemeBallonDataSerializer();
    }

    @Override
    public void setListener(ISerializerListener listener) {
        super.setListener(listener);
        this.mThemeLayoutDataSerializer.setListener(listener);
        this.mThemeAreaDataSerializer.setListener(listener);
        this.mThemeComposingDataSerializer.setListener(listener);
        this.mThemeKeyDataSerializer.setListener(listener);
        this.mThemeKeyBoardDataSerializer.setListener(listener);
        this.mThemeBallonDataSerializer.setListener(listener);
    }

    private void realSerializeData(SubjectData data, ISerializerListener listener) {
        Object temp;
        Object object = this.getReflectField(data, "mThemeLayoutDataMap");
        if (object != null) {
            temp = (HashMap)object;
            for (Object value : ((HashMap)temp).values()) {
                this.mThemeLayoutDataSerializer.serializeData(value);
            }
        }
        if ((object = this.getReflectField(data, "mThemeAreaDataMap")) != null) {
            temp = (HashMap)object;
            for (Object value : ((HashMap)temp).values()) {
                this.mThemeAreaDataSerializer.serializeData(value);
            }
        }
        if ((object = this.getReflectField(data, "mComposingData")) != null) {
            temp = (ComposingData)object;
            this.mThemeComposingDataSerializer.serializeData(temp);
        }
        if ((object = this.getReflectField(data, "mThemeKeyDataMap")) != null) {
            temp = (HashMap)object;
            for (Object value : ((HashMap)temp).values()) {
                this.mThemeKeyDataSerializer.serializeData(value);
            }
        }
        if ((object = this.getReflectField(data, "mThemeKeyBoardMap")) != null) {
            temp = (HashMap)object;
            for (Object value : ((HashMap)temp).values()) {
                this.mThemeKeyBoardDataSerializer.serializeData(value);
            }
        }
        if ((object = this.getReflectField(data, "mBalloonData")) != null) {
            temp = (ThemeBalloonData)object;
            this.mThemeBallonDataSerializer.serializeData(temp);
        }
    }

    private Object getReflectField(SubjectData subjectData, String fieldName) {
        try {
            Field field = subjectData.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(subjectData);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public TreeMap<String, String> writeto(SubjectData object) {
        this.realSerializeData(object, this.mListener);
        return this.getSubjectProps();
    }

    private TreeMap<String, String> getSubjectProps() {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        attr.put("LAYOUT", SerializerUtil.array2str(this.mThemeLayoutDataSerializer.getKeySet(), ","));
        attr.put("AREA_SET", SerializerUtil.array2str(this.mThemeAreaDataSerializer.getKeySet(), ","));
        attr.put("KEY_SET", SerializerUtil.array2str(this.mThemeKeyDataSerializer.getKeySet(), ","));
        attr.put("COMPOSING", SerializerUtil.array2str(this.mThemeComposingDataSerializer.getKeySet(), ","));
        attr.put("KEYBOARD", SerializerUtil.array2str(this.mThemeKeyBoardDataSerializer.getKeySet(), ","));
        attr.put("BALLOON", SerializerUtil.array2str(this.mThemeBallonDataSerializer.getKeySet(), ","));
        if (ThemeDataPool.msubjectset.getThemeColor(1) != 0) {
            attr.put("THEME_FORE_COLOR_NEW", SerializerUtil.getColorStr(ThemeDataPool.msubjectset.getThemeColor(1)));
        }
        if (ThemeDataPool.msubjectset.getThemeColor(2) != 0) {
            attr.put("THEME_FORE_PRESS_COLOR", SerializerUtil.getColorStr(ThemeDataPool.msubjectset.getThemeColor(2)));
        }
        return attr;
    }

    @Override
    public String toIniString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toIniString());
        sb.append(this.mThemeLayoutDataSerializer.toIniString());
        sb.append(this.mThemeAreaDataSerializer.toIniString());
        sb.append(this.mThemeKeyDataSerializer.toIniString());
        sb.append(this.mThemeComposingDataSerializer.toIniString());
        sb.append(this.mThemeKeyBoardDataSerializer.toIniString());
        sb.append(this.mThemeBallonDataSerializer.toIniString());
        return sb.toString();
    }

    @Override
    public String getTag(SubjectData data) {
        return "SUBJECT";
    }
}

