/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.common;

import com.iflytek.serializer.interfaces.ISerializer;
import com.iflytek.serializer.interfaces.ISerializerListener;
import com.iflytek.serializer.interfaces.Iniable;
import com.iflytek.skintool.util.SkinUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractBaseSerializer<E>
implements ISerializer<E>,
Iniable {
    protected TreeMap<String, TreeMap<String, String>> mProps = new TreeMap();
    protected ISerializerListener mListener;
    protected String mTag;

    public void addOtherProperties(String tag, Properties properties) {
        TreeMap<String, String> value = new TreeMap<String, String>();
        if (properties == null) {
            return;
        }
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            value.put((String)prop.getKey(), (String)prop.getValue());
        }
        this.mProps.put(tag, value);
    }

    public void setListener(ISerializerListener listener) {
        this.mListener = listener;
    }

    public Set<String> getKeySet() {
        if (this.mProps != null && this.mProps.size() != 0) {
            return this.mProps.keySet();
        }
        return null;
    }

    @Override
    public String toIniString() {
        if (this.mProps == null || this.mProps.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, TreeMap<String, String>> entrySets : this.mProps.entrySet()) {
            SkinUtils.stringMerge(sb, entrySets.getKey());
            for (Map.Entry<String, String> entry : entrySets.getValue().entrySet()) {
                SkinUtils.stringMerge(sb, entry.getKey(), entry.getValue());
            }
        }
        return sb.toString();
    }

    public void writeToFile(File file) {
        try {
            if (file.exists()) {
                file.delete();
            } else {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file.getAbsoluteFile(), false);
            fos.write(this.toIniString().getBytes());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void serializeData(E data) {
        if (this.isExist(data)) {
            return;
        }
        this.mTag = this.getTag(data);
        this.mProps.put(this.mTag, this.writeto(data));
    }

    @Override
    public String serializeData(int type, String tag, Object object) {
        if (object == null) {
            return "";
        }
        if (this.isExist(object)) {
            return tag;
        }
        this.mProps.put(tag, this.writeto(object));
        return tag;
    }

    @Override
    public boolean isExist(E data) {
        return false;
    }
}

