<?php
/**
 * Copyright (c) 2014-2018, www.kuacg.com
 * All right reserved.
 *
 * @since 2.5.0
 * @package Tint-K
 * @author 酷ACG资源网
 * @date 2018/02/14 10:00
 * @link https://www.kuacg.com/18494.html
 */
?>
<?php

/**
 * Class UCWidget
 */
class UCWidget extends WP_Widget {
    function __construct() {
        parent::__construct(false, __('TT- UC', 'tt'), array( 'description' => __('TT-Show toolkits for current user', 'tt') ,'classname' => 'widget_uc wow bounceInRight'));
    }

    function widget($args, $instance) {
        // parent::widget($args, $instance); // TODO: Change the autogenerated stub
        // extract($args);
        echo $args['before_widget'];
        if($instance['title']) { echo $args['before_title'] . $instance['title'] . $args['after_title']; } ?>
        <div class="widget-content">
        <?php if(is_user_logged_in()) { ?>
            tt_uc_widget_content();
        <?php }else{ ?>
            <li>
                <span class="local-account"><a data-sign="0" class="btn btn-info user-login"><i class="tico tico-wordpress"></i><?php _e('Local Account', 'tt'); ?></a></span>
                <?php if(tt_get_option('tt_enable_qq_login')) { ?>
                <span class="other-sign"><a class="qqlogin btn btn-social-qq" href="<?php echo tt_add_redirect(tt_url_for('oauth_qq'), Utils::getPHPCurrentUrl()); ?>"><i class="tico tico-qq"></i><span><?php _e('QQ Login', 'tt'); ?></span></a></span>
                <?php } ?>
                <?php if(tt_get_option('tt_enable_weibo_login')) { ?>
                <span class="other-sign"><a class="wblogin btn btn-social-weibo" href="<?php echo tt_add_redirect(tt_url_for('oauth_weibo'), Utils::getPHPCurrentUrl()); ?>"><i class="tico tico-weibo"></i><span><?php _e('Weibo Login', 'tt'); ?></span></a></span>
                <?php } ?>
                <?php if(tt_get_option('tt_enable_weixin_login')) { ?>
                <span class="other-sign"><a class="wxlogin btn btn-social-weixin" href="<?php echo tt_add_redirect(tt_url_for('oauth_weixin'), Utils::getPHPCurrentUrl()); ?>"><i class="tico tico-wechat"></i><span><?php _e('Wechat Login', 'tt'); ?></span></a></span>
                <?php } ?>
            </li>
        <?php } ?>
        </div>
        <?php echo $args['after_widget']; ?>
        <?php
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function form($instance) {
        $title = esc_attr(isset($instance['title']) ? $instance['title'] : __('USER MANAGEMENT', 'tt'));
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title：','tt'); ?><input class="input-lg" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
        <?php
    }
}

/* 注册小工具 */
if ( ! function_exists( 'tt_register_widget_uc' ) ) {
    function tt_register_widget_uc() {
        register_widget( 'UCWidget' );
    }
}
//add_action( 'widgets_init', 'tt_register_widget_uc' );