<?php
/**
 * Copyright (c) 2014-2018, www.kuacg.com
 * All right reserved.
 *
 * @since 2.5.0
 * @package Tint-K
 * @author 酷ACG资源网
 * @date 2018/02/14 10:00
 * @link https://www.kuacg.com/18494.html
 */
?>
<?php

/**
 * Class TagCloud
 */
class TagCloud extends WP_Widget {
    function __construct() {
        parent::__construct(false, __('TT-Tag Cloud', 'tt'), array( 'description' => __('TT-Show some site tags in tag cloud style', 'tt') ,'classname' => 'widget_tag-cloud wow bounceInRight'));
    }

    function widget($args, $instance) {
        // parent::widget($args, $instance); // TODO: Change the autogenerated stub
        // extract($args);
        $echo = apply_filters('tt_widget_retrieve_cache', '', 'tag_cloud' . $instance['num']); // 用于尝试命中缓存
        if($echo) {
            echo $echo;
            return;
        }
        $echo = $args['before_widget'];
        $echo .= $instance['title'] ? $args['before_title'] . $instance['title'] . $args['after_title'] : '';
        $tags = wp_tag_cloud(array(
            'echo'      =>  false,
            'unit'      =>  'px',
            'smallest'  =>  12,
            'largest'   =>  12,
            'number'    =>  $instance['num'],
            'order'     =>  'DESC'
        ));
        $echo .= '<div class="widget-content"><aside class="tags">' . $tags . '</aside></div>';
        $echo .= $args['after_widget'];
        do_action('tt_widget_create_cache', $echo, 'tag_cloud' . $instance['num'], 3600*24); // 生成缓存
        echo $echo;
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function form($instance) {
        $title = esc_attr(isset($instance['title']) ? $instance['title'] : __('TAG CLOUD', 'tt'));
        $num = absint(isset($instance['num']) ? $instance['num'] : 20);
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title：','tt'); ?><input class="input-lg" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
        <p><label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('Number：','tt'); ?></label><input class="input-lg" id="<?php echo $this->get_field_id('num'); ?>" name="<?php echo $this->get_field_name('num'); ?>" type="text"  value="<?php echo $num; ?>" /></p>
        <?php
    }
}

/* 注册小工具 */
if ( ! function_exists( 'tt_register_widget_tag_cloud' ) ) {
    function tt_register_widget_tag_cloud() {
        register_widget( 'TagCloud' );
    }
}
add_action( 'widgets_init', 'tt_register_widget_tag_cloud' );