<?php
/**
 * Copyright (c) 2014-2018, www.kuacg.com
 * All right reserved.
 *
 * @since 2.5.0
 * @package Tint-K
 * @author 酷ACG资源网
 * @date 2018/02/14 10:00
 * @link https://www.kuacg.com/18494.html
 */
?>
<?php

/**
 * Class RecentComments
 */
class RecentComments extends WP_Widget {
    function __construct() {
        parent::__construct(false, __('TT-Recent Comments', 'tt'), array( 'description' => __('TT-Show several recent comments', 'tt') ,'classname' => 'widget_recent-comments wow bounceInRight'));
    }

    function widget($args, $instance) {
        // parent::widget($args, $instance); // TODO: Change the autogenerated stub
        // extract($args);
        $vm = RecentCommentsVM::getInstance($instance['num']);
        if($vm->isCache && $vm->cacheTime) {
            echo '<!-- Recent comments widget cached ' . $vm->cacheTime . ' -->';
        }
        $recent_comments = $vm->modelData;
        ?>
        <?php echo $args['before_widget']; ?>
        <?php if($instance['title']) { echo $args['before_title'] . $instance['title'] . $args['after_title']; } ?>
        <div class="widget-content">
            <?php foreach ($recent_comments as $recent_comment) { ?>
                <li class="comment">
                    <div class="comment-title" title="<?php echo $recent_comment['comment_date_diff']; ?>">
                        <span class="comment-author"><img class="avatar lazy" src="<?php echo LAZY_PENDING_AVATAR; ?>" data-original="<?php echo $recent_comment['author_avatar']; ?>"><?php echo $recent_comment['author_name']; ?></span><?php _e('REVIEWED ON ', 'tt'); ?><a href="<?php echo $recent_comment['post_permalink']; ?>"><?php echo $recent_comment['post_title']; ?></a>
                    </div>
                    <div class="comment-content"><?php echo $recent_comment['comment_text']; ?></div>
                </li>
            <?php } ?>
        </div>
        <?php echo $args['after_widget']; ?>
        <?php
    }

    function update($new_instance, $old_instance) {
        // TODO 清除小工具缓存

        return $new_instance;
    }

    function form($instance) {
        $title = esc_attr(isset($instance['title']) ? $instance['title'] : __('RECENT COMMENTS', 'tt'));
        $num = absint(isset($instance['num']) ? $instance['num'] : 6);
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title：','tt'); ?><input class="input-lg" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
        <p><label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('Number：','tt'); ?></label><input class="input-lg" id="<?php echo $this->get_field_id('num'); ?>" name="<?php echo $this->get_field_name('num'); ?>" type="text"  value="<?php echo $num; ?>" /></p>
        <?php
    }
}

/* 注册小工具 */
if ( ! function_exists( 'tt_register_widget_recent_comments' ) ) {
    function tt_register_widget_recent_comments() {
        register_widget( 'RecentComments' );
    }
}
add_action( 'widgets_init', 'tt_register_widget_recent_comments' );