<?php
/**
 * Copyright (c) 2014-2018, www.kuacg.com
 * All right reserved.
 *
 * @since 2.5.0
 * @package Tint-K
 * @author 酷ACG资源网
 * @date 2018/02/14 10:00
 * @link https://www.kuacg.com/18494.html
 */
?>
<?php

/**
 * Class DonateWidget
 */
class DonateWidget extends WP_Widget {
    function __construct() {
        parent::__construct(false, __('TT-Donate Me', 'tt'), array( 'description' => __('TT-Show alipay and wechat pay qr code images for visitors donating', 'tt') ,'classname' => 'widget_donate wow bounceInRight'));
    }

    function widget($args, $instance) {
        // parent::widget($args, $instance); // TODO: Change the autogenerated stub
        // extract($args);
        echo $args['before_widget'];
        if($instance['title']) { echo $args['before_title'] . $instance['title'] . $args['after_title']; } ?>
        <div class="widget-content">
            <div class="row">
        <?php $wechat_pay = tt_get_option('tt_weixin_pay_qr'); $ali_pay = tt_get_option('tt_alipay_pay_qr'); if($wechat_pay && $ali_pay) {$col_class = 'qr-col col-md-6 col-sm-6 col-xs-6';} else {$col_class = 'qr-col';} ?>
            <?php if($wechat_pay) { ?>
                <div class="<?php echo $col_class; ?>">
                    <i class="qr-type-icon qr-type-wechat tico tico-wechat"></i>
                    <img src="<?php echo $wechat_pay; ?>">
                </div>
            <?php } ?>
            <?php if($ali_pay) { ?>
                <div class="<?php echo $col_class; ?>">
                    <i class="qr-type-icon qr-type-alipay"></i>
                    <img src="<?php echo $ali_pay; ?>">
                </div>
            <?php } ?>
            </div>
        </div>
        <?php echo $args['after_widget']; ?>
        <?php
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function form($instance) {
        $title = esc_attr(isset($instance['title']) ? $instance['title'] : __('DONATE ME', 'tt'));
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title：','tt'); ?><input class="input-lg" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
        <p><?php _e('The widget will auto query the qr code images from theme options, please configure it on `SHOP` tab of theme options page', 'tt'); ?></p>
        <?php
    }
}

/* 注册小工具 */
if ( ! function_exists( 'tt_register_widget_donate' ) ) {
    function tt_register_widget_donate() {
        register_widget( 'DonateWidget' );
    }
}
add_action( 'widgets_init', 'tt_register_widget_donate' );