<?php
/**
 * Copyright (c) 2014-2018, www.kuacg.com
 * All right reserved.
 *
 * @since 2.5.0
 * @package Tint-K
 * @author 酷ACG资源网
 * @date 2018/02/14 10:00
 * @link https://www.kuacg.com/18494.html
 */
?>
<?php

/**
 * Class AuthorWidget
 */
class AuthorWidget extends WP_Widget {
    function __construct() {
        parent::__construct(false, __('TT-Author Widget', 'tt'), array( 'description' => __('TT-Show the post author information, only can be used in single post page', 'tt') ,'classname' => 'widget_author-info wow bounceInRight'));
    }

    function widget($args, $instance) {
        // parent::widget($args, $instance); // TODO: Change the autogenerated stub
        // extract($args);
        wp_reset_postdata();
        $vm = AuthorWidgetVM::getInstance(get_the_author_meta('ID'));
        if($vm->isCache && $vm->cacheTime) {
            echo '<!-- Author widget cached ' . $vm->cacheTime . ' -->';
        }
        $data = $vm->modelData;
        ?>
        <?php echo $args['before_widget']; ?>
        <div class="widget-content">
            <a class="author-card_bg" href="<?php echo $data->homepage; ?>" style="background-image: url(<?php echo $data->cover; ?>)" tabindex="-1"></a>
            <div class="author-card_content">
                <a class="author_avatar-link" href="<?php echo $data->homepage; ?>" title="<?php echo $data->display_name; ?>" tabindex="-1"><img class="avatar" src="<?php echo $data->avatar; ?>" alt=""></a>
                <div class="author-fields">
                    <span class="author-name"><?php echo $data->display_name; ?></span>
                    <span class="author-user_level"><?php echo $data->cap; ?></span>
                </div>
                <?php if(get_current_user_id() != $data->ID) { ?>
                <div class="author-interact">
<!--                    <a class="follow-btn" href="javascript: void 0" title="--><?php //_e('Follow the author', 'tt'); ?><!--"><i class="tico tico-user-plus"></i>--><?php //_e('Follow', 'tt'); ?><!--</a>-->
                    <?php echo tt_follow_button($data->ID); ?>
                    <a class="pm-btn" href="javascript: void 0" data-receiver="<?php echo $data->display_name; ?>" data-receiver-id="<?php echo $data->ID; ?>" title="<?php _e('Send a message', 'tt'); ?>"><i class="tico tico-envelope"></i><?php _e('Chat', 'tt'); ?></a>
                </div>
                <?php } ?>
                <div class="author-stats">
                    <span class="posts"><?php echo intval($data->posts_count); ?><span class="unit"><?php _e('POSTS', 'tt'); ?></span></span>
                    <span class="stars"><?php echo intval($data->posts_stars); ?><span class="unit"><?php _e('STARS', 'tt'); ?></span></span>
                    <span class="following"><?php echo intval($data->following_count); ?><span class="unit"><?php _e('FOLLOWING', 'tt'); ?></span></span>
                    <span class="followers"><?php echo intval($data->followers_count); ?><span class="unit"><?php _e('FOLLOWERS', 'tt'); ?></span></span>
                </div>
<?php if (tt_get_option('tt_enable_k_authorkz', true)) { ?>
              <!-- 作者扩展信息注释开始 -->
 <div class="attentionus">
  <ul class="items clearfix">
   <?php if($qq = get_the_author_meta( 'tt_qq',  $author_id)) { ?>
    <span class="social-widget-link social-link-qq">
      <span class="social-widget-link-count">
        <i class="tico tico-qq"></i><?php echo $qq; ?></span>
      <span class="social-widget-link-title">QQ</span>
      <a href="<?php echo 'http://wpa.qq.com/msgrd?v=3&uin=' . $qq . '&site=qq&menu=yes'; ?>" target="_blank" rel="nofollow"></a>
    </span>
    <?php } ?>
    <?php if($weibo = get_the_author_meta( 'tt_weibo',  $author_id)) { ?>
    <span class="social-widget-link social-link-weibo">
      <span class="social-widget-link-count">
        <i class="tico tico-weibo"></i><?php echo $weibo; ?></span>
      <span class="social-widget-link-title">新浪微博</span>
      <a href="<?php echo 'http://www.weibo.com/' . $weibo; ?>" target="_blank" rel="nofollow"></a>
    </span>
    <?php } ?>
    <?php if($email = get_the_author_meta( 'user_email',  $author_id)) { ?>
    <span class="social-widget-link social-link-email">
      <span class="social-widget-link-count">
        <i class="tico tico-envelope"></i><?php echo $email; ?></span>
      <span class="social-widget-link-title">QQ邮箱</span>
      <a href="<?php echo 'http://mail.qq.com/cgi-bin/qm_share?t=qm_mailme&amp;email=' . $email; ?>" target="_blank" rel="nofollow"></a>
    </span>
    <?php } ?>
  </ul>
</div>
<!-- 作者扩展信息注释结束 -->
<?php } ?>
            </div>
        </div>
        <?php echo $args['after_widget']; ?>
        <?php
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function form($instance) {
        ?>
        <p><?php _e('<strong>Warning: </strong>This widget has nothing to configure, and also do not use it', 'tt'); ?></p>
        <?php
    }
}

/* 注册小工具 */
if ( ! function_exists( 'tt_register_widget_author_info' ) ) {
    function tt_register_widget_author_info() {
        register_widget( 'AuthorWidget' );
    }
}
add_action( 'widgets_init', 'tt_register_widget_author_info' );