/*
 * Decompiled with CFR 0.152.
 */
package app.pane;

import app.model.Action;
import app.model.Event;
import app.model.bean.Config;
import app.utils.FileUtil;
import app.utils.TextUtil;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class RouterPane
extends GridPane
implements EventHandler<ActionEvent> {
    private static RouterPane instance;
    private Event event;
    private Config config;
    TextField routerIpField;
    TextField routerUserField;
    TextField routerPassField;

    public RouterPane(Event event) {
        this.event = event;
        this.config = FileUtil.readConfig();
        this.setAlignment(Pos.CENTER);
        this.setHgap(10.0);
        this.setVgap(10.0);
        this.setPadding(new Insets(0.0, 25.0, 0.0, 25.0));
        Label label = new Label("\u8def\u7531\u5668\u5730\u5740\uff1a");
        this.add((Node)label, 0, 1);
        this.routerIpField = new TextField();
        this.routerIpField.setText(this.config.getRouterIpAddress());
        this.add((Node)this.routerIpField, 1, 1);
        label = new Label("\u7528   \u6237   \u540d\uff1a");
        this.add((Node)label, 0, 2);
        this.routerUserField = new TextField();
        this.routerUserField.setText(this.config.getRouterUsername());
        this.add((Node)this.routerUserField, 1, 2);
        label = new Label("\u5bc6        \u7801\uff1a");
        this.add((Node)label, 0, 3);
        this.routerPassField = new TextField();
        this.routerPassField.setText(this.config.getRouterPassword());
        this.add((Node)this.routerPassField, 1, 3);
        Button btn = new Button("\u4fdd\u5b58");
        btn.setOnAction((EventHandler)this);
        HBox hbBtn = new HBox(10.0);
        hbBtn.setAlignment(Pos.BOTTOM_RIGHT);
        hbBtn.getChildren().add((Object)btn);
        this.add((Node)hbBtn, 1, 4);
    }

    public static RouterPane instance(Event event) {
        if (instance == null) {
            instance = new RouterPane(event);
        }
        return instance;
    }

    public void handle(ActionEvent event) {
        String ip = this.routerIpField.getCharacters().toString();
        String user = this.routerUserField.getCharacters().toString();
        String pass = this.routerPassField.getCharacters().toString();
        if (TextUtil.isEmpty(ip, user, pass)) {
            this.event.setFootView("\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        Config c = new Config();
        c.setRouterUsername(user);
        c.setRouterIpAddress(ip);
        c.setRouterPassword(pass);
        FileUtil.writeConfig(c);
        this.event.action(Action.SAVEROUTER);
    }
}

