/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.model.Action;
import app.model.Event;
import app.model.ShanXunManager;
import app.model.bean.IpConfig;
import app.pane.AboutPane;
import app.pane.RouterPane;
import app.pane.ShanXunSettingPane;
import app.utils.TextUtil;
import com.google.gson.Gson;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.imageio.ImageIO;
import res.Res;

public class Main
extends Application
implements Event {
    Tab dialTab;
    Tab routerTab;
    Tab aboutTab;
    BorderPane borderPane;
    TabPane tabPane;
    Text actiontarget;
    IpConfig ipConfig;
    private TrayIcon trayIcon;

    public void start(Stage primaryStage) throws Exception {
        this.enableTray(primaryStage);
        primaryStage.setIconified(false);
        primaryStage.initStyle(StageStyle.UTILITY);
        primaryStage.setTitle("\u95ea\u8bafWIFI\u52a9\u624b\u684c\u9762\u7248 V2016.3.30 \u6e05\u660e\u7248");
        this.borderPane = new BorderPane();
        this.borderPane.setTop((Node)this.getTab());
        this.setFootView();
        this.borderPane.setBottom((Node)this.actiontarget);
        Scene scene = new Scene((Parent)this.borderPane, 350.0, 250.0);
        primaryStage.setScene(scene);
        primaryStage.setMaxWidth(350.0);
        primaryStage.setMaxHeight(250.0);
        primaryStage.getIcons().add((Object)new Image(Res.class.getResourceAsStream("ic_launcher.png")));
        primaryStage.show();
        primaryStage.setOnCloseRequest(event -> {
            event.consume();
            primaryStage.hide();
        });
    }

    private void setFootView() {
        this.actiontarget = new Text();
        this.actiontarget.setText("\u672a\u4f7f\u7528");
        this.actiontarget.setCache(true);
        this.actiontarget.setFill((Paint)Color.RED);
    }

    private TabPane getTab() {
        this.tabPane = new TabPane();
        this.dialTab = new Tab("\u62e8\u53f7");
        this.dialTab.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.borderPane.setCenter((Node)ShanXunSettingPane.instance(this));
            }
        });
        this.dialTab.setClosable(false);
        this.tabPane.getTabs().add((Object)this.dialTab);
        this.routerTab = new Tab("\u8def\u7531\u5668\u914d\u7f6e");
        this.routerTab.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.borderPane.setCenter((Node)RouterPane.instance(this));
            }
        });
        this.routerTab.setClosable(false);
        this.tabPane.getTabs().add((Object)this.routerTab);
        this.aboutTab = new Tab("\u5173\u4e8e");
        this.aboutTab.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.borderPane.setCenter((Node)AboutPane.instance(this));
            }
        });
        this.aboutTab.setClosable(false);
        this.tabPane.getTabs().add((Object)this.aboutTab);
        return this.tabPane;
    }

    private void enableTray(final Stage stage) {
        PopupMenu popupMenu = new PopupMenu();
        MenuItem quitItem = new MenuItem("Exit");
        Platform.setImplicitExit((boolean)false);
        ActionListener acl = e -> {
            MenuItem item = (MenuItem)e.getSource();
            if (item.getLabel().equals("Exit")) {
                SystemTray.getSystemTray().remove(this.trayIcon);
                Platform.exit();
                return;
            }
        };
        MouseListener sj = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Platform.setImplicitExit((boolean)false);
                if (e.getClickCount() == 2) {
                    if (stage.isShowing()) {
                        Platform.runLater(() -> stage.hide());
                    } else {
                        Platform.runLater(() -> stage.show());
                    }
                }
            }
        };
        quitItem.addActionListener(acl);
        popupMenu.add(quitItem);
        try {
            SystemTray tray = SystemTray.getSystemTray();
            BufferedImage image = ImageIO.read(Res.class.getResourceAsStream("ic_launcher.png"));
            this.trayIcon = new TrayIcon(image, "", popupMenu);
            this.trayIcon.setToolTip("\u95ea\u8bafWIFI\u52a9\u624b\u684c\u9762\u7248");
            tray.add(this.trayIcon);
            this.trayIcon.addMouseListener(sj);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    @Override
    public void action(Action action) {
        switch (action) {
            case CHECKROUTER: {
                this.setFootView("\u8def\u7531\u5668\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
                this.tabPane.getSelectionModel().select((Object)this.routerTab);
                break;
            }
            case SAVEROUTER: {
                this.setFootView("\u5df2\u4fdd\u5b58");
                this.tabPane.getSelectionModel().select((Object)this.dialTab);
                break;
            }
            case DIAL: {
                new Thread(() -> this.doDial()).start();
                break;
            }
        }
    }

    private void doDial() {
        this.setFootView("\u6b63\u5728\u62e8\u53f7");
        if (ShanXunManager.doDial()) {
            this.setFootView("\u6b63\u5728\u68c0\u67e5\u7f51\u7edc");
            String json = ShanXunManager.getIp();
            if (TextUtil.isEmpty(json)) {
                this.setFootView("\u62e8\u53f7\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            } else {
                Gson gson = new Gson();
                this.ipConfig = gson.fromJson(json, IpConfig.class);
                this.setFootView("\u8fde\u63a5\u6210\u529f\uff0cIP:" + this.ipConfig.getIp());
                ShanXunManager.sendHeart(this, this.ipConfig.getIp());
            }
        } else {
            this.setFootView("\u62e8\u53f7\u5931\u8d25");
        }
    }

    @Override
    public void setFootView(String s) {
        this.actiontarget.setText(s);
    }

    @Override
    public void appendCount(int sendTotal, int successTotal) {
        this.setFootView("\u8fde\u63a5\u6210\u529f\uff0cIP:" + this.ipConfig.getIp() + " \u5df2\u53d1\u9001" + sendTotal + "\u6b21,\u6210\u529f" + successTotal + "\u6b21");
    }
}

