/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public final class JAXBAttachment
implements Attachment,
DataSource {
    private final String contentId;
    private final String mimeType;
    private final Object jaxbObject;
    private final XMLBridge bridge;

    public JAXBAttachment(@NotNull String string, Object object, XMLBridge xMLBridge, String string2) {
        this.contentId = string;
        this.jaxbObject = object;
        this.bridge = xMLBridge;
        this.mimeType = string2;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String getContentType() {
        return this.mimeType;
    }

    @Override
    public byte[] asByteArray() {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        try {
            this.writeTo(byteArrayBuffer);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return byteArrayBuffer.getRawData();
    }

    @Override
    public DataHandler asDataHandler() {
        return new DataSourceStreamingDataHandler(this);
    }

    @Override
    public Source asSource() {
        return new StreamSource(this.asInputStream());
    }

    @Override
    public InputStream asInputStream() {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        try {
            this.writeTo(byteArrayBuffer);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return byteArrayBuffer.newInputStream();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            this.bridge.marshal(this.jaxbObject, outputStream, null, null);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    @Override
    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setDataHandler(this.asDataHandler());
        attachmentPart.setContentId(this.contentId);
        sOAPMessage.addAttachmentPart(attachmentPart);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.asInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return null;
    }
}

