/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.policy.PolicyResolver;
import com.sun.xml.internal.ws.api.policy.PolicyResolverFactory;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.jaxws.PolicyUtil;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

public class PortInfo
implements WSPortInfo {
    @NotNull
    private final WSServiceDelegate owner;
    @NotNull
    public final QName portName;
    @NotNull
    public final EndpointAddress targetEndpoint;
    @NotNull
    public final BindingID bindingId;
    @NotNull
    public final PolicyMap policyMap;
    @Nullable
    public final WSDLPort portModel;

    public PortInfo(WSServiceDelegate wSServiceDelegate, EndpointAddress endpointAddress, QName qName, BindingID bindingID) {
        this.owner = wSServiceDelegate;
        this.targetEndpoint = endpointAddress;
        this.portName = qName;
        this.bindingId = bindingID;
        this.portModel = this.getPortModel(wSServiceDelegate, qName);
        this.policyMap = this.createPolicyMap();
    }

    public PortInfo(@NotNull WSServiceDelegate wSServiceDelegate, @NotNull WSDLPort wSDLPort) {
        this.owner = wSServiceDelegate;
        this.targetEndpoint = wSDLPort.getAddress();
        this.portName = wSDLPort.getName();
        this.bindingId = wSDLPort.getBinding().getBindingId();
        this.portModel = wSDLPort;
        this.policyMap = this.createPolicyMap();
    }

    @Override
    public PolicyMap getPolicyMap() {
        return this.policyMap;
    }

    public PolicyMap createPolicyMap() {
        PolicyMap policyMap = this.portModel != null ? this.portModel.getOwner().getParent().getPolicyMap() : PolicyResolverFactory.create().resolve(new PolicyResolver.ClientContext(null, this.owner.getContainer()));
        if (policyMap == null) {
            policyMap = PolicyMap.createPolicyMap(null);
        }
        return policyMap;
    }

    public BindingImpl createBinding(WebServiceFeature[] webServiceFeatureArray, Class<?> clazz) {
        return this.createBinding(new WebServiceFeatureList(webServiceFeatureArray), clazz, null);
    }

    public BindingImpl createBinding(WebServiceFeatureList webServiceFeatureList, Class<?> clazz, BindingImpl bindingImpl) {
        if (bindingImpl != null) {
            webServiceFeatureList.addAll(bindingImpl.getFeatures());
        }
        Iterable<WebServiceFeature> iterable = this.portModel != null ? this.portModel.getFeatures() : PolicyUtil.getPortScopedFeatures(this.policyMap, this.owner.getServiceName(), this.portName);
        webServiceFeatureList.mergeFeatures(iterable, false);
        webServiceFeatureList.mergeFeatures(this.owner.serviceInterceptor.preCreateBinding(this, clazz, webServiceFeatureList), false);
        BindingImpl bindingImpl2 = BindingImpl.create(this.bindingId, webServiceFeatureList.toArray());
        this.owner.getHandlerConfigurator().configureHandlers(this, bindingImpl2);
        return bindingImpl2;
    }

    private WSDLPort getPortModel(WSServiceDelegate wSServiceDelegate, QName qName) {
        if (wSServiceDelegate.getWsdlService() != null) {
            Iterable<? extends WSDLPort> iterable = wSServiceDelegate.getWsdlService().getPorts();
            for (WSDLPort wSDLPort : iterable) {
                if (!wSDLPort.getName().equals(qName)) continue;
                return wSDLPort;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public WSDLPort getPort() {
        return this.portModel;
    }

    @Override
    @NotNull
    public WSService getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    @NotNull
    public EndpointAddress getEndpointAddress() {
        return this.targetEndpoint;
    }

    @Override
    public QName getServiceName() {
        return this.owner.getServiceName();
    }

    @Override
    public QName getPortName() {
        return this.portName;
    }

    @Override
    public String getBindingID() {
        return this.bindingId.toString();
    }
}

