/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.output;

import com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutput;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutputAbstractImpl;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;

public class XMLStreamWriterOutput
extends XmlOutputAbstractImpl {
    private final XMLStreamWriter out;
    private final CharacterEscapeHandler escapeHandler;
    private final XmlStreamOutWriterAdapter writerWrapper;
    protected final char[] buf = new char[256];
    private static final Class FI_STAX_WRITER_CLASS = XMLStreamWriterOutput.initFIStAXWriterClass();
    private static final Constructor<? extends XmlOutput> FI_OUTPUT_CTOR = XMLStreamWriterOutput.initFastInfosetOutputClass();
    private static final Class STAXEX_WRITER_CLASS = XMLStreamWriterOutput.initStAXExWriterClass();
    private static final Constructor<? extends XmlOutput> STAXEX_OUTPUT_CTOR = XMLStreamWriterOutput.initStAXExOutputClass();

    public static XmlOutput create(XMLStreamWriter xMLStreamWriter, JAXBContextImpl jAXBContextImpl, CharacterEscapeHandler characterEscapeHandler) {
        Class<?> clazz = xMLStreamWriter.getClass();
        if (clazz == FI_STAX_WRITER_CLASS) {
            try {
                return FI_OUTPUT_CTOR.newInstance(xMLStreamWriter, jAXBContextImpl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (STAXEX_WRITER_CLASS != null && STAXEX_WRITER_CLASS.isAssignableFrom(clazz)) {
            try {
                return STAXEX_OUTPUT_CTOR.newInstance(xMLStreamWriter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CharacterEscapeHandler characterEscapeHandler2 = characterEscapeHandler != null ? characterEscapeHandler : NewLineEscapeHandler.theInstance;
        return new XMLStreamWriterOutput(xMLStreamWriter, characterEscapeHandler2);
    }

    protected XMLStreamWriterOutput(XMLStreamWriter xMLStreamWriter, CharacterEscapeHandler characterEscapeHandler) {
        this.out = xMLStreamWriter;
        this.escapeHandler = characterEscapeHandler;
        this.writerWrapper = new XmlStreamOutWriterAdapter(xMLStreamWriter);
    }

    @Override
    public void startDocument(XMLSerializer xMLSerializer, boolean bl, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws IOException, SAXException, XMLStreamException {
        super.startDocument(xMLSerializer, bl, nArray, namespaceContextImpl);
        if (!bl) {
            this.out.writeStartDocument();
        }
    }

    @Override
    public void endDocument(boolean bl) throws IOException, SAXException, XMLStreamException {
        if (!bl) {
            this.out.writeEndDocument();
            this.out.flush();
        }
        super.endDocument(bl);
    }

    @Override
    public void beginStartTag(int n, String string) throws IOException, XMLStreamException {
        this.out.writeStartElement(this.nsContext.getPrefix(n), string, this.nsContext.getNamespaceURI(n));
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (element.count() > 0) {
            for (int i = element.count() - 1; i >= 0; --i) {
                String string2 = element.getNsUri(i);
                if (string2.length() == 0 && element.getBase() == 1) continue;
                this.out.writeNamespace(element.getPrefix(i), string2);
            }
        }
    }

    @Override
    public void attribute(int n, String string, String string2) throws IOException, XMLStreamException {
        if (n == -1) {
            this.out.writeAttribute(string, string2);
        } else {
            this.out.writeAttribute(this.nsContext.getPrefix(n), this.nsContext.getNamespaceURI(n), string, string2);
        }
    }

    @Override
    public void endStartTag() throws IOException, SAXException {
    }

    @Override
    public void endTag(int n, String string) throws IOException, SAXException, XMLStreamException {
        this.out.writeEndElement();
    }

    @Override
    public void text(String string, boolean bl) throws IOException, SAXException, XMLStreamException {
        if (bl) {
            this.out.writeCharacters(" ");
        }
        this.escapeHandler.escape(string.toCharArray(), 0, string.length(), false, this.writerWrapper);
    }

    @Override
    public void text(Pcdata pcdata, boolean bl) throws IOException, SAXException, XMLStreamException {
        int n;
        if (bl) {
            this.out.writeCharacters(" ");
        }
        if ((n = pcdata.length()) < this.buf.length) {
            pcdata.writeTo(this.buf, 0);
            this.out.writeCharacters(this.buf, 0, n);
        } else {
            this.out.writeCharacters(pcdata.toString());
        }
    }

    private static Class initFIStAXWriterClass() {
        try {
            Class<?> clazz = Class.forName("com.sun.xml.internal.org.jvnet.fastinfoset.stax.LowLevelFastInfosetStreamWriter");
            Class<?> clazz2 = Class.forName("com.sun.xml.internal.fastinfoset.stax.StAXDocumentSerializer");
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz2;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Constructor<? extends XmlOutput> initFastInfosetOutputClass() {
        try {
            if (FI_STAX_WRITER_CLASS == null) {
                return null;
            }
            Class<?> clazz = Class.forName("com.sun.xml.internal.bind.v2.runtime.output.FastInfosetStreamWriterOutput");
            return clazz.getConstructor(FI_STAX_WRITER_CLASS, JAXBContextImpl.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class initStAXExWriterClass() {
        try {
            return Class.forName("com.sun.xml.internal.org.jvnet.staxex.XMLStreamWriterEx");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Constructor<? extends XmlOutput> initStAXExOutputClass() {
        try {
            Class<?> clazz = Class.forName("com.sun.xml.internal.bind.v2.runtime.output.StAXExStreamWriterOutput");
            return clazz.getConstructor(STAXEX_WRITER_CLASS);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static class NewLineEscapeHandler
    implements CharacterEscapeHandler {
        public static final NewLineEscapeHandler theInstance = new NewLineEscapeHandler();

        private NewLineEscapeHandler() {
        }

        @Override
        public void escape(char[] cArray, int n, int n2, boolean bl, Writer writer) throws IOException {
            int n3 = n + n2;
            int n4 = n;
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c != '\r' && c != '\n') continue;
                if (i != n4) {
                    writer.write(cArray, n4, i - n4);
                }
                n4 = i + 1;
                if (writer instanceof XmlStreamOutWriterAdapter) {
                    try {
                        ((XmlStreamOutWriterAdapter)writer).writeEntityRef("#x" + Integer.toHexString(c));
                        continue;
                    }
                    catch (XMLStreamException xMLStreamException) {
                        throw new IOException("Error writing xml stream", xMLStreamException);
                    }
                }
                writer.write("&#x");
                writer.write(Integer.toHexString(c));
                writer.write(59);
            }
            if (n4 != n3) {
                writer.write(cArray, n4, n2 - n4);
            }
        }
    }

    private static final class XmlStreamOutWriterAdapter
    extends Writer {
        private final XMLStreamWriter writer;

        private XmlStreamOutWriterAdapter(XMLStreamWriter xMLStreamWriter) {
            this.writer = xMLStreamWriter;
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            try {
                this.writer.writeCharacters(cArray, n, n2);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IOException("Error writing XML stream", xMLStreamException);
            }
        }

        public void writeEntityRef(String string) throws XMLStreamException {
            this.writer.writeEntityRef(string);
        }

        @Override
        public void flush() throws IOException {
            try {
                this.writer.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IOException("Error flushing XML stream", xMLStreamException);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.writer.close();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IOException("Error closing XML stream", xMLStreamException);
            }
        }
    }
}

