// 頂点シェーダーで使用するuniform変数
uniform	mat4	u_mvp_matrix;			// モデルビュープロジェクション行列
uniform	float	u_ofsz;				// Zオフセット
uniform	vec2	u_tex_ofs;			// テクスチャ0UVオフセット

// 頂点シェーダーへの入力
attribute	vec4	a_position;		// 入力:位置
attribute	vec4	a_color;		// 入力:頂点色
attribute	vec2	a_texcoord;		// 入力:テクスチャ座標

// フラグメントシェーダーへの出力
varying		vec4	v_color;		// 出力:頂点色
varying		vec2	v_texcoord;		// 出力:テクスチャ座標
varying		float	v_eyeDist;		// 出力:視点からの距離

//----------------------------------------------
// 頂点カラー+テクスチャ
//----------------------------------------------
void main (void)
	{
	gl_Position	= u_mvp_matrix * a_position;
	gl_Position.z += u_ofsz;

	v_texcoord	= a_texcoord + u_tex_ofs;
	v_color		= a_color;
	v_color /= 255.0;
	}
