// modified by Luigi Auriemma
/***********************************************************
*
*    bpe2.c
*
*      Byte Pair Encoding t@C̃eXg
*      ubÑwb_ȗłꍇȗ
*
***********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

static
unsigned char   *infile   = NULL,
                *outfile  = NULL,
                *infilel  = NULL,
                *outfilel = NULL;
static int xgetc(void *skip) {
    if(infile >= infilel) return(-1);
    return(*infile++);
}
//static int xputc(int chr, void *skip) {
    //if(outfile >= outfilel) return(-1);
    //*outfile++ = chr;
    //return(chr);
//}
static int xread(void *buff, int a, int b, void *X) {
    int     len,
            inlen;

    len = a * b;
    inlen = (infilel - infile);
    if(len > inlen) len = inlen;
    memcpy(buff, infile, len);
    infile += len;
    return(len);
}
static int xwrite(void *buff, int a, int b, void *X) {
    int     len,
            outlen;

    len = a * b;
    outlen = (outfilel - outfile);
    if(len > outlen) len = outlen;
    memcpy(outfile, buff, len);
    outfile += len;
    return(len);
}

typedef unsigned char  Uchar;
typedef unsigned short Ushort;
typedef unsigned int   Uint;

/* O[oϐ̒` */
#define  HEADER_SIZE 4
char file_header[HEADER_SIZE] = "BPE2";
char file_ext[] = ".bpe2";
char input_fname[FILENAME_MAX];
char output_fname[FILENAME_MAX];
int  mode;      /* 'e':encode 'd':decode */

FILE *infp, *outfp;      /* ̓t@C, o̓t@C */

#define TRUE    1
#define FALSE   0
#define BUFMIN  128
#define BUFMAX  32511         /* 0x7eff */
int bufsize = 4096;           /* f[^Ɨ̈̃TCY */

Uchar  ptsize;                /* yA\̑傫 */
Uchar  ptbuf[256*3];          /* pyA\obt@ */

Uchar  pairtable1[256];       /* ꎞIyA\(1Ԗڂ̕) [hł͕gĂ邩ǂ̔p */
Uchar  pairtable2[256];       /* ꎞIyA\(2Ԗڂ̕) */

Uchar  srcbuf[BUFMAX + 16];   /* ̃f[^̃obt@ */
Uchar  workbuf[BUFMAX + 16];  /* kf[^̃obt@ */
Ushort *paircount;            /* yAopJE^(mallocŗ̈mۂ, [ĥݎgp) */
int    ob_count = 0;          /* *outbuf[] gĂ鐔 */
Uchar  *outbuf[256];          /* f[^o͗pobt@(mallocŗ̈mۂ, [ĥݎgp) */

/*--------------------------------------------------------*/
/*                                                */
/*--------------------------------------------------------*/

/* workbuf[]WJsrcbuf[]֏ */
static int decode_buf(int bfs, int isize)
{
	int wpos = 0, spos = 0;
	Uchar stackbuf[256], stackhead = 0;  /* fR[hpX^bN */
	
	while (wpos < isize || stackhead > 0)
	{
		Uchar ch;
		if (!stackhead) {
			/* X^bN̎Af[^1ByteǍ */
			ch = workbuf[wpos++];
		} else {
			/* X^bN1ByteǍ */
			ch = stackbuf[--stackhead];
		}

		while (TRUE) {
			/* yA\當𓾂 */
			if (ch == pairtable1[ch]) {
				/* f[^̂܂1Byte */
				if (spos >= bfs)  return(-1);
				srcbuf[spos++] = ch;
				break;
			}
			/* f[^X^bN֓ */
			stackbuf[stackhead++] = pairtable2[ch];
			ch = pairtable1[ch];
		}
	}
	return spos;
}

/*  */
static int decode(void)
{
	int osize = 0;
	
	/* obt@TCY̓Ǎ */
	bufsize = xgetc(infp);
	bufsize = (bufsize << 8) | xgetc(infp);
	if (bufsize < BUFMIN || BUFMAX < bufsize)  return(-1);
	//printf("Ɨ̈pobt@: %dByte\n", bufsize);
	while (TRUE)
	{
		int i, typ;
		int pts, ch, c2;
		int isize, srcsize;
		/* ubNwb_Ǎ */
		if (ob_count > 0) {
			if (xread(workbuf, 1, bufsize, infp) != (size_t)bufsize)  return(-1);
			xwrite(workbuf, 1, bufsize, outfp);
			srcsize = bufsize;
			ob_count--;
		} else {
			int headcode = xgetc(infp);
			if (headcode == EOF)  break;
			if (headcode == 0x7f) {
				ob_count = xgetc(infp);
				headcode = bufsize;
			} else {
				headcode = (headcode << 8) | xgetc(infp);
			}
			
			typ = headcode >> 15;
			isize = headcode & 0x7fff;
			/* ubNf[^̓Ǎ */
			if (xread(workbuf, 1, isize, infp) != (size_t)isize)  return(-1);

			/* yA\ */
			for (i = 0; i < 256; i++) {
				pairtable1[i] = i;
			}
			if (typ) {
				/* yA\̓Ǎ */
				if ((pts = xgetc(infp)) < 0)  return(-1);
				for (i = 0; i < pts; i++) {
					if ((ch = xgetc(infp)) < 0)  return(-1);
					if ((c2 = xgetc(infp)) < 0)  return(-1);
					pairtable1[ch] = c2;
					if ((c2 = xgetc(infp)) < 0)  return(-1);
					pairtable2[ch] = c2;
				}
			}
			srcsize = decode_buf(bufsize, isize);  /*  */
            if(srcsize < 0) return(-1);
			xwrite(srcbuf, 1, srcsize, outfp);
		}
		
		/* roߕ\ */
		osize += srcsize;
		//printf("             %d\r", osize);
	}
    return(0);
}



int unbpe2(unsigned char *in, int insz, unsigned char *out, int outsz) {
    infile   = in;
    infilel  = in + insz;
    outfile  = out;
    outfilel = out + outsz;
    if(decode() < 0) return(-1);
    return(outfile - out);
}

