/****************************************************************************
 *                                                                          *
 * File    : ids.h                                                          *
 *                                                                          *
 * Purpose : Misc ID's for menus, strings, icons etc.                       *
 *                                                                          *
 * History : Date      Reason                                               *
 *           03-02-02  Created                                              *
 *                                                                          *
 ****************************************************************************/

#ifndef H_IDS
#define H_IDS

//
// String ID's --------------------------------------------------------------
//

#define IDS_NULL                        10001

#define IDS_BADSCREENRESOLUTION         10002   // 6.50
#define IDS_BADCOMCTLVERSION            10003
#define IDS_BADVERSION                  10004
#define IDS_OUTOFMEMORY                 10005
#define IDS_MEMORYERROR                 10006
#define IDS_COMMDLGERROR                10007
#define IDS_THREADERROR                 10008
#define IDS_DEBUGGERERROR               10009
#define IDS_EXECERROR                   10010
#define IDS_PIPEERROR                   10011
#define IDS_BADNUMBER                   10012
#define IDS_BACKUPERROR                 10013
#define IDS_CHANGEDIRERROR              10014
#define IDS_CREATEDIRERROR              10015
#define IDS_CREATEFILEERROR             10016
#define IDS_OPENFILEERROR               10017
#define IDS_READFILEERROR               10018
#define IDS_WRITEFILEERROR              10019
#define IDS_RENAMEFILEERROR             10020   // 4.0
#define IDS_DELETEFILEERROR             10021   // 5.0
#define IDS_WRITEREGERROR               10022
#define IDS_WRITEXMLERROR               10023   // 5.0
#define IDS_PRINTERROR                  10024
#define IDS_HELPERROR                   10025
#define IDS_OPENURLERROR                10026   // 7.0
#define IDS_SAVENOW                     10027
#define IDS_QUITNOW                     10028
#define IDS_MUSTRELOADNOW               10029
#define IDS_RESTOREBACKUP               10030
#define IDS_WRAPFINDATBOTTOM            10031
#define IDS_WRAPFINDATTOP               10032
#define IDS_REPLACECOMPLETE             10033
#define IDS_FINDTEXTERROR               10034
#define IDS_FINDFUNCERROR               10035
#define IDS_BADREGEX                    10036   // 11.0
#define IDS_BADDEVICECOLORS             10037
#define IDS_DELETEIMAGE                 10038
#define IDS_CANTEDITIMAGE               10039
#define IDS_BADDROPSHADOWIMAGE          10040   // 4.0
#define IDS_CREATECTRLERROR             10041
#define IDS_CREATEDLGERROR              10042
#define IDS_DUPCONTROLID                10043
#define IDS_DUPCONTROLMNEMONIC          10044
#define IDS_DUPPOPUPMNEMONIC            10045
#define IDS_NODUPMNEMONICS              10046
#define IDS_PASTEERROR                  10047
#define IDS_RESERVEDID                  10048
#define IDS_CREATERSRCERROR             10049
#define IDS_BADRESOURCENAME             10050
#define IDS_BADRESOURCETYPE             10051   // 3.0
#define IDS_DUPRSRCLANGUAGE             10052
#define IDS_LOADFORMERROR               10053
#define IDS_SAVEFORMERROR               10054
#define IDS_LOADMENUERROR               10055
#define IDS_SAVEMENUERROR               10056
#define IDS_LOADACCELERROR              10057
#define IDS_SAVEACCELERROR              10058
#define IDS_LOADTEXTERROR               10059
#define IDS_SAVETEXTERROR               10060
#define IDS_LOADMESSERROR               10061   // 3.0
#define IDS_SAVEMESSERROR               10062   // 3.0
#define IDS_LOADIMAGEERROR              10063
#define IDS_SAVEIMAGEERROR              10064
#define IDS_LOADANIMERROR               10065
#define IDS_SAVEANIMERROR               10066
#define IDS_LOADEDITERROR               10067
#define IDS_SAVEEDITERROR               10068
#define IDS_LOADVERSERROR               10069
#define IDS_SAVEVERSERROR               10070
#define IDS_LOADDUMPERROR               10071
#define IDS_SAVEDUMPERROR               10072
#define IDS_ENLARGEBITMAP               10073
#define IDS_SELECTPROJROOT              10074
#define IDS_SELECTFINDPATH              10075
#define IDS_UPGRADEPROJECT              10076   // 9.0
#define IDS_DUPPROJNAME                 10077
#define IDS_DELETEPROJECT               10078   // 4.0
#define IDS_IMPORTPROJECT               10079   // 4.0
#define IDS_IMPORTPROJFILE              10080
#define IDS_DELETEPROJFILE              10081
#define IDS_ADDPROJFILE                 10082
#define IDS_BADPROJPATH                 10083   // 7.0
#define IDS_BADPROJFILEPATH             10084   // 6.0
#define IDS_DUPPROJMODE                 10085   // 9.0
#define IDS_BADPROJMODENAME             10086   // 9.0
#define IDS_EXTRACTZIPERROR             10087
#define IDS_NOPROJZIPFILES              10088
#define IDS_NOPROJEXECUTOR              10089
#define IDS_DUPTEXTID                   10090
#define IDS_SETATTRIBERROR              10091
#define IDS_BADCOMPRESSION              10092
#define IDS_NEEDCERTIFICATE             10093   // 5.0
#define IDS_BADMACRONAME                10094
#define IDS_DUPMACRONAME                10095
#define IDS_NOMACROVALUE                10096   // 6.0
#define IDS_DUPCUSTCNTL                 10097
#define IDS_CANTLOADDLL                 10098
#define IDS_BADCUSTCNTL                 10099
#define IDS_CANTINITCUSTCNTL            10100
#define IDS_CUSTCNTLINUSE               10101
#define IDS_CUSTCNTLERROR               10102
#define IDS_BADLABELNAME                10103
#define IDS_DUPLABELS                   10104
#define IDS_DUPLABELID                  10105
#define IDS_DUPLABELNAME                10106
#define IDS_BADACCELKEY                 10107
#define IDS_BADSTRINGVALUE              10108
#define IDS_BADTOOLTEXT                 10109
#define IDS_BADTOOLCOMMAND              10110
#define IDS_BADTOOLMACRO                10111
#define IDS_BADHELPTEXT                 10112
#define IDS_BADHELPCOMMAND              10113
#define IDS_BADHELPBUILTIN              10114   // 7.0
#define IDS_BADSNIPPETNAME              10115   // 5.0
#define IDS_DUPSNIPPETNAME              10116   // 5.0
#define IDS_BADSNIPPETCODE              10117   // 5.0
#define IDS_SAVESNIPPETERROR            10118   // 5.0
#define IDS_DUPKEY                      10119
#define IDS_NODEBUGINFO                 10120
#define IDS_STOPDEBUGGER                10121
#define IDS_EXCEPTION1                  10122
#define IDS_EXCEPTION2                  10123
#define IDS_HARDWAREBREAK               10124   // 4.0
#define IDS_TIMESTAMPERROR              10125
#define IDS_BADBRKPNTLINE               10126
#define IDS_BADEXPRESSION               10127   // 4.0
#define IDS_NOBREAKCHAR                 10128
#define IDS_CFORMATERROR                10129   // 3.0
#define IDS_KILLPROCESS                 10130
//
#define IDS_FINDABORTED                 10131
#define IDS_FINDRESULT                  10132
#define IDS_NOFILETIME                  10133
#define IDS_FILESIZE                    10134
//
#define IDS_FILEPOPUP                   10135   // 7.0: IDS_TITLEFILE -> IDS_FILEPOPUP
#define IDS_EDITPOPUP                   10136   // 7.0
#define IDS_VIEWPOPUP                   10137   // 7.0: IDS_TITLEVIEW -> IDS_VIEWPOPUP
#define IDS_PROJPOPUP                   10138   // 7.0
#define IDS_TOOLPOPUP                   10139   // 7.0: IDS_TITLETOOLS -> IDS_TOOLPOPUP
#define IDS_WINPOPUP                    10140   // 7.0: IDS_TITLEWINDOWS -> IDS_WINPOPUP
#define IDS_HELPPOPUP                   10141   // 7.0: IDS_HELPTITLE -> IDS_HELPPOPUP
#define IDS_SRCPOPUP                    10142   // 7.0: IDS_EDITPOPUP -> IDS_SRCPOPUP
#define IDS_IMGPOPUP                    10143   // 7.0: IDS_PICTPOPUP -> IDS_IMGPOPUP
#define IDS_DLGPOPUP                    10144   // 7.0: IDS_FORMPOPUP -> IDS_DLGPOPUP
#define IDS_MENUPOPUP                   10145
#define IDS_MESSPOPUP                   10146   // 3.0
#define IDS_RSRCPOPUP                   10147
#define IDS_DBGPOPUP                    10148
#define IDS_WEBPOPUP                    10149   // 7.0
#define IDS_DIFFPOPUP                   10150   // 7.0
#define IDS_CUSTOMHELPPOPUP             10151   // 5.0
#define IDS_FILEFIND                    10152
#define IDS_STOPFILEFIND                10153   // 7.0: IDS_FILEFINDQUIT -> IDS_STOPFILEFIND
#define IDS_UNDOACTION                  10154
#define IDS_REDOACTION                  10155
#define IDS_BUILDPROJ                   10156
#define IDS_REBUILDPROJ                 10157   // 5.0
#define IDS_CLEANPROJ                   10158   // 9.0
#define IDS_BUILDWKSPROJ                10159   // 5.0
#define IDS_REBUILDWKSPROJ              10160   // 5.0
#define IDS_CLEANWKSPROJ                10161   // 9.0
#define IDS_STOPBUILD                   10162   // 5.0
#define IDS_COMPILEPROJ                 10163
#define IDS_EXECUTEPROJ                 10164
#define IDS_DEBUGPROJ                   10165
#define IDS_PROFILEPROJ                 10166   // 6.50
#define IDS_EXCLPROJ                    10167   // 4.0
#define IDS_INCLPROJ                    10168   // 4.0
#define IDS_FILEDIFF                    10169   // 7.0
#define IDS_STOPFILEDIFF                10170   // 7.0
#define IDS_TITLEENVIRONMENT            10171   // 10.0
#define IDS_TITLESETUP                  10172
#define IDS_TITLEPROJSETUP              10173   // 4.0
#define IDS_TITLECHOOSECOLOR            10174   // 4.0
#define IDS_TITLECUSTOMIZE              10175
#define IDS_TITLECUSTOM                 10176
#define IDS_TITLEMISC                   10177
#define IDS_TITLEDIFFERENCE             10178   // 7.0
#define IDS_TITLECURSOR                 10179
#define IDS_TITLEICON                   10180
#define IDS_TITLEBITMAP                 10181
#define IDS_TITLEMENU                   10182
#define IDS_TITLEDIALOG                 10183
#define IDS_TITLESTRINGTABLE            10184
#define IDS_TITLEACCELTABLE             10185
#define IDS_TITLEMSGTABLE               10186
#define IDS_TITLEVERSION                10187
#define IDS_TITLEANICURSOR              10188
#define IDS_TITLEANIICON                10189
#define IDS_TITLEHTML                   10190
#define IDS_TITLEXML                    10191
#define IDS_TITLEMANIFEST               10192
#define IDS_TITLERCDATA                 10193
#define IDS_TITLEVIDEO                  10194
#define IDS_TITLESOUND                  10195
#define IDS_TITLETYPELIB                10196
#define IDS_TITLEID                     10197
#define IDS_TITLETEXT                   10198
#define IDS_TITLEWORKSPACE              10199   // 4.0
#define IDS_TITLESOURCEFILES            10200
#define IDS_TITLEINCLUDEFILES           10201
#define IDS_TITLERESOURCEFILES          10202
#define IDS_TITLEOTHERFILES             10203
#define IDS_TITLEEXTERNALFILES          10204   // 8.0
#define IDS_TITLEFILENAME               10205
#define IDS_TITLEFILEPATH               10206
#define IDS_TITLEFILEDATE               10207
#define IDS_TITLELASTWRITETIME          10208
#define IDS_TITLEPROJECT                10209
#define IDS_TITLEFILEFIND               10210
#define IDS_TITLEDEBUGGER               10211   // 11.00
#define IDS_TITLEDEBUGGER_RUNNING       10212
#define IDS_TITLEDEBUGGER_STOPPED       10213
#define IDS_TITLEPROFILER_RUNNING       10214   // 6.50
#define IDS_TITLEPROFILER               10215   // 6.50
#define IDS_TITLETRACE                  10216
#define IDS_TITLEOUTPUT                 10217
#define IDS_TITLEAUTO                   10218
#define IDS_TITLELOCALS                 10219
#define IDS_TITLEGLOBALS                10220
#define IDS_TITLEREGISTERS              10221
#define IDS_TITLESTACK                  10222
#define IDS_TITLEMEMORY                 10223
#define IDS_TITLETHREADS                10224
#define IDS_TITLEMODULES                10225
#define IDS_TITLEEXCEPTIONS             10226
#define IDS_TITLEBREAKPOINTS            10227
#define IDS_TITLEWATCH                  10228
#define IDS_TITLETHREADID               10229
#define IDS_TITLEDESCRIPTION            10230   // 9.0
#define IDS_TITLESUSPENDED              10231
#define IDS_TITLEPRIORITY               10232
#define IDS_TITLEHWBREAKNOTHING         10233   // 4.0
#define IDS_TITLEHWBREAKWRITEONLY       10234   // 4.0
#define IDS_TITLEHWBREAKREADWRITE       10235   // 4.0
#define IDS_TITLEHWBREAK1BYTE           10236   // 4.0
#define IDS_TITLEHWBREAK2BYTE           10237   // 4.0
#define IDS_TITLEHWBREAK4BYTE           10238   // 4.0
#define IDS_TITLESTOPALWAYS             10239
#define IDS_TITLEBROWSESOURCE           10240
#define IDS_TITLESAMPLES                10241   // 6.50
#define IDS_TITLEPERCENT                10242   // 6.50
#define IDS_TITLEFUNCTION               10243   // 6.50
#define IDS_TITLEMODULENAME             10244   // 6.50
#define IDS_TITLESOURCEFILE             10245   // 6.50
#define IDS_TITLEINCLUSIVE              10246   // 8.0
#define IDS_TITLEEXCLUSIVE              10247   // 8.0
#define IDS_TITLEIMPORT                 10248
#define IDS_TITLEADDFILES               10249
#define IDS_TITLEADDPROJECTS            10250   // 4.0
#define IDS_TITLEFILEVERSION            10251
#define IDS_TITLEPRODUCTVERSION         10252
#define IDS_TITLEFILEFLAGSMASK          10253
#define IDS_TITLEFILEFLAGS              10254
#define IDS_TITLEFILEOS                 10255
#define IDS_TITLEFILETYPE               10256
#define IDS_TITLEFILESUBTYPE            10257
#define IDS_TITLEBLOCKHEADER            10258
#define IDS_TITLECOMMENTS               10259
#define IDS_TITLECOMPANYNAME            10260
#define IDS_TITLEFILEDESCRIPTION        10261
#define IDS_TITLEFILEVERSION2           10262
#define IDS_TITLEINTERNALNAME           10263
#define IDS_TITLECOPYRIGHT              10264
#define IDS_TITLETRADEMARKS             10265
#define IDS_TITLEORIGINALNAME           10266
#define IDS_TITLEPRIVATEBUILD           10267
#define IDS_TITLEPRODUCTNAME            10268
#define IDS_TITLEPRODUCTVERSION2        10269
#define IDS_TITLESPECIALBUILD           10270
#define IDS_TITLEALLFRAMES              10271
#define IDS_TITLESOMEFRAMES             10272
#define IDS_TITLEONEFRAME               10273
#define IDS_TITLEDRAWFRAME              10274   // 10.0: IDS_TITLEPICTFRAME -> IDS_TITLEDRAWFRAME
#define IDS_TITLEPATH                   10275
#define IDS_TITLELIB                    10276
#define IDS_TITLEINCLUDE                10277
#define IDS_TITLEPROPS                  10278
#define IDS_TITLENAME                   10279
#define IDS_TITLEVALUE                  10280
#define IDS_TITLEADDRESS                10281
#define IDS_TITLEDBGINFO                10282   // 8.0
#define IDS_TITLETYPE                   10283
#define IDS_TITLELINENO                 10284
#define IDS_TITLEADDMACRO               10285
#define IDS_TITLEEDITMACRO              10286
#define IDS_TITLEADDTOOL                10287
#define IDS_TITLEEDITTOOL               10288
#define IDS_TITLEADDHELP                10289
#define IDS_TITLEEDITHELP               10290
#define IDS_TITLEADDSNIPPET             10291   // 5.0
#define IDS_TITLEEDITSNIPPET            10292   // 5.0
#define IDS_TITLEKEY                    10293
#define IDS_TITLE1BPP                   10294
#define IDS_TITLE4BPP                   10295
#define IDS_TITLE8BPP                   10296
#define IDS_TITLE16BPP                  10297
#define IDS_TITLE24BPP                  10298
#define IDS_TITLE32BPP                  10299
#define IDS_TITLENONE                   10300
#define IDS_TITLEC                      10301
#define IDS_TITLEASM                    10302
#define IDS_TITLERC                     10303   // 6.0
#define IDS_TITLEMC                     10304   // 6.0
#define IDS_TITLEINST                   10305   // 5.0
#define IDS_TITLEDEF                    10306
#define IDS_TITLECUT                    10307
#define IDS_TITLECOPY                   10308
#define IDS_TITLEPASTE                  10309
#define IDS_TITLECLEAR                  10310
#define IDS_TITLEEDIT                   10311
#define IDS_TITLEINSERT                 10312
#define IDS_TITLEEFFECT                 10313
#define IDS_TITLEMIRROR                 10314
#define IDS_TITLEROTATE                 10315
#define IDS_TITLEGRAYSCALE              10316
#define IDS_TITLESEPIATONE              10317   // 4.0
#define IDS_TITLEOPAQUEALPHA            10318   // 4.0
#define IDS_TITLEHSV                    10319
#define IDS_TITLEDRAW                   10320
#define IDS_TITLESCREENCOLOR            10321
#define IDS_TITLERESIZE                 10322
#define IDS_TITLEALIGN                  10323
#define IDS_TITLEEVENSPACE              10324
#define IDS_TITLESIZETOTEXT             10325
#define IDS_TITLEMOVE                   10326
#define IDS_TITLECENTER                 10327
#define IDS_TITLEORDER                  10328
#define IDS_TITLECONVERT                10329
#define IDS_TITLEINDENT                 10330
#define IDS_TITLEREPLACE                10331
#define IDS_TITLEDRAGDROP               10332
#define IDS_TITLETEST                   10333   // 6.0
#define IDS_TITLEADVANCED               10334   // 6.0
#define IDS_TITLESTANDARD               10335   // 6.0
#define IDS_TITLEHELPCONTENTS           10336   // 7.0
#define IDS_TITLEHELPINDEX              10337   // 7.0
#define IDS_TITLEHELPSEARCH             10338   // 8.0
#define IDS_TITLEOUTLINE                10339   // 7.0
#define IDS_TITLEEXPAND                 10340   // 7.0
#define IDS_OPENINCLUDE                 10341   // 4.50
#define IDS_CONTEXTHELP                 10342
#define IDS_VIEWDEFINITION              10343
#define IDS_PREVDEFINITION              10344
#define IDS_FINDCALLSITES               10345   // 4.0
#define IDS_SURROUNDBY                  10346   // 5.0
#define IDS_EDITBREAKPOINT              10347   // 4.0
#define IDS_BREAKALWAYS                 10348   // 4.0
#define IDS_BREAKONHITCOUNT             10349   // 4.0
#define IDS_BREAKONEXPRESSION           10350   // 4.0
#define IDS_BREAKDISABLED               10351   // 4.0
#define IDS_APPNAME                     10352
#define IDS_APPVERSION                  10353
#define IDS_SPLASHVERSION               10354
#define IDS_DEBUGHELPER                 10355   // 8.0 (IDS_APPNAME_DBGHELPER -> IDS_APPNAME + IDS_DEBUGHELPER)
#define IDS_ADMINISTRATOR               10356   // 8.0
#define IDS_UNTITLED                    10357
#define IDS_OK                          10358   // 9.0
#define IDS_CANCEL                      10359   // 9.0
#define IDS_YES                         10360
#define IDS_NO                          10361
#define IDS_EMPTY                       10362
#define IDS_SPECIAL                     10363
#define IDS_NEUTRAL                     10364   // 8.0
#define IDS_SAMPLELINE                  10365
#define IDS_PRINTFILE                   10366
#define IDS_PRINTPAGE                   10367
#define IDS_OUTPUTDONE                  10368
#define IDS_DELETEFROMDISK              10369   // 9.0
#define IDS_DONTASKAGAIN                10370   // 9.0
//
#define IDS_COMMONFILTER                10371
#define IDS_SOURCEFILTER                10372
#define IDS_RESOURCEFILTER              10373
#define IDS_PROJECTFILTER               10374
#define IDS_IMAGEFILTER                 10375
#define IDS_ANIMATIONFILTER             10376
#define IDS_EXECUTEFILTER               10377
#define IDS_INSTALLFILTER               10378   // 5.0
#define IDS_IMPSRCFILTER                10379   // 4.0
#define IDS_IMPPROJFILTER               10380   // 4.0
#define IDS_IMPRSRCFILTER               10381
#define IDS_IMPANICURFILTER             10382
#define IDS_IMPAVIFILTER                10383
#define IDS_CUSTCNTLFILTER              10384
#define IDS_PALETTEFILTER               10385
#define IDS_CUSTTOOLFILTER              10386
#define IDS_CUSTHELPFILTER              10387
#define IDS_ALLFILTER                   10388
#define IDS_SRCFILTER                   10389
#define IDS_INCFILTER                   10390
#define IDS_HTMFILTER                   10391
#define IDS_XMLFILTER                   10392
#define IDS_DEFFILTER                   10393
#define IDS_PISFILTER                   10394   // 5.0
#define IDS_ASMFILTER                   10395
#define IDS_RCFILTER                    10396
#define IDS_RESFILTER                   10397
#define IDS_JPGFILTER                   10398
#define IDS_PNGFILTER                   10399
#define IDS_GIFFILTER                   10400
#define IDS_BMPFILTER                   10401
#define IDS_ICOFILTER                   10402
#define IDS_CURFILTER                   10403
#define IDS_ANICURFILTER                10404
#define IDS_AVIFILTER                   10405
#define IDS_ZIPFILTER                   10406
#define IDS_MSGFILTER                   10407   // 3.0
#define IDS_WAVFILTER                   10408   // 6.0
#define IDS_CEXT                        10409
#define IDS_HEXT                        10410
#define IDS_PPWEXT                      10411   // 4.0
#define IDS_PPJEXT                      10412
#define IDS_PPXEXT                      10413
#define IDS_TAGEXT                      10414
#define IDS_RCEXT                       10415
#define IDS_RESEXT                      10416
#define IDS_PCXEXT                      10417
#define IDS_GIFEXT                      10418
#define IDS_JPGEXT                      10419
#define IDS_PNGEXT                      10420
#define IDS_BMPEXT                      10421
#define IDS_DIBEXT                      10422
#define IDS_ICOEXT                      10423
#define IDS_CUREXT                      10424
#define IDS_ANIEXT                      10425
#define IDS_AVIEXT                      10426
#define IDS_PALEXT                      10427
#define IDS_CHMEXT                      10428
#define IDS_LIBEXT                      10429
#define IDS_DLLEXT                      10430
#define IDS_EXEEXT                      10431
#define IDS_OBJEXT                      10432
#define IDS_HTMEXT                      10433
#define IDS_XMLEXT                      10434
#define IDS_ZIPEXT                      10435
#define IDS_DEFEXT                      10436
#define IDS_ASMEXT                      10437
#define IDS_INCEXT                      10438
#define IDS_MCEXT                       10439   // 6.0
#define IDS_MSGEXT                      10440   // 3.0
#define IDS_PISEXT                      10441   // 5.0
#define IDS_TXTEXT                      10442   // 5.0
#define IDS_WAVEXT                      10443   // 6.0
#define IDS_DATEXT                      10444   // 8.0
#define IDS_OPENAUTO                    10445   // 4.50
#define IDS_OPENTEXT                    10446   // 4.50
#define IDS_OPENBINARY                  10447   // 4.50
#define IDS_OPENRESOURCE                10448   // 4.50
#define IDS_OPENRCDATA                  10449   // 4.50
#define IDS_OPENCUSTOM                  10450   // 4.50
//
#define IDS_STATEPOS                    10451
#define IDS_STATESIZE                   10452
#define IDS_STATEEDIT                   10453
#define IDS_STATEDEPSCAN                10454
#define IDS_STATEBROWSEINFO             10455   // 8.0
#define IDS_STATEPOPUP                  10456
#define IDS_STATESEPARATOR              10457
#define IDS_STATEMENUITEM               10458
#define IDS_STATEIMAGELIST              10459
#define IDS_STATEOILPAINT               10460
#define IDS_STATEDITHER                 10461
#define IDS_STATEZIP                    10462   // 7.0
#define IDS_STATELOADPROJ               10463   // 9.0
#define IDS_STATEINITPROJ               10464   // 10.0
#define IDS_FILEFINDWHAT                10465
#define IDS_DEFAULTMENUTEXT             10466
#define IDS_DONTMESS                    10467
#define IDS_SELECTFROMLIST              10468
#define IDS_TARGETNAME                  10469
#define IDS_TARGETBASENAME              10470
#define IDS_FIRSTPREQNAME               10471
#define IDS_ALLPREQNAMES                10472
//
#define IDS_DIALOGTEXT                  10473   // 5.0
#define IDS_TEXTTEXT                    10474   // 5.0
#define IDS_EDITBOXTEXT                 10475   // 5.0
#define IDS_GROUPBOXTEXT                10476   // 5.0
#define IDS_PUSHBUTTONTEXT              10477   // 5.0
#define IDS_CHECKBOXTEXT                10478   // 5.0
#define IDS_RADIOBUTTONTEXT             10479   // 5.0
#define IDS_RICHEDITTEXT                10480   // 5.0
#define IDS_SYSLINKTEXT                 10481   // 5.0
#define IDS_NETADDRESSTEXT              10482   // 5.0
#define IDS_SPLITBUTTONTEXT             10483   // 5.0
#define IDS_COMMANDLINKTEXT             10484   // 5.0
#define IDS_CUSTOMTEXT                  10485   // 5.0
//
#define IDS_UNUSED                      10486
#define IDS_IDOK                        10487
#define IDS_IDCANCEL                    10488
//
#define IDS_RCHEADER                    10489
#define IDS_HHEADER                     10490
//
#define IDS_ACCELSHIFT                  10491
#define IDS_ACCELCONTROL                10492
#define IDS_ACCELALT                    10493
//
#define IDS_MAKHEADER                   10494
#define IDS_MAKTARGET                   10495
#define IDS_DELETING                    10496   // 9.0
#define IDS_BUILDING                    10497
#define IDS_BUILDSKIPPED                10498   // 9.0
#define IDS_BUILDDONE                   10499
#define IDS_BUILDABORTED                10500
#define IDS_BUILDFAILURE                10501
#define IDS_BUILDBROWSEFAILURE          10502   // 6.0
#define IDS_BUILDMACROERROR             10503
#define IDS_BUILDERROR                  10504
#define IDS_BUILDERRORIGNORE            10505
#define IDS_BUILDERRORMSG               10506
#define IDS_PROJGRP_WIZARD              10507   // 4.50
#define IDS_PROJGRP_EMPTY               10508   // 4.50
#define IDS_PROJTYPE_W32APP             10509
#define IDS_PROJTYPE_W32DLL             10510
#define IDS_PROJTYPE_W32LIB             10511
#define IDS_PROJTYPE_W32CON             10512
#define IDS_PROJTYPE_W64APP             10513   // 5.0
#define IDS_PROJTYPE_W64DLL             10514   // 5.0
#define IDS_PROJTYPE_W64LIB             10515   // 5.0
#define IDS_PROJTYPE_W64CON             10516   // 5.0
#define IDS_PROJTYPE_W32INST            10517   // 5.0
#define IDS_WKSHEADER                   10518   // 4.0
//
#define IDS_CC_DIAGCLASSIC              10519   // 10.0
#define IDS_CC_DIAGCARET                10520   // 10.0
#define IDS_CC_WARNLEVEL0               10521
#define IDS_CC_WARNLEVEL1               10522
#define IDS_CC_WARNLEVEL2               10523
#define IDS_CC_OPTNONE                  10524
#define IDS_CC_OPTTIME                  10525
#define IDS_CC_OPTSIZE                  10526
#define IDS_CC_DEBUGNONE                10527
#define IDS_CC_DEBUGLINES               10528
#define IDS_CC_DEBUGFULL                10529
#define IDS_CC_CDECL                    10530
#define IDS_CC_STDCALL                  10531
#define IDS_CC_FASTCALL                 10532
#define IDS_CC_VECTORCALL               10533   // 10.0
#define IDS_CC_CRT                      10534
#define IDS_CC_CRTMT                    10535
#define IDS_CC_CRTDLL                   10536
#define IDS_CC_ARCH_SSE2                10537   // 9.0
#define IDS_CC_ARCH_AVX                 10538   // 9.0
#define IDS_CC_ARCH_AVX2                10539   // 9.0
#define IDS_CC_FPFAST                   10540   // 6.0
#define IDS_CC_FPPRECISE                10541   // 6.0
#define IDS_CC_INLINENONE               10542   // 6.0
#define IDS_CC_INLINEUSER               10543   // 6.0
#define IDS_CC_INLINEAUTO               10544   // 6.0
#define IDS_CC_C99                      10545   // 7.0
#define IDS_CC_C11                      10546   // 7.0
#define IDS_CC_C17                      10547   // 9.0
#define IDS_AS_DEBUGNONE                10548
#define IDS_AS_DEBUGLINES               10549
#define IDS_AS_DEBUGFULL                10550
#define IDS_AS_CDECL                    10551   // 4.50
#define IDS_AS_STDCALL                  10552   // 4.50
#define IDS_AS_FASTCALL                 10553   // 4.50
#define IDS_LD_DEBUGNONE                10554
#define IDS_LD_DEBUGPO                  10555   // 9.0: IDS_LD_DEBUGCV -> IDS_LD_DEBUGPO
#define IDS_LD_DEBUGCOFF                10556
#define IDS_LD_DEBUGBOTH                10557
#define IDS_LD_NATIVE                   10558
#define IDS_LD_CONSOLE                  10559
#define IDS_LD_WINDOWS                  10560
//
#define IDS_DBG_DONE                    10561
#define IDS_DBG_CREATEPROCESS           10562
#define IDS_DBG_CREATETHREAD            10563
#define IDS_DBG_LOADMODULE              10564
#define IDS_DBG_EXITPROCESS             10565
#define IDS_DBG_EXITTHREAD              10566
#define IDS_DBG_UNLOADMODULE            10567
#define IDS_DBG_RELOCATION              10568
#define IDS_DBG_LOADERROR               10569
#define IDS_DBG_BORLAND                 10570   // 4.0
#define IDS_DBG_BADEXPRESSION           10571   // 4.0
//
// Commands (custom keyboard).
//
#define IDS_FILE_NEWPROJECT             10572
#define IDS_FILE_NEWSOURCE              10573
#define IDS_FILE_NEWRESOURCE            10574
#define IDS_FILE_NEWBITMAP              10575
#define IDS_FILE_NEWICON                10576
#define IDS_FILE_NEWCURSOR              10577
#define IDS_FILE_NEWANICURSOR           10578
#define IDS_FILE_NEWVIDEO               10579
#define IDS_FILE_NEWHEXDUMP             10580
#define IDS_FILE_NEWMSGTABLE            10581   // 3.0
#define IDS_FILE_NEWWEB                 10582   // 7.0
#define IDS_FILE_NEWDIFF                10583   // 7.0
#define IDS_FILE_OPEN                   10584
#define IDS_FILE_CLOSE                  10585
#define IDS_FILE_CLOSEPROJ              10586   // 5.0
#define IDS_FILE_SAVE                   10587
#define IDS_FILE_SAVEAS                 10588
#define IDS_FILE_SAVEALL                10589
#define IDS_FILE_PRINT                  10590
#define IDS_FILE_PRINTSETUP             10591
#define IDS_FILE_PROPERTIES             10592
#define IDS_FILE_EXIT                   10593
//
#define IDS_EDIT_UNDO                   10594
#define IDS_EDIT_REDO                   10595
#define IDS_EDIT_CUT                    10596
#define IDS_EDIT_COPY                   10597
#define IDS_EDIT_PASTE                  10598
#define IDS_EDIT_INSERT                 10599
#define IDS_EDIT_DELETE                 10600
#define IDS_EDIT_DELETEWORD             10601
#define IDS_EDIT_SELECTALL              10602
#define IDS_EDIT_FIND                   10603
#define IDS_EDIT_FINDNEXT               10604
#define IDS_EDIT_REPLACE                10605
#define IDS_EDIT_FILEFIND               10606
#define IDS_EDIT_GOTO                   10607
//
#define IDS_VIEW_SHOWTOOLBAR            10608
#define IDS_VIEW_SHOWSTATUSBAR          10609
#define IDS_VIEW_SHOWDOCTABS            10610
#define IDS_VIEW_SHOWWELCOME            10611   // 7.0
#define IDS_VIEW_TOGGLEFULLSCREEN       10612   // 8.0
#define IDS_VIEW_SOURCEFILES            10613   // 5.0
#define IDS_VIEW_TARGETFILES            10614   // 5.0
//
#define IDS_PROJ_ADDFILE                10615
#define IDS_PROJ_ADDPROJECT             10616   // 4.0
#define IDS_PROJ_SETTINGS               10617
#define IDS_PROJ_MODES                  10618   // 9.0
#define IDS_PROJ_COMPILE                10619
#define IDS_PROJ_BUILD                  10620
#define IDS_PROJ_REBUILD                10621   // 5.0: IDS_PROJ_BUILDALL -> IDS_PROJ_REBUILD
#define IDS_PROJ_CLEAN                  10622   // 9.0
#define IDS_PROJ_BUILDWKS               10623   // 5.0
#define IDS_PROJ_REBUILDWKS             10624   // 5.0
#define IDS_PROJ_CLEANWKS               10625   // 9.0
#define IDS_PROJ_STOPBUILD              10626
#define IDS_PROJ_MAKEALLPREQS           10627
#define IDS_PROJ_EXECUTE                10628
#define IDS_PROJ_PROFILE                10629   // 6.50
#define IDS_PROJ_ZIP                    10630
#define IDS_PROJ_UNZIP                  10631
#define IDS_PROJ_SETACTIVE              10632   // 4.0
#define IDS_PROJ_DEPENDENCIES           10633   // 4.0
//
#define IDS_TOOL_CUSTOMIZE              10634
#define IDS_TOOL_SETTINGS               10635
#define IDS_TOOL_CUSTOMTOOL             10636
#define IDS_TOOL_CUSTOMTOOL_1           10637
#define IDS_TOOL_CUSTOMTOOL_2           10638
#define IDS_TOOL_CUSTOMTOOL_3           10639
#define IDS_TOOL_CUSTOMTOOL_4           10640
#define IDS_TOOL_CUSTOMTOOL_5           10641
#define IDS_TOOL_CUSTOMTOOL_6           10642
#define IDS_TOOL_CUSTOMTOOL_7           10643
#define IDS_TOOL_CUSTOMTOOL_8           10644   // 5.0
#define IDS_TOOL_CUSTOMTOOL_9           10645   // 5.0
#define IDS_TOOL_CUSTOMTOOL_10          10646   // 5.0
#define IDS_TOOL_CUSTOMTOOL_11          10647   // 5.0
#define IDS_TOOL_CUSTOMTOOL_12          10648   // 5.0
#define IDS_TOOL_CUSTOMTOOL_13          10649   // 5.0
#define IDS_TOOL_CUSTOMTOOL_14          10650   // 5.0
#define IDS_TOOL_CUSTOMTOOL_15          10651   // 5.0
//
#define IDS_WIN_NEW                     10652
#define IDS_WIN_CASCADE                 10653
#define IDS_WIN_TILEVERT                10654
#define IDS_WIN_TILEHORZ                10655
#define IDS_WIN_CLOSEALL                10656
//
#define IDS_HELP_CONTENTS               10657
#define IDS_HELP_ABOUT                  10658
#define IDS_HELP_CUSTOMHELP             10659
#define IDS_HELP_CUSTOMHELP_1           10660
#define IDS_HELP_CUSTOMHELP_2           10661
#define IDS_HELP_CUSTOMHELP_3           10662
#define IDS_HELP_CUSTOMHELP_4           10663
#define IDS_HELP_CUSTOMHELP_5           10664
#define IDS_HELP_CUSTOMHELP_6           10665
#define IDS_HELP_CUSTOMHELP_7           10666
#define IDS_HELP_CUSTOMHELP_8           10667   // 5.0
#define IDS_HELP_CUSTOMHELP_9           10668   // 5.0
#define IDS_HELP_CUSTOMHELP_10          10669   // 5.0
#define IDS_HELP_CUSTOMHELP_11          10670   // 5.0
#define IDS_HELP_CUSTOMHELP_12          10671   // 5.0
#define IDS_HELP_CUSTOMHELP_13          10672   // 5.0
#define IDS_HELP_CUSTOMHELP_14          10673   // 5.0
#define IDS_HELP_CUSTOMHELP_15          10674   // 5.0
//
#define IDS_IMG_NEWIMAGE                10675
#define IDS_IMG_DELETEIMAGE             10676
#define IDS_IMG_RESIZE                  10677   // 5.0
#define IDS_IMG_MIRROR_HORZ             10678
#define IDS_IMG_MIRROR_VERT             10679
#define IDS_IMG_ROTATE                  10680
#define IDS_IMG_GRAYSCALE               10681
#define IDS_IMG_SEPIATONE               10682   // 4.0
#define IDS_IMG_HSV                     10683
#define IDS_IMG_OPAQUEALPHA             10684   // 4.0
#define IDS_IMG_EFFECT_OILPAINT         10685
#define IDS_IMG_EFFECT_SPREAD           10686
#define IDS_IMG_EFFECT_EMBOSS           10687
#define IDS_IMG_EFFECT_FISHEYE          10688
#define IDS_IMG_EFFECT_DROPSHADOW       10689   // 4.0
#define IDS_IMG_EFFECT_BLUR             10690
#define IDS_IMG_EFFECT_SHARPEN          10691
//
#define IDS_DLG_NEWPICTURE              10692   // 4.50
#define IDS_DLG_NEWTEXT                 10693   // 4.50
#define IDS_DLG_NEWEDITBOX              10694   // 4.50
#define IDS_DLG_NEWGROUPBOX             10695   // 4.50
#define IDS_DLG_NEWPUSHBUTTON           10696   // 4.50
#define IDS_DLG_NEWCHECKBOX             10697   // 4.50
#define IDS_DLG_NEWRADIOBUTTON          10698   // 4.50
#define IDS_DLG_NEWCOMBOBOX             10699   // 4.50
#define IDS_DLG_NEWLISTBOX              10700   // 4.50
#define IDS_DLG_NEWHSCROLLBAR           10701   // 4.50
#define IDS_DLG_NEWVSCROLLBAR           10702   // 4.50
#define IDS_DLG_NEWUPDOWN               10703   // 4.50
#define IDS_DLG_NEWPROGRESS             10704   // 4.50
#define IDS_DLG_NEWTRACKBAR             10705   // 4.50
#define IDS_DLG_NEWHOTKEY               10706   // 4.50
#define IDS_DLG_NEWLISTVIEW             10707   // 4.50
#define IDS_DLG_NEWTREEVIEW             10708   // 4.50
#define IDS_DLG_NEWTABCONTROL           10709   // 4.50
#define IDS_DLG_NEWANIMATE              10710   // 4.50
#define IDS_DLG_NEWRICHEDIT             10711   // 4.50
#define IDS_DLG_NEWRICHED20             10712   // 4.50
#define IDS_DLG_NEWDATETIME             10713   // 4.50
#define IDS_DLG_NEWMONTHCAL             10714   // 4.50
#define IDS_DLG_NEWCOMBOBOXEX           10715   // 4.50
#define IDS_DLG_NEWREBAR                10716   // 4.50
#define IDS_DLG_NEWPAGER                10717   // 4.50
#define IDS_DLG_NEWTOOLBAR              10718   // 4.50
#define IDS_DLG_NEWSTATUSBAR            10719   // 4.50
#define IDS_DLG_NEWSYSLINK              10720   // 5.0
#define IDS_DLG_NEWIPADDRESS            10721   // 5.0
#define IDS_DLG_NEWNETADDRESS           10722   // 5.0
#define IDS_DLG_NEWSPLITBUTTON          10723   // 5.0
#define IDS_DLG_NEWCOMMANDLINK          10724   // 5.0
#define IDS_DLG_NEWNATIVEFONT           10725   // 5.0
#define IDS_DLG_ALIGNLEFT               10726
#define IDS_DLG_ALIGNVERT               10727
#define IDS_DLG_ALIGNRIGHT              10728
#define IDS_DLG_ALIGNTOP                10729
#define IDS_DLG_ALIGNHORZ               10730
#define IDS_DLG_ALIGNBOTTOM             10731
#define IDS_DLG_CENTERVERT              10732
#define IDS_DLG_CENTERHORZ              10733
#define IDS_DLG_SPACEVERT               10734
#define IDS_DLG_SPACEHORZ               10735
#define IDS_DLG_ARRSIZEWIDTH            10736
#define IDS_DLG_ARRSIZEHEIGHT           10737
#define IDS_DLG_ARRSIZEBOTH             10738
#define IDS_DLG_ARRPUSHBOTTOM           10739
#define IDS_DLG_ARRPUSHRIGHT            10740
#define IDS_DLG_SIZETOTEXT              10741
#define IDS_DLG_NEWCUSTOM               10742
#define IDS_DLG_OPENCUSTOM              10743
#define IDS_DLG_REMOVECUSTOM            10744
#define IDS_DLG_LOCKCONTROLS            10745
#define IDS_DLG_ORDERCONTROLS           10746
//
#define IDS_RSRC_NEWBITMAP              10747
#define IDS_RSRC_NEWICON                10748
#define IDS_RSRC_NEWCURSOR              10749
#define IDS_RSRC_NEWANICURSOR           10750
#define IDS_RSRC_NEWVIDEO               10751
#define IDS_RSRC_NEWDIALOG              10752
#define IDS_RSRC_NEWMENU                10753
#define IDS_RSRC_NEWSTRINGTABLE         10754
#define IDS_RSRC_NEWMSGTABLE            10755   // 3.0
#define IDS_RSRC_NEWACCEL               10756
#define IDS_RSRC_NEWVERSION             10757
#define IDS_RSRC_NEWMANIFEST            10758
#define IDS_RSRC_NEWHTML                10759   // 5.0
#define IDS_RSRC_NEWCUSTOM              10760   // 3.0
#define IDS_RSRC_NEWCOPY                10761
#define IDS_RSRC_IMPORT                 10762
#define IDS_RSRC_EXPORT                 10763   // 6.0
#define IDS_RSRC_SORTNAMES              10764
#define IDS_RSRC_LABELS                 10765   // 6.50: IDS_VIEW_LABELS -> IDS_RSRC_LABELS
#define IDS_RSRC_INCLUDES               10766   // 6.50: IDS_VIEW_INCLUDES -> IDS_RSRC_INCLUDES
//
#define IDS_MESS_SETINCLUDE             10767   // 3.0
#define IDS_MESS_VIEWLABELS             10768   // 3.0
//
#define IDS_SRC_FORCECALLTIP            10769   // 4.50
#define IDS_SRC_COMPLETEWORD            10770
#define IDS_SRC_INSERTSNIPPET           10771   // 5.0
#define IDS_SRC_SURROUNDBY              10772   // 5.0
#define IDS_SRC_SURROUNDBY_1            10773   // 5.0
#define IDS_SRC_SURROUNDBY_2            10774   // 5.0
#define IDS_SRC_SURROUNDBY_3            10775   // 5.0
#define IDS_SRC_SURROUNDBY_4            10776   // 5.0
#define IDS_SRC_SURROUNDBY_5            10777   // 5.0
#define IDS_SRC_SURROUNDBY_6            10778   // 5.0
#define IDS_SRC_SURROUNDBY_7            10779   // 5.0
#define IDS_SRC_SURROUNDBY_8            10780   // 5.0
#define IDS_SRC_SURROUNDBY_9            10781   // 5.0
#define IDS_SRC_SURROUNDBY_10           10782   // 5.0
#define IDS_SRC_SURROUNDBY_11           10783   // 5.0
#define IDS_SRC_SURROUNDBY_12           10784   // 5.0
#define IDS_SRC_SURROUNDBY_13           10785   // 5.0
#define IDS_SRC_SURROUNDBY_14           10786   // 5.0
#define IDS_SRC_SURROUNDBY_15           10787   // 5.0
#define IDS_SRC_UCASE                   10788
#define IDS_SRC_LCASE                   10789
#define IDS_SRC_TABTOSPACE              10790
#define IDS_SRC_SPACETOTAB              10791
#define IDS_SRC_FORMAT                  10792   // 3.0
#define IDS_SRC_COMMENT                 10793   // 4.0
#define IDS_SRC_UNCOMMENT               10794   // 4.0
#define IDS_SRC_NEXTBOOKMARK            10795
#define IDS_SRC_PREVBOOKMARK            10796
#define IDS_SRC_SETBOOKMARK             10797
#define IDS_SRC_CLEARBOOKMARKS          10798
#define IDS_SRC_WHITESPACE              10799
#define IDS_SRC_LINEBREAKS              10800
#define IDS_SRC_LINENUMBERS             10801
#define IDS_SRC_FOLDINGS                10802
#define IDS_SRC_MATCHINGBRACES          10803   // 4.50
#define IDS_SRC_VIEWDEFINITION          10804   // 6.0
#define IDS_SRC_PREVDEFINITION          10805   // 6.0
#define IDS_SRC_FOLDALL                 10806
#define IDS_SRC_UNFOLDALL               10807
//
#define IDS_DBG_GO                      10808
#define IDS_DBG_RESTART                 10809
#define IDS_DBG_STOP                    10810
#define IDS_DBG_BREAK                   10811
#define IDS_DBG_STEPINTO                10812
#define IDS_DBG_STEPOVER                10813
#define IDS_DBG_STEPOUT                 10814   // 4.0
#define IDS_DBG_RUNTOCURSOR             10815   // 4.0
#define IDS_DBG_TOGGLEBREAKPOINT        10816   // 4.0
#define IDS_DBG_SHOWNEXTSTMT            10817
#define IDS_DBG_ADDWATCH                10818
#define IDS_DBG_QUICKWATCH              10819   // 4.0
#define IDS_DBG_HWBREAKS                10820   // 4.0 B4
//
#define IDS_WEB_BACK                    10821   // 7.0
#define IDS_WEB_FORWARD                 10822   // 7.0
#define IDS_WEB_HOME                    10823   // 8.0
#define IDS_WEB_REFRESH                 10824   // 7.0
#define IDS_WEB_CERTIFICATE             10825   // 7.0
#define IDS_WEB_SHOWSOURCE              10826   // 7.0
//
#define IDS_DIFF_PREVCHANGE             10827   // 7.0
#define IDS_DIFF_NEXTCHANGE             10828   // 7.0
#define IDS_DIFF_REFRESH                10829   // 7.0
#define IDS_DIFF_OPENLEFT               10830   // 7.0
#define IDS_DIFF_OPENRIGHT              10831   // 7.0
#define IDS_DIFF_OPENCOMPOSITE          10832   // 9.0
//
#define IDS_MISC_OPEN                   10833
#define IDS_MISC_TEST                   10834
#define IDS_MISC_CHECKMNEMONICS         10835
#define IDS_MISC_NEXTWINDOW             10836
//
// Tooltips.
//
#define IDS_TIP_NEW                     10837
#define IDS_TIP_OPEN                    10838
#define IDS_TIP_SAVE                    10839
#define IDS_TIP_SAVEALL                 10840
#define IDS_TIP_CUT                     10841
#define IDS_TIP_COPY                    10842
#define IDS_TIP_PASTE                   10843
#define IDS_TIP_UNDO                    10844
#define IDS_TIP_REDO                    10845
#define IDS_TIP_COMPILE                 10846
#define IDS_TIP_BUILD                   10847
#define IDS_TIP_SETTINGS                10848   // 8.0
#define IDS_TIP_MAKEALLPREQS            10849   // 11.0
#define IDS_TIP_EXECUTE                 10850
#define IDS_TIP_GO                      10851
#define IDS_TIP_RESTART                 10852
#define IDS_TIP_STOPDEBUG               10853   // 7.0: IDS_TIP_STOP -> IDS_TIP_STOPDEBUG
#define IDS_TIP_STEPINTO                10854
#define IDS_TIP_STEPOVER                10855
#define IDS_TIP_STEPOUT                 10856   // 4.0
#define IDS_TIP_QUICKWATCH              10857   // 4.0
#define IDS_TIP_DELETE                  10858
#define IDS_TIP_CHECKMNEMONICS          10859
//
#define IDS_TIP_PENCIL                  10860
#define IDS_TIP_BRUSH                   10861
#define IDS_TIP_SELECT                  10862
#define IDS_TIP_PICKCOLOR               10863
#define IDS_TIP_LINE                    10864
#define IDS_TIP_RECT                    10865
#define IDS_TIP_ELLIPSE                 10866   // 4.0 (renamed)
#define IDS_TIP_ROUNDRECT               10867
#define IDS_TIP_DRAWTEXT                10868
#define IDS_TIP_FLOODFILL               10869
#define IDS_TIP_SPRAY                   10870
#define IDS_TIP_ERASER                  10871
#define IDS_TIP_MAGNIFY                 10872
#define IDS_TIP_HOTSPOT                 10873
#define IDS_TIP_GRADIENT                10874   // 5.0
#define IDS_TIP_LEFTCOLOR               10875
#define IDS_TIP_RIGHTCOLOR              10876
#define IDS_TIP_SCREENCOLOR             10877
#define IDS_TIP_INVERSECOLOR            10878
#define IDS_TIP_TRANSPARENTCOLOR        10879   // 5.0
#define IDS_TIP_PALETTE                 10880   // 4.0
#define IDS_TIP_LOADPALETTE             10881   // 4.0
#define IDS_TIP_SAVEPALETTE             10882   // 4.0
#define IDS_TIP_RGBCOLOR                10883   // 4.0 (renamed)
#define IDS_TIP_RGBACOLOR               10884   // 4.0
//
#define IDS_TIP_POINTER                 10885
#define IDS_TIP_PICTURE                 10886
#define IDS_TIP_TEXT                    10887
#define IDS_TIP_EDITBOX                 10888
#define IDS_TIP_GROUPBOX                10889
#define IDS_TIP_PUSHBUTTON              10890
#define IDS_TIP_CHECKBOX                10891
#define IDS_TIP_RADIOBUTTON             10892
#define IDS_TIP_COMBOBOX                10893
#define IDS_TIP_LISTBOX                 10894
#define IDS_TIP_HSCROLLBAR              10895
#define IDS_TIP_VSCROLLBAR              10896
#define IDS_TIP_UPDOWN                  10897
#define IDS_TIP_PROGRESS                10898
#define IDS_TIP_TRACKBAR                10899
#define IDS_TIP_HOTKEY                  10900
#define IDS_TIP_LISTVIEW                10901
#define IDS_TIP_TREEVIEW                10902
#define IDS_TIP_TABCONTROL              10903
#define IDS_TIP_ANIMATE                 10904
#define IDS_TIP_RICHEDIT                10905
#define IDS_TIP_RICHED20                10906   // 4.50
#define IDS_TIP_DATETIME                10907
#define IDS_TIP_MONTHCAL                10908
#define IDS_TIP_COMBOBOXEX              10909
#define IDS_TIP_REBAR                   10910
#define IDS_TIP_PAGER                   10911
#define IDS_TIP_TOOLBAR                 10912
#define IDS_TIP_STATUSBAR               10913
#define IDS_TIP_SYSLINK                 10914   // 5.0
#define IDS_TIP_IPADDRESS               10915   // 5.0
#define IDS_TIP_NETADDRESS              10916   // 5.0
#define IDS_TIP_SPLITBUTTON             10917   // 5.0
#define IDS_TIP_COMMANDLINK             10918   // 5.0
#define IDS_TIP_NATIVEFONT              10919   // 5.0
#define IDS_TIP_CUSTOM                  10920
//
#define IDS_TIP_TEST                    10921
#define IDS_TIP_LOCKCONTROLS            10922
#define IDS_TIP_ORDERCONTROLS           10923
#define IDS_TIP_ARRPUSHBOTTOM           10924
#define IDS_TIP_ARRPUSHRIGHT            10925
#define IDS_TIP_ALIGNLEFT               10926
#define IDS_TIP_ALIGNRIGHT              10927
#define IDS_TIP_ALIGNTOP                10928
#define IDS_TIP_ALIGNBOTTOM             10929
#define IDS_TIP_ALIGNHORZ               10930
#define IDS_TIP_ALIGNVERT               10931
#define IDS_TIP_SPACEHORZ               10932
#define IDS_TIP_SPACEVERT               10933
#define IDS_TIP_ARRSIZEWIDTH            10934
#define IDS_TIP_ARRSIZEHEIGHT           10935
#define IDS_TIP_ARRSIZEBOTH             10936
#define IDS_TIP_CENTERHORZ              10937
#define IDS_TIP_CENTERVERT              10938
//
#define IDS_TIP_NEWFOLDER               10939
#define IDS_TIP_NEWFILE                 10940
#define IDS_TIP_NEWTOOL                 10941
#define IDS_TIP_NEWHELP                 10942
#define IDS_TIP_NEWSNIPPET              10943   // 5.0
#define IDS_TIP_IMPORT                  10944   // 5.0
#define IDS_TIP_EXPORT                  10945   // 5.0
#define IDS_TIP_MOVEUP                  10946
#define IDS_TIP_MOVEDOWN                10947
#define IDS_TIP_DEFAULTS                10948   // 10.0
//
#define IDS_TIP_NEWIMAGE                10949
#define IDS_TIP_DELETEIMAGE             10950
//
#define IDS_TIP_NEWMACRO                10951   // 6.50
#define IDS_TIP_EDITMACRO               10952   // 6.50
//
#define IDS_TIP_SOURCEFILES             10953
#define IDS_TIP_TARGETFILES             10954
#define IDS_TIP_CLOSE                   10955
//
#define IDS_TIP_BACK                    10956   // 7.0
#define IDS_TIP_FORWARD                 10957   // 7.0
#define IDS_TIP_HOME                    10958   // 8.0
#define IDS_TIP_REFRESH                 10959   // 7.0
#define IDS_TIP_CERTIFICATE             10960   // 7.0
//
#define IDS_TIP_PREVCHANGE              10961   // 7.0
#define IDS_TIP_NEXTCHANGE              10962   // 7.0
#define IDS_TIP_STOP                    10963   // 7.0
#define IDS_TIP_EXPAND                  10964   // 8.0
#define IDS_TIP_OUTLINE                 10965   // 8.0
//
// Color descriptions.
//
#define IDS_COLOR_TEXT                  10966
#define IDS_COLOR_ATTRIBUTE             10967   // 11.0
#define IDS_COLOR_KEYWORD               10968
#define IDS_COLOR_COMMENT               10969
#define IDS_COLOR_NUMBER                10970
#define IDS_COLOR_STRING                10971
#define IDS_COLOR_PREPROC               10972
#define IDS_COLOR_FUNCTION              10973
#define IDS_COLOR_OPERATOR              10974
#define IDS_COLOR_SELTEXT               10975
#define IDS_COLOR_BREAKPOINT            10976
#define IDS_COLOR_DEBUGLINE             10977
#define IDS_COLOR_DEBUGASM              10978   // 10.0
#define IDS_COLOR_PROFLINE              10979   // 6.50
#define IDS_COLOR_DIFFBLOB              10980   // 7.0
#define IDS_COLOR_DIFFLEFT              10981   // 7.0
#define IDS_COLOR_DIFFRIGHT             10982   // 7.0
#define IDS_COLORTABLE                  10983
//
// Encoding descriptions.
//
#define IDS_ENCODING_ANSI               10984   // 5.0 (#1)
#define IDS_ENCODING_OEM                10985   // 5.0 (#2)
#define IDS_ENCODING_UTF8               10986   // 5.0 (#3)
#define IDS_ENCODING_UTF8_NO_BOM        10987   // 5.0 (#4)
#define IDS_ENCODING_UTF16_LE           10988   // 5.0 (#5)
#define IDS_ENCODING_UTF16_BE           10989   // 5.0 (#6)
#define IDS_ENCODING_UTF32_LE           10990   // 5.0 (#7)
#define IDS_ENCODING_UTF32_BE           10991   // 5.0 (#8)
//
// Startup descriptions.
//
#define IDS_STARTUP_WELCOME             10992   // 7.0
#define IDS_STARTUP_PROJECT             10993   // 7.0
#define IDS_STARTUP_HOMEPAGE            10994   // 7.0
#define IDS_STARTUP_EMPTY               10995   // 7.0
//
#define IDS_DESC_GENERAL                10996
#define IDS_DESC_MYSTYLES               10997
#define IDS_DESC_STYLES                 10998
#define IDS_DESC_EXSTYLES               10999
#define IDS_DESC_RESIZER                11000   // 6.0
#define IDS_DESC_NAME                   11001
#define IDS_DESC_TEXT                   11002
#define IDS_DESC_ORDER                  11003
#define IDS_DESC_HELP                   11004   // 5.0
#define IDS_DESC_LEFT                   11005
#define IDS_DESC_TOP                    11006
#define IDS_DESC_WIDTH                  11007
#define IDS_DESC_HEIGHT                 11008
#define IDS_DESC_VERTRESIZER            11009   // 6.0
#define IDS_DESC_HORZRESIZER            11010   // 6.0
#define IDS_DESC_FONTNAME               11011
#define IDS_DESC_FONTSIZE               11012
#define IDS_DESC_FONTWEIGHT             11013
#define IDS_DESC_FONTCHARSET            11014
#define IDS_DESC_FONTITALIC             11015
#define IDS_DESC_CLASSNAME              11016
#define IDS_DESC_MENUNAME               11017
#define IDS_DESC_STYLE                  11018
#define IDS_DESC_ALIGNMENT              11019
#define IDS_DESC_TYPE                   11020
#define IDS_DESC_OWNERDRAW              11021
#define IDS_DESC_SELECTION              11022
#define IDS_DESC_POINT                  11023
#define IDS_DESC_VIEW                   11024
#define IDS_DESC_SORT                   11025
#define IDS_DESC_FOCUS                  11026
#define IDS_DESC_FORMAT                 11027
#define IDS_DESC_IMAGE                  11028
#define IDS_DESC_ELLIPSIS               11029
#define IDS_DESC_VERTALIGNMENT          11030
#define IDS_DESC_WS_OVERLAPPED          11031
#define IDS_DESC_WS_POPUP               11032
#define IDS_DESC_WS_CHILD               11033
#define IDS_DESC_WS_CAPTION             11034
#define IDS_DESC_WS_SYSMENU             11035
#define IDS_DESC_WS_VISIBLE             11036
#define IDS_DESC_WS_DISABLED            11037
#define IDS_DESC_WS_BORDER              11038
#define IDS_DESC_WS_GROUP               11039
#define IDS_DESC_WS_TABSTOP             11040
#define IDS_DESC_WS_HSCROLL             11041
#define IDS_DESC_WS_VSCROLL             11042
#define IDS_DESC_WS_MINIMIZEBOX         11043
#define IDS_DESC_WS_MAXIMIZEBOX         11044
#define IDS_DESC_WS_CLIPSIBLINGS        11045
#define IDS_DESC_WS_CLIPCHILDREN        11046
#define IDS_DESC_WS_THICKFRAME          11047
#define IDS_DESC_DS_MODALFRAME          11048
#define IDS_DESC_DS_SYSMODAL            11049
#define IDS_DESC_DS_ABSALIGN            11050
#define IDS_DESC_DS_CONTEXTHELP         11051
#define IDS_DESC_DS_SETFOREGROUND       11052
#define IDS_DESC_DS_3DLOOK              11053
#define IDS_DESC_DS_NOFAILCREATE        11054
#define IDS_DESC_DS_NOIDLEMSG           11055
#define IDS_DESC_DS_CONTROL             11056
#define IDS_DESC_DS_CENTER              11057
#define IDS_DESC_DS_CENTERMOUSE         11058
#define IDS_DESC_DS_LOCALEDIT           11059
#define IDS_DESC_SS_BITMAP              11060
#define IDS_DESC_SS_ICON                11061
#define IDS_DESC_SS_ENHMETAFILE         11062
#define IDS_DESC_SS_BLACKRECT           11063
#define IDS_DESC_SS_GRAYRECT            11064
#define IDS_DESC_SS_WHITERECT           11065
#define IDS_DESC_SS_BLACKFRAME          11066
#define IDS_DESC_SS_GRAYFRAME           11067
#define IDS_DESC_SS_WHITEFRAME          11068
#define IDS_DESC_SS_ETCHEDHORZ          11069
#define IDS_DESC_SS_ETCHEDVERT          11070
#define IDS_DESC_SS_ETCHEDFRAME         11071
#define IDS_DESC_SS_CENTERIMAGE         11072
#define IDS_DESC_SS_REALSIZEIMAGE       11073
#define IDS_DESC_SS_REALSIZECONTROL     11074   // 4.0
#define IDS_DESC_SS_SUNKEN              11075
#define IDS_DESC_SS_LEFT                11076
#define IDS_DESC_SS_CENTER              11077
#define IDS_DESC_SS_RIGHT               11078
#define IDS_DESC_SS_SIMPLE              11079
#define IDS_DESC_SS_LEFTNOWORDWRAP      11080
#define IDS_DESC_SS_OWNERDRAW           11081
#define IDS_DESC_SS_NOPREFIX            11082
#define IDS_DESC_SS_NOTIFY              11083
#define IDS_DESC_SS_RIGHTJUST           11084
#define IDS_DESC_SS_NOELLIPSIS          11085
#define IDS_DESC_SS_ENDELLIPSIS         11086
#define IDS_DESC_SS_PATHELLIPSIS        11087
#define IDS_DESC_SS_WORDELLIPSIS        11088
#define IDS_DESC_ES_LEFT                11089
#define IDS_DESC_ES_CENTER              11090
#define IDS_DESC_ES_RIGHT               11091
#define IDS_DESC_ES_MULTILINE           11092
#define IDS_DESC_ES_NUMBER              11093
#define IDS_DESC_ES_AUTOHSCROLL         11094
#define IDS_DESC_ES_AUTOVSCROLL         11095
#define IDS_DESC_ES_PASSWORD            11096
#define IDS_DESC_ES_NOHIDESEL           11097
#define IDS_DESC_ES_OEMCONVERT          11098
#define IDS_DESC_ES_WANTRETURN          11099
#define IDS_DESC_ES_UPPERCASE           11100
#define IDS_DESC_ES_LOWERCASE           11101
#define IDS_DESC_ES_READONLY            11102
#define IDS_DESC_ES_DISABLENOSCROLL     11103
#define IDS_DESC_BS_TEXT                11104
#define IDS_DESC_BS_ICON                11105
#define IDS_DESC_BS_BITMAP              11106
#define IDS_DESC_BS_NOTIFY              11107
#define IDS_DESC_BS_FLAT                11108
#define IDS_DESC_BS_PUSHBUTTON          11109
#define IDS_DESC_BS_DEFPUSHBUTTON       11110
#define IDS_DESC_BS_PUSHBOX             11111   // 5.0
#define IDS_DESC_BS_OWNERDRAW           11112
#define IDS_DESC_BS_MULTILINE           11113
#define IDS_DESC_BS_CHECKBOX            11114
#define IDS_DESC_BS_AUTOCHECKBOX        11115
#define IDS_DESC_BS_3STATE              11116
#define IDS_DESC_BS_AUTO3STATE          11117
#define IDS_DESC_BS_LEFTTEXT            11118
#define IDS_DESC_BS_PUSHLIKE            11119
#define IDS_DESC_BS_RADIOBUTTON         11120
#define IDS_DESC_BS_AUTORADIOBUTTON     11121
#define IDS_DESC_BS_LEFT                11122
#define IDS_DESC_BS_CENTER              11123
#define IDS_DESC_BS_RIGHT               11124
#define IDS_DESC_BS_TOP                 11125
#define IDS_DESC_BS_VCENTER             11126
#define IDS_DESC_BS_BOTTOM              11127
#define IDS_DESC_BS_NOALIGN             11128
#define IDS_DESC_BS_SPLITBUTTON         11129   // 5.0
#define IDS_DESC_BS_DEFSPLITBUTTON      11130   // 5.0
#define IDS_DESC_BS_COMMANDLINK         11131   // 5.0
#define IDS_DESC_BS_DEFCOMMANDLINK      11132   // 5.0
#define IDS_DESC_CBS_SIMPLE             11133
#define IDS_DESC_CBS_DROPDOWN           11134
#define IDS_DESC_CBS_DROPDOWNLIST       11135
#define IDS_DESC_OD_NO                  11136
#define IDS_DESC_OD_FIXED               11137
#define IDS_DESC_OD_VARIABLE            11138
#define IDS_DESC_CBS_AUTOHSCROLL        11139
#define IDS_DESC_CBS_OEMCONVERT         11140
#define IDS_DESC_CBS_SORT               11141
#define IDS_DESC_CBS_HASSTRINGS         11142
#define IDS_DESC_CBS_NOINTEGRALHEIGHT   11143
#define IDS_DESC_CBS_DISABLENOSCROLL    11144
#define IDS_DESC_CBS_UPPERCASE          11145
#define IDS_DESC_CBS_LOWERCASE          11146
#define IDS_DESC_LBS_SINGLESEL          11147
#define IDS_DESC_LBS_MULTIPLESEL        11148
#define IDS_DESC_LBS_EXTENDEDSEL        11149
#define IDS_DESC_LBS_NOSEL              11150
#define IDS_DESC_LBS_SORT               11151
#define IDS_DESC_LBS_HASSTRINGS         11152
#define IDS_DESC_LBS_NOINTEGRALHEIGHT   11153
#define IDS_DESC_LBS_DISABLENOSCROLL    11154
#define IDS_DESC_LBS_NOTIFY             11155
#define IDS_DESC_LBS_MULTICOLUMN        11156
#define IDS_DESC_LBS_NOREDRAW           11157
#define IDS_DESC_LBS_USETABSTOPS        11158
#define IDS_DESC_LBS_WANTKEYBOARDINPUT  11159
#define IDS_DESC_LBS_NODATA             11160
#define IDS_DESC_UDS_UNATTACHED         11161
#define IDS_DESC_UDS_ALIGNLEFT          11162
#define IDS_DESC_UDS_ALIGNRIGHT         11163
#define IDS_DESC_UDS_HORZ               11164
#define IDS_DESC_UDS_AUTOBUDDY          11165
#define IDS_DESC_UDS_SETBUDDYINT        11166
#define IDS_DESC_UDS_NOTHOUSANDS        11167
#define IDS_DESC_UDS_WRAP               11168
#define IDS_DESC_UDS_ARROWKEYS          11169
#define IDS_DESC_UDS_HOTTRACK           11170
#define IDS_DESC_PBS_VERTICAL           11171
#define IDS_DESC_PBS_SMOOTH             11172
#define IDS_DESC_PBS_MARQUEE            11173   // 4.0
#define IDS_DESC_TBS_BOTH               11174
#define IDS_DESC_TBS_LEFT               11175
#define IDS_DESC_TBS_RIGHT              11176
#define IDS_DESC_TBS_VERT               11177
#define IDS_DESC_TBS_NOTICKS            11178
#define IDS_DESC_TBS_AUTOTICKS          11179
#define IDS_DESC_TBS_ENABLESELRANGE     11180
#define IDS_DESC_TBS_FIXEDLENGTH        11181
#define IDS_DESC_TBS_NOTHUMB            11182
#define IDS_DESC_TBS_TOOLTIPS           11183
#define IDS_DESC_LVS_ICON               11184
#define IDS_DESC_LVS_SMALLICON          11185
#define IDS_DESC_LVS_LIST               11186
#define IDS_DESC_LVS_REPORT             11187
#define IDS_DESC_LVS_ALIGNTOP           11188
#define IDS_DESC_LVS_ALIGNLEFT          11189
#define IDS_DESC_LVS_NOSORT             11190
#define IDS_DESC_LVS_SORTASCENDING      11191
#define IDS_DESC_LVS_SORTDESCENDING     11192
#define IDS_DESC_LVS_SINGLESEL          11193
#define IDS_DESC_LVS_SHOWSELALWAYS      11194
#define IDS_DESC_LVS_AUTOARRANGE        11195
#define IDS_DESC_LVS_NOLABELWRAP        11196
#define IDS_DESC_LVS_EDITLABELS         11197
#define IDS_DESC_LVS_NOSCROLL           11198
#define IDS_DESC_LVS_NOCOLUMNHEADER     11199
#define IDS_DESC_LVS_NOSORTHEADER       11200
#define IDS_DESC_LVS_SHAREIMAGELISTS    11201
#define IDS_DESC_LVS_OWNERDRAWFIXED     11202
#define IDS_DESC_LVS_OWNERDATA          11203
#define IDS_DESC_TVS_HASBUTTONS         11204
#define IDS_DESC_TVS_HASLINES           11205
#define IDS_DESC_TVS_LINESATROOT        11206
#define IDS_DESC_TVS_EDITLABELS         11207
#define IDS_DESC_TVS_DISABLEDRAGDROP    11208
#define IDS_DESC_TVS_SHOWSELALWAYS      11209
#define IDS_DESC_TVS_NOTOOLTIPS         11210
#define IDS_DESC_TVS_CHECKBOXES         11211
#define IDS_DESC_TVS_TRACKSELECT        11212
#define IDS_DESC_TVS_SINGLEEXPAND       11213
#define IDS_DESC_TVS_INFOTIP            11214
#define IDS_DESC_TVS_FULLROWSELECT      11215
#define IDS_DESC_TVS_NOSCROLL           11216
#define IDS_DESC_TVS_NONEVENHEIGHT      11217
#define IDS_DESC_TCS_RIGHTJUSTIFY       11218
#define IDS_DESC_TCS_FIXEDWIDTH         11219
#define IDS_DESC_TCS_RAGGEDRIGHT        11220
#define IDS_DESC_TCS_FOCUSDEFAULT       11221
#define IDS_DESC_TCS_FOCUSONBUTTONDOWN  11222
#define IDS_DESC_TCS_FOCUSNEVER         11223
#define IDS_DESC_TCS_BUTTONS            11224
#define IDS_DESC_TCS_FLATBUTTONS        11225
#define IDS_DESC_TCS_TOOLTIPS           11226
#define IDS_DESC_TCS_MULTILINE          11227
#define IDS_DESC_TCS_OWNERDRAWFIXED     11228
#define IDS_DESC_TCS_FORCELABELLEFT     11229
#define IDS_DESC_TCS_FORCEICONLEFT      11230
#define IDS_DESC_TCS_HOTTRACK           11231
#define IDS_DESC_TCS_BOTTOM             11232
#define IDS_DESC_TCS_MULTISELECT        11233
#define IDS_DESC_TCS_SCROLLOPPOSITE     11234
#define IDS_DESC_TCS_VERTICAL           11235
#define IDS_DESC_ACS_CENTER             11236
#define IDS_DESC_ACS_TRANSPARENT        11237
#define IDS_DESC_ACS_AUTOPLAY           11238
#define IDS_DESC_ACS_TIMER              11239
#define IDS_DESC_DTS_SHORTDATEFORMAT    11240
#define IDS_DESC_DTS_LONGDATEFORMAT     11241
#define IDS_DESC_DTS_TIMEFORMAT         11242
#define IDS_DESC_DTS_RIGHTALIGN         11243
#define IDS_DESC_DTS_UPDOWN             11244
#define IDS_DESC_DTS_SHOWNONE           11245
#define IDS_DESC_MCS_DAYSTATE           11246
#define IDS_DESC_MCS_MULTISELECT        11247
#define IDS_DESC_MCS_WEEKNUMBERS        11248
#define IDS_DESC_MCS_NOTODAYCIRCLE      11249
#define IDS_DESC_MCS_NOTODAY            11250
#define IDS_DESC_CCS_NORESIZE           11251
#define IDS_DESC_CCS_TOP                11252
#define IDS_DESC_CCS_BOTTOM             11253
#define IDS_DESC_CCS_LEFT               11254
#define IDS_DESC_CCS_RIGHT              11255
#define IDS_DESC_CCS_NODIVIDER          11256
#define IDS_DESC_CCS_ADJUSTABLE         11257
#define IDS_DESC_RBS_VARHEIGHT          11258
#define IDS_DESC_RBS_BANDBORDERS        11259
#define IDS_DESC_RBS_FIXEDORDER         11260
#define IDS_DESC_RBS_REGISTERDROP       11261
#define IDS_DESC_RBS_AUTOSIZE           11262
#define IDS_DESC_RBS_VERTICALGRIPPER    11263
#define IDS_DESC_RBS_DBLCLKTOGGLE       11264
#define IDS_DESC_PGS_HORZ               11265
#define IDS_DESC_PGS_AUTOSCROLL         11266
#define IDS_DESC_PGS_DRAGNDROP          11267
#define IDS_DESC_TBSTYLE_FLAT           11268
#define IDS_DESC_TBSTYLE_LIST           11269
#define IDS_DESC_TBSTYLE_WRAPABLE       11270
#define IDS_DESC_TBSTYLE_TRANSPARENT    11271
#define IDS_DESC_TBSTYLE_TOOLTIPS       11272
#define IDS_DESC_TBSTYLE_ALTDRAG        11273
#define IDS_DESC_TBSTYLE_CUSTOMERASE    11274
#define IDS_DESC_TBSTYLE_REGISTERDROP   11275
#define IDS_DESC_SBARS_SIZEGRIP         11276
#define IDS_DESC_LWS_TRANSPARENT        11277   // 5.0
#define IDS_DESC_LWS_IGNORERETURN       11278   // 5.0
#define IDS_DESC_LWS_NOPREFIX           11279   // 5.0
#define IDS_DESC_LWS_USEVISUALSTYLE     11280   // 5.0
#define IDS_DESC_LWS_USECUSTOMTEXT      11281   // 5.0
#define IDS_DESC_LWS_RIGHT              11282   // 5.0
#define IDS_DESC_NFS_EDIT               11283   // 5.0
#define IDS_DESC_NFS_STATIC             11284   // 5.0
#define IDS_DESC_NFS_LISTCOMBO          11285   // 5.0
#define IDS_DESC_NFS_BUTTON             11286   // 5.0
#define IDS_DESC_NFS_ALL                11287   // 5.0
#define IDS_DESC_NFS_USEFONTASSOC       11288   // 5.0
#define IDS_DESC_WS_EX_CLIENTEDGE       11289
#define IDS_DESC_WS_EX_STATICEDGE       11290
#define IDS_DESC_WS_EX_TRANSPARENT      11291
#define IDS_DESC_WS_EX_ACCEPTFILES      11292
#define IDS_DESC_WS_EX_RIGHT            11293
#define IDS_DESC_WS_EX_LEFTSCROLLBAR    11294
#define IDS_DESC_WS_EX_TOOLWINDOW       11295
#define IDS_DESC_WS_EX_CONTROLPARENT    11296
#define IDS_DESC_WS_EX_CONTEXTHELP      11297
#define IDS_DESC_WS_EX_NOPARENTNOTIFY   11298
#define IDS_DESC_WS_EX_APPWINDOW        11299   // 4.0
#define IDS_DESC_WS_EX_TOPMOST          11300   // 4.0
#define IDS_DESC_WS_EX_NOACTIVATE       11301   // 4.0
#define IDS_HELP_NAME                   11302
#define IDS_HELP_TEXT                   11303
#define IDS_HELP_ORDER                  11304
#define IDS_HELP_HELP                   11305   // 5.0
#define IDS_HELP_LEFT                   11306
#define IDS_HELP_TOP                    11307
#define IDS_HELP_WIDTH                  11308
#define IDS_HELP_HEIGHT                 11309
#define IDS_HELP_VERTRESIZER            11310   // 6.0
#define IDS_HELP_HORZRESIZER            11311   // 6.0
#define IDS_HELP_FONTNAME               11312
#define IDS_HELP_FONTSIZE               11313
#define IDS_HELP_FONTWEIGHT             11314
#define IDS_HELP_FONTCHARSET            11315
#define IDS_HELP_FONTITALIC             11316
#define IDS_HELP_CLASSNAME              11317
#define IDS_HELP_MENUNAME               11318
#define IDS_HELP_STYLES                 11319   // 4.0
#define IDS_HELP_EXSTYLES               11320   // 4.0
#define IDS_HELP_STYLE                  11321
#define IDS_HELP_ALIGNMENT              11322
#define IDS_HELP_TYPE                   11323
#define IDS_HELP_OWNERDRAW              11324
#define IDS_HELP_SELECTION              11325
#define IDS_HELP_POINT                  11326
#define IDS_HELP_VIEW                   11327
#define IDS_HELP_SORT                   11328
#define IDS_HELP_FOCUS                  11329
#define IDS_HELP_FORMAT                 11330
#define IDS_HELP_IMAGE                  11331
#define IDS_HELP_ELLIPSIS               11332
#define IDS_HELP_VERTALIGNMENT          11333
#define IDS_HELP_WS_CAPTION             11334
#define IDS_HELP_WS_SYSMENU             11335
#define IDS_HELP_WS_VISIBLE             11336
#define IDS_HELP_WS_DISABLED            11337
#define IDS_HELP_WS_BORDER              11338
#define IDS_HELP_WS_GROUP               11339
#define IDS_HELP_WS_TABSTOP             11340
#define IDS_HELP_WS_HSCROLL             11341
#define IDS_HELP_WS_VSCROLL             11342
#define IDS_HELP_WS_MINIMIZEBOX         11343
#define IDS_HELP_WS_MAXIMIZEBOX         11344
#define IDS_HELP_WS_CLIPSIBLINGS        11345
#define IDS_HELP_WS_CLIPCHILDREN        11346
#define IDS_HELP_WS_THICKFRAME          11347
#define IDS_HELP_DS_MODALFRAME          11348
#define IDS_HELP_DS_SYSMODAL            11349
#define IDS_HELP_DS_ABSALIGN            11350
#define IDS_HELP_DS_CONTEXTHELP         11351
#define IDS_HELP_DS_SETFOREGROUND       11352
#define IDS_HELP_DS_3DLOOK              11353
#define IDS_HELP_DS_NOFAILCREATE        11354
#define IDS_HELP_DS_NOIDLEMSG           11355
#define IDS_HELP_DS_CONTROL             11356
#define IDS_HELP_DS_CENTER              11357
#define IDS_HELP_DS_CENTERMOUSE         11358
#define IDS_HELP_DS_LOCALEDIT           11359
#define IDS_HELP_SS_CENTERIMAGE         11360
#define IDS_HELP_SS_REALSIZEIMAGE       11361
#define IDS_HELP_SS_REALSIZECONTROL     11362   // 4.0
#define IDS_HELP_SS_SUNKEN              11363
#define IDS_HELP_SS_SIMPLE              11364
#define IDS_HELP_SS_LEFTNOWORDWRAP      11365
#define IDS_HELP_SS_OWNERDRAW           11366
#define IDS_HELP_SS_NOPREFIX            11367
#define IDS_HELP_SS_NOTIFY              11368
#define IDS_HELP_SS_RIGHTJUST           11369
#define IDS_HELP_ES_MULTILINE           11370
#define IDS_HELP_ES_NUMBER              11371
#define IDS_HELP_ES_AUTOHSCROLL         11372
#define IDS_HELP_ES_AUTOVSCROLL         11373
#define IDS_HELP_ES_PASSWORD            11374
#define IDS_HELP_ES_NOHIDESEL           11375
#define IDS_HELP_ES_OEMCONVERT          11376
#define IDS_HELP_ES_WANTRETURN          11377
#define IDS_HELP_ES_UPPERCASE           11378
#define IDS_HELP_ES_LOWERCASE           11379
#define IDS_HELP_ES_READONLY            11380
#define IDS_HELP_ES_DISABLENOSCROLL     11381
#define IDS_HELP_BS_NOTIFY              11382
#define IDS_HELP_BS_FLAT                11383
#define IDS_HELP_BS_MULTILINE           11384
#define IDS_HELP_BS_LEFTTEXT            11385
#define IDS_HELP_BS_PUSHLIKE            11386
#define IDS_HELP_CBS_AUTOHSCROLL        11387
#define IDS_HELP_CBS_OEMCONVERT         11388
#define IDS_HELP_CBS_SORT               11389
#define IDS_HELP_CBS_HASSTRINGS         11390
#define IDS_HELP_CBS_NOINTEGRALHEIGHT   11391
#define IDS_HELP_CBS_DISABLENOSCROLL    11392
#define IDS_HELP_CBS_UPPERCASE          11393
#define IDS_HELP_CBS_LOWERCASE          11394
#define IDS_HELP_LBS_SORT               11395
#define IDS_HELP_LBS_HASSTRINGS         11396
#define IDS_HELP_LBS_NOINTEGRALHEIGHT   11397
#define IDS_HELP_LBS_DISABLENOSCROLL    11398
#define IDS_HELP_LBS_NOTIFY             11399
#define IDS_HELP_LBS_MULTICOLUMN        11400
#define IDS_HELP_LBS_NOREDRAW           11401
#define IDS_HELP_LBS_USETABSTOPS        11402
#define IDS_HELP_LBS_WANTKEYBOARDINPUT  11403
#define IDS_HELP_LBS_NODATA             11404
#define IDS_HELP_UDS_HORZ               11405
#define IDS_HELP_UDS_AUTOBUDDY          11406
#define IDS_HELP_UDS_SETBUDDYINT        11407
#define IDS_HELP_UDS_NOTHOUSANDS        11408
#define IDS_HELP_UDS_WRAP               11409
#define IDS_HELP_UDS_ARROWKEYS          11410
#define IDS_HELP_UDS_HOTTRACK           11411
#define IDS_HELP_PBS_VERTICAL           11412
#define IDS_HELP_PBS_SMOOTH             11413
#define IDS_HELP_PBS_MARQUEE            11414   // 4.0
#define IDS_HELP_TBS_VERT               11415
#define IDS_HELP_TBS_NOTICKS            11416
#define IDS_HELP_TBS_AUTOTICKS          11417
#define IDS_HELP_TBS_ENABLESELRANGE     11418
#define IDS_HELP_TBS_FIXEDLENGTH        11419
#define IDS_HELP_TBS_NOTHUMB            11420
#define IDS_HELP_TBS_TOOLTIPS           11421
#define IDS_HELP_LVS_SINGLESEL          11422
#define IDS_HELP_LVS_SHOWSELALWAYS      11423
#define IDS_HELP_LVS_AUTOARRANGE        11424
#define IDS_HELP_LVS_NOLABELWRAP        11425
#define IDS_HELP_LVS_EDITLABELS         11426
#define IDS_HELP_LVS_NOSCROLL           11427
#define IDS_HELP_LVS_NOCOLUMNHEADER     11428
#define IDS_HELP_LVS_NOSORTHEADER       11429
#define IDS_HELP_LVS_SHAREIMAGELISTS    11430
#define IDS_HELP_LVS_OWNERDRAWFIXED     11431
#define IDS_HELP_LVS_OWNERDATA          11432
#define IDS_HELP_TVS_HASBUTTONS         11433
#define IDS_HELP_TVS_HASLINES           11434
#define IDS_HELP_TVS_LINESATROOT        11435
#define IDS_HELP_TVS_EDITLABELS         11436
#define IDS_HELP_TVS_DISABLEDRAGDROP    11437
#define IDS_HELP_TVS_SHOWSELALWAYS      11438
#define IDS_HELP_TVS_NOTOOLTIPS         11439
#define IDS_HELP_TVS_CHECKBOXES         11440
#define IDS_HELP_TVS_TRACKSELECT        11441
#define IDS_HELP_TVS_SINGLEEXPAND       11442
#define IDS_HELP_TVS_INFOTIP            11443
#define IDS_HELP_TVS_FULLROWSELECT      11444
#define IDS_HELP_TVS_NOSCROLL           11445
#define IDS_HELP_TVS_NONEVENHEIGHT      11446
#define IDS_HELP_TCS_BUTTONS            11447
#define IDS_HELP_TCS_FLATBUTTONS        11448
#define IDS_HELP_TCS_TOOLTIPS           11449
#define IDS_HELP_TCS_MULTILINE          11450
#define IDS_HELP_TCS_OWNERDRAWFIXED     11451
#define IDS_HELP_TCS_FORCELABELLEFT     11452
#define IDS_HELP_TCS_FORCEICONLEFT      11453
#define IDS_HELP_TCS_HOTTRACK           11454
#define IDS_HELP_TCS_BOTTOM             11455
#define IDS_HELP_TCS_MULTISELECT        11456
#define IDS_HELP_TCS_SCROLLOPPOSITE     11457
#define IDS_HELP_TCS_VERTICAL           11458
#define IDS_HELP_ACS_CENTER             11459
#define IDS_HELP_ACS_TRANSPARENT        11460
#define IDS_HELP_ACS_AUTOPLAY           11461
#define IDS_HELP_ACS_TIMER              11462
#define IDS_HELP_DTS_RIGHTALIGN         11463
#define IDS_HELP_DTS_UPDOWN             11464
#define IDS_HELP_DTS_SHOWNONE           11465
#define IDS_HELP_MCS_DAYSTATE           11466
#define IDS_HELP_MCS_MULTISELECT        11467
#define IDS_HELP_MCS_WEEKNUMBERS        11468
#define IDS_HELP_MCS_NOTODAYCIRCLE      11469
#define IDS_HELP_MCS_NOTODAY            11470
#define IDS_HELP_CCS_NORESIZE           11471
#define IDS_HELP_CCS_TOP                11472
#define IDS_HELP_CCS_BOTTOM             11473
#define IDS_HELP_CCS_LEFT               11474
#define IDS_HELP_CCS_RIGHT              11475
#define IDS_HELP_CCS_NODIVIDER          11476
#define IDS_HELP_CCS_ADJUSTABLE         11477
#define IDS_HELP_RBS_VARHEIGHT          11478
#define IDS_HELP_RBS_BANDBORDERS        11479
#define IDS_HELP_RBS_FIXEDORDER         11480
#define IDS_HELP_RBS_REGISTERDROP       11481
#define IDS_HELP_RBS_AUTOSIZE           11482
#define IDS_HELP_RBS_VERTICALGRIPPER    11483
#define IDS_HELP_RBS_DBLCLKTOGGLE       11484
#define IDS_HELP_PGS_HORZ               11485
#define IDS_HELP_PGS_AUTOSCROLL         11486
#define IDS_HELP_PGS_DRAGNDROP          11487
#define IDS_HELP_TBSTYLE_FLAT           11488
#define IDS_HELP_TBSTYLE_LIST           11489
#define IDS_HELP_TBSTYLE_WRAPABLE       11490
#define IDS_HELP_TBSTYLE_TRANSPARENT    11491
#define IDS_HELP_TBSTYLE_TOOLTIPS       11492
#define IDS_HELP_TBSTYLE_ALTDRAG        11493
#define IDS_HELP_TBSTYLE_CUSTOMERASE    11494
#define IDS_HELP_TBSTYLE_REGISTERDROP   11495
#define IDS_HELP_SBARS_SIZEGRIP         11496
#define IDS_HELP_LWS_TRANSPARENT        11497   // 5.0
#define IDS_HELP_LWS_IGNORERETURN       11498   // 5.0
#define IDS_HELP_LWS_NOPREFIX           11499   // 5.0
#define IDS_HELP_LWS_USEVISUALSTYLE     11500   // 5.0
#define IDS_HELP_LWS_USECUSTOMTEXT      11501   // 5.0
#define IDS_HELP_LWS_RIGHT              11502   // 5.0
#define IDS_HELP_NFS_EDIT               11503   // 5.0
#define IDS_HELP_NFS_STATIC             11504   // 5.0
#define IDS_HELP_NFS_LISTCOMBO          11505   // 5.0
#define IDS_HELP_NFS_BUTTON             11506   // 5.0
#define IDS_HELP_NFS_ALL                11507   // 5.0
#define IDS_HELP_NFS_USEFONTASSOC       11508   // 5.0
#define IDS_HELP_WS_EX_CLIENTEDGE       11509
#define IDS_HELP_WS_EX_STATICEDGE       11510
#define IDS_HELP_WS_EX_TRANSPARENT      11511
#define IDS_HELP_WS_EX_ACCEPTFILES      11512
#define IDS_HELP_WS_EX_RIGHT            11513
#define IDS_HELP_WS_EX_LEFTSCROLLBAR    11514
#define IDS_HELP_WS_EX_TOOLWINDOW       11515
#define IDS_HELP_WS_EX_CONTROLPARENT    11516
#define IDS_HELP_WS_EX_CONTEXTHELP      11517
#define IDS_HELP_WS_EX_NOPARENTNOTIFY   11518
#define IDS_HELP_WS_EX_APPWINDOW        11519   // 4.0
#define IDS_HELP_WS_EX_TOPMOST          11520   // 4.0
#define IDS_HELP_WS_EX_NOACTIVATE       11521   // 4.0

#define IDS_ERR_CANTREADFILE            11522
#define IDS_ERR_CANTWRITEFILE           11523
#define IDS_ERR_LINETOOLONG             11524
#define IDS_ERR_INVALIDCHAR             11525
#define IDS_ERR_BADFILEFORMAT           11526
#define IDS_ERR_BADIMAGEFORMAT          11527
#define IDS_ERR_BADRSRCFORMAT           11528
#define IDS_ERR_BADSYNTAX               11529
#define IDS_ERR_OS2BITMAP               11530
#define IDS_ERR_UNKNOWNCODEC            11531
#define IDS_ERR_CODECERROR              11532
#define IDS_ERR_INVALIDVIDEO            11533
#define IDS_ERR_WFPPROTECTED            11534
#define IDS_ERR_TOOMANYCOLORS           11535
#define IDS_ERR_WRONGCHECKSUM           11536
#define IDS_ERR_BADEXECFORMAT           11537   // 5.0
#define IDS_ERR_CORRUPTMMFREGION        11538   // 6.50

#define IDS_DIFF_ONLY_IN                11539   // 7.0
#define IDS_DIFF_DIFFERENT              11540   // 7.0
#define IDS_DIFF_IDENTICAL              11541   // 7.0
#define IDS_DIFF_SAME_SIZE              11542   // 7.0
#define IDS_DIFF_IDENTICAL_TIMES        11543   // 7.0
#define IDS_DIFF_IN_BLANKS_ONLY         11544   // 7.0
#define IDS_DIFF_BOTH_UNREADABLE        11545   // 7.0
#define IDS_DIFF_LEFT_UNREADABLE        11546   // 7.0
#define IDS_DIFF_RIGHT_UNREADABLE       11547   // 7.0
#define IDS_DIFF_UNREADABLE             11548   // 7.0
#define IDS_DIFF_IS_MORE_RECENT         11549   // 7.0

#define IDS_SCOPE_DOCUMENT              11550   // 9.0
#define IDS_SCOPE_PROJECT               11551   // 9.0
#define IDS_SCOPE_WORKSPACE             11552   // 9.0

#define CSTRINGS                        1552    // Number of strings

//
// Menu ID's ----------------------------------------------------------------
//

//
// File menu.
//
#define IDM_FILE_NEWPROJECT         6001
#define IDM_FILE_NEWSOURCE          6002
#define IDM_FILE_NEWRESOURCE        6003
#define IDM_FILE_NEWBITMAP          6004
#define IDM_FILE_NEWICON            6005
#define IDM_FILE_NEWCURSOR          6006
#define IDM_FILE_NEWANICURSOR       6007
#define IDM_FILE_NEWVIDEO           6008
#define IDM_FILE_NEWHEXDUMP         6009
#define IDM_FILE_NEWMSGTABLE        6010    // 3.0
#define IDM_FILE_NEWWEB             6011    // 7.0
#define IDM_FILE_NEWDIFF            6012    // 7.0
#define IDM_FILE_NEWADDIN           6013    // 8.0
#define IDM_FILE_OPEN               6014
#define IDM_FILE_OPENPROJ           6015    // 7.0 (Welcome page only)
#define IDM_FILE_CLOSE              6016
#define IDM_FILE_CLOSEPROJ          6017    // 5.0
#define IDM_FILE_SAVE               6018
#define IDM_FILE_SAVEAS             6019
#define IDM_FILE_SAVEALL            6020
#define IDM_FILE_PRINT              6021
#define IDM_FILE_PRINTSETUP         6022
#define IDM_FILE_PROPERTIES         6023
#define IDM_FILE_EXIT               6024
#define IDM_FILE_ADDIN              6025    // (placeholder, never used)
#define IDM_FILE_MRUFILE            6026    // room for 8 files.
#define IDM_FILE_MRUFILE_1          6027    // (placeholder, never used)
#define IDM_FILE_MRUFILE_2          6028    // (placeholder, never used)
#define IDM_FILE_MRUFILE_3          6029    // (placeholder, never used)
#define IDM_FILE_MRUFILE_4          6030    // (placeholder, never used)
#define IDM_FILE_MRUFILE_5          6031    // (placeholder, never used)
#define IDM_FILE_MRUFILE_6          6032    // (placeholder, never used)
#define IDM_FILE_MRUFILE_7          6033    // (placeholder, never used)
#define IDM_FILE_MRUFILE_8          6034    // (placeholder, never used)
#define IDM_FILE_MRUPROJ            6035    // room for 8 projects.
#define IDM_FILE_MRUPROJ_1          6036    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_2          6037    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_3          6038    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_4          6039    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_5          6040    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_6          6041    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_7          6042    // (placeholder, never used)
#define IDM_FILE_MRUPROJ_8          6043    // (placeholder, never used)
#define IDM_FILE_MRULINK            6044    // room for 8 links (7.0).
#define IDM_FILE_MRULINK_1          6045    // (placeholder, never used)
#define IDM_FILE_MRULINK_2          6046    // (placeholder, never used)
#define IDM_FILE_MRULINK_3          6047    // (placeholder, never used)
#define IDM_FILE_MRULINK_4          6048    // (placeholder, never used)
#define IDM_FILE_MRULINK_5          6049    // (placeholder, never used)
#define IDM_FILE_MRULINK_6          6050    // (placeholder, never used)
#define IDM_FILE_MRULINK_7          6051    // (placeholder, never used)
#define IDM_FILE_MRULINK_8          6052    // (placeholder, never used)
//
// Edit menu.
//
#define IDM_EDIT_UNDO               6053
#define IDM_EDIT_REDO               6054
#define IDM_EDIT_CUT                6055
#define IDM_EDIT_COPY               6056
#define IDM_EDIT_PASTE              6057
#define IDM_EDIT_INSERT             6058
#define IDM_EDIT_DELETE             6059
#define IDM_EDIT_DELETEWORD         6060
#define IDM_EDIT_SELECTALL          6061
#define IDM_EDIT_FIND               6062
#define IDM_EDIT_FINDNEXT           6063
#define IDM_EDIT_REPLACE            6064
#define IDM_EDIT_FILEFIND           6065
#define IDM_EDIT_GOTO               6066
#define IDM_EDIT_ADDIN              6067    // (placeholder, never used)
//
// View menu.
//
#define IDM_VIEW_SOURCEFILES        6068    // 5.0
#define IDM_VIEW_TARGETFILES        6069    // 5.0
#define IDM_VIEW_PROJECT            6070    // 5.0
#define IDM_VIEW_FILEFIND           6071    // 5.0
#define IDM_VIEW_OUTPUT             6072    // 5.0
#define IDM_VIEW_TRACE              6073    // 5.0
#define IDM_VIEW_BREAKPOINTS        6074    // 5.0
#define IDM_VIEW_AUTO               6075    // 5.0
#define IDM_VIEW_WATCH              6076    // 5.0
#define IDM_VIEW_LOCALS             6077    // 5.0
#define IDM_VIEW_GLOBALS            6078    // 5.0
#define IDM_VIEW_REGISTERS          6079    // 5.0
#define IDM_VIEW_STACK              6080    // 5.0
#define IDM_VIEW_MEMORY             6081    // 5.0
#define IDM_VIEW_THREADS            6082    // 5.0
#define IDM_VIEW_MODULES            6083    // 5.0
#define IDM_VIEW_EXCEPTIONS         6084    // 5.0
#define IDM_VIEW_HELPCONTENTS       6085    // 7.0
#define IDM_VIEW_HELPINDEX          6086    // 7.0
#define IDM_VIEW_HELPSEARCH         6087    // 8.0
#define IDM_VIEW_OUTLINE            6088    // 7.0
#define IDM_VIEW_EXPAND             6089    // 7.0
#define IDM_VIEW_SHOWTOOLBAR        6090
#define IDM_VIEW_SHOWSTATUSBAR      6091
#define IDM_VIEW_SHOWDOCTABS        6092
#define IDM_VIEW_SHOWWELCOME        6093    // 7.0
#define IDM_VIEW_TOGGLEFULLSCREEN   6094    // 8.0
#define IDM_VIEW_TOGGLEPROJPANE     6095    // 4.0 (hidden)
#define IDM_VIEW_TABPAGES           6096    // 5.0 (placeholder, never used)
#define IDM_VIEW_ADDIN              6097    // (placeholder, never used)
//
// Project menu.
//
#define IDM_PROJ_BUILD              6098    // Project menu.
#define IDM_PROJ_REBUILD            6099    // Project menu (5.0: IDM_PROJ_BUILDALL -> IDM_PROJ_REBUILD).
#define IDM_PROJ_CLEAN              6100    // Project menu (9.0).
#define IDM_PROJ_BUILDWKS           6101    // Project menu (5.0).
#define IDM_PROJ_REBUILDWKS         6102    // Project menu (5.0).
#define IDM_PROJ_CLEANWKS           6103    // Project menu (9.0).
#define IDM_PROJ_COMPILE            6104    // Project menu.
#define IDM_PROJ_STOPBUILD          6105    // Project menu.
#define IDM_PROJ_EXECUTE            6106    // Project menu.
#define IDM_PROJ_PROFILE            6107    // Project menu (6.50).
#define IDM_PROJ_ADDFILE            6108    // Project menu.
#define IDM_PROJ_ADDPROJECT         6109    // Project menu (4.0).
#define IDM_PROJ_MAKEALLPREQS       6110    // Project menu.
#define IDM_PROJ_ZIP                6111    // Project menu.
#define IDM_PROJ_UNZIP              6112    // Project menu.
#define IDM_PROJ_SETACTIVE          6113    // Project menu (4.0).
#define IDM_PROJ_DEPENDENCIES       6114    // Project menu (4.0).
#define IDM_PROJ_SETTINGS           6115    // Project menu.
#define IDM_PROJ_MODES              6116    // Project menu (9.0).
#define IDM_PROJ_WORKSPACE          6117    // Project menu (4.0).
#define IDM_PROJ_CTX_OPEN           6118    // Context menu (4.0).
#define IDM_PROJ_CTX_OPENAS_TEXT    6119    // Context menu (5.0).
#define IDM_PROJ_CTX_OPENAS_BINARY  6120    // Context menu (5.0).
#define IDM_PROJ_CTX_OPENFUNC       6121    // Context menu (8.0).
#define IDM_PROJ_CTX_ADDFILE        6122    // Context menu (4.0).
#define IDM_PROJ_CTX_DELETE         6123    // Context menu (4.0).
#define IDM_PROJ_CTX_RENAME         6124    // Context menu (4.0).
#define IDM_PROJ_CTX_EXCLUDE        6125    // Context menu (4.0).
#define IDM_PROJ_CTX_ZIP            6126    // Context menu (4.0).
#define IDM_PROJ_CTX_UNZIP          6127    // Context menu (4.0).
#define IDM_PROJ_CTX_SETACTIVE      6128    // Context menu (4.0).
#define IDM_PROJ_CTX_MAKEALLPREQS   6129    // Context menu (4.0).
#define IDM_PROJ_CTX_SORTFUNCS      6130    // Context menu (4.0).
#define IDM_PROJ_CTX_SETTINGS       6131    // Context menu (4.0).
#define IDM_PROJ_CTX_PROPERTIES     6132    // Context menu (4.0).
#define IDM_PROJ_CTX_BUILD          6133    // Context menu (4.0).
#define IDM_PROJ_CTX_REBUILD        6134    // Context menu (4.0) (5.0: IDM_PROJ_CTX_FORCEBUILD -> IDM_PROJ_CTX_REBUILD).
#define IDM_PROJ_CTX_EXECUTE        6135    // Context menu (4.0).
#define IDM_PROJ_CTX_DEBUG          6136    // Context menu (4.0).
#define IDM_PROJ_CTX_MAKETARGPREQS  6137    // Context menu (4.0).
#define IDM_PROJ_CTX_TOGGLEPANE     6138    // Context menu (4.0).
#define IDM_PROJ_CTX_PROFILE        6139    // Context menu (6.50).
#define IDM_PROJ_CTX_MAKEWKSPREQS   6140    // Context menu (7.0).
#define IDM_PROJ_CTX_CLEAN          6141    // Project menu (7.0).
#define IDM_PROJ_CTX_CLEANWKS       6142    // Project menu (7.0).
#define IDM_PROJ_ADDIN              6143    // (placeholder, never used)
#define IDM_PROJ_ADDIN_CTX          6144    // (placeholder, never used)
//
// Tools window.
//
#define IDM_TOOL_CUSTOMIZE          6145
#define IDM_TOOL_SETTINGS           6146
#define IDM_TOOL_CUSTOMTOOL         6147    // room for 16 tools.
#define IDM_TOOL_CUSTOMTOOL_1       6148    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_2       6149    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_3       6150    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_4       6151    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_5       6152    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_6       6153    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_7       6154    // (placeholder, never used)
#define IDM_TOOL_CUSTOMTOOL_8       6155    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_9       6156    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_10      6157    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_11      6158    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_12      6159    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_13      6160    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_14      6161    // (placeholder, never used) (5.0)
#define IDM_TOOL_CUSTOMTOOL_15      6162    // (placeholder, never used) (5.0)
//
// Window menu.
//
#define IDM_WIN_NEW                 6163
#define IDM_WIN_CASCADE             6164
#define IDM_WIN_TILEVERT            6165
#define IDM_WIN_TILEHORZ            6166
#define IDM_WIN_CLOSEALL            6167
//
// Help menu.
//
#define IDM_HELP_CONTENTS           6168
#define IDM_HELP_CUSTOM             6169    // (placeholder, never used) (5.0)
#define IDM_HELP_WEB_FORUM          6170    // 3.0
#define IDM_HELP_WEB_SOURCECODE     6171    // 3.0
#define IDM_HELP_WEB_DONATE         6172    // 3.0
#define IDM_HELP_WEB_ADDIN          6173    // (placeholder, never used)
#define IDM_HELP_ABOUT              6174
#define IDM_HELP_CUSTOMHELP         6175    // room for 16 help files.
#define IDM_HELP_CUSTOMHELP_1       6176    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_2       6177    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_3       6178    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_4       6179    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_5       6180    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_6       6181    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_7       6182    // (placeholder, never used)
#define IDM_HELP_CUSTOMHELP_8       6183    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_9       6184    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_10      6185    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_11      6186    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_12      6187    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_13      6188    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_14      6189    // (placeholder, never used) (5.0)
#define IDM_HELP_CUSTOMHELP_15      6190    // (placeholder, never used) (5.0)
#define IDM_HELP_ADDIN              6191    // (placeholder, never used)
//
// Image/Dialog/Resource/Animation/Source/Debug/Web/Difference window.
//
#define IDM_IMG_NEWIMAGE            6192
#define IDM_IMG_DELETEIMAGE         6193
#define IDM_IMG_RESIZE              6194    // 5.0
#define IDM_IMG_MIRROR_HORZ         6195
#define IDM_IMG_MIRROR_VERT         6196
#define IDM_IMG_ROTATE              6197
#define IDM_IMG_GRAYSCALE           6198
#define IDM_IMG_SEPIATONE           6199    // 4.0
#define IDM_IMG_HSV                 6200
#define IDM_IMG_OPAQUEALPHA         6201    // 4.0
#define IDM_IMG_EFFECT_OILPAINT     6202
#define IDM_IMG_EFFECT_SPREAD       6203
#define IDM_IMG_EFFECT_EMBOSS       6204
#define IDM_IMG_EFFECT_FISHEYE      6205
#define IDM_IMG_EFFECT_DROPSHADOW   6206    // 4.0
#define IDM_IMG_EFFECT_BLUR         6207
#define IDM_IMG_EFFECT_SHARPEN      6208
//
#define IDM_DLG_NEWPICTURE          6209    // 4.50
#define IDM_DLG_NEWTEXT             6210    // 4.50
#define IDM_DLG_NEWEDITBOX          6211    // 4.50
#define IDM_DLG_NEWGROUPBOX         6212    // 4.50
#define IDM_DLG_NEWPUSHBUTTON       6213    // 4.50
#define IDM_DLG_NEWCHECKBOX         6214    // 4.50
#define IDM_DLG_NEWRADIOBUTTON      6215    // 4.50
#define IDM_DLG_NEWCOMBOBOX         6216    // 4.50
#define IDM_DLG_NEWLISTBOX          6217    // 4.50
#define IDM_DLG_NEWHSCROLLBAR       6218    // 4.50
#define IDM_DLG_NEWVSCROLLBAR       6219    // 4.50
#define IDM_DLG_NEWUPDOWN           6220    // 4.50
#define IDM_DLG_NEWPROGRESS         6221    // 4.50
#define IDM_DLG_NEWTRACKBAR         6222    // 4.50
#define IDM_DLG_NEWHOTKEY           6223    // 4.50
#define IDM_DLG_NEWLISTVIEW         6224    // 4.50
#define IDM_DLG_NEWTREEVIEW         6225    // 4.50
#define IDM_DLG_NEWTABCONTROL       6226    // 4.50
#define IDM_DLG_NEWANIMATE          6227    // 4.50
#define IDM_DLG_NEWRICHEDIT         6228    // 4.50
#define IDM_DLG_NEWRICHED20         6229    // 4.50
#define IDM_DLG_NEWDATETIME         6230    // 4.50
#define IDM_DLG_NEWMONTHCAL         6231    // 4.50
#define IDM_DLG_NEWCOMBOBOXEX       6232    // 4.50
#define IDM_DLG_NEWREBAR            6233    // 4.50
#define IDM_DLG_NEWPAGER            6234    // 4.50
#define IDM_DLG_NEWTOOLBAR          6235    // 4.50
#define IDM_DLG_NEWSTATUSBAR        6236    // 4.50
#define IDM_DLG_NEWSYSLINK          6237    // 5.0
#define IDM_DLG_NEWIPADDRESS        6238    // 5.0
#define IDM_DLG_NEWNETADDRESS       6239    // 5.0
#define IDM_DLG_NEWSPLITBUTTON      6240    // 5.0
#define IDM_DLG_NEWCOMMANDLINK      6241    // 5.0
#define IDM_DLG_NEWNATIVEFONT       6242    // 5.0
#define IDM_DLG_ALIGN               6243
#define IDM_DLG_ALIGNLEFT           6244
#define IDM_DLG_ALIGNVERT           6245
#define IDM_DLG_ALIGNRIGHT          6246
#define IDM_DLG_ALIGNTOP            6247
#define IDM_DLG_ALIGNHORZ           6248
#define IDM_DLG_ALIGNBOTTOM         6249
#define IDM_DLG_CENTER              6250
#define IDM_DLG_CENTERVERT          6251
#define IDM_DLG_CENTERHORZ          6252
#define IDM_DLG_SPACE               6253
#define IDM_DLG_SPACEVERT           6254
#define IDM_DLG_SPACEHORZ           6255
#define IDM_DLG_ARRSIZE             6256
#define IDM_DLG_ARRSIZEWIDTH        6257
#define IDM_DLG_ARRSIZEHEIGHT       6258
#define IDM_DLG_ARRSIZEBOTH         6259
#define IDM_DLG_ARRPUSH             6260
#define IDM_DLG_ARRPUSHBOTTOM       6261
#define IDM_DLG_ARRPUSHRIGHT        6262
#define IDM_DLG_SIZETOTEXT          6263
#define IDM_DLG_SORTNAMES           6264
#define IDM_DLG_SORTPROPS           6265
#define IDM_DLG_PROPDESCRIPTION     6266
#define IDM_DLG_RAWSTYLES           6267    // 4.0
#define IDM_DLG_HIDEPROPS           6268
#define IDM_DLG_NEWCUSTOM           6269
#define IDM_DLG_OPENCUSTOM          6270
#define IDM_DLG_REMOVECUSTOM        6271
#define IDM_DLG_LOCKCONTROLS        6272
#define IDM_DLG_ORDERCONTROLS       6273
//
#define IDM_RSRC_NEWBITMAP          6274
#define IDM_RSRC_NEWICON            6275
#define IDM_RSRC_NEWCURSOR          6276
#define IDM_RSRC_NEWANICURSOR       6277
#define IDM_RSRC_NEWVIDEO           6278
#define IDM_RSRC_NEWDIALOG          6279
#define IDM_RSRC_NEWMENU            6280
#define IDM_RSRC_NEWSTRINGTABLE     6281
#define IDM_RSRC_NEWMSGTABLE        6282    // 3.0
#define IDM_RSRC_NEWACCEL           6283
#define IDM_RSRC_NEWVERSION         6284
#define IDM_RSRC_NEWMANIFEST        6285
#define IDM_RSRC_NEWHTML            6286    // 5.0
#define IDM_RSRC_NEWCUSTOM          6287    // 3.0
#define IDM_RSRC_NEWCOPY            6288
#define IDM_RSRC_IMPORT             6289
#define IDM_RSRC_EXPORT             6290    // 6.0
#define IDM_RSRC_SORTNAMES          6291
#define IDM_RSRC_LABELS             6292    // 6.50: IDM_VIEW_LABELS -> IDM_RSRC_LABELS
#define IDM_RSRC_INCLUDES           6293    // 6.50: IDM_VIEW_INCLUDES -> IDM_RSRC_INCLUDES
#define IDM_RSRC_ADDIN              6294    // 3.0 (placeholder, never used)
#define IDM_RSRC_NEW_ADDIN          6295    // 3.0 (placeholder, never used)
//
#define IDM_ANIM_IMPORT             6296
//
#define IDM_MESS_SETINCLUDE         6297    // 3.0
#define IDM_MESS_VIEWLABELS         6298    // 3.0
#define IDM_MESS_ADDIN              6299    // 3.0 (placeholder, never used)
//
#define IDM_SRC_FORCECALLTIP        6300    // 4.50
#define IDM_SRC_COMPLETEWORD        6301
#define IDM_SRC_INSERTSNIPPET       6302    // 5.0
#define IDM_SRC_SURROUNDBYPOPUP     6303    // 5.0
#define IDM_SRC_SURROUNDBY          6304    // 5.0 - room for 16 snippets.
#define IDM_SRC_SURROUNDBY_1        6305    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_2        6306    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_3        6307    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_4        6308    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_5        6309    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_6        6310    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_7        6311    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_8        6312    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_9        6313    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_10       6314    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_11       6315    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_12       6316    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_13       6317    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_14       6318    // 5.0 (placeholder, never used)
#define IDM_SRC_SURROUNDBY_15       6319    // 5.0 (placeholder, never used)
#define IDM_SRC_UCASE               6320
#define IDM_SRC_LCASE               6321
#define IDM_SRC_TABTOSPACE          6322
#define IDM_SRC_SPACETOTAB          6323
#define IDM_SRC_FORMAT              6324    // 3.0
#define IDM_SRC_COMMENT             6325    // 4.0
#define IDM_SRC_UNCOMMENT           6326    // 4.0
#define IDM_SRC_NEXTBOOKMARK        6327
#define IDM_SRC_PREVBOOKMARK        6328
#define IDM_SRC_SETBOOKMARK         6329
#define IDM_SRC_CLEARBOOKMARKS      6330
#define IDM_SRC_WHITESPACE          6331
#define IDM_SRC_LINEBREAKS          6332
#define IDM_SRC_LINENUMBERS         6333
#define IDM_SRC_FOLDINGS            6334
#define IDM_SRC_MATCHINGBRACES      6335    // 4.50
#define IDM_SRC_OPENINCLUDE         6336    // 4.50
#define IDM_SRC_CONTEXTHELP         6337
#define IDM_SRC_VIEWDEFINITION      6338
#define IDM_SRC_PREVDEFINITION      6339
#define IDM_SRC_FINDCALLSITES       6340    // 4.0
#define IDM_SRC_FOLDALL             6341
#define IDM_SRC_UNFOLDALL           6342
#define IDM_SRC_ADDIN               6343    // (placeholder, never used)
#define IDM_SRC_ADDIN_CONV          6344    // (placeholder, never used)
//
#define IDM_DBG_GO                  6345
#define IDM_DBG_RESTART             6346
#define IDM_DBG_STOP                6347
#define IDM_DBG_BREAK               6348
#define IDM_DBG_STEPINTO            6349
#define IDM_DBG_STEPOVER            6350
#define IDM_DBG_STEPOUT             6351    // 4.0
#define IDM_DBG_RUNTOCURSOR         6352    // 4.0
#define IDM_DBG_TOGGLEBREAKPOINT    6353    // 4.0
#define IDM_DBG_EDITBREAKPOINT      6354    // 4.0
#define IDM_DBG_REMOVEBREAKPOINT    6355    // 4.0
#define IDM_DBG_REMOVEBREAKPOINTS   6356    // 4.0
#define IDM_DBG_SHOWNEXTSTMT        6357
#define IDM_DBG_SHOWDISASM          6358
#define IDM_DBG_SHOWSOURCE          6359
#define IDM_DBG_SHOWCODEBYTES       6360
#define IDM_DBG_SHOWSYMBOLS         6361
#define IDM_DBG_ADDWATCH            6362
#define IDM_DBG_REMOVEWATCH         6363
#define IDM_DBG_REMOVEALLWATCHES    6364
#define IDM_DBG_QUICKWATCH          6365    // 4.0
#define IDM_DBG_HWBREAKS            6366    // 4.0
#define IDM_DBG_HEXVALUES           6367    // 4.50
#define IDM_DBG_CPU                 6368    // 5.0
#define IDM_DBG_FPU                 6369    // 5.0
#define IDM_DBG_MMX                 6370    // 5.0
#define IDM_DBG_SSE                 6371    // 5.0
#define IDM_DBG_AVX                 6372    // 7.0 (disabled), 8.0 (supported)
#define IDM_DBG_CPUSEG              6373    // 9.0
#define IDM_DBG_AVX512              6374    // 10.0
#define IDM_DBG_MODULEMSG           6375    // 8.0
#define IDM_DBG_THREADMSG           6376    // 8.0
#define IDM_DBG_OUTPUTMSG           6377    // 8.0
#define IDM_DBG_TOGGLESUSPENDED     6378    // 6.50
#define IDM_DBG_ADDIN               6379    // (placeholder, never used)
//
#define IDM_WEB_BACK                6380    // 7.0
#define IDM_WEB_FORWARD             6381    // 7.0
#define IDM_WEB_HOME                6382    // 8.0
#define IDM_WEB_REFRESH             6383    // 7.0
#define IDM_WEB_CERTIFICATE         6384    // 7.0
#define IDM_WEB_SHOWSOURCE          6385    // 7.0
#define IDM_WEB_ZOOM_SMALLEST       6386    // 7.0
#define IDM_WEB_ZOOM_SMALLER        6387    // 7.0
#define IDM_WEB_ZOOM_MEDIUM         6388    // 7.0
#define IDM_WEB_ZOOM_LARGER         6389    // 7.0
#define IDM_WEB_ZOOM_LARGEST        6390    // 7.0
#define IDM_WEB_ADDIN               6391    // (placeholder, never used)
//
#define IDM_DIFF_PREVCHANGE         6392    // 7.0
#define IDM_DIFF_NEXTCHANGE         6393    // 7.0
#define IDM_DIFF_REFRESH            6394    // 7.0
#define IDM_DIFF_STOP               6395    // 7.0
#define IDM_DIFF_OPENLEFT           6396    // 7.0
#define IDM_DIFF_OPENRIGHT          6397    // 7.0
#define IDM_DIFF_OPENCOMPOSITE      6398    // 9.0
#define IDM_DIFF_ADDIN              6399    // (placeholder, never used)
//
// Misc commands.
//
#define IDM_MISC_OPEN               6400
#define IDM_MISC_TEST               6401
#define IDM_MISC_CHECKMNEMONICS     6402
#define IDM_MISC_NEXTWINDOW         6403
#define IDM_MISC_MODEPOPUP          6404    // 10.0
#define IDM_MISC_KILLPROCESS        6405
//
// Drag & drop menu.
//
#define IDM_DROP_MOVE               6406
#define IDM_DROP_COPY               6407
#define IDM_DROP_CANCEL             6408
//
// Add-in commands (internal).
//
#define IDM_ADDIN_COMMAND           6409
// Range to: IDM_ADDIN_COMMAND + CMAXADDINS - 1

//
// Dialog ID's --------------------------------------------------------------
//

#define DLG_SPLASH              1001
#define DLG_ABOUT               1002
#define DLG_MAINRIBBON          1003    // 9.0
#define DLG_PROJECTRIBBON       1004
#define DLG_FORMRIBBON          1005
#define DLG_MENURIBBON          1006
#define DLG_DRAWRIBBON          1007    // 10.0: DLG_PICTRIBBON -> DLG_DRAWRIBBON
#define DLG_ANIMRIBBON          1008
#define DLG_MEMRIBBON           1009
#define DLG_WEBRIBBON           1010    // 7.0
#define DLG_HELPRIBBON          1011    // 8.0
#define DLG_DIFFRIBBON          1012    // 7.0
#define DLG_NEWPROJECT          1013
#define DLG_NEWDEFPROJECT       1014    // 4.0
#define DLG_NEWICONIMAGE        1015
#define DLG_NEWCURSORIMAGE      1016
#define DLG_NEWCUSTOMIMAGE      1017    // 6.0
#define DLG_PROPSFILE           1018
#define DLG_PROPSSOURCE         1019
#define DLG_PROPSPROJ           1020    // 5.0
#define DLG_PROPSCMDS           1021
#define DLG_PROPSPREQS          1022
#define DLG_PROPSBITMAP         1023
#define DLG_PROPSICONCURSOR     1024
#define DLG_PROPSRSRC           1025
#define DLG_PROPSRSRC2          1026    // 5.0
#define DLG_PROPSSTRING         1027
#define DLG_PROPSMESSAGE        1028    // 3.0
#define DLG_PROPSMENU           1029
#define DLG_PROPSMENU2          1030
#define DLG_PROPSACCEL          1031
#define DLG_PROPSACON           1032
#define DLG_PROPSVIDEO          1033
#define DLG_PROPSPROF           1034    // 6.50
#define DLG_SETUPGENERAL        1035
#define DLG_SETUPCOLORFONT      1036    // 10.0
#define DLG_SETUPSTARTUP        1037    // 10.0
#define DLG_SETUPWEB            1038    // 7.0
#define DLG_SETUPPROJECT        1039    // 7.0
#define DLG_SETUPFOLDERS        1040
#define DLG_SETUPBROWSE         1041    // 10.0
#define DLG_SETUPZIP            1042    // 10.0
#define DLG_SETUPDEBUG          1043
#define DLG_SETUPPROFILE        1044    // 10.0
#define DLG_SETUPSOURCE         1045
#define DLG_SETUPRESOURCE       1046    // 10.0
#define DLG_SETUPDIALOG         1047
#define DLG_SETUPIMAGE          1048
#define DLG_SETUPIMAGEJPG       1049    // 10.0
#define DLG_SETUPIMAGEPNG       1050    // 10.0
#define DLG_SETUPADDINS         1051
#define DLG_SETUPSYSDEFS        1052    // 5.0
#define DLG_PROJGENERAL         1053    // 10.0
#define DLG_PROJMACROS          1054    // 10.0
#define DLG_PROJFOLDERS         1055    // 10.0
#define DLG_PROJZIP             1056    // 10.0
#define DLG_PROJSYMBOLS         1057    // 10.0
#define DLG_PROJCOMPILER1       1058    // 10.0
#define DLG_PROJCOMPILER2       1059    // 10.0
#define DLG_PROJASSEMBLER       1060    // 10.0
#define DLG_PROJRESCOMPILER     1061    // 10.0
#define DLG_PROJMSGCOMPILER     1062    // 10.0
#define DLG_PROJLINKER1         1063    // 10.0
#define DLG_PROJLINKER2         1064    // 10.0
#define DLG_PROJLIBRARIAN       1065    // 10.0
#define DLG_PROJINSTBUILDER     1066    // 10.0
#define DLG_PROJSIGNER          1067    // 10.0
#define DLG_PRINT               1068
#define DLG_FIND                1069
#define DLG_REPLACE             1070
#define DLG_FILEFIND            1071
#define DLG_GOTOLINE            1072
#define DLG_GOTOFUNCTION        1073
#define DLG_RSRCLABELS          1074
#define DLG_RSRCINCLUDES        1075
#define DLG_CUSTOMTOOLS         1076
#define DLG_TOOL                1077
#define DLG_CUSTOMHELP          1078
#define DLG_HELP                1079
#define DLG_CUSTOMKEYS          1080
#define DLG_ADDINS              1081
#define DLG_SNIPPETS            1082    // 5.0
#define DLG_SNIPPET             1083    // 5.0
#define DLG_CUSTOMRESOURCE      1084    // 3.0
#define DLG_DUPRESOURCE         1085
#define DLG_PROJMACRO           1086
#define DLG_NEWCUSTOM           1087
#define DLG_REMOVECUSTOM        1088
#define DLG_SELECTCUSTOM        1089
#define DLG_COLORPAL            1090    // 4.0
#define DLG_COLORHSV            1091    // 4.0
#define DLG_RESIZEIMAGE         1092    // 5.0
#define DLG_ROTATEIMAGE         1093
#define DLG_OILPAINTIMAGE       1094
#define DLG_SPREADIMAGE         1095
#define DLG_FISHEYEIMAGE        1096
#define DLG_DROPSHADOWIMAGE     1097    // 4.0
#define DLG_HSVIMAGE            1098
#define DLG_DRAWTEXT            1099
#define DLG_FORMTEXT            1100    // 5.0
#define DLG_MENUTEST            1101
#define DLG_TYPEDKEY            1102
#define DLG_SELECTPROJECT       1103    // 4.0
#define DLG_PROJECTDEPS         1104    // 4.0
#define DLG_PROJECTMODES        1105    // 9.0
#define DLG_NEWPROJMODE         1106    // 9.0
#define DLG_EXTRACTZIP          1107
#define DLG_BROWSEINFO          1108
#define DLG_SELECTSNIPPET       1109    // 5.0
#define DLG_EDITBREAK           1110    // 4.0
#define DLG_ADDWATCH            1111
#define DLG_QUICKWATCH          1112    // 4.0
#define DLG_HWBREAKS            1113    // 4.0
#define DLG_EFLAGS              1114
#define DLG_CONTROLWORD         1115
#define DLG_STATUSWORD          1116
#define DLG_TAGWORD             1117
#define DLG_MXCSR               1118
#define DLG_RUNEXE              1119    // 5.0; 6.50: DLG_DEBUGEXE -> DLG_RUNEXE

//
// Dialog control ID's ------------------------------------------------------
//

#define DID_ABOUT1              4001
#define DID_ABOUT2              4002
#define DID_ABOUT3              4003
#define DID_ABOUT4              4004
#define DID_ABOUT5              4005
#define DID_MODELIST            4006    // DLG_MAINRIBBON
#define DID_IMAGELIST           4007    // DLG_DRAWRIBBON
#define DID_HOTSPOT             4008
#define DID_HOTSPOTLABEL        4009
#define DID_ACONFRAME           4010
#define DID_ACONRATE            4011
#define DID_ACONRATESPIN        4012
#define DID_ACONTITLE           4013
#define DID_ACONARTIST          4014
#define DID_ACONFRAMES          4015
#define DID_ACONSTEPS           4016
#define DID_ACONRATEDEF         4017
#define DID_OPENASLIST          4018    // 4.50
#define DID_NEWPROJLIST         4019
#define DID_NEWPROJVIEW         4020
#define DID_PROJNAME            4021
#define DID_PROJPATH            4022
#define DID_ADVANCED            4023    // 6.0
#define DID_OUTPUTPATH          4024    // 6.0
#define DID_OUTPUTPATHLABEL     4025    // 6.0
#define DID_RESULTPATH          4026    // 6.0
#define DID_RESULTPATHLABEL     4027    // 6.0
#define DID_NEWWORKSPACE        4028    // 4.0
#define DID_ADDTOWORKSPACE      4029    // 4.0
#define DID_NEWIMAGELIST        4030    // Both Icon and Cursor. Must be!
#define DID_CUSTOMCLASS         4031
#define DID_CUSTOMSTYLE         4032
#define DID_CUSTOMEXSTYLE       4033
#define DID_CUSTOMWIDTH         4034
#define DID_CUSTOMHEIGHT        4035
#define DID_CUSTOMTEXT          4036
#define DID_FILENAME            4037
#define DID_FILEPATH            4038
#define DID_FILESIZE            4039
#define DID_REALFILESIZE        4040    // 8.0
#define DID_FILEICON            4041
#define DID_FILEMESSAGE         4042    // 5.0
#define DID_TIME_CREATED        4043
#define DID_TIME_CHANGED        4044
#define DID_TIME_TOUCHED        4045
#define DID_ATTR_ARCHIVE        4046
#define DID_ATTR_READONLY       4047
#define DID_ATTR_HIDDEN         4048
#define DID_ATTR_SYSTEM         4049
#define DID_LANGUAGE            4050
#define DID_CRBREAK             4051
#define DID_LFBREAK             4052
#define DID_ENCODING            4053    // 5.0
#define DID_ENCODING2           4054    // 5.0
#define DID_ENCODING3           4055    // 5.0
#define DID_CTRLCHARS           4056
#define DID_SHELLCOMMANDS       4057
#define DID_MACROLIST           4058
#define DID_MACRONAME           4059
#define DID_MACROVALUE          4060
#define DID_PREQSLIST           4061
#define DID_PROJTYPELABEL       4062    // 10.0
#define DID_PROJTYPE            4063    // 10.0
#define DID_IMAGEWIDTH          4064
#define DID_IMAGEHEIGHT         4065
#define DID_IMAGECOLORS         4066
#define DID_COMPRESSEDFILE      4067
#define DID_TRANSPARENCY        4068    // 5.0
#define DID_XORMASK             4069
#define DID_ANDMASK             4070
#define DID_RSRCID              4071
#define DID_RSRCLANGUAGE        4072
#define DID_RSRCFILENAME        4073    // 4.0
#define DID_RSRCTYPE            4074    // 3.0
#define DID_STRINGID            4075
#define DID_STRINGTEXT          4076
#define DID_MSGID               4077    // 3.0
#define DID_MSGCODE             4078    // 3.0
#define DID_MSGFACILITY         4079    // 3.0
#define DID_MSGSEVERITY         4080    // 3.0
#define DID_MSGCUSTOMER         4081    // 3.0
#define DID_MSGTEXT             4082    // 3.0
#define DID_MSGANSI             4083    // 3.0
#define DID_MSGUNICODE          4084    // 3.0
#define DID_MENUID              4085
#define DID_MENUTEXT            4086
#define DID_MENUPOPUP           4087
#define DID_MENUSEPARATOR       4088
#define DID_MENUDEFAULT         4089
#define DID_MENUGRAYED          4090
#define DID_MENUCHECKED         4091
#define DID_MENURADIOCHECK      4092
#define DID_MENUBREAK           4093
#define DID_MENUTEXTID          4094    // Menubar
#define DID_MENUCHECKBUTTON     4095    // Menubar
#define DID_MENUGROUP           4096    // Menubar
#define DID_MENUAUTOSIZE        4097    // Menubar
#define DID_MENUNOWRAP          4098    // Menubar
#define DID_MENUPRESSED         4099    // Menubar
#define DID_MENUDISABLED        4100    // Menubar
#define DID_MENUELLIPSIS        4101    // Menubar
#define DID_MENUINDETERMINATE   4102    // Menubar
#define DID_MENUHIDDEN          4103    // Menubar
#define DID_MENUHIGHLIGHTED     4104    // Menubar
#define DID_ACCELID             4105
#define DID_ACCELKEY            4106
#define DID_ACCELCTRL           4107
#define DID_ACCELALT            4108
#define DID_ACCELSHIFT          4109
#define DID_ACCELASCII          4110
#define DID_ACCELVIRTKEY        4111
#define DID_VIDEORATE           4112
#define DID_VIDEORATESPIN       4113
#define DID_FRAMERATE           4114
#define DID_FRAMERATESPIN       4115
#define DID_TRANSPARENT         4116
#define DID_CODEC               4117
#define DID_FUNCSAMPLES         4118    // 6.50
#define DID_PROFSAMPLES         4119    // 6.50
#define DID_VOIDSAMPLES         4120    // 6.50
#define DID_SHOWSPLASH          4121
#define DID_ONSTARTUP           4122    // 7.0
#define DID_SHOWPATH            4123
#define DID_AUTORELOAD          4124    // 6.0
#define DID_MAXFILESIZE         4125    // 11.0
#define DID_UNIQUERSRCIDENTS    4126    // 4.0
#define DID_MOUSELINES          4127
#define DID_MOUSELINESSPIN      4128
#define DID_THEME               4129    // 10.0
#define DID_CATEGORIES          4130    // 10.0
#define DID_COLORLIST           4131
#define DID_FORECOLOR           4132
#define DID_BACKCOLOR           4133
#define DID_FONTFACE            4134
#define DID_FONTSIZE            4135
#define DID_BROWSEINFO          4136
#define DID_BROWSELEVEL1        4137
#define DID_BROWSELEVEL2        4138
#define DID_CALLTIPS            4139
#define DID_INFOTIPS            4140    // 9.0
#define DID_MEMBERLIST          4141
#define DID_INCLUDELIST         4142    // 6.50
#define DID_DRAGDROP            4143
#define DID_WRAPFINDQUERY       4144
#define DID_MAKEBACKUP          4145
#define DID_TABSIZE             4146
#define DID_INDENTSIZE          4147    // 4.50
#define DID_USETABS             4148    // 3.0
#define DID_SPACETABS           4149    // 3.0
#define DID_INDENTNONE          4150    // 3.0
#define DID_INDENTBLOCK         4151    // 3.0
#define DID_INDENTSMART         4152    // 3.0
#define DID_CSTYLE1             4153    // 3.0
#define DID_CSTYLE2             4154    // 3.0
#define DID_AUTOFILESAVE        4155
#define DID_FASTLOADPROJECT     4156    // 3.0
#define DID_PROJPANELEFT        4157    // 7.0
#define DID_PROJPANERIGHT       4158    // 7.0
#define DID_SORTPROJFUNCS       4159    // 7.0
#define DID_AUTOSELECTNEWPROJ   4160    // 7.0
#define DID_ZIPEXTRA            4161    // 7.0
#define DID_UNIQUEZIPNAMES      4162    // 4.0
#define DID_CLEANPROJECTMODE    4163    // 9.0
#define DID_CXFORMGRID          4164
#define DID_CYFORMGRID          4165
#define DID_CXFORMMARGIN        4166
#define DID_CYFORMMARGIN        4167
#define DID_CXCONTROLSPACE      4168
#define DID_CYCONTROLSPACE      4169
#define DID_CXBUTTONSPACE       4170
#define DID_CYBUTTONSPACE       4171
#define DID_FORMGRID            4172
#define DID_PIXELGRID           4173
#define DID_IMAGEGRID           4174
#define DID_CXIMAGEGRID         4175
#define DID_CYIMAGEGRID         4176
#define DID_JPEGQUALITY         4177
#define DID_PNGCOMPRESSION      4178    // 4.0
#define DID_USEDITHER           4179
#define DID_JITDEBUGGER         4180
#define DID_HEXVALUES           4181
#define DID_FLAGSDIALOG         4182
#define DID_BREAKONENTRY        4183    // 4.0
#define DID_MAXARRAYELEMS       4184    // 3.0
#define DID_PROFRATE            4185    // 6.50
#define DID_PROFRATESPIN        4186    // 6.50
#define DID_ALLMODULES          4187    // 6.50
#define DID_PROFLINES           4188    // 8.0
#define DID_CALLTREE            4189    // 8.0
#define DID_HOMEPAGE            4190    // 7.0
#define DID_FOLDERGROUP         4191
#define DID_FOLDERS             4192
#define DID_ARGUMENTS           4193    // GNRL
#define DID_WORKPATH            4194    // GNRL
#define DID_EXECUTOR            4195    // GNRL
#define DID_PPDEFINE            4196    // CC, RC, AS
#define DID_PPUNDEFINELABEL     4197    // CC, RC
#define DID_PPUNDEFINE          4198    // CC, RC
#define DID_DEBUGINFO           4199    // CC, AS, LINK
#define DID_WARNINGLEVEL        4200    // CC
#define DID_DIAGTYPE            4201    // CC (10.0)
#define DID_CSTANDARD           4202    // CC (7.0)
#define DID_MSEXTENSIONS        4203    // CC
#define DID_EXTENSIONS          4204    // CC
#define DID_OPENMP              4205    // CC (8.0)
#define DID_CHARUNSIGNED        4206    // CC
#define DID_TIME64              4207    // CC (10.0)
#define DID_OVERFLOWTRAP        4208    // CC (7.0)
#define DID_CRTLIB              4209    // CC
#define DID_OPTIMIZATION        4210    // CC
#define DID_OPTIMIZEMORE        4211    // CC (11.0)
#define DID_INLINEMODEL         4212    // CC (6.0)
#define DID_ARCH                4213    // CC (9.0)
#define DID_FPMODEL             4214    // CC (6.0)
#define DID_CALLCONV            4215    // CC, AS
#define DID_OMITDEFAULTLIB      4216    // CC
#define DID_OLDNAMES            4217    // CC
#define DID_NULLTERMINATE       4218    // RC (5.0)
#define DID_MAPFILE             4219    // LINK
#define DID_DBGFILE             4220    // LINK (9.0)
#define DID_NODEFAULTLIB        4221    // LINK
#define DID_RELEASE             4222    // LINK
#define DID_LARGEADDRESSAWARE   4223    // LINK (5.0)
#define DID_SAFESEH             4224    // LINK (9.0)
#define DID_LIBRARIES           4225    // LINK
#define DID_DELAYLOADS          4226    // LINK
#define DID_ENTRYPOINT          4227    // LINK
#define DID_ALIGNMENT           4228    // LINK
#define DID_STACKRESERVE        4229    // LINK
#define DID_STACKCOMMIT         4230    // LINK
#define DID_VERMAJOR            4231    // LINK
#define DID_VERMINOR            4232    // LINK
#define DID_OSVERMAJOR          4233    // LINK
#define DID_OSVERMINOR          4234    // LINK
#define DID_SUBSYSTEM           4235    // LINK
#define DID_SUBSYSMAJOR         4236    // LINK
#define DID_SUBSYSMINOR         4237    // LINK
#define DID_VERBOSE             4238    // PROJ, RC, MC, LINK, LIB, INST, CAB, SIGN
#define DID_SIGN                4239    // SIGN (5.0)
#define DID_CERTIFICATE         4240    // SIGN (5.0)
#define DID_TIMESTAMPSERVER     4241    // SIGN (5.0)
#define DID_PROGRESS            4242
#define DID_FINDWHAT            4243
#define DID_REPLACEWITH         4244
#define DID_SEARCHUP            4245
#define DID_SEARCHDOWN          4246
#define DID_MATCHCASE           4247
#define DID_WHOLEWORD           4248    // 6.0
#define DID_REGEX               4249    // 11.0
#define DID_FINDSCOPE           4250    // 9.0
#define DID_FINDSCOPELABEL      4251    // 9.0
#define DID_FINDSPEC            4252    // 7.0: DID_FINDFORMAT -> DID_FINDSPEC
#define DID_FINDPATH            4253
#define DID_SUBFOLDERS          4254
#define DID_LINENO              4255
#define DID_ADDRESS             4256
#define DID_FUNCNAME            4257
#define DID_LABELLIST           4258
#define DID_LABELNAME           4259
#define DID_LABELVALUE          4260
#define DID_INCLUDES            4261
#define DID_TOOLS               4262
#define DID_TOOLTEXT            4263
#define DID_TOOLCOMMAND         4264
#define DID_TOOLARGUMENTS       4265
#define DID_TOOLFOLDER          4266
#define DID_TOOLCAPTURE         4267
#define DID_HELPFILES           4268
#define DID_HELPTEXT            4269
#define DID_HELPCOMMAND         4270
#define DID_HELPBUILTIN         4271    // 7.0
#define DID_KEYCATEGORIES       4272
#define DID_KEYCOMMANDS         4273
#define DID_KEYLIST             4274
#define DID_ADDINS              4275
#define DID_ADDINTEXT           4276    // 9.0: stc32 -> DID_ADDINTEXT
#define DID_SNIPPETGROUP        4277    // 5.0
#define DID_SNIPPETS            4278    // 5.0
#define DID_SNIPPETNAME         4279    // 5.0
#define DID_SNIPPETCODE         4280    // 5.0
#define DID_IMPORTASLIST        4281    // 4.50 (from 3.0 radio buttons)
#define DID_CUSTOMLIST          4282
#define DID_CUSTOMSAMPLE        4283
#define DID_RETAINRATIO         4284    // 5.0
#define DID_DEGREES             4285
#define DID_RADIUS              4286
#define DID_AMOUNT              4287
#define DID_CURVATURE           4288
#define DID_OFFSETX             4289    // 4.0
#define DID_OFFSETXSPIN         4290    // 4.0
#define DID_OFFSETY             4291    // 4.0
#define DID_OFFSETYSPIN         4292    // 4.0
#define DID_HUE                 4293
#define DID_HUESPIN             4294    // 5.0
#define DID_SATURATION          4295
#define DID_SATURATIONSPIN      4296    // 5.0
#define DID_BRIGHTNESS          4297
#define DID_BRIGHTNESSSPIN      4298    // 5.0
#define DID_PREVIEW             4299
#define DID_TOOLBAR             4300
#define DID_GENERIC             4301
#define DID_GENERIC2            4302    // 6.0
#define DID_PROJECTLIST         4303    // 4.0
#define DID_DEPENDENCYLIST      4304    // 4.0
#define DID_MODENAME            4305    // 9.0
#define DID_ZIPCOMMENT          4306
#define DID_ZIPFILES            4307
#define DID_BROWSETAGS          4308
#define DID_BREAKONHITCOUNT     4309    // 4.0
#define DID_BREAKCOUNT          4310    // 4.0
#define DID_BREAKONEXPRESSION   4311    // 4.0
#define DID_BREAKEXPRESSION     4312    // 4.0
#define DID_BREAKENABLED        4313    // 4.0
#define DID_WATCHBYLIST         4314    // 4.0
#define DID_WATCHLIST           4315
#define DID_WATCHBYEXPRESSION   4316    // 4.0
#define DID_WATCHEXPRESSION     4317    // 4.0
#define DID_WATCHRESULT         4318    // 4.0
#define DID_HWBREAKTYPE1        4319    // 4.0
#define DID_HWBREAKTYPE2        4320    // 4.0
#define DID_HWBREAKTYPE3        4321    // 4.0
#define DID_HWBREAKTYPE4        4322    // 4.0
#define DID_HWBREAKADDRESS1     4323    // 4.0
#define DID_HWBREAKADDRESS2     4324    // 4.0
#define DID_HWBREAKADDRESS3     4325    // 4.0
#define DID_HWBREAKADDRESS4     4326    // 4.0
#define DID_HWBREAKSIZE1        4327    // 4.0
#define DID_HWBREAKSIZE2        4328    // 4.0
#define DID_HWBREAKSIZE3        4329    // 4.0
#define DID_HWBREAKSIZE4        4330    // 4.0
#define DID_CF                  4331
#define DID_PF                  4332
#define DID_AF                  4333
#define DID_ZF                  4334
#define DID_SF                  4335
#define DID_DF                  4336
#define DID_OF                  4337
#define DID_IM                  4338
#define DID_DM                  4339
#define DID_ZM                  4340
#define DID_OM                  4341
#define DID_UM                  4342
#define DID_PM                  4343
#define DID_PC0                 4344
#define DID_PC1                 4345
#define DID_PC2                 4346
#define DID_PC3                 4347
#define DID_RC0                 4348
#define DID_RC1                 4349
#define DID_RC2                 4350
#define DID_RC3                 4351
#define DID_IE                  4352
#define DID_DE                  4353
#define DID_ZE                  4354
#define DID_OE                  4355
#define DID_UE                  4356
#define DID_PE                  4357
#define DID_STKFAULT            4358
#define DID_ES                  4359
#define DID_TOP                 4360
#define DID_TAG0                4361
#define DID_TAG1                4362
#define DID_TAG2                4363
#define DID_TAG3                4364
#define DID_TAG4                4365
#define DID_TAG5                4366
#define DID_TAG6                4367
#define DID_TAG7                4368
#define DID_DAZ                 4369
#define DID_FZ                  4370
#define DID_PALETTE             4371    // 4.0
#define DID_HSV                 4372    // 4.0
#define DID_RED                 4373    // 4.0
#define DID_REDSPIN             4374    // 5.0
#define DID_GREEN               4375    // 4.0
#define DID_GREENSPIN           4376    // 5.0
#define DID_BLUE                4377    // 4.0
#define DID_BLUESPIN            4378    // 5.0
#define DID_ALPHA               4379    // 4.0
#define DID_ALPHASPIN           4380    // 5.0
#define DID_ALPHALABEL          4381    // 4.0
#define DID_ALPHATRACK          4382    // 4.0
#define DID_ALPHAFRAME          4383    // 4.0
#define DID_PALINDEX            4384    // 6.50
#define DID_URL                 4385    // 7.0
#define DID_LEFT                4386    // 7.0
#define DID_RIGHT               4387    // 7.0
#define DID_DEEP                4388    // 7.0

// Private Button ID's.
#define IDOK                    1       // For help project.
#define IDCANCEL                2       // For help project.
#define IDADD                   21
#define IDCHANGE                22
#define IDDEL                   23
#define IDDEFAULT               24
#define IDREPLACE               25
#define IDREPLACEALL            26
#define IDBROWSE                27
#define IDTYPEDKEY              28
#define IDSETUP                 29
#define IDSYSDEFS               30      // 5.0
#define IDBROWSE2               31      // 7.0
#define IDRENAME                32      // 9.0

//
// Various resource ID's ----------------------------------------------------
//

// Menu ID's.
//
#define IDR_MNU_MAIN            2001
#define IDR_MNU_MODE            2002    // 10.0
#define IDR_MNU_EDIT            2003
#define IDR_MNU_DRAW            2004    // 10.0: IDR_MNU_PICT -> IDR_MNU_DRAW
#define IDR_MNU_FORM            2005
#define IDR_MNU_MENU            2006
#define IDR_MNU_MESS            2007    // 3.0
#define IDR_MNU_RSRC            2008
#define IDR_MNU_DBG             2009
#define IDR_MNU_WEB             2010    // 7.0
#define IDR_MNU_DIFF            2011    // 7.0

#define IDR_CTX_EDIT            2012
#define IDR_CTX_DRAW            2013    // 10.0: IDR_CTX_PICT -> IDR_CTX_DRAW
#define IDR_CTX_FORM            2014
#define IDR_CTX_TEXT            2015
#define IDR_CTX_MESS            2016    // 3.0
#define IDR_CTX_MENU            2017
#define IDR_CTX_ACCL            2018
#define IDR_CTX_VERS            2019
#define IDR_CTX_ANIM            2020
#define IDR_CTX_RSRC            2021
#define IDR_CTX_DUMP            2022
#define IDR_CTX_PROF            2023    // 6.50
#define IDR_CTX_PROJPANE        2024    // 4.0
#define IDR_CTX_PROJSRCWKS      2025    // 4.0
#define IDR_CTX_PROJSRCPROJ     2026    // 4.0
#define IDR_CTX_PROJSRCFILE     2027    // 4.0
#define IDR_CTX_PROJSRCFUNC     2028    // 8.0
#define IDR_CTX_PROJTARGWKS     2029    // 5.0
#define IDR_CTX_PROJTARGPROJ    2030    // 4.0
#define IDR_CTX_PROJTARGFILE    2031    // 4.0
#define IDR_CTX_BUILD           2032
#define IDR_CTX_PROPS           2033
#define IDR_CTX_FILEFIND        2034    // 10.0
#define IDR_CTX_OUTPUT          2035
#define IDR_CTX_TRACE           2036
#define IDR_CTX_DBGSRC          2037
#define IDR_CTX_DBGMIX          2038
#define IDR_CTX_BREAK           2039    // 4.0
#define IDR_CTX_WATCH           2040
#define IDR_CTX_SYMBOL          2041    // 4.50
#define IDR_CTX_MEMORY          2042    // 4.50
#define IDR_CTX_THREAD          2043    // 6.50
#define IDR_CTX_REGS            2044    // 5.0
#define IDR_CTX_DROP            2045
#define IDR_CTX_TABS            2046
#define IDR_CTX_WEB             2047    // 7.0
#define IDR_CTX_DIFFOUTLINE     2048    // 7.0
#define IDR_CTX_DIFFEXPAND      2049    // 7.0

#define IDR_ACC_MAIN            3001

// Bitmap ID's.
//
#define IDR_BMP_BANNER          8001    // About banner.
#define IDR_BMP_BRUSHTYPES      8002
#define IDR_BMP_SELTYPES        8003
#define IDR_BMP_ERASETYPES      8004
#define IDR_BMP_LINETYPES       8005    // 4.0
#define IDR_BMP_SHAPETYPES      8006
#define IDR_BMP_SPRAYTYPES      8007
#define IDR_BMP_ZOOMTYPES       8008
#define IDR_BMP_GRADTYPES       8009    // 5.0
#define IDR_BMP_HANDLE1         8010
#define IDR_BMP_HANDLE2         8011
#define IDR_BMP_MACROLIST       8012
#define IDR_BMP_SYMTREE         8013
#define IDR_BMP_HELPTREE        8014    // 7.0
#define IDR_BMP_MDITABS         8015    // 8.0
#define IDR_BMP_HOT_MDITABS     8016    // 8.0
#define IDR_BMP_RSRCTREE        8017
#define IDR_BMP_PROJTREE        8018
#define IDR_BMP_PROJBROW        8019
#define IDR_BMP_EDITCUES        8020
#define IDR_BMP_BREAKCUES       8021    // 4.0
#define IDR_BMP_FORMCUES        8022    // 5.0
#define IDR_BMP_FONTCUES        8023    // 6.50
#define IDR_BMP_THRDCUES        8024    // 6.50
// Alpha channel patterns.
#define IDR_BMP_ALPHAZOOM2      8025    // 4.0
#define IDR_BMP_ALPHAZOOM6      8026    // 4.0
#define IDR_BMP_ALPHAZOOM8      8027    // 4.0

// Icon ID's.
//
#define IDR_ICO_MAIN            8028    // Application icon.
#define IDR_ICO_SRCFILE         8029    // Explorer association icon (.c, .asm).
#define IDR_ICO_WRKFILE         8030    // Explorer association icon (.h, .inc, .rc, ...).
#define IDR_ICO_SOURCE          8031
#define IDR_ICO_IMAGE           8032
#define IDR_ICO_DIALOG          8033
#define IDR_ICO_DEBUG           8034
#define IDR_ICO_PROFILE         8035    // 6.50
#define IDR_ICO_STRTABLE        8036
#define IDR_ICO_MSGTABLE        8037    // 3.0
#define IDR_ICO_MENU            8038
#define IDR_ICO_ACCEL           8039
#define IDR_ICO_VERSION         8040
#define IDR_ICO_ANIM            8041
#define IDR_ICO_RESOURCE        8042
#define IDR_ICO_HEXDUMP         8043
#define IDR_ICO_DIFF            8044    // 7.0
#define IDR_ICO_W32APP          8045
#define IDR_ICO_W32DLL          8046
#define IDR_ICO_W32LIB          8047
#define IDR_ICO_W32CON          8048
#define IDR_ICO_W32INST         8049    // 5.0
#define IDR_ICO_W64APP          8050    // 5.0
#define IDR_ICO_W64DLL          8051    // 5.0
#define IDR_ICO_W64LIB          8052    // 5.0
#define IDR_ICO_W64CON          8053    // 5.0
#define IDR_ICO_PPCAPP          8054
#define IDR_ICO_PPCDLL          8055
#define IDR_ICO_PPCLIB          8056
#define IDR_ICO_PPCINST         8057    // 5.0
#define IDR_ICO_SPAPP           8058
#define IDR_ICO_SPDLL           8059
#define IDR_ICO_SPLIB           8060
#define IDR_ICO_SPINST          8061    // 5.0
#define IDR_ICO_WIZARD          8062
#define IDR_ICO_CHECK           8063
// Objects and actions.
#define IDR_ICO_OPEN            8064    // 6.50
#define IDR_ICO_SAVE            8065    // 6.50
#define IDR_ICO_SAVEALL         8066    // 6.50
#define IDR_ICO_PRINT           8067    // 6.50
#define IDR_ICO_PROPERTIES      8068    // 6.50

#define IDR_ICO_UNDO            8069    // 6.50
#define IDR_ICO_REDO            8070    // 6.50
#define IDR_ICO_CUT             8071    // 6.50
#define IDR_ICO_COPY            8072    // 6.50
#define IDR_ICO_PASTE           8073    // 6.50
#define IDR_ICO_DELETE          8074    // 6.50
#define IDR_ICO_INSERT          8075    // 6.50
#define IDR_ICO_EDIT            8076    // 6.50
#define IDR_ICO_FIND            8077    // 6.50
#define IDR_ICO_FINDNEXT        8078    // 6.50
#define IDR_ICO_FILEFIND        8079    // 6.50

#define IDR_ICO_TABPAGES        8080    // 6.50
#define IDR_ICO_CASCADE         8081    // 6.50
#define IDR_ICO_TILEHORZ        8082    // 6.50
#define IDR_ICO_TILEVERT        8083    // 6.50
#define IDR_ICO_TOOL            8084    // 6.50
#define IDR_ICO_HELP            8085    // 6.50
#define IDR_ICO_WEB             8086    // 6.50
#define IDR_ICO_USER            8087    // 6.50

#define IDR_ICO_BITMAP          8088    // 6.50
#define IDR_ICO_ICON            8089    // 6.50
#define IDR_ICO_CURSOR          8090    // 6.50
#define IDR_ICO_ANICURSOR       8091    // 6.50
#define IDR_ICO_VIDEO           8092    // 6.50

#define IDR_ICO_FOLDER          8093    // 6.50
#define IDR_ICO_MOVEUP          8094    // 6.50
#define IDR_ICO_MOVEDOWN        8095    // 6.50
#define IDR_ICO_RENAME          8096    // 6.50

#define IDR_ICO_BACK            8097    // 7.0
#define IDR_ICO_FORWARD         8098    // 7.0
#define IDR_ICO_HOME            8099    // 8.0
#define IDR_ICO_REFRESH         8100    // 7.0
#define IDR_ICO_CERTIFICATE     8101    // 7.0

// Debugger.
#define IDR_ICO_GODEBUG         8102    // 6.50
#define IDR_ICO_RESTART         8103    // 6.50
#define IDR_ICO_BREAK           8104    // 6.50
#define IDR_ICO_STOPDEBUG       8105    // 6.50, 7.0: IDR_ICO_STOP -> IDR_ICO_STOPDEBUG
#define IDR_ICO_STEPINTO        8106    // 6.50
#define IDR_ICO_STEPOVER        8107    // 6.50
#define IDR_ICO_STEPOUT         8108    // 6.50
#define IDR_ICO_QUICKWATCH      8109    // 6.50
#define IDR_ICO_TOGGLEBRKPT     8110    // 6.50
#define IDR_ICO_SHOWNEXTSTMT    8111    // 6.50
// Projects.
#define IDR_ICO_SOURCEFILES     8112    // 6.50
#define IDR_ICO_TARGETFILES     8113    // 6.50
#define IDR_ICO_BUILD           8114    // 6.50
#define IDR_ICO_STOPBUILD       8115    // 6.50
#define IDR_ICO_COMPILE         8116    // 6.50
#define IDR_ICO_EXECUTE         8117    // 6.50
#define IDR_ICO_ADDFILE         8118    // 6.50
#define IDR_ICO_ADDPROJ         8119    // 6.50
#define IDR_ICO_ZIP             8120    // 6.50
#define IDR_ICO_UNZIP           8121    // 6.50
#define IDR_ICO_MAKEPREQ        8122    // 6.50
#define IDR_ICO_SETACTIVE       8123    // 6.50
#define IDR_ICO_SETTINGS        8124    // 6.50
#define IDR_ICO_EXCLUDE         8125    // 6.50
#define IDR_ICO_CLOSEPROJ       8126    // 6.50
#define IDR_ICO_VIEWLIST        8127    // 6.50
#define IDR_ICO_VIEWICON        8128    // 6.50
#define IDR_ICO_ADVANCED        8129    // 6.50
#define IDR_ICO_STANDARD        8130    // 6.50
// Image editor.
#define IDR_ICO_PENCIL          8131    // 6.50
#define IDR_ICO_BRUSH           8132    // 6.50
#define IDR_ICO_SELECT          8133    // 6.50
#define IDR_ICO_ERASER          8134    // 6.50
#define IDR_ICO_LINE            8135    // 6.50
#define IDR_ICO_RECT            8136    // 6.50
#define IDR_ICO_ELLIPSE         8137    // 6.50
#define IDR_ICO_ROUNDRECT       8138    // 6.50
#define IDR_ICO_FILL            8139    // 6.50
#define IDR_ICO_DRAWTEXT        8140    // 6.50
#define IDR_ICO_SPRAY           8141    // 6.50
#define IDR_ICO_PICKCOLOR       8142    // 6.50
#define IDR_ICO_MAGNIFY         8143    // 6.50
#define IDR_ICO_HOTSPOT         8144    // 6.50
#define IDR_ICO_GRADIENT        8145    // 6.50
#define IDR_ICO_PALETTE         8146    // 6.50
#define IDR_ICO_OPENPALETTE     8147    // 6.50
#define IDR_ICO_SAVEPALETTE     8148    // 6.50
#define IDR_ICO_ROTATE          8149    // 6.50
#define IDR_ICO_MIRRORVERT      8150    // 6.50
#define IDR_ICO_MIRRORHORZ      8151    // 6.50
#define IDR_ICO_RESIZE          8152    // 6.50
#define IDR_ICO_NEWIMAGE        8153    // 6.50
// Dialog editor.
#define IDR_ICO_TESTDIALOG      8154    // 6.50
#define IDR_ICO_CHECKMNEMONICS  8155    // 6.50
#define IDR_ICO_LOCKCONTROLS    8156    // 6.50
#define IDR_ICO_ORDERCONTROLS   8157    // 6.50
#define IDR_ICO_ALIGNLEFT       8158    // 6.50
#define IDR_ICO_ALIGNRIGHT      8159    // 6.50
#define IDR_ICO_ALIGNTOP        8160    // 6.50
#define IDR_ICO_ALIGNBOTTOM     8161    // 6.50
#define IDR_ICO_ALIGNHORZ       8162    // 6.50
#define IDR_ICO_ALIGNVERT       8163    // 6.50
#define IDR_ICO_SPACEHORZ       8164    // 6.50
#define IDR_ICO_SPACEVERT       8165    // 6.50
#define IDR_ICO_ARRSIZEWIDTH    8166    // 6.50
#define IDR_ICO_ARRSIZEHEIGHT   8167    // 6.50
#define IDR_ICO_ARRSIZEBOTH     8168    // 6.50
#define IDR_ICO_ARRPUSHBOTTOM   8169    // 6.50
#define IDR_ICO_ARRPUSHRIGHT    8170    // 6.50
#define IDR_ICO_CENTERHORZ      8171    // 6.50
#define IDR_ICO_CENTERVERT      8172    // 6.50
// Dialog controls.
#define IDR_ICO_POINTER         8173    // 6.50
#define IDR_ICO_PICTURE         8174    // 6.50
#define IDR_ICO_STATIC          8175    // 6.50
#define IDR_ICO_EDITBOX         8176    // 6.50
#define IDR_ICO_GROUPBOX        8177    // 6.50
#define IDR_ICO_PUSHBUTTON      8178    // 6.50
#define IDR_ICO_CHECKBOX        8179    // 6.50
#define IDR_ICO_RADIOBUTTON     8180    // 6.50
#define IDR_ICO_COMBOBOX        8181    // 6.50
#define IDR_ICO_LISTBOX         8182    // 6.50
#define IDR_ICO_HSCROLLBAR      8183    // 6.50
#define IDR_ICO_VSCROLLBAR      8184    // 6.50
#define IDR_ICO_UPDOWN          8185    // 6.50
#define IDR_ICO_PROGRESS        8186    // 6.50
#define IDR_ICO_TRACKBAR        8187    // 6.50
#define IDR_ICO_HOTKEY          8188    // 6.50
#define IDR_ICO_LISTVIEW        8189    // 6.50
#define IDR_ICO_TREEVIEW        8190    // 6.50
#define IDR_ICO_TABCONTROL      8191    // 6.50
#define IDR_ICO_ANIMATE         8192    // 6.50
#define IDR_ICO_RICHEDIT        8193    // 6.50
#define IDR_ICO_RICHED20        8194    // 6.50
#define IDR_ICO_DATETIME        8195    // 6.50
#define IDR_ICO_MONTHCAL        8196    // 6.50
#define IDR_ICO_COMBOBOXEX      8197    // 6.50
#define IDR_ICO_REBAR           8198    // 6.50
#define IDR_ICO_PAGER           8199    // 6.50
#define IDR_ICO_TOOLBAR         8200    // 6.50
#define IDR_ICO_STATUSBAR       8201    // 6.50
#define IDR_ICO_SYSLINK         8202    // 6.50
#define IDR_ICO_IPADDRESS       8203    // 6.50
#define IDR_ICO_NETADDRESS      8204    // 6.50
#define IDR_ICO_SPLITBUTTON     8205    // 6.50
#define IDR_ICO_COMMANDLINK     8206    // 6.50
#define IDR_ICO_NATIVEFONT      8207    // 6.50
// Menu editor.
#define IDR_ICO_TESTMENU        8208    // 6.50
// Source editor.
#define IDR_ICO_SETBOOKMARK     8209    // 6.50
#define IDR_ICO_NEXTBOOKMARK    8210    // 6.50
#define IDR_ICO_PREVBOOKMARK    8211    // 6.50
#define IDR_ICO_CFORMAT         8212    // 6.50
#define IDR_ICO_SPACETOTAB      8213    // 6.50
#define IDR_ICO_TABTOSPACE      8214    // 6.50
// Difference.
#define IDR_ICO_PREVCHANGE      8215    // 7.0
#define IDR_ICO_NEXTCHANGE      8216    // 7.0
#define IDR_ICO_EXPANDED        8217    // 7.0
#define IDR_ICO_COLLAPSED       8218    // 7.0

// Cursor ID's.
//
#define IDR_CUR_RESIZELR        8219
#define IDR_CUR_RESIZEUD        8220
#define IDR_CUR_HOTSPOT         8221
#define IDR_CUR_FLOOD           8222
#define IDR_CUR_SPRAY           8223
#define IDR_CUR_CROSS           8224
#define IDR_CUR_PENCIL          8225
#define IDR_CUR_PICKCOLOR       8226
#define IDR_CUR_MAGNIFY         8227
#define IDR_CUR_OUTSEL          8228
#define IDR_CUR_MOVE            8229
#define IDR_CUR_DROPTOOL        8230
#define IDR_CUR_DRAGMOVE        8231
#define IDR_CUR_DRAGCOPY        8232
#define IDR_CUR_NODROP          8233

// Misc ID's.
//
#define IDR_JPG_SPLASH          8234
#define IDR_RAW_ANIFRAME        8235
#define IDR_DLL_SERVER          8236    // 4.50
#define IDR_WAV_DOH             8237
#define IDR_HTM_WELCOME         8238    // 7.0

#endif // H_IDS
