<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:dap="#dap-functions" exclude-result-prefixes="msxsl dap">
    <xsl:output method="html" version="4.0" indent="yes"/>
	<ox:meta inputtype="ReportML" outputtype="DataPage" displayname="Data Access Page" visible="false" xmlns:ox="urn:schemas-microsoft-com:officexsl"/>

	<xsl:template match="/">
		<!-- Assemble HTML tag with appropriate namespaces -->
		<xsl:value-of select="dap:OpenHTMLTag(true)" disable-output-escaping="yes"/>
		<xsl:choose>
			<xsl:when test="RPTML/REPORT[1]/SMART-TAG-NAMESPACES">
				<xsl:value-of select="RPTML/REPORT[1]/SMART-TAG-NAMESPACES"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="dap:OfficeNamespace()"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="dap:AccessNamespace()"/>
		<xsl:value-of select="dap:REChtmlNamespace()"/>
		<xsl:if test="RPTML/REPORT[DIR='right-to-left']">
			<xsl:value-of select="dap:RTLAttrib()" disable-output-escaping="yes"/>
		</xsl:if>
		<xsl:value-of select="dap:OpenHTMLTag(false())" disable-output-escaping="yes"/>

			<HEAD xmlns="http://www.w3.org/TR/REC-html40">
				<META name="ProgId" content="Access.Application"/>
				<META name="VBSForEventHandlers" value="true"/>
				<META http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
				<META name="DesignerVersion" content="10.00.2225"/>
				<TITLE>
					<xsl:value-of select="RPTML/REPORT[1]/TITLE"/>
				</TITLE>
				<xsl:apply-templates select="RPTML/REPORT[1]/SMART-TAG-TAGTYPES"/>
				<xsl:if test="RPTML/REPORT[1]/SMART-TAG-CLSID">
					<xsl:element name="OBJECT">
						<xsl:attribute name="classid"><xsl:value-of select="RPTML/REPORT[1]/SMART-TAG-CLSID/SMART-TAG-CLSID-CLSID"/></xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="RPTML/REPORT[1]/SMART-TAG-CLSID/SMART-TAG-CLSID-ID"/></xsl:attribute>
						<![CDATA[]]>
					</xsl:element>
				</xsl:if>
				<xsl:if test="RPTML/REPORT[1]/RECORD-SOURCE">
				<OBJECT classid="CLSID:0002E553-0000-0000-C000-000000000046" id="MSODSC" tabIndex="-1">
						<PARAM NAME="XMLData" VALUE="{dap:GetDataSourceControl(.)}">
						</PARAM>
					</OBJECT>
				</xsl:if>

				<xsl:if test="RPTML/REPORT[1]/SMART-TAG-IEOOUI-STYLE">
					<STYLE>
						<xsl:value-of select="RPTML/REPORT[1]/SMART-TAG-IEOOUI-STYLE"/>
					</STYLE>
				</xsl:if>

			</HEAD>
			<STYLE id="MSODAPDEFAULTS" type="text/css">
				<xsl:variable name="localeFont" select="dap:GetLocaleFontFamily(.)"/>
				.MSTheme-Label { BORDER-RIGHT: 0px; PADDING-RIGHT: 3px; BORDER-TOP: 0px; PADDING-LEFT: 3px; OVERFLOW: visible; BORDER-LEFT: 0px; WIDTH: 1in; BORDER-BOTTOM: 0px; HEIGHT: 0.156in; TEXT-ALIGN: left; <xsl:value-of select="$localeFont"/> }
				.MsoTextbox { PADDING-RIGHT: 3px; PADDING-LEFT: 3px; OVERFLOW: hidden; WIDTH: 1in; HEIGHT: 0.197in; <xsl:value-of select="$localeFont"/>}
				.MsoBoundSpan { BORDER-RIGHT: 0px; PADDING-RIGHT: 3px; BORDER-TOP: 0px; PADDING-LEFT: 3px; OVERFLOW: hidden; BORDER-LEFT: 0px; BORDER-BOTTOM: 0px; TEXT-ALIGN: left; <xsl:value-of select="$localeFont"/> }
				.MsoHyperlinkDisplayText { BORDER-RIGHT: 0px; PADDING-RIGHT: 3px; BORDER-TOP: 0px; PADDING-LEFT: 3px; OVERFLOW: hidden; BORDER-LEFT: 0px; CURSOR: hand; BORDER-BOTTOM: 0px; TEXT-ALIGN: left; <xsl:value-of select="$localeFont"/> }
				.Mso2dSection { LEFT: 0px; BEHAVIOR: url(#DEFAULT#Mso2dSection); OVERFLOW: hidden; POSITION: relative; TOP: 0px; BACKGROUND-COLOR: transparent }
				.Mso2dSectionBanner { PADDING-RIGHT: 4px; DISPLAY: none; PADDING-LEFT: 4px; FONT-WEIGHT: normal; LEFT: 0px; BEHAVIOR: url(#DEFAULT#Mso2dSectionBanner); PADDING-TOP: 2px; TOP: 0px; HEIGHT: 0.2in; BACKGROUND-COLOR: buttonface; <xsl:value-of select="$localeFont"/> }
				.MsoRectangle { BORDER-RIGHT: black 1px solid; BORDER-TOP: black 1px solid; OVERFLOW: hidden; BORDER-LEFT: black 1px solid; BORDER-BOTTOM: black 1px solid }
				.MsoTitle { DISPLAY: none; FONT-WEIGHT: normal; COLOR: inactivecaptiontext }
				.MsoExpandCollapse { CURSOR: hand }
				.MsoNavContainer { BORDER-RIGHT: gainsboro 1px solid; BORDER-TOP: gainsboro 1px solid; Z-INDEX: -1; BORDER-LEFT: gainsboro 1px solid; CURSOR: hand; BORDER-BOTTOM: gainsboro 1px solid; POSITION: absolute; HEIGHT: 25px; BACKGROUND-COLOR: gainsboro}
				.MsoNavButton {	BORDER-RIGHT: gainsboro 1px solid; BORDER-TOP: gainsboro 1px solid; BORDER-LEFT: gainsboro 1px solid; CURSOR: auto; BORDER-BOTTOM: gainsboro 1px solid; BACKGROUND-REPEAT: no-repeat}				
				.MsoNavButtonMouseOver { BORDER-RIGHT: highlight 1px solid; BORDER-TOP: highlight 1px solid; BORDER-LEFT: highlight 1px solid; BORDER-BOTTOM: highlight 1px solid; BACKGROUND-COLOR: buttonhighlight}
				.MsoNavToggleButtonMouseOver { BORDER-RIGHT: highlight 1px solid; BORDER-TOP: highlight 1px solid; BORDER-LEFT: highlight 1px solid; BORDER-BOTTOM: highlight 1px solid; BACKGROUND-REPEAT: no-repeat; BACKGROUND-COLOR: buttonhighlight}
				.MsoNavButtonMouseDown { BORDER-RIGHT: buttonshadow 1px solid; BORDER-TOP: buttonshadow 1px solid; BORDER-LEFT: buttonshadow 1px solid; CURSOR: hand; BORDER-BOTTOM: buttonshadow 1px solid; BACKGROUND-COLOR: buttonshadow }
				.MsoNavRecordsetLabel { BORDER-RIGHT: gainsboro 1px solid; BORDER-TOP: gainsboro 1px solid; PADDING-LEFT: 0px; FONT-SIZE: 8pt; OVERFLOW: hidden; BORDER-LEFT: gainsboro 1px solid; WIDTH: 100%; CURSOR: default; PADDING-TOP: 0px; BORDER-BOTTOM: gainsboro 1px solid; <xsl:value-of select="$localeFont"/> }
				.MsoRecordSelector { BORDER-RIGHT: Buttonshadow 1px solid; BORDER-TOP: Buttonshadow 1px solid; OVERFLOW: hidden; BORDER-LEFT: Buttonshadow 1px solid; WIDTH: 0.17in; BORDER-BOTTOM: buttonshadow 1px solid; HEIGHT: 100%; BACKGROUND-COLOR: gainsboro}
				.MsoRecordSelectorCurrent { BACKGROUND-POSITION: 1px 0px; BACKGROUND-IMAGE: <xsl:value-of select="dap:IsRightToLeft(.,&quot;url(owc://GIF/#11240);&quot;,&quot;url(owc://GIF/#11243);&quot;)"/> BACKGROUND-REPEAT: no-repeat }
				.MsoRecordSelectorSelectedImage { BACKGROUND-POSITION: 1px 0px; BACKGROUND-IMAGE: <xsl:value-of select="dap:IsRightToLeft(.,&quot;url(owc://GIF/#11241);&quot;,&quot;url(owc://GIF/#11244);&quot;)"/> BACKGROUND-REPEAT: no-repeat }
				.MsoRecordSelectorSelected { BORDER-RIGHT: buttonshadow 1px solid; BORDER-TOP: buttonshadow 1px solid; LEFT: 0px; OVERFLOW: hidden; BORDER-LEFT: buttonshadow 1px solid; WIDTH: 0.17in; BORDER-BOTTOM: buttonshadow 1px solid; TOP: 0px; HEIGHT: 100%; BACKGROUND-COLOR: buttonshadow; POSTION: relative}
				.MsoRecordSelectorDirty { BACKGROUND-POSITION: -1px 0px; BACKGROUND-IMAGE: url(owc://GIF/#11242); BACKGROUND-REPEAT: no-repeat }
				.MsoRecordSelectorTransparent { LEFT: 0px; OVERFLOW: hidden; WIDTH: 0.17in; TOP: 0px; POSTION: relative }
				HR { COLOR: black }
				SELECT { <xsl:value-of select="$localeFont"/> }
				INPUT { <xsl:value-of select="$localeFont"/> }
				BODY { FONT-SIZE: 10pt; FONT-FAMILY: Tahoma }
				MARQUEE { <xsl:value-of select="$localeFont"/> }
				LEGEND { <xsl:value-of select="$localeFont"/> }
				BUTTON { <xsl:value-of select="$localeFont"/> }
				TEXTAREA { <xsl:value-of select="$localeFont"/> }
			
				<xsl:choose>
					<xsl:when test="dap:IsDataSheetHelper(.)">
						.MSODatasheetText { <xsl:value-of select="dap:GetDatasheetStyle(.)"/> }					
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="/RPTML/REPORT[1]/STYLE"/>		
					</xsl:otherwise>
				</xsl:choose>
			</STYLE>
			<BODY link="{dap:GetLink(.)}" vlink="{dap:GetVLink(.)}" style="OVERFLOW: auto; {dap:GetBodyStyle(.)}">
				<xsl:if test="RPTML/REPORT[DIR='right-to-left']">
					<xsl:attribute name="DIR">RTL</xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="RPTML/REPORT[1][DEFAULT-VIEW='pivottable']">
						<OBJECT classid="CLSID:0002E552-0000-0000-C000-000000000046" id="PivotTable">
							<PARAM NAME="XMLData" VALUE="{RPTML/REPORT[1]/PIVOTTABLE-XML}">
							</PARAM>
						</OBJECT>
					</xsl:when>
					<xsl:when test="RPTML/REPORT[1][DEFAULT-VIEW='pivotchart']">
						<OBJECT classid="CLSID:0002E552-0000-0000-C000-000000000046" id="PivotTable" style="width: 0; height: 0; visibility: hidden">
							<PARAM NAME="XMLData" VALUE="{RPTML/REPORT[1]/PIVOTTABLE-XML}">
							</PARAM>
						</OBJECT>
						<OBJECT classid="CLSID:0002E556-0000-0000-C000-000000000046" id="PivotChart">
							<PARAM NAME="XMLData" VALUE="{RPTML/REPORT[1]/PIVOTCHART-XML}">
							</PARAM>
						</OBJECT>
						<SCRIPT language="VBScript">
							Sub Window_OnLoad()
								Set PivotChart.DataSource = PivotTable
							End Sub
						</SCRIPT>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="RPTML/REPORT[1]"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="RPTML/REPORT[1]/CODE">
<xsl:comment>
---------- BEGIN VBA CODE ----------
<xsl:value-of select="RPTML/REPORT[1]/CODE"/>
----------- END VBA CODE -----------
</xsl:comment>
				</xsl:if>

			</BODY>
		<xsl:value-of select="dap:CloseHTMLTag()" disable-output-escaping="yes"/>
	</xsl:template>

	<xsl:template match="RPTML/REPORT[1]/SMART-TAG-TAGTYPES" xmlns:o="urn:schemas-microsoft-com:office:office">
		<xsl:element name="o:SmartTagType">
		<xsl:attribute name="namespaceuri"><xsl:value-of select="SMART-TAG-TAGTYPES-URI"/></xsl:attribute>
		<xsl:attribute name="name"><xsl:value-of select="SMART-TAG-TAGTYPES-NAME"/></xsl:attribute>
		<xsl:if test="SMART-TAG-TAGTYPES-URL">
			<xsl:attribute name="downloadurl"><xsl:value-of select="SMART-TAG-TAGTYPES-URL"/></xsl:attribute>
		</xsl:if>
		</xsl:element>
	</xsl:template>

	<xsl:template match="SMART-TAG-OPEN">
		<xsl:value-of select="dap:GetSmartTag(., true)" disable-output-escaping="yes"/>
	</xsl:template>

	<xsl:template match="SMART-TAG-CLOSE">
		<xsl:value-of select="dap:GetSmartTag(., false())" disable-output-escaping="yes"/>
	</xsl:template>

	<xsl:template match="STYLE">
		.<xsl:value-of select="@id"/> { <xsl:value-of select="dap:GetSharedStyle(.)"/> }
	</xsl:template>

	<xsl:template match="REPORT">
		<xsl:choose>
			<xsl:when test="dap:IsDataSheetFormHelper(.)">
			<!-- special code if default view is a data sheet -->
				<xsl:for-each select="/RPTML/REPORT[1]/SECTION[@type='detail']">
						<!-- header -->
						<DIV>
							<xsl:attribute name="class">Mso2dSection</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="dap:GetCaptionID(.)"/></xsl:attribute>
							<xsl:attribute name="style"><xsl:value-of select="dap:GetSectionPositionHelper(.)"/>; POSITION: relative;<xsl:value-of select="dap:GetDatasheetTopBorder(.)"/></xsl:attribute>
							<xsl:value-of disable-output-escaping="yes" select="dap:GetColumnLabels(.)"/>
						</DIV>

						<!-- details -->
						<DIV>
							<xsl:attribute name="class">Mso2dSection</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="dap:GetSectionID(., 'detail')"/></xsl:attribute>
							<xsl:attribute name="style"><xsl:value-of select="dap:GetSectionPositionHelper(.)"/>; POSITION: relative</xsl:attribute>
							<xsl:value-of disable-output-escaping="yes" select="dap:GetColumnTextBoxes(.)"/>
						</DIV>		

						<!-- detail navigation section -->
						<xsl:if test="dap:IncludeNavigationSection(., 'detail')">
							<DIV>
								<xsl:attribute name="class">Mso2dSection</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="dap:GetSectionID(., 'detail_navigation')"/></xsl:attribute>
								<xsl:attribute name="style"><xsl:value-of select="dap:GetDetailNavigationStyle(.)"/></xsl:attribute>
								<xsl:if test="/RPTML/REPORT[1]/NAVIGATION-SECTION[text()='true']">
									<xsl:value-of disable-output-escaping="yes" select="dap:GetDetailNavBar(., '/RPTML/REPORT', false())"/>
								</xsl:if>
								<xsl:if test="dap:IncludeFooterSectionsHelper(., 'detail')">
									<xsl:apply-templates select="SECTION[@type='page_footer']"/>
									<xsl:apply-templates select="SECTION[@type='report_footer']"/>
								</xsl:if>
							</DIV>
						</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<!-- caption section -->
				<xsl:if test="SECTION[@type='report_header' or @type='page_header']">
					<DIV>
						<xsl:attribute name="class">Mso2dSection</xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetCaptionID(.)"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetFirstHeaderSectionStyle(.)"/>; <xsl:value-of select="dap:GetDatasheetTopBorder(.)"/></xsl:attribute>
						<xsl:apply-templates select="SECTION[@type='report_header']"/>
						<xsl:apply-templates select="SECTION[@type='page_header']"/>
					</DIV>
				</xsl:if>

				<!-- group header sections -->
				<xsl:for-each select="GROUP-LEVEL[GROUP-HEADER='true']">
					<DIV>
						<xsl:attribute name="class">Mso2dSection</xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetGroupID(., 'group_header')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetGroupStyle(., 'group_header')"/></xsl:attribute>
						<xsl:value-of disable-output-escaping="yes" select="dap:GetGroupHeaderExpando(.)"/>
						<xsl:apply-templates select="../SECTION[@type='group_header' and @idref=current()/@id]"/>
					</DIV>
				</xsl:for-each>

				<!-- detail section -->
				<xsl:if test="SECTION[@type='detail']">
					<DIV>
						<xsl:attribute name="class">Mso2dSection</xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetSectionID(., 'detail')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetDetailSectionStyle(.)"/></xsl:attribute>
						<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
						<xsl:apply-templates select="SECTION[@type='detail']"/>
					</DIV>
				</xsl:if>

				<!-- detail navigation section -->
				<xsl:if test="dap:IncludeNavigationSection(., 'detail')">
					<DIV>
						<xsl:attribute name="class">Mso2dSection</xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetSectionID(., 'detail_navigation')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetDetailNavigationStyle(.)"/></xsl:attribute>
						<xsl:if test="/RPTML/REPORT[1]/NAVIGATION-SECTION[text()='true']">
							<xsl:value-of disable-output-escaping="yes" select="dap:GetDetailNavBar(.,'', false())"/>
						</xsl:if>
						<xsl:if test="dap:IncludeFooterSectionsHelper(., 'detail')">
							<xsl:apply-templates select="SECTION[@type='page_footer']"/>
							<xsl:apply-templates select="SECTION[@type='report_footer']"/>
						</xsl:if>
					</DIV>
				</xsl:if>

				<!-- group footer sections -->
				<xsl:for-each select="GROUP-LEVEL">
					<xsl:if test="current()[GROUP-FOOTER='true']">
						<DIV>
							<xsl:attribute name="class">Mso2dSection</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="dap:GetGroupID(., 'group_footer')"/></xsl:attribute>
							<xsl:attribute name="style"><xsl:value-of select="dap:GetGroupStyle(., 'group_footer')"/></xsl:attribute>
							<xsl:apply-templates select="../SECTION[@type='group_footer' and @idref=current()/@id]"/>
						</DIV>
					</xsl:if>
					<xsl:if test="dap:IncludeNavigationSection(., 'group_footer')">
						<DIV>
							<xsl:attribute name="class">Mso2dSection</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="dap:GetGroupID(., 'group_navigation')"/></xsl:attribute>
							<xsl:attribute name="style"><xsl:value-of select="dap:GetGroupStyle(., 'group_navigation')"/></xsl:attribute>
							<xsl:if test="/RPTML/REPORT[1]/NAVIGATION-SECTION[text()='true']">
								<xsl:value-of disable-output-escaping="yes" select="dap:GetGroupNavBar(., false())"/>
							</xsl:if>
							<xsl:if test="dap:IncludeFooterSectionsHelper(., 'group_footer')">
								<xsl:apply-templates select="../SECTION[@type='page_footer']"/>
								<xsl:apply-templates select="../SECTION[@type='report_footer']"/>
							</xsl:if>
						</DIV>
					</xsl:if>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="SECTION">
		<xsl:apply-templates select="REPORT-TEXT | REPORT-ITEM"/>
	</xsl:template>

	<xsl:template match="REPORT-TEXT">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<xsl:value-of disable-output-escaping="yes" select="text()"/>
		</xsl:if>
	</xsl:template>

	<!-- NOTE: If you add more REPORT-ITEM types, update GetElementExtensions so they aren't skipped -->

	<xsl:template match="REPORT-ITEM[@type='text-box']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<xsl:apply-templates select="SMART-TAG-OPEN"/>
			<TEXTAREA>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'text')"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="dap:GetTextStyle(., 'text-box')"/>; POSITION: absolute</xsl:attribute>
				<xsl:if test="dap:IsGeneralTextAlign(.)"><xsl:attribute name="MsoTextAlign">General</xsl:attribute></xsl:if>
				<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
				<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
				<xsl:if test="current()[LOCKED='true']"><xsl:attribute name="readOnly">true</xsl:attribute></xsl:if>
				<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
				<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="ITLE[1]"/></xsl:attribute></xsl:if>
				<xsl:apply-templates select="./*[not(@smarttag)]"/>
			</TEXTAREA>
			<xsl:apply-templates select="SMART-TAG-CLOSE"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='label' and not(HREF)]">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<xsl:apply-templates select="SMART-TAG-OPEN"/>
			<SPAN>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'label')"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="dap:GetTextStyle(., 'label')"/>; POSITION: absolute</xsl:attribute>
				<xsl:if test="dap:IsGeneralTextAlign(.)"><xsl:attribute name="MsoTextAlign">General</xsl:attribute></xsl:if>
				<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
				<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
				<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
				<xsl:if test="ACCESS-KEY"><xsl:attribute name="accesskey"><xsl:value-of select="ACCESS-KEY"/></xsl:attribute></xsl:if>
				<xsl:apply-templates select="./*[not(@smarttag)]"/>
			</SPAN>
			<xsl:apply-templates select="SMART-TAG-CLOSE"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='label' and HREF]">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<A>
				<xsl:attribute name="href"><xsl:value-of select="HREF"/></xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/>_Anchor</xsl:attribute>
				<xsl:apply-templates select="SMART-TAG-OPEN"/>
				<SPAN>
					<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
					<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'hyperlink')"/></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="dap:GetHyperlinkStyle(.)"/>; POSITION: absolute</xsl:attribute>
					<xsl:if test="dap:IsGeneralTextAlign(.)"><xsl:attribute name="MsoTextAlign">General</xsl:attribute></xsl:if>
					<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
					<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
					<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
					<xsl:if test="ACCESS-KEY"><xsl:attribute name="accesskey"><xsl:value-of select="ACCESS-KEY"/></xsl:attribute></xsl:if>
					<xsl:apply-templates select="./*[not(@smarttag)]"/>
				</SPAN>
				<xsl:apply-templates select="SMART-TAG-CLOSE"/>
			</A>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='check-box']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<INPUT>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'check-box')"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="dap:GetCheckboxStyle(.)"/>; POSITION: absolute</xsl:attribute>
				<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
				<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
				<xsl:attribute name="type">checkbox</xsl:attribute>
				<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
				<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
				<xsl:apply-templates />
			</INPUT>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='radio-button']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			 <xsl:if test="dap:OrphanedRadioButton(.)">
				<INPUT>
					<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
					<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'radio-button')"/></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
					<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
					<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
					<xsl:attribute name="type">radio</xsl:attribute>
					<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
					<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
				<xsl:apply-templates />
				</INPUT>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='line']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<HR>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'line')"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="dap:GetLineStyle(.)"/>; POSITION: absolute</xsl:attribute>
				<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
				<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			</HR>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='rectangle']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<SPAN>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'rectangle')"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
				<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
				<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			</SPAN>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='image' and not(HREF)]">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
				<IMG>
					<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
					<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'image')"/></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="dap:GetImageStyle(.)"/>; POSITION: absolute</xsl:attribute>
					<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
					<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
					<xsl:if test="SRC"><xsl:attribute name="SRC"><xsl:value-of select="SRC"/></xsl:attribute></xsl:if>
					<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
				</IMG>
		</xsl:if>
	</xsl:template>


	<xsl:template match="REPORT-ITEM[@type='image' and HREF]">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<A> <xsl:attribute name="href"><xsl:value-of select="HREF"/></xsl:attribute>
				<IMG>
					<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
					<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'image')"/></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="dap:GetImageStyle(.)"/>; POSITION: absolute</xsl:attribute>
					<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
					<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
					<xsl:if test="SRC"><xsl:attribute name="SRC"><xsl:value-of select="SRC"/></xsl:attribute></xsl:if>
					<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
				</IMG>
			</A>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='list-box']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<xsl:choose>
				<xsl:when test="dap:IsReportHelper(.)">
					<xsl:apply-templates select="SMART-TAG-OPEN"/>
					<SPAN>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
						<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'list-box')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
						<xsl:if test="dap:IsGeneralTextAlign(.)"><xsl:attribute name="MsoTextAlign">General</xsl:attribute></xsl:if>
						<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
						<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
						<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
						<xsl:apply-templates select="./*[not(@smarttag)]"/>
					</SPAN>
					<xsl:apply-templates select="SMART-TAG-CLOSE"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="SMART-TAG-OPEN"/>
					<SELECT>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
						<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'list-box')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
						<xsl:if test="dap:IsGeneralTextAlign(.)"><xsl:attribute name="MsoTextAlign">General</xsl:attribute></xsl:if>
						<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
						<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:attribute name="type">select-one</xsl:attribute>
						<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
						<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
						<xsl:attribute name="size">8</xsl:attribute>
						<xsl:apply-templates select="./*[not(@smarttag)]"/>
					</SELECT>
					<xsl:apply-templates select="SMART-TAG-CLOSE"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='combo-box']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<xsl:choose>
				<xsl:when test="dap:IsReportHelper(.) or dap:IsValueList(.)">
					<xsl:apply-templates select="SMART-TAG-OPEN"/>
					<SPAN>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
						<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'combo-box')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
						<xsl:if test="dap:IsGeneralTextAlign(.)"><xsl:attribute name="MsoTextAlign">General</xsl:attribute></xsl:if>
						<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
						<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
						<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
						<xsl:apply-templates select="./*[not(@smarttag)]"/>
					</SPAN>
					<xsl:apply-templates select="SMART-TAG-CLOSE"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="SMART-TAG-OPEN"/>
					<SELECT>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
						<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'combo-box')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
						<xsl:if test="dap:IsGeneralTextAlign(.)"><xsl:attribute name="MsoTextAlign">General</xsl:attribute></xsl:if>
						<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
						<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
						<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
						<xsl:apply-templates select="./*[not(@smarttag)]"/>
					</SELECT>
					<xsl:apply-templates select="SMART-TAG-CLOSE"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='button']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<BUTTON>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'button')"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
				<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
				<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
				<xsl:if test="dap:includeTabIndex(.)"><xsl:attribute name="tabIndex"><xsl:value-of select="TAB-INDEX"/></xsl:attribute></xsl:if>
				<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
				<xsl:if test="ACCESS-KEY"><xsl:attribute name="accesskey"><xsl:value-of select="ACCESS-KEY"/></xsl:attribute></xsl:if>
				<xsl:choose>
					<xsl:when test="SRC"><xsl:element name="IMG"><xsl:attribute name="src"><xsl:value-of select="SRC"/></xsl:attribute></xsl:element></xsl:when>
					<xsl:otherwise><xsl:apply-templates /></xsl:otherwise>
				</xsl:choose>
			</BUTTON>
		</xsl:if>
	</xsl:template>

	<xsl:template match="REPORT-ITEM[@type='option-group']">
		<xsl:if test="dap:IncludeReportItemHelper(.)">
			<FIELDSET>
				<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="dap:GetBasicStyle(.)"/>; POSITION: absolute</xsl:attribute>
				<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
				<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
				<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
				<xsl:for-each select="../REPORT-ITEM[@id=current()/CHILD-LABEL]">
					<LEGEND>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(dap:GetParentOptionGroupHelper(.))"/>_Legend</xsl:attribute>
						<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'label')"/></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetTextStyle(., 'option-group')"/></xsl:attribute>
						<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
						<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:value-of select="CAPTION"/>
						<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
					</LEGEND>
				</xsl:for-each>
				<xsl:for-each select="../REPORT-ITEM[(@type='radio-button' or @type='check-box') and @parent=current()/@id]">
					<INPUT>
						<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/>_Option</xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="dap:GetRadioButtonStyle(.)"/>; POSITION: absolute</xsl:attribute>
						<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
						<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="VALUE"/></xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="@parent"/>___Option___</xsl:attribute>
						<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
					</INPUT>
					<xsl:for-each select="../REPORT-ITEM[@type='label' and @parent=current()/@id]">
						<SPAN>
							<xsl:attribute name="id"><xsl:value-of select="dap:GetMungedFieldNameHelper(.)"/></xsl:attribute>
							<xsl:attribute name="class"><xsl:value-of select="dap:GetItemClass(., 'label')"/></xsl:attribute>
							<xsl:attribute name="style"><xsl:value-of select="dap:GetTextStyle(., 'option-group')"/>; POSITION: absolute</xsl:attribute>
							<xsl:if test="EXPANDO-TAG"><xsl:attribute name="tag"><xsl:value-of select="EXPANDO-TAG"/></xsl:attribute></xsl:if>
							<xsl:if test="current()[ENABLED='false']"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
							<xsl:if test="TITLE"><xsl:attribute name="title"><xsl:value-of select="TITLE"/></xsl:attribute></xsl:if>
							<xsl:apply-templates />
						</SPAN>
					</xsl:for-each>
				</xsl:for-each>
			</FIELDSET>
		</xsl:if>
	</xsl:template>

	<!-- NOTE: If you add more REPORT-ITEM types, update GetElementExtensions so they aren't skipped -->

	<xsl:template match="CAPTION">
		<xsl:choose>
			<xsl:when test="../ACCESS-KEY"><xsl:value-of disable-output-escaping="yes" select="dap:GetAccessKey(.)"/></xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="node()">
	</xsl:template>

	<msxsl:script language="JScript" implements-prefix="dap"><![CDATA[

		//
		// Get the top-level DSC persistence
		//
		function GetDataSourceControl(nodelist)
			{
			objElem = nodelist.nextNode();
			// This will be true if this a standard DataPage with multiple controls and false if it is a PivotList or PivotChart view
			var fComplexPage = true;

			var objViewOnOpen = objElem.selectSingleNode("/RPTML/REPORT[1]/DEFAULT-VIEW");
			if (objViewOnOpen != null && (objViewOnOpen.text == "pivottable" || objViewOnOpen.text == "pivotchart"))
				fComplexPage = false;
			return	'<xml xmlns:a="urn:schemas-microsoft-com:office:access">\r\n' +
						'<a:DataSourceControl>\r\n' +
							GetDataSourceControlProperties(objElem, fComplexPage) +
							(fComplexPage ? GetElementExtensions(objElem) : GetControlElementExtension(objViewOnOpen.text)) +
							(fComplexPage ? GetGroupLevels(objElem, fComplexPage) : '') +
							GetDataModel(objElem, fComplexPage) +
						'</a:DataSourceControl>\r\n' +
					'</xml>';
			}

		//
		// Get the DSC persistence properties
		//
		function GetDataSourceControlProperties(objElem, fComplexPage)
			{
			var fDataEntry       = (GetNodeText(objElem, "/RPTML/REPORT[1]/DATA-ENTRY", "") == 'true');
			var nGridX = GetNodeText(objElem, "/RPTML/REPORT[1]/GRID-X", "24");
			var nGridY = GetNodeText(objElem, "/RPTML/REPORT[1]/GRID-Y", "24");

			return	'<a:OWCVersion>10.0.0.1402 (OFFSEN1,DEBUG)</a:OWCVersion>\r\n' +
					'<a:ConnectionString>' + objElem.selectSingleNode("/RPTML/REPORT[1]/CONNECTION-STRING").text + '</a:ConnectionString>\r\n' +
					(fDataEntry ? '<a:DataEntry/>\r\n' : '') +
					'<a:MaxRecords>10000</a:MaxRecords>\r\n' +
					(fComplexPage ? '' : '<a:DefaultRecordsetName>' + CleanFormReferences(objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE").text, objElem) + '</a:DefaultRecordsetName>\r\n') +
					'<a:GridX>' + nGridX + '</a:GridX>\r\n' +
					'<a:GridY>' + nGridY + '</a:GridY>\r\n' +
					'<a:OfflineType>2</a:OfflineType>\r\n' +
					'<a:OfflinePublication/>\r\n' +
					'<a:XMLLocation>0</a:XMLLocation>\r\n' +
					'<a:XMLDataTarget/>\r\n' +
					'<a:ConnectionFile/>\r\n';
			}

		//
		// Get all element extensions
		//
		function GetElementExtensions(objElem)
			{
			var strList = "";
			var strSource = "";
			var objNodes;

			// We allow binding of controls in all sections of a form but not in certain sections of a report
			if (objElem.selectSingleNode("/RPTML/REPORT[1]/OBJECT-TYPE").text == "form")
				objNodes = objElem.selectNodes("/RPTML/REPORT[1]/SECTION/REPORT-ITEM[CONTROL-SOURCE]");
			else
				objNodes = objElem.selectNodes("/RPTML/REPORT[1]/SECTION[@type!='report_header' and @type!='page_header' and @type!='page_footer' and @type!='report_footer']/REPORT-ITEM[CONTROL-SOURCE]");

			// Walk through the list of retrieved nodes
			for (var iNode = 0; iNode < objNodes.length; iNode++)
				{
				objNode = objNodes.item(iNode);
				
				// Check if we should bind this item
				if (!IncludeReportItem(objNode) && !IsDataSheetForm(objNode))
					continue;

				// List the valid bound types. Anything not listed here will remain unbound.

				var strType = GetNodeText(objNode, "@type", "");
				switch (strType)
					{
					case "text-box":
					case "label":
					case "check-box":
					case "list-box":
					case "combo-box":
					case "button":
					case "option-group":
						break;
					default:
						continue;
					}

				var strChildLabel = '';
				if ((objNode.selectSingleNode("CHILD-LABEL") != null) && !IsDataSheetForm(objNode)) 
					strChildLabel = '<a:ChildLabel>' + objNode.selectSingleNode("CHILD-LABEL").text + '</a:ChildLabel>\r\n';
				var strDefaultValue = (objNode.selectSingleNode("DEFAULT-VALUE") != null ? '<a:DefaultValue>' + CleanFormReferences(StripQuotes(objNode.selectSingleNode("DEFAULT-VALUE").text)) + '</a:DefaultValue>\r\n' : '');
				var strFormat = '';
				
				var objFormat = objNode.selectSingleNode("FORMAT");
				if (objFormat != null)
					{
					strFormat = '<a:Format>';
					switch (objFormat.text)
						{
						case "Currency":
							strFormat += 'Local Currency';
							break;
						
						case "Euro":
							strFormat += 'Euro Currency';
							break;
						
						default:
							strFormat += objNode.selectSingleNode("FORMAT").text;
							break;
						}

					strFormat += '</a:Format>\r\n';
					}

				// List-boxes and combo-boxes require special handling in the element extension list
				switch (objNode.selectSingleNode("@type").text)
					{
					case "list-box":
					case "combo-box":
						var objRowsourceType = objNode.selectSingleNode("ROW-SOURCE-TYPE");
						if (objRowsourceType != null && objRowsourceType.text != "Value List")
						{
							var objRowsource = objElem.selectSingleNode("/RPTML/REPORT[1]/DATA-MODEL/ROW-SOURCE[@id='" + objNode.selectSingleNode("ROW-SOURCE").text + "']");
							var objFields = objRowsource.selectNodes("FIELD");
							var objListBoundField = objFields.item(objNode.selectSingleNode("BOUND-COLUMN").text - 1);
							var nListDisplayField = GetListDisplayFieldNum(objNode);

							var strListDisplayField = "";
							if (nListDisplayField)
								{
								var objListDisplayField = objFields.item(nListDisplayField);
								if (objListDisplayField != null)
									{
									strListDisplayField = GetNodeText(objListDisplayField, "@id", "");
									}
								else
									{
									nListDisplayField = 0;
									}
								}
						
							strList = strList +
								'<a:ElementExtension>\r\n' +
									'<a:ElementID>' + GetMungedFieldName(objNode) + '</a:ElementID>\r\n' +
									'<a:ListRowSource>' + CleanFormReferences(objNode.selectSingleNode("ROW-SOURCE").text, objNode) + '</a:ListRowSource>\r\n' +
									'<a:ListBoundField>' + objListBoundField.selectSingleNode("@id").text + '</a:ListBoundField>\r\n' +
									(nListDisplayField ? '<a:ListDisplayField>' + strListDisplayField + '</a:ListDisplayField>\r\n' : '') +
									(IncludeControlSource(objNode) ? '<a:ControlSource>' + objNode.selectSingleNode("CONTROL-SOURCE").text + '</a:ControlSource>\r\n' : '') +
									strChildLabel +
									strDefaultValue +
									strFormat +
								'</a:ElementExtension>\r\n';
							break;
						} // treat value lists as text boxes, don't break
					default:
						var objGL;
						var objSection;
						var strGroupOf = '';
						var strAbsGL = '';
						
						// Rename the field if it is in a section that has a GroupLevel
						objSection = objNode.selectSingleNode("../@idref");
						if (objSection != null)
							{
							strGroupOf = 'GroupOf';
							objGL = objElem.selectSingleNode("/RPTML/REPORT[1]/GROUP-LEVEL[@id='" + objSection.text + "']")
							if (objGL != null)
								strAbsGL = DAPabsoluteChildNumber(objGL);
							}

						if (GetNodeText(objNode, "CONTROL-SOURCE/@type", "") == "expression")
							strSource = GetMungedFieldName(objNode);
						else
							strSource = MungeFieldName(objNode.selectSingleNode("CONTROL-SOURCE").text);

						strList = strList +
							'<a:ElementExtension>\r\n' +
								'<a:ElementID>' + GetMungedFieldName(objNode) + '</a:ElementID>\r\n' +
								(IncludeControlSource(objNode) ? '<a:ControlSource>' + strGroupOf + strSource + strAbsGL + '</a:ControlSource>\r\n' : '') +
								strChildLabel +
								strDefaultValue +
								strFormat +
							'</a:ElementExtension>\r\n';
					}

					// add element extensions for child controls
					if (objNode.selectSingleNode("@type").text == "option-group")
						{
						var objChildren = objNode.selectNodes("CHILD-CONTROLS/CHILD-CONTROL")
						var objChild;
						var objChildControl;
						for (var iChild = 0; iChild < objChildren.length; iChild++)
							{
							objChild = objChildren.item(iChild);
							objChildControl = objChild.selectSingleNode("/RPTML/REPORT[1]/SECTION/REPORT-ITEM[@id='" + objChild.text + "']");
							if (objChildControl != null && objChildControl.selectSingleNode("CONTROL-SOURCE") == null)
								{
								strChildLabel   = (objChildControl.selectSingleNode("CHILD-LABEL") != null ? '<a:ChildLabel>' + objChildControl.selectSingleNode("CHILD-LABEL").text + '</a:ChildLabel>\r\n' : '');
								strList = strList +
										'<a:ElementExtension>\r\n' +
										'<a:ElementID>' + GetMungedFieldName(objChildControl) + '_Option</a:ElementID>\r\n' +
										strChildLabel +
										'</a:ElementExtension>\r\n'; 
								}
							}
						}

				}

			// If we have navbars, add the appropriate element extensions
			if (IncludeNavigationBar(objElem))
				{
				strSource = CleanFormReferences(objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE").text, objElem);

				objLevels = objElem.selectNodes("/RPTML/REPORT[1]/GROUP-LEVEL");
				var objLevel
				for (var iLevel = 0; iLevel < objLevels.length; iLevel++)
					{
					objLevel = objLevels.item(iLevel);
					if (objLevel.selectSingleNode("GROUP-HEADER").text == "true" || objLevel.selectSingleNode("GROUP-FOOTER").text == "true")
						{
						var strGLSource = GetNodeText(objLevel, "@id", "");

						// One for each group-header or group-footer
						strList = strList +
							'<a:ElementExtension>\r\n' +
								'<a:ElementID>' + CleanFormReferences(strGLSource, objLevel) + 'NavLabel</a:ElementID>\r\n' +
								'<a:RecordsetLabel>' + strGLSource + ' |0 of |2;' + strGLSource + ' |0-|1 of |2</a:RecordsetLabel>\r\n' + 
								'<a:ConsumesRecordset/>\r\n' +
							'</a:ElementExtension>\r\n';
						}
					}

				// One for the main detail section
				strList = strList +
					'<a:ElementExtension>\r\n' +
						'<a:ElementID>' + CleanFormReferences(strSource, objElem) + 'NavLabel</a:ElementID>\r\n' +
						'<a:RecordsetLabel>' + strSource + ' |0 of |2;' + strSource + ' |0-|1 of |2</a:RecordsetLabel>\r\n' + 
						'<a:ConsumesRecordset/>\r\n' +
					'</a:ElementExtension>\r\n';
				}

			return strList;
			}

		//
		// Get the element extensions for the PivotTable or PivotChart view
		//
		function GetControlElementExtension(strControl)
			{
			return	'<a:ElementExtension>\r\n' +
						'<a:ElementID>PivotTable</a:ElementID>\r\n' +	// We always bind the PivotTable, even with a PivotChart
						'<a:ConsumesRecordset/>\r\n' +
					'</a:ElementExtension>\r\n';
			}

		//
		// Get the properties for each group-level
		//
		function GetGroupLevels(objElem)
			{
			var strGroupLevels = '';
			var strDefaultSort = '';
			var strSource = CleanFormReferences(objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE").text, objElem);
			var strDataPageSize = "1";

			var strObjectType = objElem.selectSingleNode("/RPTML/REPORT[1]/OBJECT-TYPE").text;
			if (strObjectType == "table" || strObjectType == "report" || IsDataSheetForm(objElem))
				if (IsDataSheet(objElem) && !IncludeNavigationBar(objElem))
					strDataPageSize = "-1";
				else
					strDataPageSize = "10";			// Table and report views show 10 records
			else
				{
				var objView = objElem.selectSingleNode("/RPTML/REPORT[1]/DEFAULT-VIEW");
				if (objView != null && objView.text == "continuous-forms")
					strDataPageSize = "-1";		// Continuous form shows all records
				else
					strDataPageSize = "1";		// Regular form shows single record
				}

			var fNavigationBar  = IncludeNavigationBar(objElem);

			var fReadOnly		= IsReport(objElem);
			var fAllowEdits     = !fReadOnly && (GetNodeText(objElem, "/RPTML/REPORT[1]/ALLOW-EDITS", "true") == "true");
			var fAllowAdditions = !fReadOnly && (GetNodeText(objElem, "/RPTML/REPORT[1]/ALLOW-ADDITIONS", "true") == "true");
			var fAllowDeletions = !fReadOnly && (GetNodeText(objElem, "/RPTML/REPORT[1]/ALLOW-DELETIONS", "true") == "true");
			var fRecordSelector = !fReadOnly && (GetNodeText(objElem, "/RPTML/REPORT[1]/OBJECT-TYPE", "") == "form" && GetNodeText(objElem, "/RPTML/REPORT[1]/RECORD-SELECTORS", "") == "true");
			fRecordSelector = fRecordSelector || IsDataSheet(objElem) || IsDataSheetForm(objElem);

			var objLevels = objElem.selectNodes("/RPTML/REPORT[1]/GROUP-LEVEL");
			var objLevel;
			var strSortDirection;
			var strSourceName;
			var fHeaderElement;
			var fFooterElement;
			var fCaptionElement;
			var fNavigationElement;
			for (var iLevel = 0; iLevel < objLevels.length; iLevel++)
				{
				objLevel = objLevels.item(iLevel);
				if (objLevel.selectSingleNode("GROUP-HEADER").text == "true" || objLevel.selectSingleNode("GROUP-FOOTER").text == "true")
					{
					strSortDirection = (GetNodeText(objLevel, "SORT-ORDER", "ascending") == "ascending" ? " ASC" : " DESC");
					strSourceName = objLevel.selectSingleNode("CONTROL-SOURCE").text;

					fHeaderElement     = (GetNodeText(objLevel, "GROUP-HEADER", "") == "true");
					fFooterElement     = (GetNodeText(objLevel, "GROUP-FOOTER", "") == "true");
					fCaptionElement    = (iLevel == 0 && objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='report_header' or @type='page_header']") != null)
					fNavigationElement = (fNavigationBar || (!IsDataSheet(objElem) && iLevel == objLevels.length - 1 && GetFirstFooterSection(objElem) != null));

					// GroupLevel element for each GROUP-LEVEL in the ReportML
					strGroupLevels = strGroupLevels +
						'<a:GroupLevel>\r\n' +
							'<a:RecordSource>' + CleanFormReferences(objLevel.selectSingleNode("@id").text, objLevel) + '</a:RecordSource>\r\n' +
							'<a:DefaultSort>' + GetDefaultSort(objLevel, true, true) + strSortDirection + '</a:DefaultSort>\r\n' +
							(fHeaderElement ? '<a:HeaderElementId>Header' + CleanFormReferences(objLevel.selectSingleNode("@id").text, objLevel) + '</a:HeaderElementId>\r\n' : '') +
							(fFooterElement ? '<a:FooterElementId>Footer' + CleanFormReferences(objLevel.selectSingleNode("@id").text, objLevel) + '</a:FooterElementId>\r\n' : '') +
							(fCaptionElement ? '<a:CaptionElementId>Caption' + CleanFormReferences(objLevel.selectSingleNode("@id").text, objLevel) + '</a:CaptionElementId>\r\n' : '') +
							(fNavigationElement ? '<a:RecordNavigationElementId>Navigation' + CleanFormReferences(objLevel.selectSingleNode("@id").text, objLevel) + '</a:RecordNavigationElementId>\r\n' : '') +
							'<a:DataPageSize>' + strDataPageSize + '</a:DataPageSize>\r\n' +
							'<a:GroupFilterControl/>\r\n' +
							(fAllowEdits     ? '' : '<a:NoAllowEdits/>\r\n') +
							(fAllowAdditions ? '' : '<a:NoAllowAdditions/>\r\n') +
							(fAllowDeletions ? '' : '<a:NoAllowDeletions/>\r\n') +
							(fRecordSelector ? '<a:RecordSelector/>\r\n' : '') +
						'</a:GroupLevel>\r\n';

					}
				else // not a real group level, just get the sort
					{
					strSourceName = GetDefaultSort(objLevel, false, false);
					strSortDirection = (GetNodeText(objLevel, "SORT-ORDER", "ascending") == "ascending" ? " ASC" : " DESC");
					if (strDefaultSort.length > 0)
						{
						strDefaultSort += ', ' + strSourceName + strSortDirection;
						}
					else
						{
						strDefaultSort = strSourceName + strSortDirection;
						}
					}
				}
			objLevel = objLevels.item(0);

			// if we still don't have a default sort
			if (strDefaultSort == "")
				{
				if (GetNodeText(objElem, "/RPTML/REPORT[1]/DEFAULT-SORT-ON", "") == "true")
					{
					strDefaultSort = StripTableNames(GetNodeText(objElem, "/RPTML/REPORT[1]/DEFAULT-SORT", ""));
					if (strDefaultSort == "false")
						strDefaultSort = "";
					}
				else 
					{
					if (objLevel != null && strDefaultSort.length == 0)
						{
						strSourceName = GetDefaultSort(objLevel, false, false);
						strSortDirection = (GetNodeText(objLevel, "SORT-ORDER", "ascending") == "ascending" ? " ASC" : " DESC");
						strDefaultSort = strSourceName + strSortDirection;
						}
					}
				}
		
			fCaptionElement    = (objLevels.length == 0 && GetFirstHeaderSection(objElem) != null) || IsDataSheetForm(objElem);
			fNavigationElement = (fNavigationBar || (!IsDataSheet(objElem) && objElem.selectNodes("/RPTML/REPORT[1]/GROUP-LEVEL[GROUP-FOOTER='true']").length == 0 && GetFirstFooterSection(objElem) != null));

			// GroupLevel for the main detail section
			strGroupLevels = strGroupLevels +
				'<a:GroupLevel>\r\n' +
					'<a:RecordSource>' + strSource + '</a:RecordSource>\r\n' +
					'<a:DefaultSort>' + strDefaultSort + '</a:DefaultSort>\r\n' +
					'<a:HeaderElementId>Header' + strSource + '</a:HeaderElementId>\r\n' +
					'<a:FooterelementId/>\r\n' +
					(fCaptionElement ? '<a:CaptionElementId>Caption' + strSource + '</a:CaptionElementId>\r\n' : '') +
					(fNavigationElement ? '<a:RecordNavigationElementId>Navigation' + strSource + '</a:RecordNavigationElementId>\r\n' : '') +
					'<a:DataPageSize>' + strDataPageSize + '</a:DataPageSize>\r\n' +
					'<a:GroupFilterControl/>\r\n' +
					(fAllowEdits     ? '' : '<a:NoAllowEdits/>\r\n') +
					(fAllowAdditions ? '' : '<a:NoAllowAdditions/>\r\n') +
					(fAllowDeletions ? '' : '<a:NoAllowDeletions/>\r\n') +
					(fRecordSelector ? '<a:RecordSelector/>\r\n' : '') +
				'</a:GroupLevel>\r\n';

			return strGroupLevels;
			}

		function GetDefaultSort(objLevel, fAppendGroupOf, fAddChildNumber)
			{
			var strTemp = ""
			if (objLevel.selectSingleNode("CONTROL-SOURCE[@type = 'expression']") != null)
				{
				var objReportItem = objLevel.selectSingleNode("/RPTML/REPORT[1]/SECTION/REPORT-ITEM[CONTROL-SOURCE ='" + GetNodeText(objLevel, "CONTROL-SOURCE", "") + "']");
				if (objReportItem != null)
					{
					strTemp = BracketFieldName(MungeFieldName(GetNodeText(objReportItem, "@id", "")) + (fAddChildNumber ? DAPabsoluteChildNumber(objLevel) : ""));
					}
				}
			else
				strTemp = BracketFieldName(MungeFieldName(GetNodeText(objLevel, "CONTROL-SOURCE", "")) + (fAddChildNumber ? DAPabsoluteChildNumber(objLevel) : ""));

			if (fAppendGroupOf)
				strTemp = '[GroupOf' + strTemp.replace(/^\[/, '');
			return strTemp;
			}

		//
		// Get the DataModel persistence properties
		//
		function GetDataModel(objElem, fComplexPage)
			{
			// Skip it if there is no RowSource in the DataModel
			var objRowsources = objElem.selectNodes("/RPTML/REPORT[1]/DATA-MODEL/ROW-SOURCE");
			if (objRowsources == null)
				return "";

			var strDatamodel = "";

			//
			// Add SchemaRowsources
			//

			var objRowsource;
			var objFields;
			var objField;
			var objParams;
			var objParam;
			var objSource;
			for (var iRowsource = 0; iRowsource < objRowsources.length; iRowsource++)
				{
				objRowsource = objRowsources.item(iRowsource);

				// Add a SchemaRowsource for each RowSource
				strDatamodel = strDatamodel +
					'<a:SchemaRowsource ' +
						'a:id="' + CleanFormReferences(objRowsource.selectSingleNode("@id").text, objRowsource) + '" ' +
						'a:type="' + GetRowsourceType(objRowsource) + '"' +
					'>\r\n';

				// Optionally add the command-text
				if (objRowsource.selectSingleNode("@type").text == "view" || objRowsource.selectSingleNode("@type").text == "command-text")
					strDatamodel = strDatamodel +
						'<a:CommandText>' + CleanFormReferences(objRowsource.selectSingleNode("COMMAND-TEXT").text, null) + '</a:CommandText>\r\n';

				objFields = objRowsource.selectNodes("FIELD");
				for (var iField = 0; iField < objFields.length; iField++)
					{
					objField = objFields.item(iField);

					// Add a SchemaField for each field in the RowSource
					strDatamodel = strDatamodel +
						'<a:SchemaField ' +
							'a:id="' + GetFieldName(objField) + '" ' +
							'a:datatype="' + objField.selectSingleNode("@datatype").text + '" ' +
							'a:size="' + objField.selectSingleNode("@size").text + '"' +
							(objField.selectSingleNode("@iskey") != null ? ' a:iskey="' + objField.selectSingleNode("@iskey").text + '"' : '') +
						'/>\r\n';
					}

				objParams = objRowsource.selectNodes("PARAMETER");
				for (var iParam = 0; iParam < objParams.length; iParam++)
					{
					objParam = objParams.item(iParam);

					// Add a SchemaParameter for each parameter in the RowSource
					strDatamodel = strDatamodel +
						'<a:SchemaParameter ' +
							'a:id="' + GetFieldName(objParam) + '" ' +
							'a:datatype="' + objParam.selectSingleNode("@datatype").text + '" ' +
						'/>\r\n';
					}

				strDatamodel = strDatamodel + '</a:SchemaRowsource>\r\n';
				}

			//
			// Add RecordsetDefs
			//

			for (var iRowsource = 0; iRowsource < objRowsources.length; iRowsource++)
				{
				objRowsource = objRowsources.item(iRowsource);

				strDatamodel = strDatamodel +
					'<a:RecordsetDef ' +
						'a:id="' + CleanFormReferences(objRowsource.selectSingleNode("@id").text, objRowsource) + '" ' +
					'>\r\n';

				objFields = objRowsource.selectNodes("FIELD");
				for (var iField = 0; iField < objFields.length; iField++)
					{
					objField = objFields.item(iField);
					strField = GetFieldName(objField);
					if (GetMungedFieldName(objField) != "Invalid Record Source" && strField != "Invalid Record Source")
						{
						strDatamodel = strDatamodel + '<a:PageField ';
						
						if (strField != GetMungedFieldName(objField))	// If the munged name is different, add a reference to the original field name ("a:source=")
							strDatamodel = strDatamodel + 'a:id="' + GetMungedFieldName(objField) + '" a:source="' + strField + '"';
						else
							strDatamodel = strDatamodel + 'a:id="' + strField + '"';

						strDatamodel = strDatamodel + '/>\r\n';
						}
					}

				var strFieldID = "";
				var strSource = "";
				// If this is a ComplexPage, add expressions and group-levels
				if (fComplexPage)
					{
					// Add expressions from the detail section
					var objDetailCalcs = objElem.selectNodes("/RPTML/REPORT[1]/SECTION[@type='detail']/REPORT-ITEM[CONTROL-SOURCE/@type='expression']");
					for (var iField = 0; iField < objDetailCalcs.length; iField++)
						{
						objField = objDetailCalcs.item(iField);
		
						strFieldID = GetMungedFieldName(objField);
						strSource  = objField.selectSingleNode("CONTROL-SOURCE").text;

						strSource = strSource.replace(/nz\(/gi, 'MSODSC.NZ\(');

						if (MungeFieldName(strSource) != "Invalid Record Source")
							strDatamodel = strDatamodel + '<a:PageField a:id="' + strFieldID+ '" a:source="' + EncodeSource(strSource) + '" a:type="dscCalculated"/>\r\n';
						}
		
					strSource = CleanFormReferences(objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE").text, objElem);

					if (iRowsource == 0)
						{
						var objLevels = objElem.selectNodes("/RPTML/REPORT[1]/GROUP-LEVEL");
						var objLevel;
						var objGroupFields;
						var strAttr;
						var strTotal;
						var strID;
						var strNew;
						for (var iLevel = objLevels.length-1; iLevel >= 0 ; iLevel--)
							{
							objLevel = objLevels.item(iLevel);

							// Get the list of fields from all grouped sections
							objGroupFields = objElem.selectNodes("/RPTML/REPORT[1]/SECTION[@idref='" + objLevel.selectSingleNode("@id").text + "']/REPORT-ITEM[CONTROL-SOURCE]");
							if (objGroupFields.length > 0)
								{
								strDatamodel = strDatamodel + '<a:GroupingDef a:id="' + objLevel.selectSingleNode("@id").text + '">\r\n';

								// Generate the unique list of bound fields for this group-level
								var objList = new ActiveXObject("Scripting.Dictionary");
								for (var iField = 0; iField < objGroupFields.length; iField++)
									objList.Add(GetMungedFieldName(objGroupFields.item(iField)), "yes");

								// Walk through this field list
								for (var iField = 0; iField < objGroupFields.length; iField++)
									{
									objField = objGroupFields.item(iField);

									objSource = objField.selectSingleNode("CONTROL-SOURCE");
									strAttr = '';

									if (GetNodeText(objSource, "@type", "") == "expression")
										{
										strFieldID = GetMungedFieldName(objField);
										strSource  = objSource.text;

										// Is it an aggregate function?
										if (strSource.search(new RegExp("sum\\(|avg\\(|min\\(|max\\(|count\\(", "i")) == 0)
											{
											strTotal  = strSource.replace(/(.*)\(.*\)/i, '$1');					// Get name of aggregate function
											strSource = strSource.replace(/.*\(\[*([^\]]+)\]*\)/i, '$1');		// Get name of field being aggregated
											strAttr   = ' a:total="dsc' + strTotal.substr(0,1).toUpperCase() + strTotal.substr(1).toLowerCase() + '"';
											}
										else
											{
											strSource = strSource.replace(/"/gi, '&quot;');						// Encode quotes as "&quot;"
											for (var i = 0; i < objFields.length; i++)
												{
												strID = GetMungedFieldName(objFields.item(i));
												strNew = strSource.replace(new RegExp("\\[(" + strID + ")\\]", "gi"), "[GroupOf$1]");
												if (strNew != strSource && strID != "Invalid Record Source")	// Were there field names in the expression?
													{
													
													var strGSBracketed = BracketFieldName('GroupOf' + strID + DAPabsoluteChildNumber(objLevel));
													strSource = strSource.replace(new RegExp("\\[(" + strID + ")\\]", "gi"), "[GroupOf$1" + DAPabsoluteChildNumber(objLevel) + "]");
													if (!objList.Exists(strGSBracketed))									// Is it one of our bound fields?
														{
														strDatamodel = strDatamodel + '<a:PageField a:id="' + strGSBracketed + '" a:source="' + strID + '" ' + GetGroupOnType(strID, objLevel) + '/>\r\n';
														objList.Add(strGSBracketed, "yes");
														}
													}
												}
											for (i = 0; i < objGroupFields.length; i++)
												{
												strID = GetMungedFieldName(objGroupFields.item(i));
												strSource = strSource.replace(new RegExp("\\[(" + strID + ")\\]", "gi"), "[GroupOf$1" + DAPabsoluteChildNumber(objLevel) + "]");		// Munge all field references
												}
											strAttr = ' a:type="dscCalculated"';
											}
										}
									else
										{
										strFieldID = MungeFieldName(objSource.text);
										strSource  = MungeFieldName(objSource.text);
										}

									// Note, strSource might not be a valid control-source at this point due to the adding of the GroupLevel index.
									if (strSource != "Invalid Record Source")
										{
										var strFieldIDBracketed = BracketFieldName('GroupOf' + strFieldID + DAPabsoluteChildNumber(objLevel));
										if (!objList.Exists(strFieldIDBracketed))
											{
											strDatamodel = strDatamodel + '<a:PageField a:id="' + strFieldIDBracketed + '" a:source="' + strSource + '" ' + GetGroupOnType(strSource, objLevel) + strAttr + '/>\r\n';
											objList.Add(strFieldIDBracketed, "yes")
											}
										}
									}

								var strGroupSource = MungeFieldName(GetNodeText(objLevel, "CONTROL-SOURCE", "Invalid Record Source")) 
								if (strGroupSource != "Invalid Record Source")
									{
									var strGroupSourceBracketed = GetDefaultSort(objLevel, true, true);
									if (!objList.Exists(strGroupSourceBracketed))
										{
										strDatamodel = strDatamodel + '<a:PageField a:id="' + strGroupSourceBracketed + '" a:source="' + strGroupSource + '" ' + GetGroupOnType(strGroupSource, objLevel) + '/>\r\n';
										objList.Add(strGroupSourceBracketed, "yes");
										}
									}

								strDatamodel = strDatamodel + '</a:GroupingDef>\r\n';
								}
							else if (objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@idref='" + objLevel.selectSingleNode("@id").text + "']") != null)  // no bound fields in the group level
								{
								var strGroupOf = '';
								
								strDatamodel = strDatamodel + '<a:GroupingDef a:id="' + objLevel.selectSingleNode("@id").text + '">\r\n';
								objSource = objLevel.selectSingleNode("CONTROL-SOURCE");
								strFieldID = MungeFieldName(objSource.text);
								
								if (strFieldID == "Invalid Record Source")
									{
									strGroupOf = strFieldID = objSource.text;
									}
								else
									{
									strGroupOf = 'GroupOf' + strFieldID + DAPabsoluteChildNumber(objLevel);
									}
								
								strDatamodel = strDatamodel + '<a:PageField a:id="' + strGroupOf + '" a:source="' + strFieldID + '" ' + GetGroupOnType(strFieldID, objLevel) + '/>\r\n';
								}
							}
						}
					}

				strDatamodel = strDatamodel + '</a:RecordsetDef>\r\n';
				}

			return '<a:Datamodel a:version="0816">\r\n' + strDatamodel + '</a:Datamodel>\r\n';
			}

		//
		// Get the DataModel type associated with a RowSource
		//
		function GetRowsourceType(objRowsource)
			{
			if (objRowsource.selectSingleNode("PARAMETER") != null)
				return "dscProcedure";

			var strType = objRowsource.selectSingleNode("@type").text
			switch (strType)
				{
				case "table":			return "dscTable";
				case "view":			return "dscView";
				case "procedure":		return "dscProcedure";
				case "command-text":	return "dscCommandText";
				default:				return "unknown"
				}
			}

		function GetGroupOnType(strSource, objField)
			{
			if (strSource.length == 0 || objField == null || objField.selectSingleNode("GROUP-ON") == null)
				return '';

			var strGroupOn = GetNodeText(objField, "GROUP-ON", "each value");
			var strGroupInterval = GetNodeText(objField, "GROUP-INTERVAL", "");
			switch (strGroupOn)
				{
				case "each value":			return 'a:groupon="dscEachValue"';
				case "prefix characters":	
					if (strGroupInterval.length > 0)
						return 'a:groupon="dscPrefix" a:interval="' + strGroupInterval + '"';
					else
						return 'a:groupon="dscPrefix"';
				case "year":				return 'a:groupon="dscYear"';
				case "quarter":				return 'a:groupon="dscQuarter"';
				case "month":				return 'a:groupon="dscMonth"';
				case "week":				return 'a:groupon="dscWeek"';
				case "day":					return 'a:groupon="dscDay"';
				case "hour":				return 'a:groupon="dscHour"';
				case "minute":				return 'a:groupon="dscMinute"';
				case "interval":			
					if (strGroupInterval.length > 0)
						return 'a:groupon="dscInterval" a:interval="' + strGroupInterval + '"';
					else
						return 'a:groupon="dscInterval"';
				default:					return 'a:groupon="dscEachValue"';
				}
			}

		//
		// Get the name of a field. If the field has an "id" attribute, us that. Otherwise,
		// generate a unique name based on the ordinal of the field and the section it is in.
		//
		function GetFieldName(objElem)
			{
			var objID = objElem.selectSingleNode("@id");
			if (objID != null)
				return objID.text;
			return "_Section" + DAPabsoluteChildNumber(objElem.selectSingleNode("..")) + "_Field" + DAPabsoluteChildNumber(objElem) + "_";
			}

		function GetMungedFieldNameHelper(nodelist)
			{
			 return GetMungedFieldName(nodelist.item(0));
			}
		//
		// Get the munged name of a field. If the field has an "id" attribute, munge that. Otherwise,
		// generate a unique name based on the ordinal of the field and the section it is in.
		//
		function GetMungedFieldName(objElem)
			{
			var objID = objElem.selectSingleNode("@id");
			if (objID != null)
				return MungeFieldName(objID.text);
			else
				return CleanFormReferences("_Section" + DAPabsoluteChildNumber(objElem.selectSingleNode("..")) + "_Field" + DAPabsoluteChildNumber(objElem) + "_", null);
			}

		function CleanFormReferences(strSource, objElem)
			{
			if ((strSource.match(/\[Forms\]\!/i) != null) || 
				(strSource.match(/Forms\!/i) != null) ||
				(strSource.match(/Forms\([^\!]*\!/i) != null) ||
				(strSource.match(/\[Reports\]\!/i) != null)  || 
				(strSource.match(/Reports\!/i) != null) ||
				(strSource.match(/Reports\([^\!]*\!/i) != null) ||
				(strSource.match(/\[Form\]\!/i) != null) || 
				(strSource.match(/Form\!/i) != null) ||
				(strSource.match(/Form\([^\!]*\!/i) != null) ||
				(strSource.match(/\[Report\]\!/i) != null)  || 
				(strSource.match(/Report\!/i) != null) ||
				(strSource.match(/Report\([^\!]*\!/i) != null))
				return "Invalid Record Source";

			if (objElem != null)
				{
				var objRowsource = objElem.selectSingleNode("/RPTML/REPORT[1]/DATA-MODEL/ROW-SOURCE[@id='" + strSource + "']");
				if (objRowsource == null) //if we couldn't find the rowsource, try the encoded record source
					{
					if (GetNodeText(objElem, "/RPTML/REPORT[1]/RECORD-SOURCE", "") == strSource)
						{
						var strEncodedRecordSource = GetNodeText(objElem, "/RPTML/REPORT[1]/ENCODED-RECORD-SOURCE", "");
						if (strEncodedRecordSource != "")
							objRowsource = objElem.selectSingleNode("/RPTML/REPORT[1]/DATA-MODEL/ROW-SOURCE[@id='" + strEncodedRecordSource + "']");
						}
					}
				if (objRowsource != null && GetNodeText(objRowsource, "@type", "") == "command-text")
					{
					objColumns = objRowsource.selectNodes("preceding-sibling::node()");
					var id = objColumns.length + 1;
					return "_dscRowsource_" + id;
					}
				}
			return strSource;
			}

		//
		// Fixup a field name. Replaces all periods with underscores.
		//
		function MungeFieldName(strField)
			{
			return CleanFormReferences(strField.replace(/\./g, '_'), null);
			}

		//
		// Gets the Field name from a table.field name
		//
		function StripTableNames(strField)
			{
			return strField.replace (/.*\./, '');
			}

		//
		// Strips off enclosing quotes if they exist
		//
		function StripQuotes(strSource)
			{
			return strSource.replace(/^\"|\"$/g, '');
			}

		//
		// Encodes " as &quot; and & as &amp;
		//
		function EncodeSource(strSource)
			{
			var strOut = strSource.replace(/\&/g, '&amp;');
			return strOut.replace(/\"/g, '&quot;');
			}


		//
		// Get the id of the caption section
		//
		function GetCaptionID(nodelist)
			{
			var objElem = nodelist.item(0);
			var objLevel = objElem.selectSingleNode("GROUP-LEVEL");
			if (objLevel != null)
				return "Caption" + objLevel.selectSingleNode("@id").text;
			return "Caption" + CleanFormReferences(GetNodeText(objElem, "/RPTML/REPORT[1]/RECORD-SOURCE", ""), objElem);
			}

		//
		// Get the id of a group
		//
		function GetGroupID(nodelist, strType)
			{
			var objElem = nodelist.item(0);
			var strID = '';

			switch (strType)
				{
				case "group_header":
					strID = "Header" + objElem.selectSingleNode("@id").text;
					break;
				case "group_footer":
					strID = "Footer" + objElem.selectSingleNode("@id").text;
					break;
				case "group_navigation":
					strID = "Navigation" + objElem.selectSingleNode("@id").text;
					break;
				}

			return strID;
			}

		//
		// Get the id of a section
		//
		function GetSectionID(nodelist, strType)
			{
			var objElem = nodelist.item(0);
			var strID = '';

			if (objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE") != null)
				{
				switch (strType)
					{
					case "detail":
						strID = "Header" + CleanFormReferences(objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE").text, objElem);
						break;
					case "detail_navigation":
						strID = "Navigation" + CleanFormReferences(objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE").text, objElem);
						break;
					}
				}

			return strID;
			}

		function IncludeNavigationBar(objElem)
			{
			return (GetNodeText(objElem, "/RPTML/REPORT[1]/NAVIGATION-SECTION", "true") == "true");
			}

		function IncludeFooterSectionsHelper(nodelist, strType)
			{
			return IncludeFooterSections(nodelist.item(0), strType);
			}

		function IncludeNavigationSection(nodelist, strType)
			{
			var objElem = nodelist.item(0);
			if (IncludeNavigationBar(objElem))
				return true;
			return IncludeFooterSections(objElem, strType);
			}

		function IncludeFooterSections(objElem, strType)
			{
			if (IsDataSheetForm(objElem))
				return false;
			
			if (GetFirstFooterSection(objElem) != null)
				{
				switch (strType)
					{
					case "detail":
						return (GetFirstGroupLevel(objElem) == null);
					case "group_footer":
						 var length = objElem.selectNodes("preceding-sibling::*[local-name()='GROUP-LEVEL'] | self::node()").length;
						 return (length == objElem.selectNodes("/RPTML/REPORT[1]/GROUP-LEVEL").length);
					}
				}
			return false;
			}

		function GetFirstHeaderSection(objElem)
			{
			return objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='report_header' or @type='page_header']");
			}

		function GetFirstFooterSection(objElem)
			{
			return objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='page_footer' or @type='report_footer']");
			}

		function GetFirstGroupLevel(objElem)
			{
			return objElem.selectSingleNode("/RPTML/REPORT[1]/GROUP-LEVEL");
			}

		//
		// Get the NavBar for the detail section
		//
		function GetDetailNavBar(nodelist, strPath, fIncludeDiv)
			{
			var objElem = nodelist.item(0);
			if (strPath != "")
				objElem = objElem.selectSingleNode(strPath);

			var objSection = objElem.selectSingleNode("SECTION[@type='detail']");
			if (objSection == null)
				return "";

			var objRecordSource = objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE");
			if (objRecordSource == null)
				return "";

			var strSource = CleanFormReferences(objRecordSource.text, objElem);

			var strDivID = 'Navigation' + strSource;
			var strObjID = strSource + 'Navigation';
			
			var fRTLMode = (GetNodeText(objElem, "/RPTML/REPORT[1]/DIR") == 'right-to-left');

			return GetNavBar(strDivID, strObjID, strSource, 0, fIncludeDiv, fRTLMode, GetNodeText(objElem, "/RPTML/REPORT[1]/WIDTH", "6in"));			
			}

		//
		// Get the NavBar for a group-level section
		//
		function GetGroupNavBar(nodelist, fIncludeDiv)
			{
			var objElem = nodelist.item(0);
			if (objElem.selectSingleNode("GROUP-HEADER").text != "true" && objElem.selectSingleNode("GROUP-FOOTER").text != "true")
				return "";

			var objRecordSource = objElem.selectSingleNode("/RPTML/REPORT[1]/RECORD-SOURCE");
			if (objRecordSource == null)
				return "";

			var strSource = objElem.selectSingleNode("@id").text;

			var strDivID = 'Navigation' + strSource;
			var strObjID = strSource + 'Navigation';
			
			var fRTLMode = (GetNodeText(objElem, "/RPTML/REPORT[1]/DIR") == 'right-to-left');
			
			return GetNavBar(strDivID, strObjID, strSource, 0, fIncludeDiv, fRTLMode, GetNodeText(objElem, "/RPTML/REPORT[1]/WIDTH", "6in"));			
			}

		//
		// Get the actual HTML element for a NavBar
		//
		function GetNavBar(strDivID, strObjID, strSource, nIndent, fIncludeDiv, fRTLMode, strWidth)
			{
			return (fIncludeDiv ? '<DIV class="Mso2dSection" id="' + strDivID + '" style="HEIGHT: 0.333in; MARGIN-LEFT: ' + nIndent * 0.25 + 'in; VISIBILITY: hidden; WIDTH: 576px; BACKGROUND-COLOR: gainsboro">\r\n' : '') +
				'<TABLE cellPadding=0 cellSpacing=0 class=MsoNavContainer id="' + strObjID + '" style="' + (fRTLMode ? 'RIGHT' :  'LEFT') + ': 4px; POSITION: absolute; TOP: 4px; WIDTH: ' + strWidth + '"><TBODY><TR>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavFirst tabIndex=1 height=20 id="' + strSource + 'NavFirst" src="owc://' + (fRTLMode ? 'GIF/#11206"' :  'GIF/#11200"') + ' width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavPrevious tabIndex=2 height=20 id="' + strSource + 'NavPrevious" src="owc://' + (fRTLMode ? 'GIF/#11204"' :  'GIF/#11202"') + ' width=20></TD>\r\n' +
				'<TD noWrap style="VERTICAL-ALIGN: middle; TEXT-ALIGN: center; WIDTH: 100%"><SPAN class=MsoNavRecordsetLabel id="' + strSource + 'NavLabel" style="VISIBILITY: hidden">' + strSource + ' |0-|1 of |2</SPAN></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavNext tabIndex=4 height=20 id="' + strSource + 'NavNext" src="owc://' + (fRTLMode ? 'GIF/#11202"' :  'GIF/#11204"') + ' width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavLast tabIndex=5 height=20 id="' + strSource + 'NavLast" src="owc://' + (fRTLMode ? 'GIF/#11200"' :  'GIF/#11206"') + ' width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavAddNew tabIndex=6 height=20 id="' + strSource + 'NavNew" src="owc://' + (fRTLMode ? 'GIF/#11230"' :  'GIF/#11208"') + ' width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavDelete tabIndex=7 height=20 id="' + strSource + 'NavDelete" src="owc://' + (fRTLMode ? 'GIF/#11232"' :  'GIF/#11210"') + ' width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavSave tabIndex=8 height=20 id="' + strSource + 'NavSave" src="owc://GIF/#11214" width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavUndo tabIndex=9 height=20 id="' + strSource + 'NavUndo" src="owc://GIF/#11212" width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavSortAsc tabIndex=10 height=20 id="' + strSource + 'NavSortAscending" src="owc://GIF/#11216" width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavSortDesc tabIndex=11 height=20 id="' + strSource + 'NavSortDescending" src="owc://GIF/#11218" width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavFilter tabIndex=12 height=20 id="' + strSource + 'NavFilterBySelection" src="owc://GIF/#11220" width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavToggleFilter tabIndex=13 height=20 id="' + strSource + 'NavFilterToggle" src="owc://GIF/#11222" width=20></TD>\r\n' +
				'<TD class=MsoNavButton style="HEIGHT: 20px; WIDTH: 20px"><IMG class=MsoNavHelp tabIndex=14 height=20 id="' + strSource + 'NavHelp" src="owc://GIF/#11224" width=20></TD>\r\n' +
				'</TR></TBODY></TABLE>' +
				(fIncludeDiv ? '\r\n</DIV>' : '');
			}

		var rgSharedAttr = new Array("COLOR", "BACKGROUND-COLOR", "BORDER-WIDTH", "TEXT-ALIGN",
									  "FONT-WEIGHT", "FONT-SIZE", "FONT-FAMILY", "FONT-STYLE", "VISIBILITY", "WRITING-MODE");

		function GetSharedStyle(nodelist)
			{
			objElem = nodelist.item(0);
			var strStyle = GetBorderStyle(objElem);
			strStyle = GetBorderColor(objElem, strStyle);
			return AppendAttribute(strStyle, GetItemStyle(objElem, rgSharedAttr));
			}

		function GetDatasheetStyle(nodelist)
			{
			var strStyle = "";
			var objProperty;
			var objElem = nodelist.item(0);
			
			objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-FORE-COLOR");
			if (objProperty != null)
				strStyle += "COLOR: " + objProperty.text;

			objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-TEXT-DECORATION");	
			if (objProperty != null)
				strStyle = AppendAttribute(strStyle, "TEXT-DECORATION: " + objProperty.text);

			objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-FONT-STYLE");	
			if (objProperty != null)
				strStyle = AppendAttribute(strStyle, "FONT-STYLE : " + objProperty.text);

			objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-FONT-WEIGHT");	
			if (objProperty != null)
				strStyle = AppendAttribute(strStyle, "FONT-WEIGHT : " + objProperty.text);

			objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-FONT-SIZE");	
			if (objProperty != null)
				strStyle = AppendAttribute(strStyle, "FONT-SIZE : " + objProperty.text);

			objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-FONT-FAMILY");	
			if (objProperty != null)
				strStyle = AppendAttribute(strStyle, "FONT-FAMILY : " + objProperty.text);

			return strStyle;
			}


		function GetFirstHeaderSectionStyle(nodelist)
		{
			var objElem = nodelist.item(0);
			var objHdr = GetFirstHeaderSection(objElem);
			return GetSectionStyle(objHdr);
		}

		function GetDetailSectionStyle(nodelist)
		{
			var objElem = nodelist.item(0).selectSingleNode("SECTION[@type='detail']");
			return GetSectionStyle(objElem);
		}

		var rgSectionAttr = new Array("COLOR", "BORDER-WIDTH", "BORDER-STYLE");
		var rgSectionReportAttr = new Array("COLOR");
		var rgSectionBackgroundColorAttr = new Array("BACKGROUND-COLOR");			

		function GetSectionStyle(objElem)
			{
			var strStyle = "";
			if (IsReport(objElem))
				strStyle = GetItemStyle(objElem, rgSectionReportAttr);
			else
				strStyle = GetItemStyle(objElem, rgSectionAttr);
			strStyle = GetBorderColor(objElem, strStyle);
			if (objElem.selectSingleNode("/RPTML/REPORT[1]/BACKGROUND-IMAGE") == null)
				strStyle = AppendAttribute(strStyle, GetItemStyle(objElem, rgSectionBackgroundColorAttr));
			strStyle = AppendAttribute(strStyle, GetSectionPosition(objElem));

			if ((GetNodeText(objElem, "@type", "") == "detail") && !IsReport(objElem) && (GetNodeText(objElem, "/RPTML/REPORT[1]/DIVIDING-LINES", "") == 'true'))
				strStyle = AppendAttribute(strStyle, "BORDER-BOTTOM: black 1px solid");

			if (IsDataSheet(objElem) && GetNodeText(objElem, "@type", "") == "detail")
				{
				var	objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-BACK-COLOR");
				if (objProperty != null)
					strStyle = AppendAttribute(strStyle, "BACKGROUND-COLOR: " + objProperty.text);
				}
				
			return strStyle;
			}

		function GetDetailNavigationStyle(nodelist)
			{
			var objElem = nodelist.item(0);
			if (GetFirstFooterSection(objElem) != null && GetFirstGroupLevel(objElem) == null)
				return AppendAttribute(GetSectionPosition(GetFirstFooterSection(objElem)), "POSITION: relative");
			else
				return "HEIGHT: 0.427in; VISIBILITY: hidden; WIDTH: " + GetNodeText(objElem, "/RPTML/REPORT[1]/WIDTH", "6in");
			}

		function GetGroupStyle(nodelist, strType)
			{
			var objElem = nodelist.item(0);
			var objSection = objElem.selectSingleNode("../SECTION[@type='" + strType + "' and @idref='" + objElem.selectSingleNode("@id").text + "']");
			if (objSection != null)
				return GetSectionStyle(objSection);
			if (strType == "group_navigation" && IncludeNavigationBar(objElem))
				{
				objSection = GetFirstFooterSection(objElem);
				if (objSection != null)
					return GetSectionStyle(objSection);
				else
					return "HEIGHT: 0.427in; VISIBILITY: hidden; WIDTH: " + GetNodeText(objElem, "/RPTML/REPORT[1]/WIDTH", "6in");
				}
			return "";
			}

		var rgTextAttr = new Array("COLOR", "BACKGROUND-COLOR", "TEXT-ALIGN",
								   "FONT-WEIGHT", "FONT-SIZE", "FONT-FAMILY", "FONT-STYLE", "VISIBILITY", "Z-INDEX");
		var rgPaddingAttr = new Array("PADDING-LEFT", "PADDING-RIGHT", "PADDING-BOTTOM", "PADDING-TOP");

		function GetTextStyle(nodelist, strType)
			{
			var objElem = nodelist.item(0);
			var strStyle = GetItemStyle(objElem, rgTextAttr);
			strStyle = AppendAttribute(strStyle, GetItemPosition(objElem, true));
			strStyle = GetOverflowStyle(objElem, strStyle);
			strStyle = GetPaddingStyle(objElem, strStyle, rgPaddingAttr);	

			var objParentID = objElem.selectSingleNode("@parent");
			if (objParentID != null && (objParent = objElem.selectSingleNode("../REPORT-ITEM[@id='" + objParentID.text + "']")) != null && objParent.selectSingleNode("@type").text == "check-box")
				strStyle = AppendAttribute(strStyle, "MARGIN-LEFT: 2px; MARGIN-TOP: 2px");

			if (IsDataSheet(objElem))
				{
				if (strType == "text-box")
					{
					var	objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-BACK-COLOR");
					if (objProperty != null)
						strStyle = AppendAttribute(strStyle, "BACKGROUND-COLOR: " + objProperty.text);

					objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-FORE-COLOR");
					if (objProperty != null)
						strStyle = AppendAttribute(strStyle, "COLOR: " + objProperty.text);

					objProperty = objElem.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-CELLS-EFFECT");
					if (objProperty != null)
						strStyle = AppendAttribute(strStyle, MapDataSheetBorder(objProperty));
					}
				if (strType == "label")
					strStyle = AppendAttribute(strStyle, "TEXT-ALIGN: center");
				}

			return AppendAttribute(strStyle, "OVERFLOW: hidden");
			}

		function GetBorderStyle(objElem)
			{
			var objBS = objElem.selectSingleNode("BORDER-STYLE");

			if (objBS != null)
				{
				return "BORDER-STYLE: " + MapBorderStyle(objBS);
				}
			return "";
			}	

		function GetBorderColor(objElem, strStyle)
			{
			var objBC = objElem.selectSingleNode("BORDER-COLOR");

			if (objBC != null)
				{
				// If we don't have a border-color specified, then make it transparent
				if (objBC.text != "")
					strStyle = AppendAttribute(strStyle, "BORDER-COLOR: " + objBC.text);
				else
					strStyle = AppendAttribute(strStyle, "BORDER-COLOR: transparent");
				}
			
			return strStyle;
			}

		var rgHyperlinkAttr = new Array("BORDER-WIDTH", "BORDER-STYLE", "TEXT-ALIGN",
										"FONT-WEIGHT", "FONT-SIZE", "FONT-FAMILY", "FONT-STYLE", "VISIBILITY", "Z-INDEX");

		function GetHyperlinkStyle(nodelist)
			{
			var objElem = nodelist.item(0);
			var strStyle = GetItemStyle(objElem, rgHyperlinkAttr);
			strStyle = GetBorderColor(objElem, strStyle);
			strStyle = AppendAttribute(strStyle, GetItemPosition(objElem, true));
			strStyle = GetOverflowStyle(objElem, strStyle);
			strStyle = GetPaddingStyle(objElem, strStyle, rgPaddingAttr);	

			return AppendAttribute(strStyle, "OVERFLOW: hidden");
			}

		var rgCheckboxAttr = new Array("COLOR", "BACKGROUND-COLOR", "VISIBILITY", "Z-INDEX");

		function GetCheckboxStyle(nodelist)
			{
			var objElem = nodelist.item(0);
			var strStyle = GetItemStyle(objElem, rgCheckboxAttr);
			strStyle = AppendAttribute(strStyle, "BORDER-STYLE: solid; BORDER-WIDTH: 0");
			return AppendAttribute(strStyle, GetItemPosition(objElem, true));
			}

		var rgLineAttr = new Array("COLOR", "BACKGROUND-COLOR", "BORDER-WIDTH", "BORDER-STYLE", "VISIBILITY", "Z-INDEX");

		function GetLineStyle(nodelist)
			{
			objElem = nodelist.item(0);
			var strStyle = GetItemStyle(objElem, rgLineAttr);
			strStyle = GetBorderColor(objElem, strStyle);

			var objBorder = GetStyleNode(objElem, "BORDER-WIDTH");
			if (objBorder != null)
				{
				var strWidth = objElem.selectSingleNode("WIDTH").text;
				if (strWidth == "0in")
					strWidth = objBorder.text;

				var strHeight = objElem.selectSingleNode("HEIGHT").text;
				if (strHeight == "0in")
					strHeight = objBorder.text;

				strStyle = AppendAttribute(strStyle, "WIDTH: " + strWidth);
				strStyle = AppendAttribute(strStyle, "HEIGHT: " + strHeight);
				}

			return AppendAttribute(strStyle, GetItemPosition(objElem, false));
			}

		var rgImageAttr = new Array("BORDER-WIDTH", "BORDER-STYLE", "VISIBILITY", "Z-INDEX");

		function GetImageStyle(nodelist)
			{
			var objElem = nodelist.item(0);
			var strStyle = GetItemStyle(objElem, rgImageAttr);
			strStyle = GetBorderColor(objElem, strStyle);
			return AppendAttribute(strStyle, GetItemPosition(objElem, true));
			}

		var rgRadioButtonAttr = new Array("VISIBILITY", "Z-INDEX");

		function GetRadioButtonStyle(nodelist)
			{
			var objElem = nodelist.item(0);
			var strStyle = GetItemStyle(objElem, rgRadioButtonAttr);
			return AppendAttribute(strStyle, GetItemPosition(objElem, true));
			}

		var rgBasicAttr = new Array("COLOR", "BACKGROUND-COLOR", "BORDER-WIDTH", "BORDER-STYLE", "VISIBILITY", "Z-INDEX");

		function GetBasicStyle(nodelist)
			{
			var objElem = nodelist.item(0);
			var strStyle = GetItemStyle(objElem, rgBasicAttr);
			strStyle = GetBorderColor(objElem, strStyle);
			return AppendAttribute(strStyle, GetItemPosition(objElem, true));
			}

		function GetItemStyle(objElem, rgAttr)
			{
			var strStyle = "";
			var objNode;
			for (var iAttr in rgAttr)
				{
				objNode = objElem.selectSingleNode(rgAttr[iAttr]);
				if (objNode != null && objNode.text != "")
					strStyle = AppendAttribute(strStyle, rgAttr[iAttr] + ": " + objNode.text);
				}

			return strStyle;
			}

		var rgBodyAttr = new Array("BACKGROUND-POSITION", "BACKGROUND-REPEAT");

		function GetBodyStyle(nodelist)
			{
			var objElem = nodelist.item(0);
			var strStyle = "";
			var objImage = objElem.selectSingleNode("RPTML/REPORT[1]/BACKGROUND-IMAGE")
			if (objImage != null) 
				{
				strStyle = "BACKGROUND-IMAGE:url('" + objImage.text + "'); ";
				strStyle += GetItemStyle(objElem.selectSingleNode("/RPTML/REPORT[1]"), rgBodyAttr);
				}

			if (IsDataSheet(objElem))
					strStyle = AppendAttribute(strStyle, "MARGIN: 0px");				
					
			return strStyle;
			}			

		//maps the scroll style to overflow
		function GetOverflowStyle(objElem, strStyle)
			{
			var objClass = objElem.selectSingleNode("CLASS");
			if (objClass != null && objClass.text != "")
				{
				var objScroll = objElem.selectSingleNode("/RPTML/REPORT[1]/STYLE[@id='"+objClass.text+"']");
				if (objScroll != null && objScroll.text != "")
					{
					var strScroll = GetNodeText(objScroll, "SCROLL");
								
					if (strScroll == "vertical" || strScroll == "both")
						strStyle = AppendAttribute(strStyle, "OVERFLOW-Y: scroll");
					if (strScroll == "horizontal" || strScroll == "both")
						strStyle = AppendAttribute(strStyle, "OVERFLOW-X: scroll");
					}
				}
			return strStyle;
			}

		//maps the padding attributes
		function GetPaddingStyle(objElem, strStyle, rgAttr)
			{
			var objClass = objElem.selectSingleNode("CLASS");
			var objNode;
			if (objClass != null && objClass.text != "")
				{
				var objStyle = objElem.selectSingleNode("/RPTML/REPORT[1]/STYLE[@id='"+objClass.text+"']");
				if (objStyle != null)
					{
					for (var iAttr in rgAttr)
						{
						objNode = objStyle.selectSingleNode(rgAttr[iAttr]);
						if (objNode != null && objNode.text != "0in")
							strStyle = AppendAttribute(strStyle, rgAttr[iAttr] + ": " + objNode.text);
						else
							strStyle = AppendAttribute(strStyle, rgAttr[iAttr] + ": 1px");
						}
					}
				}
			return strStyle;
			}

		function GetStyleNode(objElem, strName)
			{
			var objNode = objElem.selectSingleNode(strName);
			if (objNode == null)
				objNode = objElem.selectSingleNode("/RPTML/REPORT[1]/STYLE[@id='"+objElem.selectSingleNode("CLASS").text+"']/" + strName);
			return objNode;
			}

		function GetItemClass(nodelist, strName)
			{
			var objElem = nodelist.item(0);
			var strClass = "";

			// UNDONE: Need to add remaining clas types/names
			switch (strName)
				{
				case "label":
					if (objElem.selectSingleNode("CONTROL-SOURCE") != null)
						strClass = "MsoBoundSpan";
					else
						strClass = "MSTheme-Label";
					break;
				case "text":
					strClass = "MsoTextbox";
					break;
				case "hyperlink":
					strClass = "MsoHyperlinkDisplayText";
					break;
				case "rectangle":
					strClass = "MsoRectangle";
					break;
				}

			if(IsDataSheet(objElem) && (strName == "label" || strName == "text"))
				{
				strClass += " MSODatasheetText";
				}
			else
				{
				var objClass = objElem.selectSingleNode("CLASS");
				if (objClass != null)
					{
					if (strClass.length > 0)
						strClass = strClass + " ";
					strClass = strClass + objClass.text;
					}
				}

			return strClass;
			}

		function IsGeneralTextAlign(nodelist)
			{
			var objElem = nodelist.item(0);
			var objClass = objElem.selectSingleNode("CLASS");
			if (objClass != null)
				{
				objStyleNode = GetStyleNode(objElem, "TEXT-ALIGN");
				if (objStyleNode != null && objStyleNode.text == "general")
					return true;
				}
			if (IsDataSheet(objElem))
				return true;
			return false;
			}

		function GetSectionPositionHelper(nodelist)
			{
			return GetSectionPosition(nodelist.item(0));
			}


		function GetSectionPosition(objElem)
			{
			if (objElem.selectSingleNode("/RPTML/REPORT[1]/LAYOUT").text == "grid" || IsDataSheetForm(objElem))
				return GetSectionGridPosition(objElem);
			else
				return GetSectionAbsolutePosition(objElem);
			}

		var rgSectionGridAttr = new Array("LEFT", "TOP");

		function GetSectionGridPosition(objElem)
			{
			var nWidth = 0;

			var fIsDataSheet = IsDataSheetForm(objElem);
			var nColumnOrder = Number(GetNodeText(objElem, "COLUMN-ORDER", "0"));
			var objHeader;
			var objColumns;
			var objColumn;
			var strSuffix;
			var strWidth;
			
			if (fIsDataSheet)
				objHeader = objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='detail']");
			else
				objHeader = objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='page_header']");
				
			if (objHeader != null)
				{
				if (fIsDataSheet)
					objColumns = objHeader.selectNodes("REPORT-ITEM[COLUMN-WIDTH]");
				else
					objColumns = objHeader.selectNodes("REPORT-ITEM");
				if (objColumns.length > 0)
					{
					strSuffix = GetSuffix(objColumns.item(0).selectSingleNode("COLUMN-WIDTH").text);

					for (var iColumn = 0; iColumn < objColumns.length; iColumn++)
						{
						objColumn = objColumns.item(iColumn);
						if (objColumn.selectSingleNode("COLUMN-WIDTH") != null)
							{
							strWidth = objColumn.selectSingleNode("COLUMN-WIDTH").text;
							nWidth += Number(GetBaseValue(strWidth, strSuffix));
							}
						else
							nWidth += 2;		// UNDONE: Is this a good default when no column width is specified?
						}

					nWidth = String(nWidth) + strSuffix;
					}
				}

			var strPosition = "";
			strPosition = GetItemStyle(objElem, rgSectionGridAttr);
			var strHeight = GetNodeText(objElem, "/RPTML/REPORT[1]/ROW-HEIGHT", "auto");
			if (strHeight != "")
				strPosition = AppendAttribute(strPosition, "HEIGHT: " + strHeight);
			return AppendAttribute(strPosition, "WIDTH: " + nWidth);
			}

		var rgSectionAbsoluteAttr = new Array("LEFT", "TOP", "WIDTH");

		function GetSectionAbsolutePosition(objElem)
			{
			var strHeight = objElem.selectSingleNode("HEIGHT").text;

			var nAdjust = 0;
			var strSuffix = GetSuffix(strHeight);
			var strSection = objElem.selectSingleNode("@type").text;
			var objBelow;
			var strAdjust = "";

			switch (strSection)
				{
				case "report_header":
					objBelow = objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='page_header']");
					if (objBelow != null)
						{
						strAdjust = objBelow.selectSingleNode("HEIGHT").text;
						nAdjust = Number(GetBaseValue(strAdjust, strSuffix));
						}
					break;
				case "page_footer":
					objBelow = objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='report_footer']");
					if (objBelow != null)
						{
						strAdjust = objBelow.selectSingleNode("HEIGHT").text;
						nAdjust = Number(GetBaseValue(strAdjust, strSuffix));
						}
					// fall through...
				case "report_footer":
					if (IncludeNavigationBar(objElem))
						nAdjust += (nAdjust == 0 ? .4 : .33);		// height needed for nav bar
					break;
				}

			if (nAdjust > 0)
				{
				var nHeight = Number(GetBaseValue(strHeight, strSuffix)) + nAdjust;
				strHeight = String(nHeight) + strSuffix;
				}

			var strPosition = GetItemStyle(objElem, rgSectionAbsoluteAttr);
			if (objElem.selectSingleNode("WIDTH") == null)
				{
				var strWidth = GetNodeText(objElem, "/RPTML/REPORT[1]/WIDTH", "6in")
				strPosition = AppendAttribute(strPosition, "WIDTH: " + strWidth);
				}
			return AppendAttribute(strPosition, "HEIGHT: " + strHeight);
			}

		function GetItemPosition(objElem, fIncludeSize)
			{
			if (objElem.selectSingleNode("/RPTML/REPORT[1]/LAYOUT").text == "grid" || IsDataSheetForm(objElem))
				return GetItemGridPosition(objElem, fIncludeSize);
			else
				return GetItemAbsolutePosition(objElem, fIncludeSize);
			}

		function GetItemGridPosition(objElem, fIncludeSize)
			{
			var nLeft = 0;
			var nWidth = 1.8;		// UNDONE: Is this a good default when no column width is specified?
			var fIsDataSheet = IsDataSheetForm(objElem);
			var nColumnOrder = Number(GetNodeText(objElem, "COLUMN-ORDER", "0"));
			var objHeader;
			var objColumns;
			var objColumn;
			var strSuffix = "";
			var nColumnTemp;
			var strWidth= "";
			
				fRTLMode = (GetNodeText(objElem, "/RPTML/REPORT[1]/DIR") == 'right-to-left');
				objColumns = objElem.selectNodes("preceding-sibling::REPORT-ITEM | self::node()");

				if (objColumns.length > 0)
					{
					strSuffix = GetSuffix(objColumns.item(0).selectSingleNode("COLUMN-WIDTH").text);
					var nLength = fIsDataSheet ? objColumns.length : (objColumns.length - 1);
					
					for (var iColumn = 0; iColumn < nLength; iColumn++)
						{
						objColumn = objColumns.item(iColumn);
						nColumnTemp = Number(GetNodeText(objColumn, "COLUMN-ORDER", "0"));

						// for data sheets if column is to the right of current element, skip this column
						if (!fIsDataSheet || ((nColumnOrder > nColumnTemp) || ((nColumnOrder == nColumnTemp) && iColumn < nLength-1)))
							{
							if (objColumn.selectSingleNode("COLUMN-WIDTH") != null)
								{
								strWidth = objColumn.selectSingleNode("COLUMN-WIDTH").text;
								nLeft += Number(GetBaseValue(strWidth, strSuffix));
								}
							// else
							//	nLeft += 2;		// UNDONE: Is this a good default when no column width is specified?
							}
						}
					nLeft = String(nLeft) + strSuffix;
					if (fIsDataSheet)
						nWidth = GetNodeText(objElem, "COLUMN-WIDTH", "1in");
					else
						nWidth = objColumns.item(objColumns.length-1).selectSingleNode("COLUMN-WIDTH").text;
					}

			var strHeight = GetNodeText(objElem, "/RPTML/REPORT[1]/ROW-HEIGHT", "1.3em");
			var strPosition = "";

			strPosition = AppendAttribute(strPosition, "HEIGHT: " + strHeight);
			
			return AppendAttribute(strPosition, (fRTLMode ? "RIGHT:" :  "LEFT:") + nLeft + "; WIDTH: " + nWidth + (fRTLMode ? "; TEXT-ALIGN: RIGHT" : ""));
			}

		var rgItemAbsoluteAttr = new Array("HEIGHT", "WIDTH");

		function GetItemAbsolutePosition(objElem, fIncludeSize)
			{
			var strTop  = objElem.selectSingleNode("TOP").text;
			var strLeft = objElem.selectSingleNode("LEFT").text;

			var nAdjust = 0;
			var strSuffix = GetSuffix(strTop);
			var strSection = objElem.selectSingleNode("../@type").text;
			var objAbove;
			var nTop;
			var objParent;
			var nTopAdjust;
			var nLeftAdjust;

			switch (strSection)
				{
				case "page_header":
					objAbove = objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='report_header']");
					if (objAbove != null)
						{
						strAdjust = objAbove.selectSingleNode("HEIGHT").text;
						nAdjust = Number(GetBaseValue(strAdjust, strSuffix));
						}
					break;
				case "report_footer":
					objAbove = objElem.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='page_footer']");
					if (objAbove != null)
						{
						strAdjust = objAbove.selectSingleNode("HEIGHT").text;
						nAdjust = Number(GetBaseValue(strAdjust, strSuffix));
						}
					// fall through...
				case "page_footer":
					if (IncludeNavigationBar(objElem))
						nAdjust += (nAdjust == 0 ? .4 : .33);		// height needed for nav bar
				}

			if (nAdjust > 0)
				{
				nTop = Number(GetBaseValue(strTop, strSuffix)) + nAdjust;
				strTop = String(nTop) + strSuffix;
				}

			if (objElem.selectSingleNode("@type").text == "radio-button" || 
			    objElem.selectSingleNode("@type").text == "label" || 
			    objElem.selectSingleNode("@type").text == "check-box")
				{
				objParent = GetParentOptionGroup(objElem)
				if (objParent != null)
					{
					strSuffix = GetSuffix(objParent.selectSingleNode("TOP").text);

					nTopAdjust  = Number(GetBaseValue(objParent.selectSingleNode("TOP").text,  strSuffix));
					nLeftAdjust = Number(GetBaseValue(objParent.selectSingleNode("LEFT").text, strSuffix));

					if (objElem.selectSingleNode("@type").text == "label" &&
						(objElem.selectSingleNode("../REPORT-ITEM[@id='" + objElem.selectSingleNode("@parent").text + "']/@type").text == "radio-button" ||
						 objElem.selectSingleNode("../REPORT-ITEM[@id='" + objElem.selectSingleNode("@parent").text + "']/@type").text == "check-box"))
						{
						strTop = GetParent(objElem).selectSingleNode("TOP").text;		// align top of label with top of radio-button
						nLeftAdjust -= .05;												// extra space required between label and radio-button
						}

					strTop  = String(Number(GetBaseValue(strTop, strSuffix))  - nTopAdjust)  + strSuffix;
					strLeft = String(Number(GetBaseValue(strLeft, strSuffix)) - nLeftAdjust) + strSuffix;
					}
				}

			var strPosition = (fIncludeSize ? GetItemStyle(objElem, rgItemAbsoluteAttr) : '');
			return AppendAttribute(strPosition, "TOP: " + strTop + "; LEFT: " + strLeft);
			}

		function GetParent(objElem)
			{
			var objParentName = objElem.selectSingleNode("@parent");
			if (objParentName == null)
				return null;
			return objElem.selectSingleNode("../REPORT-ITEM[@id='" + objParentName.text + "']");
			}

		function GetParentOptionGroupHelper(nodelist)
			{
			return GetParentOptionGroup(nodelist.item(0));
			}


		function GetParentOptionGroup(objElem)
			{
			var objParentName;
			while (true)
				{
				objParentName = objElem.selectSingleNode("@parent");
				if (objParentName == null)
					break;
				objElem = objElem.selectSingleNode("../REPORT-ITEM[@id='" + objParentName.text + "']");
				if (objElem == null)
					break;
				if (objElem.selectSingleNode("@type").text == "option-group")
					return objElem;
				}
			return null;
			}

		function GetSuffix(strVal)
			{
			var cch;
			var ich;
			for (ich = strVal.length; ich > 0; ich--)
				{
				cch = strVal.charAt(ich - 1);
				if ((cch >= 'a' && cch <= 'z') || (cch >= 'A' && cch <= 'Z'))
					continue;
				break;
				}
			return strVal.substr(ich);
			}

		function GetBaseValue(strVal, strSuffix)
			{
			return strVal.substr(0, strVal.length - strSuffix.length);
			}

		function AppendAttribute(strList, strAttr)
			{
			if (strList.length > 0)
				strList += "; ";
			return strList + strAttr;
			}

		function IncludeReportItemHelper(nodelist)
			{
			return IncludeReportItem(nodelist.item(0));
			}

		function IncludeReportItem(objElem)
			{
			// skip all items if datasheet
			if (IsDataSheetForm(objElem))
				return false;

			var thisNode = objElem;

			// We don't want to include items inside tab-pages so
			// scan the parent chain looking for a tab-page.
			var objParentName;
			while (true)
				{
				objParentName = objElem.selectSingleNode("@parent");
				if (objParentName == null)
					break;
				objElem = objElem.selectSingleNode("../REPORT-ITEM[@id='" + objParentName.text + "']");
				if (objElem == null)
					break;
				if (objElem.selectSingleNode("@type").text == "tab-page")
					return false;
				}

			// Skip items that are inside option-groups
			var objParent = GetParentOptionGroup(thisNode);
			if (objParent != null)
				return false;

			return true;
			}

		function IncludeControlSource(objElem)
			{
			// We want to blank out the control source
			// if controls are in report/page header/footer
			var strType = objElem.selectSingleNode("../@type").text;
			if (strType != 'report_header' && strType != 'page_header' && strType != 'page_footer' && strType != 'report_footer')
				{
				var strSource = GetNodeText(objElem, "CONTROL-SOURCE", "");
				if ((strSource.match(/\[Forms\]\!/i) == null) || (strSource.match(/Forms\!/i) == null))
					return true;
				}
			return false;
			}

		function OrphanedRadioButton(nodelist)
			{
			var objElem = nodelist.item(0);
			// if this radio button does not belong to an option group, return true
			var objParent = objElem.selectSingleNode("@parent");
			if ((objParent != null) && (objElem.selectSingleNode("../REPORT-ITEM[@id='" + objParent.text + "' and @type='option-group']") != null))
				return false; //has an option group for a parent
			return true;
			}

		function IsReportHelper(nodelist)
			{
			return IsReport(nodelist.item(0));
			}
			

		function IsReport(objElem)
			{
			if (GetNodeText(objElem, "/RPTML/REPORT[1]/OBJECT-TYPE", "") == "report")
				return true;
			return false;
			}

		function IsValueList(nodelist)
			{
			if (GetNodeText(nodelist.item(0), "ROW-SOURCE-TYPE", "") == "Value List")
				return true;
			return false;
			}

		function includeTabIndex(nodelist)
			{
			var objElem = nodelist.item(0);
			if (IsReport(objElem) || objElem.selectSingleNode("TAB-INDEX") == null)
				return false;
			return true;
			}

		function GetNodeText(objNode, strPath, strDefault)
			{
			var objResult = objNode.selectSingleNode(strPath);
			return (objResult != null ? objResult.text : strDefault);
			}

		function IsRightToLeft(objElem, strLTR, strRTL)
			{
			if (GetNodeText(objElem.item(0), "/RPTML/REPORT[1]/DIR","") == 'right-to-left')
				return strRTL;
			return strLTR;
			}

		function GetGroupHeaderExpando(nodelist)
			{
			var objGroupHeader = nodelist.item(0);
			var strExpando = "";
			
			var objControlSource = objGroupHeader.selectSingleNode("CONTROL-SOURCE");
			if (objControlSource != null)
				{
				var objField = objGroupHeader.selectSingleNode("/RPTML/REPORT[1]/DATA-MODEL/ROW-SOURCE/FIELD[@id='" + objControlSource.text + "']");
				if (objField != null)
					{
					strExpando = '<IMG class=MsoExpandCollapse id=';
					strExpando += StripTableNames(GetFieldName(objField))+"Expand"; 
					strExpando += ' src="owc://GIF/#11250" style="LEFT: 0.083in; POSITION: absolute; TOP: 0.083in; Z-INDEX: 32768" tabIndex=1>';
					}
				}
			
			return strExpando
			}

		function GetAccessKey(nodelist)
			{
			var objCaption = nodelist.item(0);
			var strCaption = "";
			if (objCaption != null)
				{
				var objAccessKey = objCaption.selectSingleNode("../ACCESS-KEY");
				if (objAccessKey != null)
					{
					strCaption = objCaption.text;
					strCaption = strCaption.replace(new RegExp("(^[^" + objAccessKey.text + "])*" + objAccessKey.text + "(.*$)", "g"), "$1<U>" + objAccessKey.text + "</U>$2");
					}
				}
			return strCaption;
			}

		function IsDataSheetFormHelper(objElem)
			{
			return IsDataSheetForm(objElem.item(0));
			}

		function IsDataSheetForm(objElem)
			{
			if (GetNodeText(objElem, "/RPTML/REPORT[1]/DEFAULT-VIEW", "") == "datasheet" &&
				GetNodeText(objElem, "/RPTML/REPORT[1]/OBJECT-TYPE", "") == "form")
				return true;
			return false;
			}

		function IsDataSheetHelper(objElem)
			{
			return IsDataSheet(objElem.item(0));
			}

		function IsDataSheet(objElem)
			{
			if (GetNodeText(objElem, "/RPTML/REPORT[1]/DEFAULT-VIEW", "") == "datasheet")
				return true;
			return false;
			}

		function GetColumnLabels(objElem)
			{
			var strLabels = "";

			var objColumns = objElem.item(0).selectNodes("/RPTML/REPORT[1]/SECTION[@type='detail']/REPORT-ITEM[COLUMN-WIDTH]");
			var objColumn;
			
			if (objColumns.length > 0)
				{
				for (var iCol = 0; iCol < objColumns.length; iCol++)
					{
					objColumn = objColumns.item(iCol);

					strLabels += GetColumnLabel(objColumn);
					}
				}
			return strLabels;
			}

		function GetColumnLabel(objColumn)
			{
			var strLabelName = GetNodeText(objColumn, "@id", "");
			var objLabel = objColumn.selectSingleNode("/RPTML/REPORT[1]/SECTION[@type='detail']/REPORT-ITEM[@parent='" + strLabelName + "']")

			if (objLabel != null)
				strLabelName = GetMungedFieldName(objLabel);
			else
				strLabelName = GetMungedFieldName(objColumn);

			var strLabelHTML = "<SPAN id='" + strLabelName + "' ";
			strLabelHTML += "class='MSTheme-Label MSODatasheetText'";
			strLabelHTML += "style='" + GetItemPosition(objColumn, true) + "; OVERFLOW: hidden; POSITION: absolute; TEXT-ALIGN: center'>";

			var strCaption = "";
			if (objLabel != null)
				strCaption = GetNodeText (objLabel, "CAPTION", strLabelName);
			else
				strCaption = strLabelName;
			strCaption = strCaption.replace(/:$/, '');
				
			strLabelHTML += strCaption + "</SPAN>";

			return strLabelHTML;
			}
			
		function GetColumnTextBoxes(nodelist)
			{
			var objElem = nodelist.item(0);
			var strTextBoxes = "";

			var objColumns = objElem.selectNodes("/RPTML/REPORT[1]/SECTION[@type='detail']/REPORT-ITEM[COLUMN-WIDTH]");
			var objColumn;

			if (objColumns.length > 0)
				{
				for (var iColumn = 0; iColumn < objColumns.length; iColumn++)
					{
					objColumn = objColumns.item(iColumn);

					strTextBoxes += GetColumnTextBox(objColumn);
					}
				}
			return strTextBoxes;			

			}

		function GetColumnTextBox(objColumn)
			{
			var strLabelHTML = "<TEXTAREA id='" + GetMungedFieldName(objColumn) + "' ";
			strLabelHTML += "class='MsoTextbox MSODatasheetText' MsoTextAlign='general'";

			var	objBackColor = objColumn.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-BACK-COLOR");
			var objForeColor = objColumn.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-FORE-COLOR");
			var objBorder = objColumn.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-CELLS-EFFECT"); 
			strLabelHTML += "style='" + GetItemPosition(objColumn, true) + "; OVERFLOW: hidden; POSITION: absolute" + 
			((objBackColor != null) ? ";BACKGROUND-COLOR: " + objBackColor.text: "") +
			((objForeColor != null) ? ";COLOR: " + objForeColor.text: "") +
			((objBorder != null) ? ";" + MapDataSheetBorder(objBorder): "") +
			"'></TEXTAREA>";

			return strLabelHTML;
			}

		function MapDataSheetBorder(objBorder)
			{
			var strBorder = "";
			var strBorderColor = GetNodeText(objBorder, "/RPTML/REPORT[1]/DATASHEET-GRIDLINES-COLOR", "#000000");
			if (objBorder != null)
				{
				switch(objBorder.text)
					{
					case "sunken":
						return "BORDER-COLOR: " + strBorderColor + "; BORDER-STYLE:inset; BORDER-WIDTH:2px";
					case "raised":
						return "BORDER-STYLE:outset";
					case "flat":
					default:
						var objDirection = objBorder.selectSingleNode("/RPTML/REPORT[1]/DATASHEET-GRIDLINES-BEHAVIOR");
						var objHStyle = objBorder.selectSingleNode("/RPTML/REPORT[1]/HORIZONTAL-DATASHEET-GRIDLINE-STYLE");
						var objVStyle = objBorder.selectSingleNode("/RPTML/REPORT[1]/VERTICAL-DATASHEET-GRIDLINE-STYLE");
						
						if (objDirection != null)
							{
							switch (objDirection.text)
								{
								case "horizontal":
									if (objHStyle != null)
										return "BORDER-BOTTOM: " + strBorderColor + " 1px " + MapBorderStyle(objHStyle) +
										"; BORDER-TOP: 0px; BORDER-RIGHT: 0px; BORDER-LEFT: 0px;"
									break;
								case "vertical":
									if (objVStyle != null)
										return "BORDER-RIGHT: " + strBorderColor + " 1px " + MapBorderStyle(objVStyle) + 
										"; BORDER-TOP: 0px; BORDER-BOTTOM: 0px; BORDER-LEFT: 0px;"
									break;								
								case "both":
									if (objHStyle != null && objVStyle != null)
										return "BORDER-RIGHT: " + strBorderColor + " 1px " + MapBorderStyle(objVStyle) + 
											   "; BORDER-BOTTOM: " + strBorderColor + " 1px " + MapBorderStyle(objHStyle) + 
											   "; BORDER-TOP: 0px; BORDER-LEFT: 0px;"
								case "none":
									return "BORDER-BOTTOM: 0px; BORDER-TOP: 0px; BORDER-RIGHT: 0px; BORDER-LEFT: 0px;";
								default:
									break;
								}
							}
						return "BORDER-STYLE:solid; BORDER-WIDTH: 1px; BORDER-COLOR: " + strBorderColor + ";";
					}
				}
			}

		function MapBorderStyle(objBS)
			{
			if (objBS != null)
				{
				if (objBS.text == "solid" || objBS.text == "double-solid")
					return "solid";
				if (objBS.text == "dashed" || objBS.text == "short-dashes" || objBS.text == "dash-dot")
					return "dashed";
				if (objBS.text == "dotted" || objBS.text == "sparse-dots" || objBS.text == "dash-dot-dot")
					return "dotted";
				return objBS.text;
				}
			return "";
			}

		function GetDatasheetTopBorder(nodelist)
			{
			var objElem = nodelist.item(0);
			if (IsDataSheet(objElem))
				{
				var strBorderColor = GetNodeText(objElem, "/RPTML/REPORT[1]/DATASHEET-GRIDLINES-COLOR", "#000000");
				return "BORDER-BOTTOM: " + strBorderColor + " 1px solid;";
				}
			return "";
			}

		function GetListDisplayFieldNum(objNode)
			{
			var strText = GetNodeText(objNode, "COLUMN-WIDTHS", "");
			var strTemp = strText;
			var nColumn = 0;

			if (strTemp == "0")
				return 1;

			while (strTemp.length > 0 && strTemp != "0" && strText.match(/;/))
				{
				strTemp = strText.replace(/^([0-9])*;.*$/, '$1');
				strText = strText.replace(/^[0-9]*;/, '');
				nColumn++;
				}
			return (strTemp == "0") ? nColumn : 0;
			}

		function GetLocaleFontFamily(objRoot)
			{
			objElem = objRoot.item(0).selectSingleNode("SYSTEM-SETTINGS");
			if (objElem == null)
				{
				strFont = "FONT-SIZE: 8pt; FONT-FAMILY: Tahoma";
				}
			else
				{
				switch (objElem.nodeValue)
					{
					// English
					case "1033":
					default:
						strFont = "FONT-SIZE: 8pt; FONT-FAMILY: Tahoma";
						break;

					// Japanese - MS P Gothic
					case "1041":
					case "1153":
						strFont = "FONT-SIZE: 9pt; FONT-FAMILY:  &#EF;&#BC;&#AD;&#EF;&#BC;&#B3;&#20;&#EF;&#BC;&#B0;&#E3;&#82;&#B4;&#E3;&#82;&#B7;&#E3;&#83;&#83;&#E3;&#82;&#AF;";
						break;
					
					// Korean - Gulim
					case "1042":
						strFont = "FONT-SIZE: 9pt; FONT-FAMILY: &#EA;&#B5;&#B4;&#EB;&#A6;&#BC;";
						break;
					
					// Traditional Chinese - New MingLi
					case "1028":
					case "3076":
					case "5124":
						strFont = "FONT-SIZE: 9pt; FONT-FAMILY: &#E6;&#96;&#B0;&#E7;&#B4;&#B0;&#E6;&#98;&#8E;&#E9;&#AB;&#94;";
						break;
					
					// Simplified Chinese - Song
					case "2052":
					case "4100":
						strFont = "FONT-SIZE: 9pt; FONT-FAMILY: &#E5;&#AE;&#8B;&#E4;&#BD;&#93;";
						break;
					
					}
				}
			
			return strFont;
			}
			
		// add brackets around field names if needed
		function BracketFieldName (strFieldName)
			{
			if (!strFieldName.match(/^\[.*\]$/))
				return '[' + strFieldName + ']';
			return strFieldName;
			}

		function GetDataType(objFieldName)
			{
			if (objFieldName != null)
				{
				var strRecordSource = objFieldName.selectSingleNode("/RPTML/REPORT/RECORD-SOURCE").text;
				strRecordSource = strRecordSource.replace(/^[ ]*(.+[^ ])[ ]*$/, '$1');		// remove spaces from beginning and end
				return objFieldName.selectSingleNode("/RPTML/REPORT[1]/DATA-MODEL/ROW-SOURCE[@id='" + strRecordSource + "']/FIELD[@id='" + objFieldName.text.replace (/.*\./, '') + "']/@datatype").text;
				}
			return 8; // string type
			}
			
		function GetLink(objElem)
			{
			return GetNodeText(objElem.item(0), "RPTML/REPORT[1]/LINK", "#0000ff");
			}
			
		function GetVLink(objElem)
			{
			return GetNodeText(objElem.item(0), "RPTML/REPORT[1]/VLINK", "#800080");
			}

		function DAPabsoluteChildNumber(objElem)
			{
			var objSibling = objElem.selectNodes("preceding-sibling::node() | self::node()");
			if (objSibling != null)
				return objSibling.length;
			else
				return 1;
			}

		function OpenHTMLTag(fBeginTag)
			{
			var strHTMLtag = "";

			if (fBeginTag)
				strHTMLtag += "<HTML";
			else
				strHTMLtag += ">";

			return strHTMLtag;
			}

		function OfficeNamespace()
			{
			var strNamspace = ' xmlns:o="urn:schemas-microsoft-com:office:office"';

			return strNamspace;
			}

		function AccessNamespace()
			{
			var strNamspace = ' xmlns:a="urn:schemas-microsoft-com:office:access"';

			return strNamspace;
			}

		function REChtmlNamespace()
			{
			var strNamspace = ' xmlns="http://www.w3.org/TR/REC-html40"';

			return strNamspace;
			}

		function RTLAttrib()
			{
			var strAttrib = ' DIR="RTL"';

			return strAttrib;
			}

		function CloseHTMLTag()
			{
			var strHTMLtag = "<HTML>";

			return strHTMLtag;
			}
			
		function GetSmartTag(nodelist, fOpenTag)
			{
			var objElem = nodelist.item(0);
			var objTagPrefix = objElem.selectSingleNode("SMART-TAG-PREFIX");
			var objTagName = objElem.selectSingleNode("SMART-TAG-NAME");
			var strTag = "<";
			var strTagPrefix = objTagPrefix.text;
			var strTagName = objTagName.text;

			if (!fOpenTag)
				strTag += "/";

			strTag += strTagPrefix;
			strTag += ":";
			strTag += strTagName;
			strTag += ">";

			return strTag;
			}

	]]></msxsl:script>

</xsl:stylesheet>

