<?php
/**
 * Copyright (C) OElove Weixin All rights reserved.
 * <E-Mail：service@phpcoo.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 *     http://www.OElove.com
 * Update 2020.12.01
 */
header("Content-type: text/html; charset=utf-8");
@set_time_limit(0);
@error_reporting(E_ALL & ~ E_NOTICE);
@date_default_timezone_set("Asia/Shanghai"); //0.02.14
define('BASE_ROOT', dirname(__FILE__).'/');
require_once(BASE_ROOT."source/core/oephp/Application.php");
define("WEIXIN_DEBUG", true); //开启日志
require_once(BASE_ROOT."source/control/weixin/weixinapi.php");
list ($c, $a, $rqsData) = XWeixin::initCA();
if (empty($a)) {$a = 'run';}
$white_c = array(
    "post", "click", "welcome", "location", "text", "share", 
);
if (!in_array($c, $white_c)) {
    XHandle::error('Weixin controller is not forbid!');
}
define("GB_OELOVE_C", $c);
define("GB_OELOVE_A", $a);
//载入控制器类文件
$hook_base = BASE_ROOT."source/control/oephp/oelove.apphook.php";
$control_path = BASE_ROOT."source/control/weixin/{$c}.php";
if (!file_exists($control_path)) {
    XHandle::error("Weixin controller file is not found!");
}
else {
    //过滤微信OPENID
    if (isset($rqsData['fromusername'])) {
        $rqsData['fromusername'] = XFilter::filterBadChar($rqsData['fromusername']);
    }
    require_once($hook_base);
    require_once($control_path);
    $control = new control($rqsData);
    $method = "control_{$a}";
    if (method_exists($control, $method)) {
        $control->$method();
    }
    else {
        XHandle::error("Weixin controller action is not found!");
    }
    unset($control);
}
?>