/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.06.05 Update by CL $
*/
$(function(){
    //登录类
    function OELogin() {
        this.loginname = ''; //用户名
        this.password = ''; //密码
        this.mobile = ''; //手机号
        this.mobilecode = ''; //手机验证码
        
        this._this_dialog = ''; //弹窗对象
        this.slide_time = 200; //速度
        
        this.can_send_sms = '0'; //是否开启验证码
        this.forward = '';
        this.au_mod = ''; //授权类型 weixin,wechat/sina/qq
        this.openid = ''; //openid
        this.obj_id = '';
        this.login_type = 'pwd'; //登录方式
        
        this.wake();
        this.pwdLogin();
        this.mobileLogin();
    } 
    
    OELogin.prototype = {
        
        //唤醒
        wake:function() {
            var _this = this;
            
            //初始化
            _this.can_send_sms = $("#can_send_sms").val();
            if (typeof(_this.can_send_sms) == 'undefined') {
                _this.can_send_sms = '0';
            }
            _this.forward = $("#forward").val();
            if (typeof(_this.forward) == 'undefined') {
                _this.forward = '';
            }
            _this.au_mod = $("#au_mod").val();
            if (typeof(_this.au_mod) == 'undefined') {
                _this.au_mod = '';
            }
            _this.openid = $("#openid").val();
            if (typeof(_this.openid) == 'undefined') {
                _this.openid = '';
            }
            
            //默认显示温馨提示 0.06.05
            if (_this.openid != '') {
                setTimeout(function() {
                    _this._this_dialog = OEUI.Dialog({
                        el: '#tips_box',
                        animated: 'zoomIn',
                        time:_this.slide_time,
                        type:'2'
                    });
                }, 100);
            }
            //关闭提示
            $(document).on("click", "[f='but_close_tips']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //选择登录方式
            $(document).on("click", "[f='but_select_type']", function(){
                var $type = $(this).attr("data-type");
                _this.login_type = $type;
                if ($type == "pwd") {
                    $(".type_pwd").show();
                    $(".type_mobi").hide();
                    $(this).attr("data-type", "mobile");
                    $(this).html("短信登录");
                }
                else {
                    $(".type_pwd").hide();
                    $(".type_mobi").show();
                    $(this).attr("data-type", "pwd");
                    $(this).html("密码登录");
                }
            });
            
            //去注册
            $(document).on("click", "[f='but_jump_reg']", function(){
                var $reg_url = $("#regurl").val();
                if (typeof($reg_url) == 'undefined') {
                    $reg_url = '';
                }
                if ($reg_url == '') {
                    $reg_url = WAP_APPFILE + "&c=passport&a=reg";
                }
                window.location.href = $reg_url;
            });
            
        },
        
        //使用密码登录
        pwdLogin:function() {
            var _this = this;
            
            $(document).on("click", "[f='but_login_pwd']", function(){
                _this.loginname = $("#loginname").val();
                _this.password = $("#password").val();
                
                if(_this.loginname == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入登录帐号/邮箱/手机号'
                    });
                    return;
                }
                if(_this.password == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入登录密码'
                    });
                    return;
                }
                
                _this.doLogin("pwd");
            });
        },
        
        //使用手机号登录
        mobileLogin:function() {
            var _this = this;
            
            $(document).on("click", "[f='but_login_mobi']", function(){
                _this.mobile = $("#mobile").val();
                _this.mobilecode = $("#mobilecode").val();
                
                if (_this.mobile == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入手机号'
                    });
                    return;
                }
                if (_this.mobilecode == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请输入手机验证码'
                    });
                    return;
                }
                
                _this.doLogin("mobi");
            });
        },
        
        
        doLogin:function(type) {
            var _this = this;
            
            if (type == 'pwd') {
                //使用密码登录
                var $obj_id = "but_login_pwd";
                var $post_url = WAP_APPFILE + "&c=passport&a=loginpost";
                var $send_data = {
                    'loginname':_this.loginname, 'password':_this.password, 
                    'au_mod':_this.au_mod, 'openid':_this.openid, 
                    'forward':_this.forward
                };
            }
            else {
                //使用短信登录
                var $obj_id = "but_login_mobi";
                var $post_url = WAP_APPFILE + "&c=passport&a=loginmobile";
                var $send_data = {
                    'mobile':_this.mobile, 'validcode':_this.mobilecode, 
                    'au_mod':_this.au_mod, 'openid':_this.openid, 
                    'forward':_this.forward
                };
            }
            
            if (!$("#"+$obj_id).hasClass("forbid_submit")) {
            
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+$obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: 'POST',
                    url: $post_url,
                    data: $send_data,
                    dataType: 'json',
                    success: function ($data) {
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        $json = eval($data);
                        $response = $json.response;
                        $result = $json.result;
                        
                        if ($response == '1') {
                            //成功
                            if (_this.forward == '') {
                                _this.forward = WAP_APPFILE+'&c=cp';
                            }
                            window.location.href = _this.forward;
                        }
                        else if ($response == '2') {
                            //整合OEM
                            window.top.location.href = $result;
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '登录失败，请检查帐号/密码！';
     
                            } 
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            });
                        }
                        $("#"+$obj_id).removeClass("forbid_submit");
                    },
                    error: function () {
                        $("#"+$obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
            
            }
            
        }
        
    }
    var login = new OELogin();
    
});
