/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/10 by BO $
*/
var inst_oebanner = null;
$(function(){
    //幻灯片
    slide = {
        slide: null,
        currentPageIndex: 0,
        playTimer: 0,
        mounted: function mounted() {
          this.init();
        },
        beforeDestroy: function beforeDestroy() {
          clearTimeout(this.playTimer);
          this.slide.destroy();
        },
        init: function init() {
          var _this2 = this;

          clearTimeout(this.playTimer);
          var nodeList = document.querySelectorAll('#slide .item');
          var length = nodeList.length;

          if (length < 2) {
            return;
          }

          var clientW = document.body.clientWidth;
          document.querySelector('#slide .wrapper').style.width = (length + 2) * clientW + 'px';
          $('#slide .item').css('width', clientW + 'px');
          this.slide = new BScroll(document.getElementById('slide'), {
            scrollX: true,
            scrollY: false,
            snap: {
              loop: true,
              // 开启循环播放
              stepX: clientW,
              // 每页宽度为 200px
              threshold: 0.3,
              // 滚动距离超过宽度/高度的 30% 时切换图片
              speed: 400 // 切换动画时长 400ms

            },
            click: true,
            useTransition: true,
            momentum: false,
            bounce: false,
            stopPropagation: true
          });
          this.slide.on('scrollEnd', function () {
            var pageIndex = _this2.slide.getCurrentPage().pageX;

            _this2.currentPageIndex = pageIndex;
            $('.indicator span').eq(pageIndex).addClass('current').siblings().removeClass('current');

            _this2.autoGoNext();
          }); // user touches the slide area

          this.slide.on('beforeScrollStart', function () {
            clearTimeout(_this2.playTimer);
          }); // user touched the slide done

          this.slide.on('scrollEnd', function () {
            _this2.autoGoNext();
          });
          window.bs = this.slide;
          this.autoGoNext();
        },
        nextPage: function nextPage() {
          this.slide.next();
        },
        prePage: function prePage() {
          this.slide.prev();
        },
        _onScrollEnd: function _onScrollEnd() {
          var pageIndex = slide.slide.getCurrentPage().pageX;
          slide.currentPageIndex = pageIndex;
          $('.docs_wrapper span').eq(pageIndex).addClass('current').siblings().removeClass('current');
          slide.autoGoNext();
        },
        autoGoNext: function autoGoNext() {
          var _this3 = this;

          clearTimeout(this.playTimer);
          this.playTimer = setTimeout(function () {
            _this3.nextPage();
          }, 4000);
        }
    };
    
});
