/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.03.02 Update by CL $
*/
$(function(){
    function OEBook() {
        this.api_url = WAP_APPFILE+"&c=index";
        this.wake();
    }
    OEBook.prototype = {
        
        wake:function() {
            var _this = this;
            
            //选择分类
            $(document).on("click", "[f='but_sel_bookcat']", function(){
                var $val = $(this).attr("data-val");
                $("[f='but_sel_bookcat']").removeClass("current");
                $(this).addClass("current");
                $("#book_catid").val($val);
                
            });
            //提交反馈
            $(document).on("click", "[f='but_submit_book']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $book_catid = $("#book_catid").val();
                if ($book_catid == '' || $book_catid == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请选择分类'
                    });
                    return;
                }
                var $book_title = $("#book_title").val();
                if ($book_title == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写标题'
                    });
                    return;
                }
                var $book_content = $("#book_content").val();
                if ($book_content == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写反馈内容'
                    });
                    return;
                }
                var $book_mobile = $("#book_mobile").val();
                if ($book_mobile == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写手机号'
                    });
                    return;
                }
                
                var $img1 = $("#img1_url").val();
                if (typeof($img1) == 'undefined') {
                    $img1 = '';
                }
                var $img2 = $("#img2_url").val();
                if (typeof($img2) == 'undefined') {
                    $img2 = '';
                }
                var $img3 = $("#img3_url").val();
                if (typeof($img3) == 'undefined') {
                    $img3 = '';
                }
                var $img4 = $("#img4_url").val();
                if (typeof($img4) == 'undefined') {
                    $img4 = '';
                }
                var $img5 = $("#img5_url").val();
                if (typeof($img5) == 'undefined') {
                    $img5 = '';
                }
                var $img6 = $("#img6_url").val();
                if (typeof($img6) == 'undefined') {
                    $img6 = '';
                }
                
                var $send_data = {
                    'a':'saveguestbook', 'catid':$book_catid, 
                    'title':$book_title, 'content':$book_content, 
                    'mobile':$book_mobile, 'img1':$img1, 'img2':$img2,
                    'img3':$img3, 'img4':$img4, 'img5':$img5, 'img6':$img6
                }
                _this.sendGuest($send_data);
                
            });
        },
        
        //提交反馈
        sendGuest:function($send_data) {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: WAP_APPFILE,
                    cache: false,
                    data:$send_data, 
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") { 
                            OEUI.toast({
                                type: 'bottom',
                                text: '提交成功，请等待客服处理'
                            });
                            setTimeout(function(){
                                window.location.reload();
                            }, 1000);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '提交失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            } 
        }
        
    }
    new OEBook();
});

