/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/05/07 by CL $
*/
var _inst_oesearch = null;
$(function(){
    
    //搜索类
    function OESearch() {
        this._search_dialog = null; //弹出对象
        this._search_box = "search_wrap"; //搜索框名称
        this.slide_time = 200; //0.05.07
        this.params = ""; //搜索项组合 item=value&item=value
        
        this.api_url = WAP_APPFILE+"&c=dynamic";
        this.id = '';
        this.zantype = ''; //点赞类型 add/cancel
        this.this_dom = '';
        
        this.wake();
        this.wakeOther();
        this.backTop();
    }
    
    OESearch.prototype = {
        
        //唤醒
        wake:function() {
            _this = this;
            
            //打开侧滑
            $(document).on("click", "[f='but_wake_search']", function(){
                _this._search_dialog = OEUI.Dialog({
                    el: '#'+_this._search_box,
                    animated: 'slideRightIn',
                    time:_this.slide_time
                });
            });
            //关闭侧滑
            $(document).on("click", "[f='close_wake_search']", function(){
                if (_this._search_dialog) {
                    _this._search_dialog.hide();
                }
            });
            //侧滑提交
            $(document).on("click", "[f='but_confirm_search']", function(){
                //按条件搜索，需重置
                $("#s_type").val("new");
                $("#s_uid").val("");
                $("[f='but_sel_type']").removeClass("current");
                $("[f='but_sel_type']:first").addClass("current");
                
                
                //关闭侧滑
                if (_this._search_dialog) {
                    _this._search_dialog.hide();
                }
                _this.submitSearch();
            });
            
            //选择类型
            $(document).on("click", "[f='but_sel_type']", function(){
                var $type = $(this).attr("data-val");
                if ($type == 'my') {
                    if (_LOGIN_STATUS == '0') {
                        _this.login();
                        return;
                    }
                }
                $("#s_type").val($type);
                $(this).addClass("current").siblings().removeClass("current");
                _this.submitSearch();
            });
            
        },
        
        
        //执行搜索
        submitSearch:function() {
            _this = this;
            
            _this.params = _this.buildParams(); //获取参数
            $reqs_url = _this.api_url+"&a=list&datatype=json";
            $reqs_url += "&"+_this.params;
            $("#reqs_url").val($reqs_url);
            $("#page").val("1");
            //重新搜索...
            setTimeout(function(){
                if (_inst_oepage) {
                    $("#"+_inst_oepage.pull_data_id).html("");
                    _inst_oepage.scroll.refresh();
                }
            }, 50);
        },
        
        //组合参数
        buildParams:function() {
            var $build_params = "";
            
            var arr_data = new Array();
            arr_data = [
                    's_gender', 's_age', 's_dist1', 's_dist2', 's_dist3', 's_dist4', 
                    's_type', 's_uid', 
                ];
                  
            $.each(arr_data, function(i, item) {
                $val = $("#"+item).val();
                if (typeof($val) == "undefined") {
                    $val = "";
                }
                if ($build_params.length == 0 || $build_params == "") {
                    $build_params += item+"="+encodeURIComponent($val);
                }
                else {
                    $build_params += "&"+item+"="+encodeURIComponent($val);
                }
            });
            return $build_params;
        },
        
        //跳到登录页
        login:function() {
            var _this = this;
            var $back_url = _this.api_url+'&nofollow=1';
            window.location.href = WAP_APPFILE+'&c=passport&a=login&forward='+encodeURIComponent($back_url);
        },
        
        
        //其他操作
        wakeOther:function() {
            var _this = this;
            
            //删除
            $(document).on("click", "[f='but_del']", function(){
                if (_LOGIN_STATUS == '0') {
                    _this.login();
                    return;
                }
                _this.id = $(this).attr("data-id");
                OEUI.confirm({
                    title: '温馨提示',
                    text: '确定要删除该动态吗？',
                    confirm: function () {
                        _this.submitDel();
                    }
                });
                
            });
            
            //点赞
            $(document).on("click", "[f='but_dianzan']", function(){
                if (_LOGIN_STATUS == '0') {
                    _this.login();
                    return;
                }
                _this.id = $(this).attr("data-id");
                if ($(this).hasClass('color_red')) {
                    _this.zantype = 'cancel';
                }
                else {
                    _this.zantype = 'add';
                }
                _this.this_dom = this;
                _this.submitZan();
            });
        },
        
        //删除
        submitDel:function() {
            var _this = this;
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data:{
                    a:'delete', id:_this.id
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == "1") { 
                        OEUI.toast({
                            type: 'bottom',
                            text: '删除成功'
                        });
                        $("#list_"+_this.id).remove();
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '删除失败，请检查';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });
                
        },
        
        //点赞
        submitZan:function() {
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data:{
                    a:'zans', id:_this.id
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    if ($response == "1") { 
                        var $zans = parseInt($(_this.this_dom).find("em").text());
                        if (_this.zantype == 'add') {
                            $(_this.this_dom).addClass('color_red');
                            $(_this.this_dom).find("em").text($zans+1);
                        }
                        else {
                            $(_this.this_dom).removeClass('color_red');
                            $(_this.this_dom).find("em").text($zans-1);
                        }
                    }
                    else {
                        if ($result != '') {
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            });
                        }
                    }
                },
                error: function() {
                }
            });
        },
        
        //返回顶部
        backTop: function () {
            var _this = this;
            var scroll = $('#pull_box .scroll')[0];
            $('[f="back_to_top"]').on('click', function () {
                _this.animateToTop(scroll.scrollTop, 0, 4, function (value) {
                    scroll.scrollTop = value;
                });
            });
        },
        //返回顶部动画
        animateToTop: function (m, n, rate, cb) {
            if(m == n || typeof m != 'number') {
                return;
            }
            if(!window.requestAnimationFrame) {
                requestAnimationFrame = function (fn) {
                    setTimeout(fn, 1000/60);
                }
            }
            n = n || 0;
            rate = rate || 2;
            var step = function () {
                m = m + (n - m)/rate;
                if(m<1) {
                    cb(n, true);
                    return;
                }
                cb(m, false);
                requestAnimationFrame(step);
            }
            step();
        }
    }
    _inst_oesearch = new OESearch();
});