/**
 * [OEUI] (C)2010-2099 oelove.com  biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * $ Last update 2020.11.11 by CL $
*/
$(function () {
    
    function OEYunrz() {
        this.api_url = _OE_FILE+'&c=yunrz';
        
        this.clickNext();
        this.clickSubmit();
        
    }

    OEYunrz.prototype = {
        
        //下一步
        clickNext:function() {
            var _this = this;
            //点击 “下一步” 
            $(document).on("click", "[f='but_submit_next']", function () {
                _this.obj_id = $(this).attr('id');
                
                var truename = $("#truename").val();
                var idnumber = $("#idnumber").val();
                
                if (truename == '') {
                    OEUI.message.msg({
                        text: '请输入真实姓名'
                    });
                    return false;
                }
                if (idnumber == '') {
                    OEUI.message.msg({
                        text: '请输入身份证号'
                    });
                    return false;
                }
                
                if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                    $("#"+_this.obj_id).addClass("forbid_submit");
                    var loading = OEUI.loading({
                        el: '#'+_this.obj_id,
                        width: 30,
                        height: 30
                    });
                    loading.show();
                    
                    $.ajax({
                        type: "POST",
                        url: _this.api_url,
                        cache: false,
                        data: {
                            a: "jycard", truename: truename, idnumber: idnumber, 
                            datatype: "json"
                        },
                        dataType: "json",
                        success: function (data) {
                            var response = data.response;
                            var result = data.result;
                            $("#"+_this.obj_id).removeClass("forbid_submit");
                            loading.remove();
                            
                            if (response == "1") {
                                window.location.href = _this.api_url+'&a=step2';
                            }
                            else {
                                if (result == '') {
                                    result = '输入错误，请检查';
                                }
                                OEUI.message.msg({
                                    text: result
                                });
                            }
                        },
                        error: function () {
                            $("#"+_this.obj_id).removeClass("forbid_submit");
                            loading.remove();
                            OEUI.message.msg({
                                text: '系统繁忙，请稍后再试'
                            });
                        }
                    });
                }
            });
            
        },
        
        //第二步
        clickSubmit: function () {
            var _this = this;
            //弹出协议
            $(document).on("click", "[f='but_open_rzxieyi']", function () {
                OEUI.modal.dialog({
                    type: 'iframe',
                    title: '认证服务协议',
                    width: '520',
                    height: '400',
                    content: _this.api_url+'&a=xieyi'
                });
            });
            
            //提交
            $(document).on("click", "[f='but_confirm_submit']", function () {
                _this.obj_id = $(this).attr('id');
                
                var mobile = $("#mobile").val();
                var mobile_code = $("#mobile_code").val();
                var agree = $("input[name='agree']:checked").val();
                if (typeof (agree) == "undefined") {
                    OEUI.message.msg({
                        text: '请同意认证服务协议'
                    });
                    return false;
                }
                if (mobile == '') {
                    OEUI.message.msg({
                        text: '请输入手机号码'
                    });
                    return false;
                }
                if (mobile_code == '') {
                    OEUI.message.msg({
                        text: '请输入手机验证码'
                    });
                    return false;
                }

                if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                    $("#"+_this.obj_id).addClass("forbid_submit");
                    var loading = OEUI.loading({
                        el: '#'+_this.obj_id,
                        width: 30,
                        height: 30
                    });
                    loading.show();

                    $.ajax({
                        type: "POST",
                        url: _this.api_url,
                        cache: false,
                        data: {
                            a: "submit", mobile: mobile, mobilecode: mobile_code,
                            datatype: "json"
                        },
                        dataType: "json",
                        success: function (data) {
                            var response = data.response;
                            var result = data.result;
                            
                            $("#"+_this.obj_id).removeClass("forbid_submit");
                            loading.remove();

                            if (response == '1') {
                                //免费认证
                                window.top.location.href = _ROOT_PATH + "index.php?m=user&c=yunrz&a=step3&rzno="+result;
                            }
                            else if (response == '2') {
                                //付费认证 (收银台)
                                window.top.location.href = _ROOT_PATH + "index.php?c=pay&paynum=" + encodeURIComponent(result);
                            }
                            else {
                                if (result == '' || result == null) {
                                    result = '提交失败，请检查';
                                }
                                OEUI.message.msg({
                                    text: result
                                });
                            }

                        },
                        error: function () {
                            $("#"+_this.obj_id).removeClass("forbid_submit");
                            loading.remove();
                            OEUI.message.msg({
                                text: '系统繁忙，请稍后再试'
                            });
                        }
                    });
                }

            });
        }
    }

    new OEYunrz();

});
//请求结果 
function _doRz() {
    var _this = this;
    var rzno = $("#rzno").val();
    $.ajax({
        type: "POST",
        url: _OE_FILE,
        cache: false,
        data: {
            c:'yunrz', a:'dorz', rzno:rzno
        },
        dataType: "json",
        success: function(data) {
            var response = data.response;
            var result = data.result;
            
            if (response == '1') { 
                //实名匹配
                $("#step_0").hide();
                $("#step_1").show();
            }
            else if (response == '2') {
                //实名不匹配
                $("#step_0").hide();
                if (result != "") {
                    $("#step_2_result").html(result);
                }
                $("#step_2").show();
            }
            else if (response == '3') {
                //实名失败
                $("#step_0").hide();
                if (result != "") {
                    $("#step_3_result").html(result);
                }
                $("#step_3").show();
            }
            else {
                if (result == '') {
                    result = "实名失败，请检查！";
                }
                $("#step_0").hide();
                if (result != "") {
                    $("#step_3_result").html(result);
                }
                $("#step_3").show();
            }
        },
        error: function() {
            OEUI.message.msg({
                text: '系统繁忙，请稍后再试'
            });
        }
    });
}