/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2012/12/01 by OE $
*/
$(function(){
    function Recharge () {
        this.select();
        this.bindInput();
        this.submit();
    }
    Recharge.prototype = {
        select: function () {
            $('[f="select"]').on('click', function () {
                $(this).addClass('bo_main color_main').siblings().removeClass('bo_main color_main');
                var val = $(this).attr('data-val');
                $('#money').val(val);
                $('#text').html(val+ '元');
            });
        },
        bindInput: function () {
            $('#money').on('blur', function () {
                var val = $(this).val();
                $('[f="select"]').removeClass('bo_main color_main');
                $('[f="select"][data-val="'+ val +'"]').addClass('bo_main color_main');
                $('#text').html((val || '0')+ '元');
            })
        },
        submit: function () {
            var is_http = false;
            $('[f="submit"]').on('click', function() {
                var money = $('#money').val();
                if (money == '0' || money == '') {
                    OEUI.message.msg({text: '请输入充值金额'});
                    return;
                }
                if (is_http) {return}
                is_http = true;

                var timer = null, loading, el = this;
                timer = setTimeout(function() {
                  loading = OEUI.loading({
                    el: el
                  });
                  loading.show();
                }, 200);

                $.ajax({
                    type: "POST",
                    url: _OE_FILE + "&c=recharge",
                    data: {a:"submit", money: money},
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;

                        var res = JSON.parse(json);
                        if (res.response == "1") {
                            window.location.href = _ROOT_PATH+"index.php?c=pay&paynum="+res.result;
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text:res.result});
                            }
                            else {
                                OEUI.message.msg({text:'提交失败，请检查！'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text:'系统繁忙，请稍后再试'});
                    }
                });
            });
        }
    }
    new Recharge();    
});