/**
 * [OElove] (C)2010-2099 oelove.com  biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/11/07 by BO $
*/
$(function(){ 
    function Profile () {
        this.initDistPicker();
        this.submit();
        this.interest();
        this.editName();
        this.saveName();
        this.editGender();
        this.saveGender();
        this.selectBirthday();
        this.showMap();
    }
    Profile.prototype = {
        initDistPicker: function () {
            new Dist({
                el: $('#dist'),
                dataType: '2'
            });
            new Dist({
                el: $('#home'),
                dataType: '2',
                type: 'home'
            });
            new School({
                el: $('#school'),
                dataType: '2'
            }); 
        },
        interest: function () {
            $('[f="interest"]').on('change', function () {
                var checkbox = $('[name="checkbox_interest"]:checked');
                var value = [];
                $.each(checkbox, function (i, v) {
                    value.push(v.value);
                });
                $('#interest').val(value.join(','));
            });
        },
        submit: function () {
            $('[f="save_profile"]').on('click', function () {
                $('#profile').submit();
            });
        },
        editName: function () {
            $('[f="edit_name"]').on('click', function () {
                OEUI.modal.dialog({
                    title: '编辑昵称',
                    width: 400,
                    height: 250,
                    content: '<div class="clearfix plr30 pt50">\
                                <div class="fl w200">\
                                  <input type="text" class="oeui_input" style="height:40px;" id="username" autocomplete="off">\
                                </div>\
                                <div class="ml15 fl">\
                                  <button class="bg_main color_f plr20 ptb10 br3 cursor bo_main" f="save_name">修改</button>\
                                </div>\
                              </div>'
                });
            });
        },
        saveName: function () {
            var is_http = false;
            $(document).on('click', '[f="save_name"]', function () {
                var username = $('#username').val();
                if (username == '') {
                    OEUI.message.msg({text: '请输入用户名'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading, timer, el = this;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 

                $.ajax({
                    type: 'POST',
                    url: _OE_FILE+"&c=profile",
                    data: {
                        a:"editname", username: username, datatype:"json"
                    },
                    success: function (json) {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            OEUI.message.msg({text: '修改成功'});
                            setTimeout(function () {
                                location.reload();
                            }, 800);
                        } else {
                            if (res.result) {
                                OEUI.message.msg({text: res.result});
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function () {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        editGender: function () {
            $('[f="edit_gender"]').on('click', function () {
                $('#select_gender').show().siblings().hide();
            });
        },
        saveGender: function () {
            $('[f="gender"]').on('change', function (e) {
                var gender = e.target.dataset.val;
                $.ajax({
                    type: 'POST',
                    url: _OE_FILE+"&c=profile",
                    data: {
                        a:"editgender", gender: gender, datatype:"json"
                    },
                    success: function (json) {
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            OEUI.message.msg({text: '修改成功'});
                            setTimeout(function () {
                                location.reload();
                            }, 800);
                        } else {
                            if (res.result) {
                                OEUI.message.msg({text: res.result});
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function () {
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        selectBirthday: function () {
            $('[f="edit_birthday"]').on('click', function () {
                $('#select_birthday').show().siblings().hide();
                $(this).siblings('.oeui_btn').show();
            });
            var birth = new Birthday({
                el: $('#birthday'),
                range: ['18', '60']
            }); 
            var birthData = {};
            birth.on('change', function (data) {
                birthData.year = data.year || '';
                birthData.month = data.month || '';
                birthData.date = data.date || '';
            });
            var is_http = false;
            $('[f="submit_birthday"]').on('click', function () {
                  if (birthData.year == '' || birthData.month == '' || birthData.date == '') {
                      OEUI.message.msg({text: '请选择出生日期'});
                      return;
                  }

                  if (is_http) return;
                  is_http = true;

                  var loading, timer, el = this;
                  timer = setTimeout(function () {
                      loading = OEUI.loading({
                          el: el,
                          color: '#666'
                      });
                      loading.show();
                  }, 200); 
                  $.ajax({
                      type: 'POST',
                      url: _OE_FILE+"&c=profile",
                      data: {
                          a:"editage", ageyear:birthData.year, agemonth:birthData.month, ageday:birthData.date, datatype:"json",
                      },
                      success: function (json) {
                          is_http = false;
                          clearTimeout(timer);
                          timer = null;
                          loading &&　loading.remove();
                          var res = JSON.parse(json);
                          if (res.response == '1') {
                              OEUI.message.msg({text: '修改成功'});
                              setTimeout(function () {
                                  location.reload();
                              }, 800);
                          } else {
                              if (res.result) {
                                  OEUI.message.msg({text: res.result});
                              } else {
                                  OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                              }
                          }
                      },
                      error: function () {
                          is_http = false;
                          clearTimeout(timer);
                          timer = null;
                          loading &&　loading.remove();
                          OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                      }
                  });
            });
        },
        showMap: function () {
            $('[f="pop_setmap"]').on('click', function () {
                window.mapdialog = OEUI.modal.dialog({
                    type: 'iframe',
                    title: '设置地图坐标',
                    width: 900,
                    height: 660,
                    content: _ROOT_PATH+"index.php?m=user&c=map"
                });
            });
        }
    }
    new Profile();
});

