/**
 * [OElove] (C)2010-2099 oelove.com
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 *  Last update 2020-11-09 by OE
 */
$(function () {
    function PhotoAdd() {
        this.openUploadPage();
        this.delPhoto();
        this.syncDynamic();
        this.initUploader();
    }

    PhotoAdd.prototype = {
        //弹出上传页
        openUploadPage: function () {
            var _this = this;
            $(document).on("click", "[f='pop_photo_add']", function () {
                var can_photos = parseInt($(this).attr("data-cans"));
                if (typeof (can_photos) == "undefined") {
                    can_photos = 0;
                }
                if (can_photos < 1) {
                    OEUI.mesage.msg({text: "对不起，可上传相册张数已满！"});
                    return false;
                }

                var width = 600;
                var height = 450;
                _this.uploadpage = OEUI.modal.dialog({
                    type: "iframe",
                    title: "上传相册",
                    widht: width,
                    height: height,
                    content: _ROOT_PATH + "index.php?m=user&c=photo&a=addto&r=" + get_rndnum(8)
                });
            });
        },
        //删除相册
        delPhoto: function () {
            //删除相册...
            $(document).on("click", "[f='del_btn']", function () {
                var id = $(this).attr("data-id");
                OEUI.modal.info({
                    title: '删除相册',
                    text: '确定删除该相册吗？',
                    confirmText: "确定",
                    confirm: function () {
                        $.ajax({
                            type: "POST",
                            url: _OE_FILE + "&c=photo",
                            cache: false,
                            data: {
                                a: "del", id: id, datatype: "json", r: get_rndnum(8)
                            },
                            dataType: "json",
                            success: function (data) {
                                var json = eval(data);
                                var response = json.response;
                                var result = json.result;
                                if (response == "1") {
                                    setTimeout(function () {
                                        window.location.reload();
                                    }, 500);
                                } else {
                                    if (result.length > 0) {
                                        OEUI.message.msg({text: result})
                                    } else {
                                        OEUI.message.msg({text: "删除失败"})
                                    }
                                }
                            },
                            error: function () {
                                OEUI.message.msg({text: "系统繁忙，请稍后再试"});
                            }
                        });
                    },
                    cancel: function () {
                    }
                });
            });
        },
        //同步动态
        syncDynamic: function () {
            var _this = this;
            $(document).on("click", "#finish_btn", function () {
                var photoid = $("#photoid").val();
                var photo_type = "0";

                if (photoid.length == 0) {
                    OEUI.message.msg({text: "请先上传照片"});
                    return false;
                }
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH + "index.php?m=user&c=photo",
                    cache: false,
                    data: {
                        a: "dynamic", photoid: photoid, photo_type: photo_type, r: get_rndnum(8)
                    },
                    dataType: "json",
                    success: function (data) {
                        var json = eval(data);
                        var response = json.response;
                        var result = json.result;
                        if (response == '1') {
                            OEUI.message.msg({text: "上传完成"});
                            setTimeout(function () {
                                _this.uploadpage.remove();
                            }, 500);
                        } else {
                            if (result.length > 0) {
                                OEUI.message.msg({text: "操作失败"});
                            } else {
                                OEUI.message.msg({text: "操作失败"});
                            }
                        }
                    },
                    error: function () {
                        OEUI.message.msg({text: "系统繁忙，请稍后再试"});
                    }
                });
                return false;
            });
        },
        //初始化上传
        initUploader: function () {
            if (typeof Uploader == 'undefined') return;
            var loading;
            var upload = new Uploader({
                el: document.getElementById('uploader'),
                url: _ROOT_PATH + "index.php?m=user&c=photo&a=saveadd&phototype=0",
                data: {
                  uploadpart: 'file'
                }
            });
            upload.on('beforeUploadOption', function () {
                var remain_photos = parseInt($("#remain_photos").val()) || 0;
                if (remain_photos == 0) {
                    OEUI.message.msg({text: "可上传相册张数已满！"});
                    return false;
                }
                return true;
            });
            upload.on('beforeUpload', function (e) {
                var file = e.target.files[0];
                var regexp = /.(gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG)$/;
                if (!regexp.test(file.name)) {
                    OEUI.message.msg({ text: '请上传gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG格式的图片' });
                    return false;
                }
                loading = OEUI.loading({
                  el: document.getElementById('uploader'),
                  color: '#999',
                  width: 30,
                  height: 30
                });
                loading.show();
                return true;
            });
            upload.on('success', function (res) {
                OEUI.message.msg({text: '上传成功'});
                loading.remove();
                _oeloveFileSynYun(res.attid); //同步云存储
                setTimeout(function() {
                    location.reload();
                }, 1000);
            });
            upload.on('error', function () {
                loading.remove();
            }); 
        }
    };
    new PhotoAdd();
});