/**
 * [OElove] (C)2010-2099 oelove.com Inc. biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/11/11 by BO $
*/
$(function () {
    function Login () {
        this.submitPwdLogin();
        this.Weixin();
        this.switchMethod();
        this.mobileLogin();
    }
    Login.prototype = {
        submitPwdLogin: function () {
            var is_http = false;
            $('[f="pwd_login"]').on('click', function () {
                var loginname = $('#loginname').val();
                var password = $('#password').val();
                var forward = $("#forward").val() || '';
                var au_mod = $("#au_mod").val() || '';
                var openid = $("#openid").val() || '';
                var au_unionid = $("#au_unionid").val() || '';

                if (loginname == '') {
                    OEUI.message.msg({text: '请输入登录账号'});
                    return;
                }
                if (password == '') {
                    OEUI.message.msg({text: '请输入登录密码'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: 'POST',
                    url: _ROOT_PATH + "index.php?c=passport",
                    data: {
                        a:"loginpost", loginname: loginname, password: password, 
                        au_mod: au_mod, openid: openid, au_unionid: au_unionid, forward: forward
                    },
                    success: function (json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == "1") { //成功，返回页面
                            if (forward == '') {
                                forward = _ROOT_PATH+"index.php?m=user";
                            } else {
                                if (forward == "/") {
                                    forward = forward + "index.php";
                                }
                            }
                            window.location.href = forward;
                        } else if (res.response == "2") { //整合OEmarry
                            window.top.location.href = res.result;
                        } else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: res.result});
                            } else {
                                OEUI.message.msg({text: '登录失败，请检查帐号密码是否正确'});
                            }
                        }
                    },
                    error: function () {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        //微信登录
        Weixin: function () {
            //弹出微信登录框...iframe
            $(document).on("click", "[f='but_open_wxlogin']", function(){
                var width = $(this).attr("data-width");
                if (typeof(width) == "undefined") {
                    width = 350;
                }
                var height = $(this).attr("data-height");
                if (typeof(height) == "undefined") {
                    height = 300;
                }
                OEUI.modal.dialog({
                    type: "iframe",
                    title: "微信扫码登录",
                    width: width,
                    height: height,
                    content: _ROOT_PATH+"index.php?c=passport&a=wxcode&r="+get_rndnum(8),
                });
            });
        },

        //手机验证码登录
        mobileLogin: function () {
            $('[f="mobile_login"]').on('click', function () {
                var mobile = $("#mobile").val() || '';
                var validcode = $("#mobile_code").val() || '';
                var forward = $("#forward").val() || '';
                var au_mod = $("#au_mod").val() || '';
                var openid = $("#openid").val() || '';
                var au_unionid = $("#au_unionid").val() || '';
                
                if (mobile == '') {
                    OEUI.message.msg({text: '请输入手机号码'});
                    return;
                }
                if (validcode == '') {
                    OEUI.message.msg({text: '请输入手机验证码'});
                    return;
                }

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH + "index.php?c=passport",
                    data: {
                        a:"loginmobile", mobile: mobile, validcode: validcode, 
                        au_mod: au_mod, openid: openid, au_unionid: au_unionid
                    },
                    success: function(json) {
                        var res = JSON.parse(json);
                        if (res.response == "1") { //成功，返回页面
                            OEUI.message.msg({text: '登录成功'});

                            if (forward.length == 0) {
                                forward = _ROOT_PATH+"index.php?m=user";
                            }
                            if (forward.indexOf("?") > 0) {
                                forward = forward;
                            }
                            else {
                                forward = forward;
                            }
                            window.location.href = forward;
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: res.result})
                            }
                            else {
                                OEUI.message.msg({text: '登录失败，请检查手机/验证码是否正确'});
                            }
                        }
                    },
                    error: function() {
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                }); 

            });
        },

        //切换登录模式
        switchMethod: function () {
            $('[f="login_method"]').on('click', function () {
                var method = $(this).attr('data-method');
                $(this).addClass('color_main fb current').siblings().removeClass('color_main fb current');
                if (method == 'pwd_login') {
                    $('#pwd_login').show();
                    $('#sms_login').hide();
                } else {
                    $('#pwd_login').hide();
                    $('#sms_login').show();
                }
            });
        }
    }
    new Login();
});