/**
 * [OElove] (C)2010-2099 oelove.com  biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 *  Last update 2020-11-02 by OE
*/
$(function(){
    function Diarylist() {
        this.condition = {
            s_gender: $("[name='s_gender'][checked='checked']").val(),
            s_avatar: $("#s_avatar").attr("checked")=="checked"?1:0,
            s_orderby: $("#s_orderby").val(),
            s_keyword: $("#s_keyword").val(),
            page: 1
        };
        this.buildUrl();
        this.commitBtn();
    }
    Diarylist.prototype = {
        //建立
        buildUrl: function () {
            var url = "/index.php?c=diary&a=list";
            for (let key in this.condition) {
                if (key == "s_avatar") {
                    this.condition[key] = $("#s_avatar").attr("checked") == "checked"?1:0;
                } else if (key == "s_gender") {
                    this.condition[key] = $("[name='s_gender'][checked='checked']").val();
                } else if (key == "page") {
                    continue;
                }
                else {
                    this.condition[key] = $("#"+key).val();
                }
                if (this.condition[key]) {
                    url += "&" + key + "=" + this.condition[key];
                }
            }
            return url;
        },
        //筛选按钮
        commitBtn: function () {
            var _this = this;
            $("#commit_btn").on("click", function () {
                var url = _this.buildUrl();
                location.href = url;
            })
        },
    };
    new Diarylist();


    function DiaryDetail() {
        this.loadComment();
        this.clickLoad();
        this.commitComment();
    }
    DiaryDetail.prototype = {
        //加载第一页评论
        loadComment: function () {
            var page = $("#page").val();
            var diary_id = $("#diary_id").val();
            $.ajax({
                type: "GET",
                url: _ROOT_PATH + "index.php?c=diary&a=loadcomm0",
                cache: false,
                data: {
                    diaryid: diary_id, page:page, r:get_rndnum(8)
                },
                dataType: "json",
                success: function(data) {
                    var nextpage = data.nextpage; //下一页
                    var result = data.result;
                    $("#page").val(nextpage); //重新赋值
                    if (result.length > 0) {
                        //限制
                        $("#list").append(result);
                        if (nextpage > 0) { //还有下一页
                            $("#comment_btn_more").show();
                        }
                        else { //没有下一页
                            $("#comment_btn_more").hide();
                        }
                        $("#comment_btn_loading").hide();
                    }
                },
                error: function() {

                }
            });
        },
        //点击执行加载
        clickLoad: function () {
            var _this = this;
            $(document).on("click", "#comment_btn_loading", function () {
                if ($("#comment_btn_loading").attr("display")=="none"){
                    _this.loadComment();
                    $("#comment_btn_loading").show();
                    $("#comment_btn_more").hide();
                }
            })
        },
        //发表评论
        commitComment: function () {
            //提交评论
            $(document).on('click', "#submit_comment_btn", function() {
                if (_LOGIN_STATUS == 0) {
                    location.href = _ROOT_PATH + "index.php?c=passport&a=login"
                }
                var _content = $("#comm_content").val();
                var _diaryid = $("#diaryid").val();
                if (_content.length == 0) {
                    OEUI.message.msg({
                        text: "内容不能为空"
                    });
                    return false;
                }
                if (_diaryid.length == 0) {
                    OEUI.message.msg({
                        text: "参数错误"
                    });
                    return false;
                }
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH + "index.php?c=diary",
                    cache: false,
                    data: {
                        a: "savecomm", diaryid: _diaryid, cmcont: _content, r: get_rndnum(8)
                    },
                    dataType: "json",
                    success: function (data) {
                        var response = data.response;
                        var result = data.result;
                        if (response == '1') {
                            $("#comm_content").val("");
                            if (result.length>0) {
                                OEUI.message.msg({text: "评论发表成功"});
                                $("#list").prepend(result)
                                if ($("#no_data").length>0) {
                                    $("#no_data").remove();
                                }
                            } else {
                                OEUI.message.msg({text: "评论发表成功,审核通过后将公开展示"});
                            }
                        } else {
                            OEUI.message.msg({text: "网络繁忙，请稍后再试"});
                        }
                    },
                    error: function () {
                        OEUI.message.msg({text: "网络繁忙，请稍后再试"});
                    }
                });
            });
        },
    };
    new DiaryDetail();
});