<?php
/**
 * Copyright (C) OElove All rights reserved.
 * <E-Mail：service@phpcoo.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 *     http://www.oelove.com
 * Update 2021.04.27
 */
if (!defined('IN_OELOVE')) {
    exit('OElove[OEPHP] Access Denied');
}
//权限值
function init_power_white_list()
{
    //白名单 21.04.27
    return array(
        "index_run", "index_main", "index_statis", "index_upload", "index_uploadimg", "index_uploadatt",
        "index_getroleadmin", "index_getsubadmin",  "index_logout", "index_getnews",
        "user_select", "user_check", "user_checkcan", "user_mobilelocal", "myads_check", "setting_testmail",
        "setting_checkSmsBalance", "setting_testsms", "setting_smssdk2key", "templet_select",
        "zone_check", "htmllabel_check", "finance_getuser", "index_map", "index_checkstatus", "index_upbaseimg"
    );
}

//define("OE_POWER_WHITE_LIST", $oe_power_white_list);
function init_roles_elements()
{
    $view_name = "查看";
    $add_name = "添加";
    $edit_name = "编辑";
    $del_name = "删除";
    $approved_name = "审核";
    $roles_elements = array();

    /*-------------------- base Begin ---------------------*/


    $roles_elements[] = array(
        'mod' => 'mod_setting',
        'name' => '【系统配置】+&#12288;', //一级菜单
    );

    $roles_elements[] = array(
        'mod' => 'menu_set',
        'name' => '|-- [网站设置]',
    );
    $roles_elements[] = array(
        'mod' => 'settint',
        'name' => '站点配置',
        'base' => array(),
        'other' => array(
            'setting_base' => array(
                "text" => "站点设置",
                "allows" => "setting_run,setting_savebase,setting_saveset",
            ),
            'setting_global' => array(
                "text" => "全局设置",
                "allows" => "setting_global,setting_saveglobal",
            ),
            'setting_upload' => array(
                "text" => "上传设置",
                "allows" => "setting_upload,setting_saveupload",
            ),
            'setting_page' => array(
                "text" => "分页设置",
                "allows" => "setting_page,setting_savepage",
            ),
            'setting_footer' => array(
                "text" => "页面底部设置",
                "allows" => "setting_footer,setting_savefooter",
            ),
            'setting_wap' => array(
                "text" => "手机版设置",
                "allows" => "setting_wap,setting_savewap,setting_wapabout,setting_savewapabout,setting_wapcontact,setting_savewapcontact,setting_wappayment,setting_savewappayment,setting_wapclause,setting_savewapclause,setting_waphelp,setting_savewaphelp",
            ),
            'setting_qqkf' => array(
                "text" => "QQ客服",
                "allows" => "setting_qqkf,setting_saveqqkf",
            ),
            'setting_weixin' => array(
                "text" => "公众号配置",
                "allows" => "setting_weixin,setting_saveweixin",
            ),
            'setting_mail' => array(
                "text" => "邮件接口设置",
                "allows" => "setting_mail,setting_savemail",
            ),
            'setting_qq' => array(
                "text" => "QQ登录设置",
                "allows" => "setting_qq,setting_saveqq",
            ),
            'setting_rpzy' => array(
                "text" => "RP诚信接口设置",
                "allows" => "setting_rpzy,setting_saverpzy",
            ),

            'setting_clearcache' => array(
                "text" => "清除页面缓存",
                "allows" => "setting_clearcache",
            ),
            'setting_updatecache' => array(
                "text" => "更新数据缓存",
                "allows" => "setting_updatecache",
            ),
            'setting_dealcache' => array(
                "text" => "更新缓存",
                "allows" => "setting_dealcache",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'seo',
        'name' => 'SEO设置',
        'base' => array(
            'seo_view' => array(
                "text" => $view_name,
                "allows" => "seo_run",
            ),
            'seo_edit' => array(
                "text" => $edit_name,
                "allows" => "seo_edit,seo_saveedit,seo_update",
            ),

        ),
    );
    $roles_elements[] = array(
        'mod' => 'item',
        'name' => '参数选项',
        'base' => array(
            'item_view' => array(
                "text" => $view_name,
                "allows" => "item_run",
            ),
            'item_edit' => array(
                "text" => $edit_name,
                "allows" => "item_edit,item_saveedit",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'diyintro',
        'name' => '自定义独白',
        'base' => array(
            'diyintro_view' => array(
                "text" => $view_name,
                "allows" => "diyintro_run",
            ),
            'diyintro_add' => array(
                "text" => $add_name,
                "allows" => "diyintro_add,diyintro_saveadd",
            ),
            'diyintro_edit' => array(
                "text" => $edit_name,
                "allows" => "diyintro_edit,diyintro_saveedit",
            ),
            'diyintro_del' => array(
                "text" => $del_name,
                "allows" => "diyintro_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'menu_weixin',
        'name' => '|-- [微信设置]',
    );
    $roles_elements[] = array(
        'mod' => 'weixinmenu',
        'name' => '公众号微信菜单',
        'base' => array(
            'weixinmenu_view' => array(
                "text" => $view_name,
                "allows" => "weixinmenu_run",
            ),
            'weixinmenu_add' => array(
                "text" => $add_name,
                "allows" => "weixinmenu_add,weixinmenu_saveadd",
            ),
            'weixinmenu_edit' => array(
                "text" => $edit_name,
                "allows" => "weixinmenu_edit,weixinmenu_saveedit,weixinmenu_update",
            ),
            'weixinmenu_del' => array(
                "text" => $del_name,
                "allows" => "weixinmenu_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'menu_interface',
        'name' => '|-- [接口设置]',
        'base' => array(),
    );
    $roles_elements[] = array(
        'mod' => 'paysdk',
        'name' => '支付接口',
        'base' => array(
            'paysdk_view' => array(
                "text" => $view_name,
                "allows" => "paysdk_run",
            ),
            'paysdk_edit' => array(
                "text" => $edit_name,
                "allows" => "paysdk_edit,paysdk_saveedit",
            ),
        ),
    );


    
    $roles_elements[] = array(
        'mod' => 'mod_share',
        'name' => '【运营管理】+&#12288;',
    );
    $roles_elements[] = array(
        'mod' => 'smstpl',
        'name' => '短信模板',
        'base' => array(
            'smstpl_view' => array(
                "text" => $view_name,
                "allows" => "smstpl_run",
            ),
            'smstpl_edit' => array(
                "text" => $edit_name,
                "allows" => "smstpl_edit,smstpl_saveedit",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'mailtpl',
        'name' => '邮件模板',
        'base' => array(
            'mailtpl_view' => array(
                "text" => $view_name,
                "allows" => "mailtpl_run",
            ),
            'mailtpl_edit' => array(
                "text" => $edit_name,
                "allows" => "mailtpl_edit,mailtpl_saveedit",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'msg',
        'name' => '站内通知',
        'base' => array(
            'msg_view' => array(
                "text" => $view_name,
                "allows" => "msg_run,msg_view",
            ),
            'msg_del' => array(
                "text" => $del_name,
                "allows" => "msg_del",
            ),
        ),
        'other' => array(
            'msg_send' => array(
                "text" => "发送通知",
                "allows" => "msg_send,msg_savesend,msg_batch,msg_savebatch",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'maillog',
        'name' => '邮件通知',
        'base' => array(
            'maillog_view' => array(
                "text" => $view_name,
                "allows" => "maillog_run,maillog_view",
            ),
            'maillog_del' => array(
                "text" => $del_name,
                "allows" => "maillog_del",
            ),
        ),
        'other' => array(
            'maillog_send' => array(
                "text" => "发送通知",
                "allows" => "maillog_send,maillog_savesend",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'smslog',
        'name' => '短信通知',
        'base' => array(
            'smslog_view' => array(
                "text" => $view_name,
                "allows" => "smslog_run",
            ),
            'smslog_del' => array(
                "text" => $del_name,
                "allows" => "smslog_del",
            ),
        ),
        'other' => array(
            'smslog_send' => array(
                "text" => "发送通知",
                "allows" => "smslog_send,smslog_savesend",
            ),
        ),
    );


    $roles_elements[] = array(
        'mod' => 'mod_user',
        'name' => '【会员模块】+&#12288;',
    );
    $roles_elements[] = array(
        'mod' => 'menu_user',
        'name' => '|--[会员管理]',
    );
    $roles_elements[] = array(
        'mod' => 'user',
        'name' => '会员列表',
        'base' => array(
            'user_view' => array(
                "text" => $view_name,
                "allows" => "user_run,user_view",
            ),
            'user_add' => array(
                "text" => $add_name,
                "allows" => "user_add,user_saveadd",
            ),
            'user_edit' => array(
                "text" => $edit_name,
                "allows" => "user_edit,user_saveedit,user_update,user_savedata,user_editavatar,user_saveavatar,user_editstatus,user_savestatus", //9.11.26
            ),
            'user_del' => array(
                "text" => $del_name,
                "allows" => "user_del",
            ),
        ),
        'other' => array(
            'user_login' => array(
                "text" => "登录会员",
                "allows" => "user_loginuser",
            ),
        ),
    );
    
    $roles_elements[] = array(
        'mod' => 'useraudit',
        'name' => '审核会员',
        'base' => array(
            'useraudit_view' => array(
                "text" => $view_name,
                "allows" => "useraudit_run,useraudit_headimg,useraudit_dubai",
            ),
            'useraudit_edit' => array(
                "text" => $edit_name,
                "allows" => "useraudit_editstatus,useraudit_savestatus,useraudit_editheadimg,useraudit_saveheadimg,useraudit_editdubai,useraudit_savedubai,useraudit_fliphead", //9.10.10
            ),
        ),

    );
    
    $roles_elements[] = array(
        'mod' => 'photo',
        'name' => '相册管理',
        'base' => array(
            'photo_view' => array(
                "text" => $view_name,
                "allows" => "photo_run",
            ),
            'photo_add' => array(
                "text" => $add_name,
                "allows" => "photo_add,photo_saveadd",
            ),
            'photo_edit' => array(
                "text" => $edit_name,
                "allows" => "photo_edit,photo_saveedit,photo_update,photo_flip", //9.10.10
            ),
            'photo_del' => array(
                "text" => $del_name,
                "allows" => "photo_del",
            ),

            'photo_approved' => array(
                "text" => $approved_name,
                "allows" => "photo_pass,photo_fail",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'vipuser',
        'name' => 'VIP会员',
        'base' => array(
            'vipuser_view' => array(
                "text" => $view_name,
                "allows" => "vipuser_run",
            ),
            'vipuser_add' => array(
                "text" => $add_name,
                "allows" => "vipuser_add,vipuser_saveadd,vipuser_add2", //9.11.26
            ),
            'vipuser_edit' => array(
                "text" => $edit_name,
                "allows" => "vipuser_edit,vipuser_saveedit,vipuser_update,vipuser_saveedit2", //9.11.26
            ),
        ),
    );
    
    $roles_elements[] = array(
        'mod' => 'visit',
        'name' => '浏览记录',
        'base' => array(
            'visit_view' => array(
                "text" => $view_name,
                "allows" => "visit_run",
            ),
        ),
    );
    //9.04.10
    $roles_elements[] = array(
        'mod' => 'viewcontact',
        'name' => '查看微信记录',
        'base' => array(
            'viewcontact_view' => array(
                "text" => $view_name,
                "allows" => "viewcontact_run",
            ),
        ),
    );
    //0.05.07
    $roles_elements[] = array(
        'mod' => 'love',
        'name' => '喜欢记录',
        'base' => array(
            'love_view' => array(
                "text" => $view_name,
                "allows" => "love_run",
            ),
        ),
    );
    
    $roles_elements[] = array(
        'mod' => 'guest',
        'name' => '游客记录',
        'base' => array(
            'guest_view' => array(
                "text" => $view_name,
                "allows" => "guest_run",
            ),
            'guest_del' => array(
                "text" => $del_name,
                "allows" => "guest_del",
            ),
        ),
    );
    
    $roles_elements[] = array(
        'mod' => 'wxfans',
        'name' => '微信粉丝',
        'base' => array(
            'wxfans_view' => array(
                "text" => $view_name,
                "allows" => "wxfans_run",
            ),
            'wxfans_del' => array(
                "text" => $del_name,
                "allows" => "wxfans_del",
            ),
        ),
    );


    $roles_elements[] = array(
        'mod' => 'menu_viptc',
        'name' => '|--[套餐权限]',
    );
    $roles_elements[] = array(
        'mod' => 'taocan',
        'name' => 'VIP套餐',
        'base' => array(
            'taocan_view' => array(
                "text" => $view_name,
                "allows" => "taocan_run",
            ),
            'taocan_add' => array(
                "text" => $add_name,
                "allows" => "taocan_add,taocan_saveadd",
            ),
            'taocan_edit' => array(
                "text" => $edit_name,
                "allows" => "taocan_edit,taocan_saveedit,taocan_update",
            ),
            'taocan_del' => array(
                "text" => $del_name,
                "allows" => "taocan_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'group',
        'name' => '等级特权',
        'base' => array(
            'group_view' => array(
                "text" => $view_name,
                "allows" => "group_run",
            ),
            'group_edit' => array(
                "text" => $edit_name,
                "allows" => "group_edit,group_saveedit,group_update",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'menu_rz',
        'name' => '|--[认证管理]',
    );
    $roles_elements[] = array(
        'mod' => 'userrz',
        'name' => '诚信认证',
        'base' => array(
            'userrz_view' => array(
                "text" => $view_name,
                "allows" => "userrz_run,userrz_idcard,userrz_house,userrz_car,userrz_education,userrz_marry",
            ),
            'userrz_edit' => array(
                "text" => $edit_name,
                "allows" => "userrz_edit,userrz_saveedit,userrz_editidcard,userrz_saveidcard,userrz_edithouse,userrz_savehouse,userrz_editcar,userrz_savecar,userrz_editeducation,userrz_saveeducation,userrz_editmarry,userrz_savemarry,userrz_makerz,userrz_savemakerz", //9.10.22
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'viewrp',
        'name' => '诚信查询',
        'base' => array(),
        'other' => array(
            'viewrp_check' => array(
                "text" => "查询",
                "allows" => "viewrp_run,viewrp_checkrp",
            ),
        ),
    );

    //自助认证 9.06.06
    $roles_elements[] = array(
        'mod' => 'yunrz',
        'name' => '自助认证(三要素)',
        'base' => array(
            'yunrz_view' => array(
                "text" => $view_name,
                "allows" => "yunrz_run",
            ),
            'yunrz_del' => array(
                "text" => $del_name,
                "allows" => "yunrz_del",
            ),
        ),
        'other' => array(
            'yunrz_rz' => array(
                "text" => "认证查询",
                "allows" => "yunrz_again",
            ),
        ),
    );
    
    //21.04.27
    $roles_elements[] = array(
        'mod'=>'statement',
        'name'=>'单身(婚况)声明',
        'base'=>array(
            'statement_view'=>array(
                "text"=>$view_name,
                "allows"=>"statement_run,statement_print",
            ),
            'statement_edit'=>array(
                "text"=>$edit_name,
                "allows"=>"statement_edit,statement_saveedit,statement_pass,statement_fail",
            ),
            'statement_del'=>array(
                "text"=>$del_name,
                "allows"=>"statement_del",
            ),
        ),
    );


    $roles_elements[] = array(
        'mod' => 'menu_message',
        'name' => '|--[信件管理]',
    );
    $roles_elements[] = array(
        'mod' => 'message',
        'name' => '会员信件',
        'base' => array(
            'message_view' => array(
                "text" => $view_name,
                "allows" => "message_run",
            ),
            'message_add' => array(
                "text" => $add_name,
                "allows" => "message_write,message_savewrite",
            ),
            'message_edit' => array(
                "text" => $edit_name,
                "allows" => "message_edit,message_saveedit,message_update",
            ),
            'message_del' => array(
                "text" => $del_name,
                "allows" => "message_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'msglink',
        'name' => '通信连接',
        'base' => array(
            'msglink_view' => array(
                "text" => $view_name,
                "allows" => "msglink_run",
            ),
            'msglink_edit' => array(
                "text" => $edit_name,
                "allows" => "msglink_edit,msglink_freesid,msglink_locksid",
            ),
            'msglink_del' => array(
                "text" => $del_name,
                "allows" => "msglink_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'msglog',
        'name' => '通信记录',
        'base' => array(
            'msglog_view' => array(
                "text" => $view_name,
                "allows" => "msglog_run",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'msgcontact',
        'name' => '通信联系人',
        'base' => array(
            'msgcontact_view' => array(
                "text" => $view_name,
                "allows" => "msgcontact_run",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'greet',
        'name' => '自定义信件',
        'base' => array(
            'greet_view' => array(
                "text" => $view_name,
                "allows" => "greet_run,greet_view",
            ),
            'greet_add' => array(
                "text" => $add_name,
                "allows" => "greet_add,greet_saveadd",
            ),
            'greet_edit' => array(
                "text" => $add_name,
                "allows" => "greet_edit,greet_saveedit,greet_update",
            ),
            'greet_del' => array(
                "text" => $del_name,
                "allows" => "greet_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'mod_cms',
        'name' => '【内容管理】+&#12288;',
    );
    $roles_elements[] = array(
        'mod' => 'party',
        'name' => '活动管理',
        'base' => array(
            'party_view' => array(
                "text" => $view_name,
                "allows" => "party_run,party_view,party_select",
            ),
            'party_add' => array(
                "text" => $add_name,
                "allows" => "party_add,party_saveadd",
            ),
            'party_edit' => array(
                "text" => $edit_name,
                "allows" => "party_edit,party_saveedit,party_update,party_finish,party_endbm",
            ),
            'party_del' => array(
                "text" => $del_name,
                "allows" => "party_del",
            ),
        ),
        'other' => array(
            'party_signin' => array(
                "text" => "现场签到",
                "allows" => "party_link,party_readidcard,party_idcardsignin,party_regnewsign,party_uidsignin,party_getuser,party_signin",
            ),

            //9.02.26
            'party_exportbm' => array(
                "text" => "导出报名",
                "allows" => "party_exportbm,party_saveexportbm",
            ),

            //8.08.28
            'party_sendwx' => array(
                "text" => "报名微信通知",
                "allows" => "party_sendwx,party_savesendwx",
            ),
            'party_sendmsg' => array(
                "text" => "报名站内信通知",
                "allows" => "party_sendmsg,party_savesendmsg",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'partybm',
        'name' => '活动报名',
        'base' => array(
            //9.01.19
            'partybm_add' => array(
                "text" => $add_name, //9.05.18
                "allows" => "partybm_add1,partybm_add,partybm_saveadd,partybm_underbm,partybm_saveunderbm",
            ),

            'partybm_view' => array(
                "text" => $view_name,
                "allows" => "partybm_run,partybm_view",
            ),
            'partybm_edit' => array(
                "text" => $edit_name,
                "allows" => "partybm_pass,partybm_savepass,partybm_cancel,partybm_savecancel,partybm_edit,partybm_saveedit,", //2018.06.11
            ),
            'partybm_del' => array(
                "text" => $del_name,
                "allows" => "partybm_del",
            ),
        ),
    );
    
    //0.04.12
    $roles_elements[] = array(
        'mod' => 'menu_gift',
        'name' => '|--[礼物管理]',
    );
    $roles_elements[] = array(
        'mod' => 'gift',
        'name' => '礼物列表',
        'base' => array(
            'gift_view' => array(
                "text" => $view_name,
                "allows" => "gift_run",
            ),
            'gift_add' => array(
                "text" => $add_name,
                "allows" => "gift_add,gift_saveadd",
            ),
            'gift_edit' => array(
                "text" => $edit_name,
                "allows" => "gift_edit,gift_saveedit,gift_update",
            ),
            'gift_del' => array(
                "text" => $del_name,
                "allows" => "gift_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'giftrecord',
        'name' => '赠送记录',
        'base' => array(
            'giftrecord_view' => array(
                "text" => $view_name,
                "allows" => "giftrecord_run",
            ),
            'giftrecord_del' => array(
                "text" => $del_name,
                "allows" => "giftrecord_del",
            ),
        ),
    );


    $roles_elements[] = array(
        'mod' => 'article',
        'name' => '文章资讯',
        'base' => array(
            'article_view' => array(
                "text" => $view_name,
                "allows" => "article_run",
            ),
            'article_add' => array(
                "text" => $add_name,
                "allows" => "article_add,article_saveadd",
            ),
            'article_edit' => array(
                "text" => $edit_name,
                "allows" => "article_edit,article_saveedit,article_update",
            ),
            'article_del' => array(
                "text" => $del_name,
                "allows" => "article_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'articlecat',
        'name' => '文章分类',
        'base' => array(
            'articlecat_view' => array(
                "text" => $view_name,
                "allows" => "articlecat_run",
            ),
            'articlecat_add' => array(
                "text" => $add_name,
                "allows" => "articlecat_add,articlecat_saveadd",
            ),
            'articlecat_edit' => array(
                "text" => $edit_name,
                "allows" => "articlecat_edit,articlecat_saveedit,articlecat_update",
            ),
            'articlecat_del' => array(
                "text" => $del_name,
                "allows" => "articlecat_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'about',
        'name' => '单页内容',
        'base' => array(
            'about_view' => array(
                "text" => $view_name,
                "allows" => "about_run",
            ),
            'about_add' => array(
                "text" => $add_name,
                "allows" => "about_add,about_saveadd",
            ),
            'about_edit' => array(
                "text" => $edit_name,
                "allows" => "about_edit,about_saveedit,about_update",
            ),
            'about_del' => array(
                "text" => $del_name,
                "allows" => "about_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'aboutcat',
        'name' => '单页分类',
        'base' => array(
            'aboutcat_view' => array(
                "text" => $view_name,
                "allows" => "aboutcat_run",
            ),
            'aboutcat_add' => array(
                "text" => $add_name,
                "allows" => "aboutcat_add,aboutcat_saveadd",
            ),
            'aboutcat_edit' => array(
                "text" => $edit_name,
                "allows" => "aboutcat_edit,aboutcat_saveedit,aboutcat_update",
            ),
            'aboutcat_del' => array(
                "text" => $del_name,
                "allows" => "aboutcat_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'kefu',
        'name' => '团队客服',
        'base' => array(
            'kefu_view' => array(
                "text" => $view_name,
                "allows" => "kefu_run",
            ),
            'kefu_add' => array(
                "text" => $add_name,
                "allows" => "kefu_add,kefu_saveadd",
            ),
            'kefu_edit' => array(
                "text" => $edit_name,
                "allows" => "kefu_edit,kefu_saveedit",
            ),
            'kefu_del' => array(
                "text" => $del_name,
                "allows" => "kefu_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'guestbook',
        'name' => '留言反馈',
        'base' => array(
            'guestbook_view' => array(
                "text" => $view_name,
                "allows" => "guestbook_run,guestbook_view",
            ),
            'guestbook_edit' => array(
                "text" => $edit_name,
                "allows" => "guestbook_edit,guestbook_saveedit,guestbook_update",
            ),
            'guestbook_del' => array(
                "text" => $del_name,
                "allows" => "guestbook_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'diary',
        'name' => '日记管理',
        'base' => array(
            'diary_view' => array(
                "text" => $view_name,
                "allows" => "diary_run",
            ),
            'diary_add' => array(
                "text" => $add_name,
                "allows" => "diary_add,diary_saveadd",
            ),
            'diary_edit' => array(
                "text" => $edit_name,
                "allows" => "diary_edit,diary_saveedit,diary_update",
            ),
            'diary_del' => array(
                "text" => $del_name,
                "allows" => "diary_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'diarycomm',
        'name' => '日记评论',
        'base' => array(
            'diarycomm_view' => array(
                "text" => $view_name,
                "allows" => "diarycomm_run",
            ),
            'diarycomm_edit' => array(
                "text" => $edit_name,
                "allows" => "diarycomm_edit,diarycomm_saveedit,diarycomm_update",
            ),
            'diarycomm_del' => array(
                "text" => $del_name,
                "allows" => "diarycomm_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'dynamic',
        'name' => '动态管理',
        'base' => array(
            'dynamic_view' => array(
                "text" => $view_name,
                "allows" => "dynamic_run",
            ),
            'dynamic_add' => array(
                "text" => $add_name,
                "allows" => "dynamic_add,dynamic_saveadd",
            ),
            'dynamic_edit' => array(
                "text" => $edit_name,
                "allows" => "dynamic_edit,dynamic_saveedit,dynamic_update",
            ),
            'dynamic_del' => array(
                "text" => $del_name,
                "allows" => "dynamic_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'dynamiccomm',
        'name' => '动态评论',
        'base' => array(
            'dynamiccomm_view' => array(
                "text" => $view_name,
                "allows" => "dynamiccomm_run",
            ),
            'dynamiccomm_edit' => array(
                "text" => $edit_name,
                "allows" => "dynamiccomm_edit,dynamiccomm_saveedit,dynamiccomm_update",
            ),
            'dynamiccomm_del' => array(
                "text" => $del_name,
                "allows" => "dynamiccomm_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'story',
        'name' => '成功案例',
        'base' => array(
            'story_view' => array(
                "text" => $view_name,
                "allows" => "story_run",
            ),
            'story_add' => array(
                "text" => $add_name,
                "allows" => "story_add,story_saveadd",
            ),
            'story_edit' => array(
                "text" => $edit_name,
                "allows" => "story_edit,story_saveedit,story_update",
            ),
            'story_del' => array(
                "text" => $del_name,
                "allows" => "story_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'storycomm',
        'name' => '案例评论',
        'base' => array(
            'storycomm_view' => array(
                "text" => $view_name,
                "allows" => "storycomm_run",
            ),
            'storycomm_edit' => array(
                "text" => $edit_name,
                "allows" => "storycomm_edit,storycomm_saveedit,storycomm_update",
            ),
            'storycomm_del' => array(
                "text" => $del_name,
                "allows" => "storycomm_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'safety',
        'name' => '防骗文章',
        'base' => array(
            'safety_view' => array(
                "text" => $view_name,
                "allows" => "safety_run",
            ),
            'safety_add' => array(
                "text" => $add_name,
                "allows" => "safety_add,safety_saveadd",
            ),
            'safety_edit' => array(
                "text" => $edit_name,
                "allows" => "safety_edit,safety_saveedit,safety_update",
            ),
            'safety_del' => array(
                "text" => $del_name,
                "allows" => "safety_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'jubao',
        'name' => '举报信息',
        'base' => array(
            'jubao_view' => array(
                "text" => $view_name,
                "allows" => "jubao_run",
            ),
            'jubao_edit' => array(
                "text" => $edit_name,
                "allows" => "jubao_edit,jubao_fail,jubao_success",
            ),
            'jubao_del' => array(
                "text" => $del_name,
                "allows" => "jubao_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'blackuser',
        'name' => '黑名单',
        'base' => array(
            'blackuser_view' => array(
                "text" => $view_name,
                "allows" => "blackuser_run",
            ),
        ),
        'other' => array(
            'blackuser_cancel' => array(
                "text" => "取消黑名单",
                "allows" => "blackuser_cancel",
            ),
        ),
    );

    
    
    $roles_elements[] = array(
        'mod' => 'mod_finance',
        'name' => '【财务模块】+&#12288;',
    );
    $roles_elements[] = array(
        'mod' => 'menu_finance',
        'name' => '|--[财务记录]',
    );
    $roles_elements[] = array(
        'mod' => 'payorder',
        'name' => '在线支付记录',
        'base' => array(
            'payorder_view' => array(
                "text" => $view_name,
                "allows" => "payorder_run",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'money',
        'name' => '会员余额明细',
        'base' => array(
            'money_view' => array(
                "text" => $view_name,
                "allows" => "money_run",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'reportprofit',
        'name' => '经营报表',
        'base' => array(
            'reportprofit_view' => array(
                "text" => $view_name,
                "allows" => "reportprofit_run,reportprofit_report",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'finance',
        'name' => '财务管理',
        'other' => array(
            'finance_money' => array(
                "text" => "添加会员余额",
                "allows" => "finance_money,finance_savemoney,finance_money2", 
            ),
        ),
    );
    
    
    $roles_elements[] = array(
        'mod' => 'mod_siteadm',
        'name' => '【站点管理】+&#12288;', //一级菜单
    );
    $roles_elements[] = array(
        'mod' => 'menu_admin',
        'name' => '|--[系统帐号]',
        'base' => array(),
    );
    $roles_elements[] = array(
        'mod' => 'admin',
        'name' => '系统用户',
        'base' => array(
            'admin_view' => array(
                "text" => $view_name,
                "allows" => "admin_run",
            ),
            'admin_add' => array(
                "text" => $add_name,
                "allows" => "admin_add,admin_saveadd",
            ),
            'admin_edit' => array(
                "text" => $edit_name,
                "allows" => "admin_edit,admin_saveedit",
            ),
            'admin_del' => array(
                "text" => $del_name,
                "allows" => "admin_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'roles',
        'name' => '角色权限',
        'base' => array(
            'roles_view' => array(
                "text" => $view_name,
                "allows" => "roles_run",
            ),
            'roles_add' => array(
                "text" => $add_name,
                "allows" => "roles_add,roles_saveadd",
            ),
            'roles_edit' => array(
                "text" => $edit_name,
                "allows" => "roles_edit,roles_saveedit",
            ),
            'roles_del' => array(
                "text" => $del_name,
                "allows" => "roles_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'my',
        'name' => '我的帐号',
        'base' => array(
            'my_view' => array(
                "text" => $view_name,
                "allows" => "my_run",
            ),
        ),
        'other' => array(
            "my_editinfo" => array(
                "text" => "修改资料",
                "allows" => "my_editinfo,my_saveinfo"
            ),
            "my_editpass" => array(
                "text" => "修改密码",
                "allows" => "my_editpass,my_savepass"
            ),
            "my_power" => array(
                "text" => "查看我的权限",
                "allows" => "my_power"
            ),
            "my_subordinate" => array(
                "text" => "查看我的下属",
                "allows" => "my_subordinate"
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'area',
        'name' => '地区管理',
        'base' => array(
            'area_view' => array(
                "text" => $view_name,
                "allows" => "area_run,area_child",
            ),
            'area_add' => array(
                "text" => $add_name,
                "allows" => "area_add,area_saveadd",
            ),
            'area_edit' => array(
                "text" => $edit_name,
                "allows" => "area_edit,area_saveedit,area_update",
            ),
            'area_del' => array(
                "text" => $del_name,
                "allows" => "area_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'hometown',
        'name' => '户籍管理',
        'base' => array(
            'hometown_view' => array(
                "text" => $view_name,
                "allows" => "hometown_run,area_child",
            ),
            'hometown_add' => array(
                "text" => $add_name,
                "allows" => "hometown_add,hometown_saveadd",
            ),
            'hometown_edit' => array(
                "text" => $edit_name,
                "allows" => "hometown_edit,hometown_saveedit,hometown_update",
            ),
            'hometown_del' => array(
                "text" => $del_name,
                "allows" => "hometown_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'school',
        'name' => '院校管理',
        'base' => array(
            'school_view' => array(
                "text" => $view_name,
                "allows" => "school_run",
            ),
            'school_add' => array(
                "text" => $add_name,
                "allows" => "school_add,school_saveadd",
            ),
            'school_edit' => array(
                "text" => $edit_name,
                "allows" => "school_edit,school_saveedit",
            ),
            'school_del' => array(
                "text" => $del_name,
                "allows" => "school_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'zone',
        'name' => '广告版位',
        'base' => array(
            'zone_view' => array(
                "text" => $view_name,
                "allows" => "zone_run",
            ),
            'zone_add' => array(
                "text" => $add_name,
                "allows" => "zone_add,zone_saveadd",
            ),
            'zone_edit' => array(
                "text" => $edit_name,
                "allows" => "zone_edit,zone_saveedit",
            ),
            'zone_del' => array(
                "text" => $del_name,
                "allows" => "zone_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'myads',
        'name' => '广告图',
        'base' => array(
            'myads_view' => array(
                "text" => $view_name,
                "allows" => "myads_run",
            ),
            'myads_add' => array(
                "text" => $add_name,
                "allows" => "myads_add,myads_saveadd",
            ),
            'myads_edit' => array(
                "text" => $edit_name,
                "allows" => "myads_edit,myads_saveedit",
            ),
            'myads_del' => array(
                "text" => $del_name,
                "allows" => "myads_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'friendlink',
        'name' => '友情链接',
        'base' => array(
            'friendlink_view' => array(
                "text" => $view_name,
                "allows" => "friendlink_run",
            ),
            'friendlink_add' => array(
                "text" => $add_name,
                "allows" => "friendlink_add,friendlink_saveadd",
            ),
            'friendlink_edit' => array(
                "text" => $edit_name,
                "allows" => "friendlink_edit,friendlink_saveedit,friendlink_update",
            ),
            'friendlink_del' => array(
                "text" => $del_name,
                "allows" => "friendlink_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'htmllabel',
        'name' => '自定义HTML标签',
        'base' => array(
            'htmllabel_view' => array(
                "text" => $view_name,
                "allows" => "htmllabel_run",
            ),
            'htmllabel_add' => array(
                "text" => $add_name,
                "allows" => "htmllabel_add,htmllabel_saveadd",
            ),
            'htmllabel_edit' => array(
                "text" => $edit_name,
                "allows" => "htmllabel_edit,htmllabel_saveedit",
            ),
            'htmllabel_del' => array(
                "text" => $del_name,
                "allows" => "htmllabel_del",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'skin',
        'name' => '前台主题风格',
        'base' => array(
            'skin_view' => array(
                "text" => $view_name,
                "allows" => "skin_run",
            ),
            'skin_del' => array(
                "text" => $del_name,
                "allows" => "skin_del",
            ),
        ),
        'other' => array(
            'skin_usetpl' => array(
                "text" => "切换风格",
                "allows" => "skin_usetpl",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'templet',
        'name' => '前台模板文件',
        'base' => array(
            'templet_view' => array(
                "text" => $view_name,
                "allows" => "templet_run",
            ),
            'templet_edit' => array(
                "text" => $edit_name,
                "allows" => "templet_edit,templet_saveedit",
            ),
            'templet_del' => array(
                "text" => $del_name,
                "allows" => "templet_del",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'logadmin',
        'name' => '管理日志',
        'base' => array(
            'logadmin_view' => array(
                "text" => $view_name,
                "allows" => "logadmin_run",
            ),
            'logadmin_del' => array(
                "text" => $del_name,
                "allows" => "logadmin_del,logadmin_delall",
            ),
        ),
    );
    $roles_elements[] = array(
        'mod' => 'loguser',
        'name' => '会员日志',
        'base' => array(
            'loguser_view' => array(
                "text" => $view_name,
                "allows" => "loguser_run",
            ),
            'loguser_del' => array(
                "text" => $del_name,
                "allows" => "loguser_del,loguser_delall",
            ),
        ),
    );

    $roles_elements[] = array(
        'mod' => 'datatool',
        'name' => '数据备份',
        'base' => array(),
        'other' => array(
            "datatool_backup" => array(
                "text" => "备份数据",
                "allows" => "datatool_run,datatool_baktables,datatool_backup",
            ),
            "datatool_restore" => array(
                "text" => "还原数据",
                "allows" => "datatool_restore,datatool_import",
            ),
            "datatool_del" => array(
                "text" => "删除备份文件",
                "allows" => "datatool_del",
            ),
            "datatool_down" => array(
                "text" => "下载备份文件",
                "allows" => "datatool_down",
            ),
        ),
    );

    
    return $roles_elements;
}

?>