/*
 * Decompiled with CFR 0.152.
 */
package alcoholmod.Mathioks.TransformationsRealPackage;

import alcoholmod.Mathioks.TransformationsRealPackage.Helper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureHelper {
    private static final ResourceLocation TEXTURE_STEVE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");
    private static final String TAG = "TextureHelper";
    private static final ResourceLocation playerOverlay = new ResourceLocation("tm:textures/entity/6paths.png");
    private static final ResourceLocation playerOverlaySlim = new ResourceLocation(":textures/entity/.png");
    private static final Map<Class, ResourceLocation> overlays = new HashMap<Class, ResourceLocation>();

    public static void createVampireTexture(EntityLivingBase e, ResourceLocation old, ResourceLocation newLoc) {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        if (manager.func_110581_b(newLoc) == null) {
            ResourceLocation overlay;
            boolean slimPlayer = false;
            if (e instanceof EntityPlayer) {
                slimPlayer = true;
                overlay = playerOverlaySlim;
            } else {
                overlay = TextureHelper.getOverlay(e.getClass());
            }
            Object texture = null;
            try {
                if (overlay != null) {
                    ITextureObject tex = manager.func_110581_b(old);
                    if (tex instanceof LayeredTexture) {
                        List l = ((LayeredTexture)tex).field_110567_b;
                        l.add(overlay.toString());
                        texture = new LayeredTexture(TextureHelper.toStringArraySafe(l));
                    } else {
                        texture = new VampireTexture(old, overlay, slimPlayer);
                    }
                } else {
                    texture = new SimpleTexture(old);
                }
            }
            catch (Exception e1) {
                texture = manager.func_110581_b(old);
            }
            manager.func_110579_a(newLoc, texture);
        }
    }

    private static ResourceLocation getOverlay(Class clazz) {
        if (clazz.equals(EntityCreature.class)) {
            return null;
        }
        ResourceLocation loc = overlays.get(clazz);
        if (loc == null) {
            return TextureHelper.getOverlay(clazz.getSuperclass());
        }
        return loc;
    }

    public static void registerConvertedOverlay(Class<? extends EntityCreature> clazz, String loc) {
        overlays.put(clazz, new ResourceLocation(loc));
    }

    private static File getSkinFile(ResourceLocation fakeLoc) {
        String hash = fakeLoc.func_110623_a().replace("skins/", "");
        File dir = (File)Helper.Reflection.getPrivateFinalField(Minecraft.class, Minecraft.func_71410_x(), Helper.Obfuscation.getPosNames("Minecraft/fileAssets"));
        File sdir = new File(dir, "skins");
        File mdir = new File(sdir, hash.substring(0, 2));
        return new File(mdir, hash);
    }

    private static String[] toStringArraySafe(List list) {
        while (list.contains(null)) {
            list.remove(null);
        }
        return list.toArray(new String[list.size()]);
    }

    static {
        overlays.put(EntityPlayer.class, playerOverlay);
    }

    private static class VampireTexture
    extends AbstractTexture {
        protected final ResourceLocation textureLocation;
        protected final ResourceLocation overlayLocation;
        protected final boolean slimPlayer;

        public VampireTexture(ResourceLocation loc, ResourceLocation overlay) {
            this(loc, overlay, false);
        }

        public VampireTexture(ResourceLocation textureLocation, ResourceLocation overlayLocation, boolean slimPlayer) {
            this.textureLocation = textureLocation;
            this.overlayLocation = overlayLocation;
            this.slimPlayer = slimPlayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_110551_a(IResourceManager resManager) throws IOException {
            this.func_147631_c();
            InputStream inputstream = null;
            InputStream inputstreamOverlay = null;
            try {
                BufferedImage image = null;
                IResource iresource = null;
                if (this.textureLocation.func_110623_a().contains("skin")) {
                    File f = TextureHelper.getSkinFile(this.textureLocation);
                    if (f.isFile()) {
                        image = ImageIO.read(f);
                    } else {
                        iresource = resManager.func_110536_a(this.slimPlayer ? TEXTURE_ALEX : TEXTURE_STEVE);
                        inputstream = iresource.func_110527_b();
                        image = ImageIO.read(inputstream);
                    }
                } else {
                    iresource = resManager.func_110536_a(this.textureLocation);
                    inputstream = iresource.func_110527_b();
                    image = ImageIO.read(inputstream);
                }
                try {
                    int oh;
                    IResource iresource_overlay = resManager.func_110536_a(this.overlayLocation);
                    inputstreamOverlay = iresource_overlay.func_110527_b();
                    Image overlay = ImageIO.read(inputstreamOverlay);
                    int w = image.getWidth();
                    int h = image.getHeight();
                    if (w != ((Image)overlay).getWidth(null)) {
                        overlay = overlay.getScaledInstance(w, -1, 4);
                    }
                    if (h == (oh = ((Image)overlay).getHeight(null)) || h == oh * 2) {
                        BufferedImage combined = new BufferedImage(w, oh, 2);
                        Graphics g = combined.getGraphics();
                        g.drawImage(image, 0, 0, null);
                        g.drawImage(overlay, 0, 0, null);
                        image = combined;
                    }
                }
                catch (Exception iresource_overlay) {
                    // empty catch block
                }
                boolean flag = false;
                boolean flag1 = false;
                if (iresource != null && iresource.func_110528_c()) {
                    try {
                        TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                        if (texturemetadatasection != null) {
                            flag = texturemetadatasection.func_110479_a();
                            flag1 = texturemetadatasection.func_110480_b();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)image, (boolean)flag, (boolean)flag1);
            }
            finally {
                if (inputstream != null) {
                    inputstream.close();
                }
                if (inputstreamOverlay != null) {
                    inputstreamOverlay.close();
                }
            }
        }
    }
}

