// ===================================================================================
//
//  ADOBE CONFIDENTIAL
//
//  Copyright © 2015 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE:  All information contained herein is, and remains
//  the property of Adobe Systems Incorporated and its suppliers,
//  if any.  The intellectual and technical concepts contained
//  herein are proprietary to Adobe Systems Incorporated and its
//  suppliers and are protected by all applicable intellectual property
//  laws, including trade secret and copyright laws.
//
//  Dissemination of this information or reproduction of this material
//  is strictly forbidden unless prior written permission is obtained
//  from Adobe Systems Incorporated.
//
// @author mortimer
// ===================================================================================

/**
 * Globals
 */
var __adobe_hello = (void 0);
var __I18N        = (void 0);

$(document).bind( 'touchmove', function(e) { e.preventDefault(); } );  // disable rubber-band bounce

/**
 * This method is a shortcut for window.on( "load", handler )...
 *
 * @param lambda        function to execute on load action
 */
$(window).load(function ()
{
    try
    {
        document.oncontextmenu = function() { return false; }  // turn off right click context menu

        // setup a link to the master translation table contained in the parent's DOM
        __I18N = parent.gI18N;
        __adobe_hello = parent.window.__adobe_hello;

        // get query string parameters which will contain the tab's ID
        var options = HelloUtil.convertURLParameters(window.location.search.substring(1));

        // load the content
        loadErrorPageContent(options.tabID);
    }
    catch( e ) { HelloLog.exception( e ); }
});

/**
 * Fill in the content based on tab ID.
 *
 * @param tabID             string containing the tab's ID
 */
function loadErrorPageContent( tabID )
{
    try
    {
        // determine mbox hero image avatar
        var heroImg = ( tabID === "newfeature" )
                          ? "no-internet-01.jpg" : ( tabID === "getstarted" )
                                ? "no-internet-02.jpg" : ( tabID === "tipsntechniques" )
                                        ? "no-internet-03.jpg" : "no-internet-04.jpg";

        // localize strings
        $(".offline_error_quote").html( __I18N.getLocalizedString("offline_error_quote_"+tabID) );
        $(".offline_error_reload_label").html( __I18N.getLocalizedString("offline_error_reload") );
        $('.offline_error_image').attr("src","images/"+heroImg);

        // set last error if it exists
        if( typeof parent.personalizationProperties["lastError"] !== "undefined"
            && parent.personalizationProperties["lastError"] !== ""
            && parent.personalizationProperties["lastError"] != null )
        {
            $(".offline_error_title").html(parent.personalizationProperties["lastError"]);
        }
        else
        {
            $(".offline_error_title").html( __I18N.getLocalizedString("offline_error_title") );
        }
    }
    catch ( e ) { HelloLog.exception( e ); }
}

/**
 * Make an attempt to reload the content URL/
 */
function attemptReloadContent( )
{
    try
    {
        $('.offline_reload_image').attr('src', 'images/box-spinner-med-2x.gif');

        if ( typeof __adobe_hello !== "undefined" 
            && typeof __adobe_hello.api !== "undefined"
            && typeof __adobe_hello.api.retryLoadFromServer !== "undefined" )
        {
            __adobe_hello.api.retryLoadFromServer( function(){ $('.offline_reload_image').attr('src', 'images/2x-icon-reload.png'); });
        }
        else { throw new Error( "Undefined AdobeHello object or method" ); }
    }
    catch( e ) { HelloLog.exception( e ); }
}
