//========================================================================================
//
//  ADOBE CONFIDENTIAL
//
//  Copyright © 2015 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE:  All information contained herein is, and remains
//  the property of Adobe Systems Incorporated and its suppliers,
//  if any.  The intellectual and technical concepts contained
//  herein are proprietary to Adobe Systems Incorporated and its
//  suppliers and are protected by all applicable intellectual property
//  laws, including trade secret and copyright laws.
//
//  Dissemination of this information or reproduction of this material
//  is strictly forbidden unless prior written permission is obtained
//  from Adobe Systems Incorporated.
//
// @author mortimer
//========================================================================================

// Muse content url's
var contentURLs = {
    online  : "https://helpx.adobe.com/muse/hello/v1_6/index.html"
    , offline : "offline/index.html"
};


/**
 * Convert the options object to a URL parameter query string.
 *
 * @param opts          options object to convert
 * @return A string containing the URL parameters.
 */
var makeOptionsURLQueryString = function( opts )
{
    var search = "";
    try
    {
        // check for imported testing override options repackage them as necessary
        if ( typeof opts.overrides !== "undefined" )
        {
            // remove override url as it's unnecessary to pass along
            if ( typeof opts.overrides.url !== "undefined" ) { delete opts.overrides.url; }

            // walk through and serialize the remaining options
            for( var overrideKey in opts.overrides )
            {
                if ( typeof opts.overrides[overrideKey] !== "undefined" )
                {
                    opts["override_"+overrideKey] = opts.overrides[overrideKey];
                }
            }
            delete opts.overrides;
        }

        // remove other options that we don't want to pass along if they exist
        if ( typeof opts.urlRedirect !== "undefined" ) { delete opts.urlRedirect; }
        if ( typeof opts.contentpath !== "undefined" ) { delete opts.contentpath; }

//            HelloLog.logObject("SEARCH: ", opts);  // debugmm

        // convert to URL options
        search = $.param( opts );
    }
    catch( e ) { HelloLog.exception( e ); }

    return search;
}

/**
 * Handle the redirect to the proper Hello URL for the extension.
 *
 * @param options           initization options object to use
 */
function redirectToHelloContentURL( options )
{
    try
    {
        // point product ID should have been extablished by this point
        if ( options.hostID === "UNKN" ) { throw new Error("Point product host ID is UNKNOWN!"); }

        // modify the online url based on test module configuration parameters
        if ( typeof options.test !== "undefined" && options.test === true && typeof HelloTest !== "undefined" )
        {
            contentURLs.online = HelloTest.fixupContentURL( contentURLs.online );
        }

        // set up default url and Highbeam event
        var helloURL      = contentURLs.offline;
        var pipEventName  = "DisplayOfflineHello";

        // completion function to be used in reachability check
        var navigateToURL = function()
        {
            // check for URL parameters and add those in
            var urlOptions = makeOptionsURLQueryString(options);

            helloURL += (typeof urlOptions !== "undefined" && urlOptions != null & urlOptions !== "" )
                                ? "?"+urlOptions : "";

            // switch to the proper Hello URL
            HelloLog.log( "Navigating to content URL: "+helloURL, "DOM CHANGE" );
            HelloLog.logHelloInteractionPIPEvent( pipEventName );
            window.location = helloURL;
        };

        // check to see if we are connected or if we are in test mode
        if ( window.navigator.onLine === true
            && (options.test === false 
                || (options.test === true && options.urlRedirect.indexOf("offline") == -1)) )
        {
            // check if the online content server is reachable
            HelloUtil.asyncCheckExists(contentURLs.online, function( isReachable, jqxhr, textStatus )
            {
                    if ( isReachable === true )
                    {
                        helloURL     =  contentURLs.online;
                        pipEventName = "DisplayRemoteHello";
                        HelloLog.log("Content URL: "+helloURL+" appears to be reachable");
                    }
                    else
                    {
                        HelloLog.log("Content URL: "+contentURLs.online+" is UNREACHABLE - switching to offline mode", "Warning");
                        HelloLog.log("Status code was: " + jqxhr.status + " ("
                            + ((typeof textStatus !== "undefined" && textStatus != null && textStatus !== "")
                                        ? textStatus : "UNKNOWN")+")", "Warning");
                    }
                    navigateToURL();
            });
        }
        else { navigateToURL(); } // offline mode
    }
    catch( e ) { HelloLog.exception( e ); }
}
