//========================================================================================
//
//  ADOBE CONFIDENTIAL
//
//  Copyright © 2015 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE:  All information contained herein is, and remains
//  the property of Adobe Systems Incorporated and its suppliers,
//  if any.  The intellectual and technical concepts contained
//  herein are proprietary to Adobe Systems Incorporated and its
//  suppliers and are protected by all applicable intellectual property
//  laws, including trade secret and copyright laws.
//
//  Dissemination of this information or reproduction of this material
//  is strictly forbidden unless prior written permission is obtained
//  from Adobe Systems Incorporated.
//
// @author mortimer - inherited from sukamat
//========================================================================================

var CHLFooterHelper = {

    // Read account information
    getAccountType: function () {
        var accountType = "paid";
        if (typeof (parent.personalizationProperties) !== "undefined") {
            accountType = parent.personalizationProperties["accountType"];
        }
        return accountType;
    },

    // Get the check box value
    getHideOnLaunch: function () {
        if (typeof (parent.personalizationProperties) !== "undefined") {
            var checkBoxState = parent.personalizationProperties["dontShowAgain"];
            // Wrapper DOM returns a string. Convert to Boolean.
            return (checkBoxState.toLowerCase() === "true");
        }
        return false;
    },

    // Pass the check box value back to wrapper
    setHideOnLaunch: function (hideOnLaunchState) {
        try
        {
            if (typeof parent.projectHello !== "undefined")
            {
                if (typeof parent.projectHello.setDontShowAgainPreference !== "undefined")
                {
                    parent.projectHello.setDontShowAgainPreference(hideOnLaunchState);
                } else { throw new Error("AdobeHello API setDontShowAgainPreference is undefined"); }
            } else { throw new Error("AdobeHello is undefined"); }

            if (typeof (parent.personalizationProperties) !== "undefined") {
                var checkBoxState = $("#hidePanel").is(':checked') ? "true" : "false";
                parent.personalizationProperties["dontShowAgain"] = checkBoxState;
            }
        }
        catch( e ) { if ( typeof HelloLog !== "undefined") { HelloLog.exception( e ); } }
    },

    toggleFooterMessage: function (checkBoxState) {
        $( "#cbtext2" ).stop(true, true);
        $( "#cbtext1" ).stop(true, true);
        if (checkBoxState) {
            $( "#cbtext1" ).fadeOut( 1, function() {
                $( "#cbtext2" ).fadeIn(1).delay(2000).fadeOut( 250, function() {
                    $( "#cbtext1" ).fadeIn(250)
                });
            });
        } else {
            $( "#cbtext2" ).stop(true, true).hide();
            $( "#cbtext1" ).stop(true, true).show();
        }
    },

    openBrowser: function (url) {
        try
        {
            if (typeof parent.projectHello !== "undefined")
            {
                if (typeof parent.projectHello.openURLInDefaultBrowser !== "undefined")
                {
                    parent.projectHello.openURLInDefaultBrowser(url);
                } else { throw new Error("AdobeHello API openURLInDefaultBrowser is undefined"); }
            } else { throw new Error("AdobeHello is undefined"); }
        }
        catch( e ) { if ( typeof HelloLog !== "undefined") { HelloLog.exception( e ); } }
    }
};

/**
 * Setup the footer links.
 *
 * @param pageName              ID of the page we are loading the footer on
 * @param footerData            data object that fill in the localized footer
 */
function loadOffineFooter(pageName, footerData)
{
    try
    {
        // disable right click menu in footer
//        document.body.oncontextmenu = function () { return false; }

        // set up the hover function
        $("#CCLogoDiv a").hover(function() {
                                    try { $(".cc-logo").attr("src","images/cc-logo-hover.png"); } catch ( e ) { HelloLog.exception( e ); }
                                },function() {
                                    try { $(".cc-logo").attr("src","images/cc-logo.png"); } catch ( e ) { HelloLog.exception( e ); }
                                })

        // change anchor URL's & label based on product configuration
        $("#FooterLinkHelp").text( footerData.helpLabel );
        $("#FooterLinkHelp").attr( "href", footerData.helpURL );
        $("#FooterLinkForums").text( footerData.forumsLabel );
        $("#FooterLinkForums").attr( "href", footerData.forumsURL );
        $("#FooterLinkInspire").text( footerData.inspireLabel );
        $("#FooterLinkInspire").attr( "href", footerData.inspireURL );
        $("#FooterLinkBlog").text( footerData.blogLabel );
        $("#FooterLinkBlog").attr( "href", footerData.blogURL );
    }
    catch ( e ) { HelloLog.exception( e ); }
}
